<?php

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function get_publisher_sections()
{
  global $OG_publisher_sections;

  $sql = <<<__TEXT__
SELECT
  SectionID, PublisherID
FROM
  Sections
__TEXT__;
  if ($result = mysql_query ($sql)) {
    while (list ($sid, $pid) = mysql_fetch_row ($result)) {
      $OG_publisher_sections[$sid] = $pid;
    }
  }
}


####---------------------------------------------------------------------------
#### puts all parent publishers (up the tree) into a hashed
#### array (a hash of publisher info keyed on publisher IDs)
#### Each value in the hash is an array of
####  ($name, $cpm, $cpmp, $cpc, $cpcp, $fixed, $fixedp)
#### the rate numbers indicate for each publisher P what portion should 
#### be paid to publisher $startpid from any campaigns run by publisher P
####---------------------------------------------------------------------------
function get_parent_pubs($startpid)
{
  #### use these to calculate "running CPMs/CPCs/Fixed" as we move
  #### up the tree
  $rcpm = 0;
  $rcpmp = 1;
  $rcpc = 0;
  $rcpcp = 1;
  $rf = 0;
  $rfp = 1;

  $parentpubs = array ();

  $notdone = 1;
  $pid = $startpid;
  while ($notdone) {
    $sql = <<<__TEXT__
SELECT PublisherID, PPublisherID, Name,
CPM, CPMPerc, CPC, CPCPerc, Fixed, FixedPerc
FROM Publishers
WHERE PublisherID=$pid
__TEXT__;

    if($result = mysql_query($sql)) {
      list ($pid, $ppid, $name,
            $cpm, $cpmp, $cpc, $cpcp, $f, $fp) = mysql_fetch_row ($result);

      if ($pid != $startpid) {
        $parentpubs[$pid] = array ($name, $rcpm, $rcpmp, $rcpc, $rcpcp, $rf, $rfp);
      }

      $rcpm   = ($rcpm == 0) ? $cpm * $rcpmp : $rcpm;
      $rcpmp *= ($cpmp / 100);
      $rcpc   = ($rcpc == 0) ? $cpc * $rcpcp : $rcpc;
      $rcpcp *= ($cpcp / 100);
      $rf     = ($rf == 0) ? $f * $rfp : $rf;
      $rfp   *= ($fp / 100);

      $pid = $ppid;
      if ($ppid == 0) $notdone = 0;
    }
    else {
      $notdone = 0;
    }
  }

  #print_r ($parentpubs);
  return $parentpubs;
}


####---------------------------------------------------------------------------
#### puts all sub publishers (down the tree) into a hashed
#### array (a hash of publisher info keyed on publisher IDs)
#### Each value in the hash is an array of
####  ($name, $cpm, $cpmp, $cpc, $cpcp, $fixed, $fixedp)
#### the rate numbers indicate for each publisher P what portion should 
#### be paid to publisher $startpid from any campaigns run by publisher P
####
#### if you pass in an optional array of immediate subpublishers, all
#### publishers beneath those publishers will be attributed to one of the
#### immediate subpublishers and return them in the $subtrees hash
####---------------------------------------------------------------------------
function get_all_subpubs($startpid, $immsubpubs = '')
{
  $subpubs = array ();

  $notdone = 1;
  if ($immsubpubs) {
    $immsubpubhash = array ();
    foreach ($immsubpubs as $im) $immsubpubhash[$im] = 1;
  }

  #### put the startpid's info into the array
  $sql = <<<__TEXT__
SELECT PublisherID, PPublisherID, Name,
CPMCharge, CPMChargePerc, CPCCharge, CPCChargePerc, FixedCharge, FixedChargePerc
FROM Publishers
WHERE PublisherID=$startpid
ORDER BY PPublisherID
__TEXT__;

  if(!($result = mysql_query($sql))) return array ();
  list ($pid, $ppid, $name, $cpm, $cpmp, $cpc, $cpcp, $f, $fp)
    = mysql_fetch_row ($result);
  #$subpubs[$pid] = array ($name, $cpm, $cpmp, $cpc, $cpcp, $f, $fp);
  $subpubs[$pid] = array ($name, 0, 1, 0, 1, 0, 1);
  $subpubids = array_keys ($subpubs);

  #### get entire tree beneath startpid
  while ($notdone) {
    $filter = join (',', $subpubids);
    $sql = <<<__TEXT__
SELECT PublisherID, PPublisherID, Name,
CPMCharge, CPMChargePerc, CPCCharge, CPCChargePerc, FixedCharge, FixedChargePerc
FROM Publishers
WHERE PPublisherID IN ($filter)
ORDER BY PPublisherID
__TEXT__;

    $subpubids = array ();
    if($result = mysql_query($sql)) {
      if (!mysql_num_rows ($result)) $notdone = 0;

      while (list ($pid, $ppid, $name,
            $cpm, $cpmp, $cpc, $cpcp, $f, $fp) = mysql_fetch_row ($result)) {

        #### find to whom this pub belongs
        if ($immsubpubs) {
          if ($immsubpubhash[$pid])       $parent[$pid] = $pid;
          else if ($immsubpubhash[$ppid]) $parent[$pid] = $ppid;
          else if ($parent[$ppid])        $parent[$pid] = $parent[$ppid];
        }

        list ($pname, $pcpm, $pcpmp, $pcpc, $pcpcp, $pf, $pfp)
          = $subpubs[$ppid];

        $cpm  = ($pcpm == 0) ? $cpm * $pcpmp : $pcpm;
        $cpmp = $pcpmp * ($cpmp / 100);
        $cpc  = ($pcpc == 0) ? $cpc * $pcpcp : $pcpc;
        $cpcp = $pcpcp * ($cpcp / 100);
        $f    = ($pf == 0) ? $f * $pfp : $pf;
        $fp   = $pfp * ($fp / 100);

        array_push ($subpubids, $pid);
        $subpubs[$pid] = array ($name, $cpm, $cpmp, $cpc, $cpcp, $f, $fp);
      }
    }
    else {
      $notdone = 0;
    }
  }

  if ($immsubpubs) {
    #### reassemble the subpublisher trees so that they can be quickly
    #### accessed by the top-level publisher
    while (list ($p, $pp) = each ($parent)) {
      if (!$subtrees[$pp]) $subtrees[$pp] = array ($p);
      else array_push ($subtrees[$pp], $p);
    }
  }

  #print_r ($subpubs);
  return array ($subpubs, $subtrees);
}


####---------------------------------------------------------------------------
#### returns the immediate sub publishers in the $subpubs array
#### (a hash of publisher names keyed on publisher IDs)
####---------------------------------------------------------------------------
function get_immediate_subpubs ($ppid)
{
  $sql = <<<__TEXT__
SELECT PublisherID, Name,
CPM, CPMPerc, CPC, CPCPerc, Fixed, FixedPerc,
CPMCharge, CPMChargePerc, CPCCharge, CPCChargePerc,
FixedCharge, FixedChargePerc,
HostingCharge
FROM Publishers
WHERE PPublisherID=$ppid
__TEXT__;

  $subpubs = array ();
  if($result = mysql_query($sql)) {
    while (list ($pid, $name, $cpm, $cpmperc, $cpc,
                 $cpcperc, $fixed, $fixedperc,
                 $cpmc, $cpmcperc, $cpcc, $cpccperc, $fixedc, $fixedcperc,
                 $hosting) = mysql_fetch_row ($result)) {
      $subpubs[$pid] = array ($name,
                  $cpm, $cpmperc, $cpc, $cpcperc, $fixed, $fixedperc,
                  $cpmc, $cpmcperc, $cpcc, $cpccperc, $fixedc, $fixedcperc,
                  $hosting);
    }

    return $subpubs;
  }

  return array ();
}



####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function get_pub_info($pid)
{
  $sql = <<<__TEXT__
SELECT PublisherID, Name,
CPM, CPMPerc, CPC, CPCPerc, Fixed, FixedPerc,
CPMCharge, CPMChargePerc, CPCCharge, CPCChargePerc,
FixedCharge, FixedChargePerc,
HostingCharge
FROM Publishers
WHERE PublisherID=$pid
__TEXT__;

  if($result = mysql_query($sql)) {
    return mysql_fetch_row ($result);
  }

  return array ();
}


?>
