<?php

$OASISversion = "2.0.4.pro";

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function get_php_version()
{
  $pversion = phpversion();
  $pversion = preg_replace('#[^\d.].*#', '', $pversion);
  $comp = split('\.', $pversion);

  $comp = array_reverse($comp);
  $factor = 1;
  foreach($comp as $v)
  {
    $version_number += $v * $factor;

    $factor *= 100;
  }

  return $version_number;
}


####---------------------------------------------------------------------------
#### this wrapper exists because when I ran with php 4.2.2 and Apache 2.0,
#### I could not access my environment variables via getenv(); they were
#### now only accessible via $_SERVER.  Not sure if PHP changed or Apache
#### changed, but I think this routine will work for both situations
####---------------------------------------------------------------------------
function get_oasis_env($name)
{
  $val = '';

  if ($val = $_SERVER[$name]) return $val;
  return getenv ($name);
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function get_prefs($PrefKey)
{
  global $OASISmsg, $OG_PubID;

  #### sometimes, we're called from command-line scripts, where there is no
  #### defined $OG_PubID
  if ($OG_PubID == 0) $OG_PubID = 1;

  $v = get_table_row_s('OASISPrefs', 'PrefKey', '$PrefKey');
  if ($v[PerPublisher] == 'Y')
    $sql = "select PrefKey, PrefValue from OASISPrefs where PrefKey='$PrefKey' AND PublisherID=$OG_PubID";
  else
    $sql = "select PrefKey, PrefValue from OASISPrefs where PrefKey='$PrefKey'";

  if(($result = mysql_query($sql))
    && (list($k, $v) = mysql_fetch_row($result)))
    return $v;
  else
    die("$OASISmsg[Error]: " . mysql_error() . "<BR>\nSQL: $sql\n");

  return '';
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function identify_image($imagefile)
{
  global $id_path;

  if(!$id_path) $id_path = get_prefs('IdentifyPath');

  $command = "$id_path -format \"%w %h %n %m\\n\" $imagefile";
  $results = `$command`;

  #print "$command<BR>results: <BR><PRE>$results</PRE><BR>\n";

  $w = 0; $h = 0; $mime_type = ''; $animated='N';
  if(preg_match('#(\d+)\s+(\d+)\s+(\d+)\s+(\w+)#', $results, $matches))
  {
    list($junk, $w, $h, $framecount, $img_type) = $matches;
    if ($framecount > 1) $animated = 'Y';
    $mime_type = get_mime_type($img_type);
  }

  return array($w, $h, $mime_type, $animated);
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function fetch_url($u)
{
  global $curl_path;

  #### swap out the cache-busting block (especially since the "[]" construct
  #### has special meaning for curl!)
  $u = preg_replace('#\[CB\]#', '123', $u);

  if(!$curl_path) $curl_path = get_prefs('CurlPath');

  #print "fetching $u...<BR>\n";
  if($curl_path)
  {
    #print "command: $curl_path -L --fail '$u' 2>/dev/null<BR>";
    $results = `$curl_path -L --fail '$u' 2>/dev/null`;
    return $results;
  }
  #### if we don't have curl installed, we'll use the old fallthrough, but
  #### this is not highly reliable
  else
  {
    if($fp = @fopen($u, 'r'))
    {
      $buf = '';
      while($buf .= fgets($fp, 4096)) {}
      fclose($fp);

      return $buf;
    }
    else return '';
  }

}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function get_mime_type($magick_type)
{
  #### here's where we define the known image types
  if($magick_type == 'GIF')  return "image/gif";
  if($magick_type == 'JPEG') return "image/jpeg";
  if($magick_type == 'PNG')  return "image/png";

  return "";
}


?>
