<?php

require_once("lib-oasis.inc");
require_once("lib-i18n.inc");
require_once("lib-http.inc");
require_once("lib-html.inc");
require_once("lib-db.inc");

check_privileges();
check_authorization();

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function check_privileges()
{
  global $PHP_AUTH_USER, $PHP_AUTH_PW, $SCRIPT_FILENAME;
  global $OG_PubID, $OG_ltdcampaigns;
  global $force_login;
  global $OASISmsg;

  if(!isset($PHP_AUTH_USER)) reject_http_connection();

  $user_info = get_table_row_s('Users', 'Login', $PHP_AUTH_USER);
  $OG_PubID = $user_info['PublisherID'];

  $result = mysql_query("select password('$PHP_AUTH_PW')");
  list($encrypted_password) = mysql_fetch_row($result);

  if($encrypted_password != $user_info[Password]) reject_http_connection();

  $privs = array(
                 'admin.php'
                    => array('Admin'),
                 'advertiser.php'
                   => array('Advertisers'),
                 'campaign.php'  
                    => array('Campaigns', 'LimitedCampaigns'),
                 'campaignassignment.php'
                    => array('Campaigns', 'LimitedCampaigns'),
                 'campaigninsertion.php'
                    => array('CampaignInsertion'),
                 'delivery_control.php'
                    => array('Campaigns', 'LimitedCampaigns'),
                 'companion.php'
                    => array('Sections'),
                 'creative.php'
                    => array('Campaigns', 'LimitedCampaigns'),
                 'creativeassignment.php'
                    => array('Campaigns', 'LimitedCampaigns'),
                 'invoice.php'
                    => array('Invoicing'),
                 'index.php'
                    => array('Admin', 'Advertisers', 'Campaigns', 'CampaignInsertion', 'Invoicing', 'LimitedCampaigns', 'Reports', 'Sections'),
                 'publisher.php'
                    => array('Admin'),
                 'report.php'
                    => array('Reports'),
                 'section.php'
                    => array('Sections'),
                 'sampletag.php'
                    => array('Sections'),
                 'user.php'
                    => array('Admin'),
		 );

  preg_match('#([^/]+)$#', $SCRIPT_FILENAME, $matches);
  $script = $matches[1];

  $grant_access = 0;
  $priv_array = $privs[$script];
  $result = mysql_query("select Status from Publishers, Users
                         where Publishers.PublisherID=Users.PublisherID and
                               Users.Login='$PHP_AUTH_USER'");
  list($status) = mysql_fetch_row($result);
  if ($status == 'Active')
  {
    foreach($priv_array as $p)
    {
      if($user_info[$p] == 'Y')
      {
        $grant_access = 1;
        break;
      }
    }
  }
  else reject_http_connection();

  $OG_ltdcampaigns = 0;
  if (($user_info['LimitedCampaigns'] == 'Y')
      && ($user_info['Campaigns'] != 'Y'))
  {
    $OG_ltdcampaigns = 1;
  }

  if(!$grant_access)
  {
    print $OASISmsg[no_permission];
    exit;
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function print_header($interface_location, $CampaignID, $CreativeID)
{
  global $PHP_AUTH_USER;
  global $OASISmsg;

  $user_info = get_table_row_s('Users', 'Login', $PHP_AUTH_USER);

  if($CampaignID)
  {
    $info = get_table_row('Campaigns', 'CampaignID', $CampaignID);
    $ca_name = $info[Name];

    $second_row .= <<<__TEXT__
$OASISmsg[Campaign]: <A HREF="campaign.php?CampaignID=$CampaignID">$ca_name</A>
__TEXT__;
  }

  if($CreativeID)
  {
    $info = get_table_row('Creatives', 'CreativeID', $CreativeID);
    $cr_name = $info[Name];

    $second_row .= <<<__TEXT__
&middot;
$OASISmsg[Creative]: <A HREF="creative.php?CreativeID=$CreativeID">$cr_name</A>
__TEXT__;
  }

  $links = array();

  if($user_info[CampaignInsertion] == 'Y')
    if($interface_location == 'CampaignInsertion')
      array_push($links, '<A HREF="campaigninsertion.php" onMouseOver="button0.src=\'graphics/button-campaigninsertion.gif\'" onMouseOut="button0.src=\'graphics/button-campaigninsertion-i.gif\'"><IMG NAME=button0 BORDER=0 SRC="graphics/button-campaigninsertion-i.gif" WIDTH=101 HEIGHT=25></A>');
    else
      array_push($links, '<A HREF="campaigninsertion.php" onMouseOver="button0.src=\'graphics/button-campaigninsertion-i.gif\'" onMouseOut="button0.src=\'graphics/button-campaigninsertion.gif\'"><IMG NAME=button0 BORDER=0 SRC="graphics/button-campaigninsertion.gif" WIDTH=101 HEIGHT=25></A>');
  else
    array_push($links, '<IMG BORDER=0 SRC="graphics/button-campaigninsertion-o.gif" WIDTH=101 HEIGHT=25>');


  if($user_info[Campaigns] == 'Y' || $user_info[LimitedCampaigns] == 'Y')
    if($interface_location == 'Campaigns')
      array_push($links, '<A HREF="campaign.php" onMouseOver="button1.src=\'graphics/button-campaign.gif\'" onMouseOut="button1.src=\'graphics/button-campaign-i.gif\'"><IMG NAME=button1 BORDER=0 SRC="graphics/button-campaign-i.gif" WIDTH=81 HEIGHT=25></A>');
    else
      array_push($links, '<A HREF="campaign.php" onMouseOver="button1.src=\'graphics/button-campaign-i.gif\'" onMouseOut="button1.src=\'graphics/button-campaign.gif\'"><IMG NAME=button1 BORDER=0 SRC="graphics/button-campaign.gif" WIDTH=81 HEIGHT=25></A>');
  else
    array_push($links, '<IMG BORDER=0 SRC="graphics/button-campaign-o.gif" WIDTH=81 HEIGHT=25>');

  if($user_info[Advertisers] == 'Y')
    if($interface_location == 'Advertisers')
      array_push($links, '<A HREF="advertiser.php" onMouseOver="button2.src=\'graphics/button-advertiser.gif\'" onMouseOut="button2.src=\'graphics/button-advertiser-i.gif\'"><IMG NAME=button2 BORDER=0 SRC="graphics/button-advertiser-i.gif" WIDTH=84 HEIGHT=25></A>');
    else
      array_push($links, '<A HREF="advertiser.php" onMouseOver="button2.src=\'graphics/button-advertiser-i.gif\'" onMouseOut="button2.src=\'graphics/button-advertiser.gif\'"><IMG NAME=button2 BORDER=0 SRC="graphics/button-advertiser.gif" WIDTH=84 HEIGHT=25></A>');
  else
    array_push($links, '<IMG BORDER=0 SRC="graphics/button-advertiser-o.gif" WIDTH=84 HEIGHT=25>');

  if($user_info[Sections] == 'Y')
    if($interface_location == 'Sections')
      array_push($links, '<A HREF="section.php" onMouseOver="button3.src=\'graphics/button-section.gif\'" onMouseOut="button3.src=\'graphics/button-section-i.gif\'"><IMG NAME=button3 BORDER=0 SRC="graphics/button-section-i.gif" WIDTH=67 HEIGHT=25></A>');
    else
      array_push($links, '<A HREF="section.php" onMouseOver="button3.src=\'graphics/button-section-i.gif\'" onMouseOut="button3.src=\'graphics/button-section.gif\'"><IMG NAME=button3 BORDER=0 SRC="graphics/button-section.gif" WIDTH=67 HEIGHT=25></A>');
  else
    array_push($links, '<IMG BORDER=0 SRC="graphics/button-section-o.gif" WIDTH=67 HEIGHT=25>');

  if($user_info[Reports] == 'Y')
    if($interface_location == 'Reports')
      array_push($links, '<A HREF="report.php" onMouseOver="button4.src=\'graphics/button-report.gif\'" onMouseOut="button4.src=\'graphics/button-report-i.gif\'"><IMG NAME=button4 BORDER=0 SRC="graphics/button-report-i.gif" WIDTH=60 HEIGHT=25></A>');
    else
      array_push($links, '<A HREF="report.php" onMouseOver="button4.src=\'graphics/button-report-i.gif\'" onMouseOut="button4.src=\'graphics/button-report.gif\'"><IMG NAME=button4 BORDER=0 SRC="graphics/button-report.gif" WIDTH=60 HEIGHT=25></A>');
  else
    array_push($links, '<IMG BORDER=0 SRC="graphics/button-report-o.gif" WIDTH=60 HEIGHT=25>');

  if($user_info[Invoicing] == 'Y')
    if($interface_location == 'Invoicing')
      array_push($links, '<A HREF="invoice.php" onMouseOver="button5.src=\'graphics/button-invoice.gif\'" onMouseOut="button5.src=\'graphics/button-invoice-i.gif\'"><IMG NAME=button5 BORDER=0 SRC="graphics/button-invoice-i.gif" WIDTH=69 HEIGHT=25></A>');
    else
      array_push($links, '<A HREF="invoice.php" onMouseOver="button5.src=\'graphics/button-invoice-i.gif\'" onMouseOut="button5.src=\'graphics/button-invoice.gif\'"><IMG NAME=button5 BORDER=0 SRC="graphics/button-invoice.gif" WIDTH=69 HEIGHT=25></A>');
  else
    array_push($links, '<IMG BORDER=0 SRC="graphics/button-invoice-o.gif" WIDTH=69 HEIGHT=25>');

  if($user_info[Admin] == 'Y')
    if($interface_location == 'Admin')
      array_push($links, '<A HREF="admin.php" onMouseOver="button6.src=\'graphics/button-admin.gif\'" onMouseOut="button6.src=\'graphics/button-admin-i.gif\'"><IMG NAME=button6 BORDER=0 SRC="graphics/button-admin-i.gif" WIDTH=51 HEIGHT=25></A>');
    else
      array_push($links, '<A HREF="admin.php" onMouseOver="button6.src=\'graphics/button-admin-i.gif\'" onMouseOut="button6.src=\'graphics/button-admin.gif\'"><IMG NAME=button6 BORDER=0 SRC="graphics/button-admin.gif" WIDTH=51 HEIGHT=25></A>');
  else
    array_push($links, '<IMG BORDER=0 SRC="graphics/button-admin-o.gif" WIDTH=51 HEIGHT=25>');

  $linkstring = implode("</TD>\n<TD>", $links);

  print <<<__TEXT__
<BODY BGCOLOR="#ffffff" TEXT="#000000" LINK="#0000ff" VLINK="#330066" ALINK="#ff0000">
<TABLE WIDTH=620 CELLPADDING=0 CELLSPACING=0 BORDER=0 ALIGN=center>
<TR>
<TD WIDTH=1 BGCOLOR="#000000"><IMG SRC="graphics/1x1.gif"></TD>
<TD WIDTH=618 VALIGN=top BACKGROUND="graphics/background.gif"><TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0
WIDTH="100%">
<TR>
<TD VALIGN=bottom COLSPAN=8><A
 HREF="http://www.oasispros.com/"><IMG
SRC="graphics/header.gif" BORDER=0 ALT="OASIS" WIDTH=618 HEIGHT=61></A></TD>
</TR>

<TR>
<TD>$linkstring</TD>
<TD><A HREF="docs/index.htm" onMouseOver="button7.src='graphics/button-documentation-i.gif'" onMouseOut="button7.src='graphics/button-documentation.gif'"><IMG NAME=button7 BORDER=0 SRC="graphics/button-documentation.gif" WIDTH=105 HEIGHT=25></TD>
</TR>

<TR>
<TD ALIGN=center COLSPAN=8>
$second_row
</TD>
</TR>
</TABLE>
<P>
__TEXT__;
}

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function check_authorization()
{
  global $OG_PubID, $OG_ltdcampaigns, $SCRIPT_FILENAME;
  global $Login, $PublisherID, $PPublisherID, $AdvertiserID, $SectionID,
         $PSectionID, $CampaignID, $CreativeID, $InvoiceID, $PubInvoiceID;
  global $new_user_form;
  global $OASISmsg;

  $authorized = true;

  if ($CreativeID) {
    $info = get_table_row('Creatives', 'CreativeID', $CreativeID);
    $CampaignID = $info[CampaignID];
  }
  
  if ($InvoiceID) {
    $info = get_table_row('Invoices', 'InvoiceID', $InvoiceID);
    $CampaignID = $info[CampaignID];
  }
  if ($PubInvoiceID) {
    $info = get_table_row('PublisherInvoices', 'InvoiceID', $PubInvoiceID);
    $PublisherID = $info[PublisherID];
  }

  #### we have to treat Login differently, because it happens to be the
  #### only primary key in a table where the user directly selects the key
  if ($Login) {
    if (preg_match('#user#', $SCRIPT_FILENAME) && !$new_user_form)
      $authorized = is_authorized('Users', 'Login', 0, $Login);
  }
  if ($authorized && $PublisherID && preg_match('#publisher#', $SCRIPT_FILENAME))
    $authorized = is_authorized('Publishers', 'PublisherID', $OG_PubID, $PublisherID);

  if ($authorized && $PublisherID)
    $authorized = is_authorized('Publishers', 'PublisherID', 0, $PublisherID);

  if ($authorized && $PPublisherID)
      if (preg_match('#publisher#', $SCRIPT_FILENAME))
        $authorized = is_authorized('Publishers', 'PublisherID', 0, $PPublisherID);
      else
        $authorized = is_authorized('Publishers', 'PublisherID', 0, $PPublisherID);

  if ($authorized && $AdvertiserID)
    $authorized = is_authorized('Advertisers', 'AdvertiserID', 0, $AdvertiserID);

  if ($authorized && $SectionID) ## this will cover both sections and companions
    $authorized = is_authorized('Sections', 'SectionID', 0, $SectionID);

  if ($authorized && $PSectionID)
    $authorized = is_authorized('Sections', 'SectionID', 0, $PSectionID);

  if ($authorized && $CampaignID)
    $authorized = is_authorized('Campaigns', 'CampaignID', 0, $CampaignID);

  if ($authorized && $CampaignID && $OG_ltdcampaigns)
    $authorized = check_ltdcampaign ($CampaignID);

  if ($authorized && $CreativeID && $OG_ltdcampaigns)
    $authorized = check_ltdcampaign ('', $CreativeID);

  if (! $authorized)
  {
    print $OASISmsg[not_authorized];
    exit;
  }

}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function check_ltdcampaign($CampaignID, $CreativeID='')
{
  global $PHP_AUTH_USER;
  global $OG_campaignaccess;

  if ($CreativeID) {
    $sql = <<<__TEXT__
SELECT ca.CampaignID
FROM CampaignAccess ca 
LEFT JOIN Creatives cr ON cr.CampaignID=ca.CampaignID
WHERE ca.Login='$PHP_AUTH_USER' 
AND cr.CreativeID=$CreativeID
__TEXT__;
  }
  else {
    $sql = <<<__TEXT__
SELECT CampaignID FROM CampaignAccess WHERE Login='$PHP_AUTH_USER' 
AND CampaignID=$CampaignID
__TEXT__;
  }

  if(!($result = mysql_query($sql))) return 0;

  if (mysql_num_rows ($result) > 0) return 1;

  return 0;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function is_authorized($table, $field, $root, $id)
{
  global $filter;

  $filter = array();
  build_filter($root, $field, $table);
  return in_array($id, $filter);
}

?>
