<?php

require_once("lib-i18n.inc");
require_once("lib-db.inc");

global $admin_logfile;

$admin_logfile = get_prefs("LogDir") . "/oasis_admin.log";
$sim_logfile   = get_prefs("LogDir") . "/oasis_sim.log";


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function warn($msg)
{
  if($fp = fopen("php://stderr", "w"))
  {
    fputs($fp, "$msg\n");
    fclose($fp);
  }

  admin_log("WARNING: $msg");

  return 1;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function admin_log($msg)
{
  global $admin_logfile;
  global $OASISdatefmt;

  if ($OASISdatefmt == 'mdy')
    $log_msg = date('H:i:s M d, Y') . "\t" . $msg . "\n";
  if ($OASISdatefmt == 'dmy')
    $log_msg = date('H:i:s d M, Y') . "\t" . $msg . "\n";

  error_log($log_msg, 3, $admin_logfile);
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function sim_log($msg)
{
  global $sim_logfile;
  global $OASISdatefmt;

  if ($OASISdatefmt == 'mdy')
    $log_msg = date('H:i:s M d, Y') . "\t" . $msg . "\n";
  if ($OASISdatefmt == 'dmy')
    $log_msg = date('H:i:s d M, Y') . "\t" . $msg . "\n";

  error_log($log_msg, 3, $sim_logfile);
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function abort($msg)
{
  global $OASISmsg;

  admin_log("$OASISmsg[FATAL]: $msg");

  $admin_email = get_prefs('AdminEmail');
  mail($admin_email, "$OASISmsg[Fatal_OASIS_Error]", $msg);

  die("$msg\n");
}



####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function set_overflow_flag ($overflow)
{
    global $OG_sem_id, $OG_shm_hour_ass, $OG_shm_hour_tar,
           $OG_shm_cr_cont, $OG_shm_cr_click;
    global $OG_overflow;

    $OG_overflow = $overflow;

    #### grab a semaphore; we don't want to enter these shared memory
    #### segments when the delivery script might be running
    #### identifier:           O A 0 0
    if(!(($sem_id = sem_get(0x4f410000, 1)) && sem_acquire($sem_id))) {
        admin_log("FATAL ERROR: could not acquire semaphore 0x4f410000");
        exit;
    }
    if(!((@$smh = shm_attach(0x4f415304, 100))
        && @shm_put_var($smh, 0, $overflow))) {
        admin_log("FATAL ERROR: could not set overflow flag: $php_errormsg");
        exit;
    }
    shm_detach ($smh);

    #### note -- these assignments are opposite those in the delivery scripts;
    #### when we're in overflow mode, we're refilling the primary delivery
    #### tables and vice-versa
    if ($overflow) {
        $sem_deliver = 0x4f410001;
        $OG_shm_hour_ass = 0x4f415300;
        $OG_shm_hour_tar = 0x4f415301;
        $OG_shm_cr_cont  = 0x4f415302;
        $OG_shm_cr_click = 0x4f415303;
    }
    else {
        $sem_deliver = 0x4f410002;
        $OG_shm_hour_ass = 0x4f415305;
        $OG_shm_hour_tar = 0x4f415306;
        $OG_shm_cr_cont  = 0x4f415307;
        $OG_shm_cr_click = 0x4f415308;
    }

    #### now get the semaphore that we're going to hold while reloading
    #### the delivery shared memory
    if(!(($OG_sem_id = sem_get($sem_deliver, 1)) && sem_acquire($OG_sem_id))) {
        admin_log("FATAL ERROR: could not acquire semaphore $sem_deliver");
        exit;
    }
    sem_release ($sem_id);
}

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function clear_shared_memory()
{
  global $OG_shm_hour_ass;

  #### we need to do this periodically to avoid filling shared memory;
  #### since segment OAS 0 is keyed by SectionID (OAS0), over time
  #### it will fill up with unused sections' info.

  #### Note that this could be dangerous -- when we were clearing segment
  #### OAS1, we would sometimes get this error:
  ####       shmget() failed for key 0x4f415301: File exists
  #### because of this, we are no longer clearing OAS1; instead, after
  #### recording the previous hour's info for each creative, we
  #### call shm_remove_var().  After looping through all creatives running
  #### during the last hour, we have in effect cleared OAS1.

  admin_log("clearing shared memory...");

  #### if we're running for the first time, there won't be anything in here;
  #### thus we don't call clear_shared_memory() upon startup

  #### php version 4.0.7 changed the shm_remove() semantics
  if(get_php_version() >= 40007)
  {
    if(!@shm_remove(shm_attach($OG_shm_hour_ass,
                        get_prefs('ShmSizeHourlyAssignments'))))
      abort("Error clearing hourly assignment shm ($OG_shm_hour_ass) - $php_errormsg");
  }
  else
  {
    if(!@shm_remove($OG_shm_hour_ass))
      abort("Error clearing hourly assignment shm ($OG_shm_hour_ass) - $php_errormsg");
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function load_shared_memory($bLogVerbose = false)
{
  global $OG_assignments, $OG_hourly_targets, $OG_imp_caps,
         $OG_delivery_controls, $OG_fulfilled;
  global $OG_shm_hour_ass, $OG_shm_hour_tar, $OG_overflow, $OG_overflowok;

  admin_log("loading shared memory (OG_overflow = $OG_overflow)...");

  #### attach to a shared memory segment
  if(!(@$smh = shm_attach($OG_shm_hour_ass, get_prefs('ShmSizeHourlyAssignments'))))
  {
    warn("Could not attach to hourly assignments shm ($OG_shm_hour_ass) - $php_errormsg; Hourly Assignments and Hourly Targets not loaded.");
    return 0;
  }

  $assignment_count = 0;
  if($OG_assignments)
  {
    reset ($OG_assignments);
    while(list($s, $s_as) = each ($OG_assignments))
    {
      $sec_assignments = array();
      reset ($s_as);
      while(list($dim, $sd_as) = each ($s_as))
      {
        $sec_dim_assignments = array();
        while(list($c, $v) = each ($sd_as))
        {
          if(!$v) continue;

          #### if the creative has met its daily target, don't even put it
          #### into the assignment table
          if ($OG_fulfilled[$c]) continue;

          #### if we're delivering from the primary table, that means
          #### we're reloading the overflow table; if so, then we only
          #### want creatives that are OK for overflow (weight-based
          #### creatives where OverflowOK = 'Y')
          if (!$OG_overflow) {
            list ($ht) = $OG_hourly_targets[$c];
            if ($ht > 0 || !$OG_overflowok[$c]) continue;
          }

          $assignment_count++;
          array_push($sec_dim_assignments, $c);
          if ($bLogVerbose) {
            admin_log ("  assigning creative $c ($dim) to section $s");
          }
        }
        $sec_assignments[$dim] = $sec_dim_assignments;
      }

      if(!@shm_put_var($smh, $s, $sec_assignments))
        warn("Could not insert section $s assignments into shared memory ($php_errormsg)");
    }
  }
  
  if(!@shm_detach($smh))
    warn("Error detaching from hourly assignments shm ($OG_shm_hour_ass) - $php_errormsg");

  admin_log ("$assignment_count assignments made");

  #### attach to a shared memory segment
  if(!(@$smh = shm_attach($OG_shm_hour_tar, get_prefs('ShmSizeHourlyTargets'))))
  {
    warn("Could not attach to hourly targets shm ($OG_shm_hour_tar) - $php_errormsg; Hourly targets not loaded.");
    return 0;
  }

  #### we only need to update the RunningCreatives table once, while we're
  #### processing primary deliveries
  if($OG_hourly_targets)
  {
      $hour = date('G', time());
      reset ($OG_hourly_targets);
      while(list($k, $v) = each($OG_hourly_targets))
      {
        if (!$OG_overflow) {
            list ($ht) = $v;
            if ($ht > 0 || !$OG_overflowok[$k]) continue;
        }

        if(!@shm_put_var($smh, $k, $v))
          warn("Could not insert hourly targets into shared memory ($php_errormsg)");
        else {
          if ($bLogVerbose) {
            admin_log ("  inserting target info for creative $k");
          }
        }

        if ($OG_overflow)
          mysql_query("insert into RunningCreatives values ($k, $hour)");
      }
  }
  if(!@shm_put_var($smh, 0, array ('', $OG_delivery_controls)))
    warn("Could not insert imp_caps and delivery_controls into shared memory ($php_errormsg)");


  if(!@shm_put_var($smh, 0, array ($OG_imp_caps, $OG_delivery_controls)))
    warn("Could not insert imp_caps and delivery_controls into shared memory ($php_errormsg)");

  if(!@shm_detach($smh))
    warn("Error detaching from hourly targets shm ($OG_shm_hour_tar) - $php_errormsg\n");
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function housekeeping()
{
  $log_dir = get_prefs('LogDir');

  $cutoff = get_prefs('KeepLogsFor');
  $log_date = date('Y/md', time() - $cutoff * 86400);

  if (file_exists ("$log_dir/$log_date.log.gz")) {
    unlink("$log_dir/$log_date.log.gz");
  }
  if (file_exists ("$log_dir/$log_date-admin.log")) {
    unlink("$log_dir/$log_date-admin.log");
  }

  $cutoff = get_prefs('KeepStatsFor');
  $stats_date = date('Y-m-d', time() - $cutoff * 86400);
  mysql_query("delete from HourlyStats where Day<'$stats_date'");
  mysql_query("delete from CampaignDailyStats where Day<'$stats_date'");
  mysql_query("delete from SectionDailyTraffic where Day<'$stats_date'");
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function mail_reports()
{
  global $OG_active_creatives, $OASISdatefmt;

  $style = join("", file("oasis.css"));

  #### end is yesterday
  $end = time() - 86400;
  #### start a week before
  $start = $end - 6 * 86400;

  $do = ($OASISdatefmt == 'dmy') ? 'd/m/Y' : 'm/d/Y';
  $StartDate = date('Y-m-d', $start);
  $EndDate   = date('Y-m-d', $end);

  $StartDate_n = date($do, $start);
  $EndDate_n   = date($do, $end);

  $cr = join(",", array_keys ($OG_active_creatives));
  if(!$result = mysql_query("select Creatives.CampaignID, Notify from Creatives left join Campaigns on Creatives.CampaignID=Campaigns.CampaignID where CreativeID in ($cr)"))
    warn("Error querying creatives: " . mysql_error() . "\n");

  while(list($CampaignID, $email) = mysql_fetch_row($result))
    $active_campaigns[$CampaignID] = $email;

  $from_addr = get_prefs('ReportFromAddr');
  while(list($ca_id, $email) = each($active_campaigns))
  {
    if(!$email) continue;

    admin_log("sending report for Campaign $ca_id to $email...");

    $report = campaign_report($ca_id, $StartDate, $EndDate);

    $report = <<<__TEXT__
<HTML>
<HEAD><TITLE>Campaign Summary, $StartDate_n to $EndDate_n</TITLE></HEAD>
$style
<BODY>
$report
</BODY>
</HTML>
__TEXT__;

    mail($email, "Campaign Summary, $StartDate_n to $EndDate_n", $report,
         "From: $from_addr\nMIME-Version: 1.0\nContent-Type: text/html; charset=us-ascii\n");
  }

}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function mail_summary_report($ca_id)
{
  global $OASISdatefmt;

  $style = join("", file("oasis.css"));

  if($result = mysql_query("select Notify, UNIX_TIMESTAMP(EndDate), UNIX_TIMESTAMP(StartDate) from Campaigns where CampaignID=$ca_id"))
  {
    list($email, $end, $start) = mysql_fetch_row($result);

    $do = ($OASISdatefmt == 'dmy') ? 'd/m/Y' : 'm/d/Y';
    $StartDate = date('Y-m-d', $start);
    $EndDate   = date('Y-m-d', $end);
    $StartDate_n = date($do, $start);
    $EndDate_n   = date($do, $end);

    $from_addr = get_prefs('ReportFromAddr');
    if(!$email) return;

    admin_log("sending report for Campaign $ca_id to $email...");

    $report = campaign_report($ca_id, $StartDate, $EndDate, true);

    $report = <<<__TEXT__
<HTML>
<HEAD><TITLE>Campaign Summary, $StartDate_n to $EndDate_n</TITLE></HEAD>
$style
<BODY>
$report
</BODY>
</HTML>
__TEXT__;

    mail($email, "Campaign Final Summary, $StartDate_n to $EndDate_n", $report,
         "From: $from_addr\nMIME-Version: 1.0\nContent-Type: text/html; charset=us-ascii\n");
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function update_campaigns()
{
  if(!($result1 = mysql_query("select CampaignID from Campaigns where Status='Active'")))
  {
    warn("Error querying Campaigns: " . mysql_error() . "\n");
    return;
  }

  while(list($ca_id) = mysql_fetch_row($result1))
  {
    if(!($result2 = mysql_query("select CreativeID, ImpressionsDelivered, ClicksDelivered from Creatives where CampaignID=$ca_id")))
    {
      warn("Error querying Creatives: " . mysql_error() . "\n");
      return;
    }

    $tot_imp = 0;
    $tot_click = 0;
    while(list($cr_id, $imp, $click) = mysql_fetch_row($result2))
    {
      $tot_imp += $imp;
      $tot_click += $click;
    }
    $sql = "UPDATE Campaigns SET ImpressionsDelivered='$tot_imp', ClicksDelivered='$tot_click' WHERE CampaignID=$ca_id";
    $result = mysql_query($sql);
    admin_log("$sql; result = $result");
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function mark_complete()
{
  $sql = <<<__TEXT__
SELECT CreativeID 
FROM Creatives 
WHERE Status='Active' 
AND (
  (ImpressionsGuaranteed > 0 AND ImpressionsDelivered >= ImpressionsGuaranteed)
  OR (ClicksGuaranteed > 0 and ClicksDelivered >= ClicksGuaranteed) 
  OR (EndDate > '0000-00-00' 
      AND unix_timestamp(EndDate) <= unix_timestamp(now()) - 86400)
)
__TEXT__;

  if($result = mysql_query($sql))
  {
    while(list($cr_id) = mysql_fetch_row($result))
    {
      mysql_query("update Creatives set Status='Completed' where CreativeID=$cr_id");
      admin_log("Marked creative $cr_id complete");
    }
  }

  $sql = <<<__TEXT__
SELECT CampaignID 
FROM Campaigns 
WHERE Status='Active' 
AND (
  (ImpressionsGuaranteed > 0 AND ImpressionsDelivered >= ImpressionsGuaranteed)
  OR (ClicksGuaranteed > 0 and ClicksDelivered >= ClicksGuaranteed) 
  OR (EndDate > '0000-00-00' 
      AND unix_timestamp(EndDate) <= unix_timestamp(now()) - 86400)
)
__TEXT__;

  if($result = mysql_query($sql))
  {
    while(list($ca_id) = mysql_fetch_row($result))
    {
      mysql_query("update Campaigns set Status='Completed' where CampaignID=$ca_id");
      admin_log("Marked campaign $ca_id complete");
      mail_summary_report($ca_id);
    }
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function check_for_underdelivery()
{
  $msg = '';

  if(!($result = mysql_query("select Target, Remaining, Creatives.CreativeID, Creatives.Name, Campaigns.Name from DailyTargets left join Creatives on DailyTargets.CreativeID=Creatives.CreativeID left join Campaigns on Creatives.CampaignID=Campaigns.CampaignID")))
    die("Error querying DailyTargets: " . mysql_error() . "\n");

  while(list($target, $rem, $cr_id, $cr_name, $ca_name) = mysql_fetch_row($result))
  {
    if($target > 0 && $rem > 0)
    {
      $msg .= "$ca_name/$cr_name: $target scheduled, $rem undelivered\n";
__TEXT__;

    }
  }
  $admin_email = get_prefs('AdminEmail');
  if($msg) mail($admin_email, "Underdelivery Report", $msg);
}


?>
