<?php

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function mysql_date_to_unix($d)
{
  preg_match('#(\d+)-(\d+)-(\d+)#', $d, $matches);
  list($junk, $year, $month, $day) = $matches;
  return mktime(0, 0, 0, $month, $day, $year);
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function days_in_month ($m, $y)
{
  if ($m == 12) {
    $y++;
    $m = 1;
  }
  else {
    $m++;
  }

  return date ('j', mktime (0, 0, 0, $m, 0, $y));
}


####---------------------------------------------------------------------------
#### returns a float indicating the number of months between two dates
####---------------------------------------------------------------------------
function num_months($fd, $td)
{
  preg_match ('#(\d+)-(\d+)-(\d+)#', $fd, $matches);
  list ($junk, $fy, $fm, $fd) = $matches;

  preg_match ('#(\d+)-(\d+)-(\d+)#', $td, $matches);
  list ($junk, $ty, $tm, $td) = $matches;

  $num_months += ($ty - $fy) * 12;
  $num_months += ($tm - $fm - 1);

  $dim = days_in_month ($fm, $fy);
  $num_months += ($dim - $fd + 1) / $dim;

  $dim = days_in_month ($tm, $ty);
  $num_months += $td / $dim;

  return $num_months;
}



####---------------------------------------------------------------------------
#### returns 1 if invoices exist for the time period, 0 otherwise
####---------------------------------------------------------------------------
function existing_invoices ($td, $fd, $pid, $ca_id)
{
  #### check to see if invoices have already been generated
  #### for this period.
  if ($ca_id)
    $sql = "select InvoiceID from Invoices where FromDate <= '$td' and ToDate >= '$fd' and CampaignID=$ca_id";
  else
    $sql = "select InvoiceID from PublisherInvoices where FromDate <= '$td' and ToDate >= '$fd' and PublisherID=$pid";

  if(!($result = mysql_query($sql)))
  {
    print "$OASISmsg[error_existing_invoices]: " . mysql_error();
    return 1;
  }

  if(mysql_num_rows($result) > 0) return 1;

  return 0;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function generate_adv_invoice($ca_id, $fd, $td, $id, $sent, $paid)
{
  global $OASISmsg;
  global $OG_PubID;

  #print "generating invoice for CampaignID: $ca_id ($fd - $td, $id)<BR>\n";
  $net_due = get_prefs('InvoiceDue');

  if(!mysql_query("lock tables Campaigns read, Invoices write, CampaignDailyStats read, Creatives read, Publishers read"))
  {
    print "$OASISmsg[error_locking_Invoices_table]\n";
    return;
  }

  #### check to see if invoices have already been generated
  #### for this period.
  if (existing_invoices ($td, $fd, 0, $ca_id)) {
    mysql_query("unlock tables");
    return;
  }

  $sql = "select AdvertiserID, Fixed, CPM, CPC, ImpressionsGuaranteed, StartDate, EndDate, unix_timestamp(StartDate), unix_timestamp(EndDate), AgencyCommission, PurchaseOrder, PayFixed from Campaigns where CampaignID=$ca_id";

  if(!$result = mysql_query($sql))
  {
    print "$OASISmsg[error_pulling_campaign]: " . mysql_error();
    mysql_query("unlock tables");
    return;
  }
  list($a_id, $fixed, $cpm, $cpc, $impg, $sd, $ed, $st, $et, $ac, $po, $pay_fixed)
	                     = mysql_fetch_row($result);

  list($impd, $cd, $imphash, $chash) = get_impclick($ca_id, $fd, $td, $OG_PubID);

  $cpmc = round($cpm * $impd / 10) / 100;
  $cpcc = round($cpc * $cd * 100) / 100;

  #### compute how much of the fixed cost should be charged this month.
  $ft = mysql_date_to_unix ($fd);
  $tt = mysql_date_to_unix ($td);

  $fixedc = get_fixed($ft, $tt, $st, $et, $fixed, $pay_fixed, $ca_id);
  $acc  = Ceil($ac * ($fixedc + $cpmc + $cpcc)) / 100;

  preg_match('#(\d+)-(\d+)-(\d+)#', $id, $matches);
  list($junk, $year, $month, $day) = $matches;
  $ddue = date('Y-m-d',
               mktime(0, 0, 0, $month, $day, $year) + $net_due * 86400);
  $inum = $a_id . "-" . $ca_id . "-"
          . date('Ymd',
               mktime(0, 0, 0, $month, $day, $year) + $net_due * 86400);

  $sent = ($sent) ? 'Y' : 'N';
  $paid = ($paid) ? 'Y' : 'N';

  $sql = "insert into Invoices (CampaignID, InvoiceNumber, InvoiceDate, DueDate, FromDate, ToDate, ImpressionsDelivered, ClicksDelivered, CPM, CPC, Fixed, AgencyCommission, CPMCharge, CPCCharge, FixedCharge, AgencyCommissionCharge, PurchaseOrder, Sent, Paid) values ($ca_id, '$inum', '$id', '$ddue', '$fd', '$td', $impd, $cd, $cpm, $cpc, $fixed, $ac, $cpmc, $cpcc, $fixedc, $acc, '$po', '$sent', '$paid')";

  if(!mysql_query($sql))
  {
    print "$OASISmsg[Error_saving_invoice]: " . mysql_error() . "<BR>$sql<BR>\n";
    mysql_query("unlock tables");
    return;
  }

  mysql_query("unlock tables");
  return array($fixedc, $cpmc, $cpcc, $acc);
}


####---------------------------------------------------------------------------
#### subroutine to generate an invoice for a subpublisher
####  - pulls all network campaigns that have run on the subpub's sections;
####    calculates credits for the subpub
####  - pulls all of the subpub's campaigns and calculates network payments
####    due
####  - calculates hosting charges
####---------------------------------------------------------------------------
function generate_pub_invoice($spid, $fd, $td, $id, $sent, $paid)
{
  global $OG_PubID;

  $net_due = get_prefs('InvoiceDue');

  if(!mysql_query("lock tables Campaigns read, PublisherInvoices write, CampaignDailyStats read, Creatives read, Advertisers read, Publishers read"))
  {
    print "$OASISmsg[error_locking_Invoices_table]\n";
    return;
  }

  #### check to see if invoices have already been generated
  #### for this period.
  if (existing_invoices ($td, $fd, $spid, 0)) {
    mysql_query("unlock tables");
    return;
  }

  #### get network campaigns
  $parent_hash = get_parent_pubs ($spid);
  $parent_ids = array_keys ($parent_hash);
  $filter_str = join (',', $parent_ids);

  #### collect all the subpublishers; we'll need this to get complete
  #### impression and click counts for network campaigns
  list ($subpub_hash) = get_all_subpubs ($spid);

  $sql = <<<__TEXT__
SELECT 
  CampaignID, Advertisers.PublisherID, Campaigns.Name, Advertisers.Name, 
  unix_timestamp(StartDate), unix_timestamp(EndDate), 
  CPM, CPC, Fixed, PayFixed, AgencyCommission, EvenDelivery
FROM 
  Campaigns LEFT JOIN
  Advertisers ON Campaigns.AdvertiserID = Advertisers.AdvertiserID 
WHERE
  StartDate <= '$td' 
  AND (EndDate = '0000-00-00' OR EndDate >= '$fd')
  AND Status!='Cancelled' 
  AND Advertisers.PublisherID IN ($filter_str)
ORDER BY Advertisers.Name, Campaigns.Name
__TEXT__;

  if(!$result = mysql_query($sql))
  {
    print "$OASISmsg[error_pulling_campaign]: " . mysql_error();
    mysql_query("unlock tables");
    return;
  }

  $cpmcr_tot = 0;
  $cpccr_tot = 0;
  $fixedcr_tot = 0;
  $impdcr_tot = 0;
  $clickdcr_tot = 0;
print "<P>Publisher $spid<BR>\n";
  while(list($ca_id, $pid, $ca_name, $a_name, $st, $et, $cpm, $cpc, $fixed, $pf, $ac, $even) = mysql_fetch_row($result))
  {
    #### how much of this campaign revenue will be paid to us?
    list ($pname, $my_cpm, $my_cpmperc,
                  $my_cpc, $my_cpcperc,
                  $my_fixed, $my_fixedperc) = $parent_hash[$pid];

    list($caimpd, $caclickd, $imphash, $clickhash) 
      = get_impclick($ca_id, $fd, $td);

    $impd = 0;
    $clickd = 0;
    foreach (array_keys ($subpub_hash) as $p) {
      $impd += $imphash[$p];
      $clickd += $clickhash[$p];
    }

    $impdcr_tot += $impd;
    $clickdcr_tot += $clickd;

    #### adjust the rates to reflect our percentage
    $cpm   = $my_cpm + $cpm * $my_cpmperc;
    $cpc   = $my_cpc + $cpc * $my_cpcperc;
    $fixed = $my_fixed + $fixed * $my_fixedperc;

    #### round as you go (just like when calculating revenue reports;
    #### this way, the values are identical)
    $cpmcr_tot += round ($cpm * $impd / 1000 * 100) / 100;
    $cpccr_tot += round ($cpc * $clickd * 100) / 100;

    #### compute how much of the fixed cost should be charged this month.
    $ft = mysql_date_to_unix ($fd);
    $tt = mysql_date_to_unix ($td);
    $fixedc = get_fixed($ft, $tt, $st, $et, $fixed, $pf, $ca_id);

    #### we only get paid a fraction of the fixed cost, based on the fraction
    #### of the overall impressions we've delivered
    $tmpfixed = ($caimpd > 0) ? ($fixedc * $impd / $caimpd) : 0;
    $fixedcr_tot += round ($tmpfixed * 100) / 100;
  }


  #### get publisher's (and its subpubs') campaigns
  list ($subpub_hash) = get_all_subpubs ($spid);
  $filter_str = join (',', array_keys ($subpub_hash));

  #### now get the subpub info from the perspective of the currently logged
  #### in publisher, so we can determine how much to charge subpubs
  list ($subpub_hash) = get_all_subpubs ($OG_PubID);

  $sql = <<<__TEXT__
SELECT CampaignID, Fixed, CPM, CPC, ImpressionsGuaranteed, StartDate, 
  EndDate, unix_timestamp(StartDate), unix_timestamp(EndDate), 
  PayFixed, PublisherID
FROM Campaigns 
WHERE PublisherID in ($filter_str)
__TEXT__;

  if(!$result = mysql_query($sql))
  {
    print "$OASISmsg[error_pulling_campaign]: " . mysql_error();
    mysql_query("unlock tables");
    return;
  }
  
  $cpmc_tot = 0;
  $cpcc_tot = 0;
  $fixedc_tot = 0;
  $impd_tot = 0;
  $cd_tot = 0;
  while (list($ca_id, $fixed, $cpm, $cpc, $impg, 
              $sd, $ed, $st, $et, $pay_fixed, $pid)
	                     = mysql_fetch_row($result)) {

    #### since get_all_subpubs() also includes the current publisher,
    #### we'll need to skip its campaigns
    if ($pid == $OG_PubID) continue;

    #### how much of this campaign revenue will be paid to us?
    list ($pname, $my_cpm, $my_cpmperc,
                  $my_cpc, $my_cpcperc, 
                  $my_fixed, $my_fixedperc) = $subpub_hash[$pid];

    list($impd, $cd, $imphash, $chash)
          = get_impclick($ca_id, $fd, $td, $pid);

    $impd_tot += $impd;
    $cd_tot += $cd;

    $cpm   = $my_cpm + $cpm * $my_cpmperc;
    $cpc   = $my_cpc + $cpc * $my_cpcperc;

    #### round as you go (just like when calculating revenue reports;
    #### this way, the values are identical)
    $cpmc_tot += round($cpm * $impd / 10) / 100;
    $cpcc_tot += round($cpc * $cd * 100) / 100;

    #### compute how much of the fixed cost should be charged this month.
    $ft = mysql_date_to_unix ($fd);
    $tt = mysql_date_to_unix ($td);
    $fixedc = get_fixed($ft, $tt, $st, $et, $fixed, $pay_fixed, $ca_id);

    $fixedfraction = ($fixed > 0) ? ($fixedc / $fixed) : 0;
    $tmpfixed = $my_fixed * $fixedfraction + $fixedc * $my_fixedperc;
    $fixedc_tot += round ($tmpfixed * 100) / 100;
  }

  #### get hosting charges
  $pub_info = get_pub_info($spid);
  $hc = $pub_info[14];
  $num_months = num_months ($fd, $td);
  $hc = $hc * $num_months;

  preg_match('#(\d+)-(\d+)-(\d+)#', $id, $matches);
  list($junk, $year, $month, $day) = $matches;
  $ddue = date('Y-m-d',
               mktime(0, 0, 0, $month, $day, $year) + $net_due * 86400);
  $inum = $spid . "-"
            . date('Ymd',
               mktime(0, 0, 0, $month, $day, $year) + $net_due * 86400);

  $sent = ($sent) ? 'Y' : 'N';
  $paid = ($paid) ? 'Y' : 'N';

  $sql = <<<__TEXT__
INSERT INTO PublisherInvoices
  (PublisherID, InvoiceNumber, InvoiceDate, DueDate, FromDate, ToDate,
   ImpressionsDeliveredCredit, ClicksDeliveredCredit,
   ImpressionsDelivered, ClicksDelivered, 
   CPMCredit, CPCCredit, FixedCredit,
   CPMCharge, CPCCharge, FixedCharge,
   HostingCharge,
   Sent, Paid) 
VALUES
  ($spid, '$inum', '$id', '$ddue', '$fd', '$td', 
   $impdcr_tot, $clickdcr_tot, $impd_tot, $cd_tot,
   $cpmcr_tot, $cpccr_tot, $fixedcr_tot,
   $cpmc_tot, $cpcc_tot, $fixedc_tot,
   $hc,
   '$sent', '$paid')
__TEXT__;

  if(!mysql_query($sql))
  {
    print "$OASISmsg[Error_saving_invoice]: " . mysql_error() . "<BR>$sql<BR>\n";
    mysql_query("unlock tables");
    return;
  }

  mysql_query("unlock tables");
  return array($hc, $fixedc_tot - $fixedcr_tot, $cpmc_tot - $cpmcr_tot, $cpcc_tot - $cpccr_tot);
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function get_impclick($CampaignID, $FromDate, $ToDate)
{
  global $OASISmsg;

  $sql = "select Impressions, Clicks, PublisherID from CampaignDailyStats where CampaignID=$CampaignID and Day >= '$FromDate' and Day <= '$ToDate'";

  if(!($result = mysql_query($sql)))
  {
    print "$OASISmsg[Error_pulling_campaign_delivery_numbers]: " . mysql_error();
    exit;
  }

  $imp_total = 0;
  $click_total = 0;
  while(list($imp, $click, $pid) = mysql_fetch_row($result))
  {
    $imp_total   += $imp;
    $click_total += $click;

    $imp_hash[$pid] += $imp;
    $click_hash[$pid] += $click;
  }

  return array($imp_total, $click_total, $imp_hash, $click_hash);
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function get_netpay($impd, $cpm, $clickd, $cpc, $fixed, $fixedc,
                    $subpub_info, $subpub_impd, $subpub_clickd)
{
  list ($spcpm, $spcpmperc, $spcpc, $spcpcperc, $spfixed, $spfixedperc)
    = $subpub_info;

  $cpm = $cpm * $spcpmperc / 100 + $spcpm;
  $cpc = $cpc * $spcpcperc / 100 + $spcpc;

  $cpmc = $cpm * $subpub_impd / 1000;
  $cpcc = $cpc * $subpub_clickd;

  #### what fraction of the fixed campaign cost are we being paid this month?  
  $fixedfraction = ($fixed > 0) ? ($fixedc / $fixed) : 0;

  #### we only pay the subpublisher for the fraction of the campaign he's
  #### actually running, so we multiply by subpub_impd / impd
  $subpub_del_perc = ($impd) ? $subpub_impd / $impd : 0;
  $fixedc = ($fixedfraction * $spfixed + $fixedc * $spfixedperc / 100)
              * $subpub_del_perc;

  $cpmc = round ($cpmc * 100) / 100;
  $cpcc = round ($cpcc * 100) / 100;
  $fixedc = round ($fixedc * 100) / 100;

  return $cpmc + $cpcc + $fixedc;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function get_fixed($ft, $tt, $st, $et, $fixed, $pay_fixed, $ca_id)
{
  #### if we're spreading the fixed payments out over the life of the
  #### campaign, find out what percentage of the campaign has elapsed during
  #### this billing period and charge accordingly
  $fixedc = 0;
  if($pay_fixed == "By Period")
  {
    if(($st > 0) && ($st <= $tt || $et >= $ft))
    {
      #### simplistic calculation, but will lead to rounding errors
      #### (for example, $1000/3 = $333.33, three installments will lead
      #### to a total of $999.99).
      #$start = ($st > $ft) ? $st : $ft;
      #$end   = ($et < $tt) ? $et : $tt;
      #$fixedc = round($fixed * ($end - $start + 86400)
                        #/ ($et - $st + 86400) * 100) / 100;

      #### start and end of billing period
      $sbp = ($ft < $st) ? $st : $ft;
      $ebp = ($tt > $et) ? $et : $tt;

      #### start and end of remainder of campaign
      $scr = ($ft < $st) ? $st : $ft;
      $ecr = $et;

      #### now compute the fraction of the campaign's remaining runtime
      #### covered by the billing period; multiply by the fixed amount
      #### remaining to be invoiced

      #### believe it or not, we have to round, because the switch to
      #### and from DST will cause us to have fractional days
      $bpdr = round(($ebp - $sbp + 86400) / 86400);
      $cdr = round(($ecr - $scr + 86400) / 86400);
      $invoiced = get_invoiced_fixed($ca_id, $sbp);

      $fixedc = round(($fixed - get_invoiced_fixed($ca_id, $sbp))
                      * $bpdr / $cdr * 100) / 100;
    }

    #### if we can't calculate the percentage of the campaign that's
    #### run this billing period, then we'll have to treat this as
    #### a CIA situation
    else $pay_fixed = "CIA";
  }

  #### if we're paying at the end of campaign, determine whether the
  #### end of campaign happened during this billing period.
  elseif($pay_fixed == "End of Campaign")
  {
    if($et > 0)
    {
      if($ft <= $et && $tt >= $et) $fixedc = $fixed;
    }

    #### if no end time is set, then we'll have to treat this as
    #### a CIA situation
    else $pay_fixed = "CIA";
  }

  #### if the fixed charge is to be paid in advance, determine whether
  #### the beginning of campaign happened during this billing period.
  if($pay_fixed == "CIA")
  {
    if($ft <= $st && $tt >= $st) $fixedc = $fixed;
  }

  return $fixedc;
}


####---------------------------------------------------------------------------
#### returns the amount of fixed charges already invoiced to a campaign
####---------------------------------------------------------------------------
function get_invoiced_fixed($ca_id, $start_of_bp)
{
  $fixed_total = 0;
  $result = mysql_query("select FixedCharge from Invoices where CampaignID=$ca_id and unix_timestamp(ToDate) < $start_of_bp");
  while(list($fixed) = mysql_fetch_row($result))
  {
    $fixed_total += $fixed;
  }

  return $fixed_total;
}


?>
