<?php

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function html_adv_invoice($InvoiceID)
{
  global $OASISmsg, $OASISlcurrsym, $OASIStcurrsym, $OASIScurrdp,
                $OASISdecpt, $OASIStsep, $OASISdatefmt;

  $datefmt = ($OASISdatefmt == 'mdy') 
                 ? '%M&nbsp;%e,&nbsp;%Y'
                 : '%e&nbsp;%M,&nbsp;%Y';

  $sql = <<<__TEXT__
SELECT
  InvoiceNumber, 
  date_format(InvoiceDate, '$datefmt'), 
  date_format(DueDate, '$datefmt'), 
  date_format(ca.StartDate, '$datefmt'), 
  date_format(ca.EndDate, '$datefmt'), 
  date_format(FromDate, '$datefmt'), 
  date_format(ToDate, '$datefmt'), 
  unix_timestamp(FromDate), unix_timestamp(ToDate), 
  i.CampaignID, ca.Name, ca.ImpressionsGuaranteed, 
  a.Name, StreetAddress, City, State, PostalCode, Country, 
  i.CPM, i.CPC, i.Fixed, i.ImpressionsDelivered, 
  i.ClicksDelivered, i.AgencyCommission, 
  CPMCharge, CPCCharge, FixedCharge, AgencyCommissionCharge, 
  i.PurchaseOrder, i.Paid, ca.PayFixed 
FROM Invoices i
LEFT JOIN Campaigns ca ON i.CampaignID=ca.CampaignID 
LEFT JOIN Advertisers a ON ca.AdvertiserID=a.AdvertiserID 
WHERE InvoiceID=$InvoiceID
__TEXT__;

  if(!$result = mysql_query($sql))
  {
    print "$OASISmsg[Error_pulling_invoice_info]: " . mysql_error();
    exit;
  }
  list($i_num, $i_date, $dd, $sd, $ed, $fd, $td,
       $ft, $tt, $ca_id, $ca_name,
       $impg, $a_name, $street, $city, $state, $pcode, $country,
       $cpm, $cpc, $fixed,
       $impd, $clickd, $ac,
       $cpmc, $cpcc, $fixedc, $acc, $po,
       $paid, $pay_fixed) = mysql_fetch_row($result);
  
  $header_string  = get_prefs('InvoiceHeaderString');
  $footer_string  = get_prefs('InvoiceFooterString');
  $header_graphic = get_prefs('InvoiceHeaderGraphic');
  $invoice_due    = get_prefs('InvoiceDue');

  $street = preg_replace("#\n#s", "<BR>\n", $street);

  $agb = number_format($fixedc + $cpmc + $cpcc,
                $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $net_due = number_format($fixedc + $cpmc + $cpcc - $acc,
                $OASIScurrdp, $OASISdecpt, $OASIStsep);

  $cpmc    = number_format($cpmc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $cpcc    = number_format($cpcc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $fixedc  = number_format($fixedc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $impg    = number_format($impg, 0, $OASISdecpt, $OASIStsep);
  $impd    = number_format($impd, 0, $OASISdecpt, $OASIStsep);
  $clickd  = number_format($clickd, 0, $OASISdecpt, $OASIStsep);

  if($fixed > 0) $fixed_block = <<<__TEXT__
<TR>
<TD><B>$OASISmsg[Fixed_Charge]:</B></TD>
<TD WIDTH="25%"></TD>
<TD WIDTH="25%"></TD>
<TD ALIGN=right>$OASISlcurrsym$fixedc$OASIStcurrsym</TD>
</TR>
__TEXT__;

  if($cpm > 0) $cpm_block = <<<__TEXT__
<TR>
<TD><B>$OASISmsg[Impressions_Delivered]:</B></TD>
<TD WIDTH="25%">$impd</TD>
<TD WIDTH="25%">x $OASISlcurrsym$cpm$OASIStcurrsym / 1000 =</TD>
<TD ALIGN=right>$OASISlcurrsym$cpmc$OASIStcurrsym</TD>
</TR>
__TEXT__;

  if($cpc > 0) $cpc_block = <<<__TEXT__
<TR>
<TD><B>$OASISmsg[Clicks_Delivered]:</B></TD>
<TD WIDTH="25%">$clickd</TD>
<TD WIDTH="25%">x $OASISlcurrsym$cpc$OASIStcurrsym =</TD>
<TD ALIGN=right>$OASISlcurrsym$cpcc$OASIStcurrsym</TD>
</TR>
__TEXT__;

  if($acc > 0) $ac_block = <<<__TEXT__
<TR>
<TD><B>$OASISmsg[Agency_Commission]:</B></TD>
<TD></TD>
<TD></TD>
<TD ALIGN=right>- $OASISlcurrsym$acc$OASIStcurrsym</TD>
</TR>
__TEXT__;

  if($cpm > 0)
    $cost_block .= "<TR><TD><B>$OASISmsg[CPM]:</B></TD><TD>$OASISlcurrsym$cpm$OASIStcurrsym</TD></TR>";
  if($cpc > 0)
    $cost_block .= "<TR><TD><B>$OASISmsg[CPC]:</B></TD><TD>$OASISlcurrsym$cpc$OASIStcurrsym</TD></TR>";
  if($fixed > 0)
    $cost_block .= "<TR><TD><B>$OASISmsg[Fixed]:</B></TD><TD>$OASISlcurrsym$fixed$OASIStcurrsym</TD></TR>";

  if($paid == 'Y')
  {
    $paid_label = ($cpm == 0 && $cpc == 0 && $fixed > 0 && $pay_fixed == 'CIA')
        ? $OASISmsg[Paid_in_Advance] : $OASISmsg[Paid];
    $paid_block = <<<__TEXT__
<TR>
<TD><B>$OASISmsg[Total]:</B></TD>
<TD></TD>
<TD></TD>
<TD ALIGN=right>$OASISlcurrsym$net_due$OASIStcurrsym</TD>
</TR>
<TR>
<TD><B>$paid_label:</B></TD>
<TD></TD>
<TD></TD>
<TD ALIGN=right>- $OASISlcurrsym$net_due$OASIStcurrsym</TD>
</TR>
__TEXT__;
    $net_due = "0.00";
  }


  $invoice = <<<__TEXT__
<HTML>
<HEAD>
<TITLE>$OASISmsg[OASIS_Invoice]</TITLE>
<LINK rel="stylesheet" type="text/css" href="oasis.css">
</HEAD>
<BODY BGCOLOR="#ffffff">
<DIV ALIGN=center>

<!-- /header table -->
<TABLE WIDTH=615><TR>
<TD VALIGN=top>
<IMG SRC="$header_graphic"><BR>
<FONT SIZE="+2"><B>$header_string</B></FONT><BR>
</TD>

<TD VALIGN=top>

<!-- upper-right box table -->
<TABLE CELLSPACING=0 BORDER=1 ALIGN=right><TR><TD>
<TABLE WIDTH="100%" CELLSPACING=2>
<TR>
<TD><B>$OASISmsg[Invoice__Number]:</B></TD>
<TD>$i_num</TD>
</TR>
<TR>
<TD><B>$OASISmsg[Invoice__Date]:</B></TD>
<TD>$i_date</TD>
</TR>
<TR>
<TD><B>$OASISmsg[Terms]:</B></TD>
<TD>$OASISmsg[Net] $invoice_due $OASISmsg[Days]</TD>
</TR>
<TR>
<TD><B>$OASISmsg[Due_Date]:</B></TD>
<TD>$dd</TD>
</TR>
</TABLE>
</TD></TR></TABLE>
<!-- /upper-right box table -->

</TD>

</TR></TABLE>
<!-- /header table -->
<P>


<!-- top third table -->
<TABLE WIDTH="615" BORDER=0><TR>
<TD VALIGN=top WIDTH="50%">

<!-- advertiser details -->
<TABLE WIDTH=290>
<TR>
<TD VALIGN=top><B>$OASISmsg[Bill__To]:</B></TD>
<TD>$a_name<BR>
$street<BR>
$city, $state  $pcode<BR>
$country
</TD>
</TR>
</TABLE>
<!-- /advertiser details -->

</TD>

<TD VALIGN=top ALIGN=right>

<!-- campaign details -->
<TABLE>
<TR>
<TD VALIGN=top><B>$OASISmsg[Campaign]:</B></TD>
<TD>$ca_name</TD>
</TR>
<TR>
<TD><B>$OASISmsg[Start_Date]:</B></TD>
<TD>$sd</TD>
</TR>
<TR>
<TD><B>$OASISmsg[End_Date]:</B></TD>
<TD>$ed</TD>
</TR>
<TR>
<TD><B>$OASISmsg[Impressions]:</B></TD>
<TD>$impg</TD>
</TR>
$cost_block
</TABLE>
<!-- /campaign details -->
</TD></TR></TABLE>
<!-- /top third table -->


<TABLE WIDTH=615>
<TR>
<TD WIDTH="615"><HR NOSHADE></TD>
</TR>
<TR>
<TD><FONT SIZE="+1"><B>$OASISmsg[Ads_Delivered]</B></FONT></TD>
</TR>
</TABLE>

<TABLE WIDTH=615>
<TR>
<TD><B>$OASISmsg[Period]:</B></TD>
<TD COLSPAN=3>$fd $OASISmsg[to] $td</TD>
</TR>

$fixed_block
$cpm_block
$cpc_block

<TR>
<TD></TD>
<TD></TD>
<TD></TD>
<TD><HR NOSHADE SIZE=1 color='#000000' style="border-color:'#000000'"></TD>
</TR>

<TR>
<TD><B>$OASISmsg[Actual_Gross_Billing]:</B></TD>
<TD></TD>
<TD></TD>
<TD ALIGN=right>$OASISlcurrsym$agb$OASIStcurrsym</TD>
</TR>

$ac_block

<TR>
<TD></TD>
<TD></TD>
<TD></TD>
<TD><HR NOSHADE SIZE=1 color='#000000' style="border-color:'#000000'"></TD>
</TR>

$paid_block

<TR>
<TD><B>$OASISmsg[Net_Due_Amount]:</B></TD>
<TD></TD>
<TD></TD>
<TD ALIGN=right BGCOLOR="#cccccc">$OASISlcurrsym$net_due$OASIStcurrsym</TD>
</TR>
</TABLE>

__TEXT__;


  $d = $ft;
  while($d <= $tt)
  {
    $ymd = date('Y-m-d', $d);

    if(!($result = mysql_query("select Impressions, Clicks from CampaignDailyStats where Day='$ymd' and CampaignID=$ca_id")))
    {
      print "$OASISmsg[Error_pulling_campaign_delivery_numbers]: " . mysql_error();
      exit;
    }

    $imp_total = 0; $click_total = 0;
    while(list($imp, $click) = mysql_fetch_row($result))
    {
      $imp_total += $imp;
      $click_total += $click;
    }

    if($imp_total == 0) { $d += 86400; continue; }

    $ct_rate = sprintf("%.2f", $click_total / $imp_total * 100);

    $bgcolor = ($bgcolor == '#ffffff') ? '#cccccc' : '#ffffff';

    $imp_total = number_format($imp_total, 0, $OASISdecpt, $OASIStsep);
    $click_total = number_format($click_total, 0, $OASISdecpt, $OASIStsep);

    $campaign_detail .= <<<__TEXT__
<TR BACKGROUND='' BGCOLOR=$bgcolor>
<TD>$ymd</TD>
<TD ALIGN=right>$imp_total</TD>
<TD ALIGN=right>$click_total</TD>
<TD ALIGN=right>$ct_rate</TD>
</TR>
__TEXT__;

    $d += 86400;
  }
  
  if($campaign_detail)
  {
    $invoice .= <<<__TEXT__
<TABLE WIDTH=615>
<TR>
<TD WIDTH=615><HR NOSHADE></TD>
</TR>

<TR>
<TD><FONT SIZE="+1"><B>$OASISmsg[Campaign_Detail]</B></FONT></TD>
</TR>
</TABLE>
<P>

<TABLE BORDER=1 CELLPADDING=1 CELLSPACING=0 WIDTH="615">
<TR BGCOLOR="#000066">
<TD><FONT COLOR="#ffffff"><B>$OASISmsg[Date]</B></FONT></TD>
<TD><FONT COLOR="#ffffff"><B>$OASISmsg[Impressions_Delivered]</B></FONT></TD>
<TD><FONT COLOR="#ffffff"><B>$OASISmsg[Clickthroughs]</B></FONT></TD>
<TD><FONT COLOR="#ffffff"><B>$OASISmsg[CT_Rate]</B></FONT></TD>
</TR>

$campaign_detail

</TABLE>
__TEXT__;
  }

  if($footer_string)
  {
    $invoice .= <<<__TEXT__
<TABLE WIDTH=615>
<TR>
<TD WIDTH=615><HR NOSHADE></TD>
</TR>
<TR><TD WIDTH=615>
<FONT SIZE="-1">
$footer_string
</FONT>
</TD></TR></TABLE>
__TEXT__;
  }

  $invoice .= <<<__TEXT__
</DIV>
</BODY>
</HTML>
__TEXT__;

  return $invoice;
}

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function html_pub_invoice($InvoiceID)
{
  global $OASISmsg, $OASISlcurrsym, $OASIStcurrsym, $OASIScurrdp,
                $OASISdecpt, $OASIStsep, $OASISdatefmt;

  $datefmt = ($OASISdatefmt == 'mdy') 
                 ? '%M&nbsp;%e,&nbsp;%Y'
                 : '%e&nbsp;%M,&nbsp;%Y';

  $sql = <<<__TEXT__
SELECT
  InvoiceNumber, 
  date_format(InvoiceDate, '$datefmt'), 
  date_format(DueDate, '$datefmt'), 
  date_format(FromDate, '$datefmt'), 
  date_format(ToDate, '$datefmt'), 
  unix_timestamp(FromDate), unix_timestamp(ToDate), 
  p.Name, StreetAddress, City, State, PostalCode, Country, 
  i.ImpressionsDeliveredCredit, i.ClicksDeliveredCredit,
  i.ImpressionsDelivered, i.ClicksDelivered,
  i.CPMCredit, i.CPCCredit, i.FixedCredit,
  i.CPMCharge, i.CPCCharge, i.FixedCharge,
  i.HostingCharge,
  i.Paid
FROM PublisherInvoices i
LEFT JOIN Publishers p ON i.PublisherID=p.PublisherID 
WHERE InvoiceID=$InvoiceID
__TEXT__;

  if(!$result = mysql_query($sql))
  {
    print "$OASISmsg[Error_pulling_invoice_info]: " . mysql_error();
    exit;
  }
  list($i_num, $i_date, $dd, $fd, $td,
       $ft, $tt,
       $pname, $street, $city, $state, $pcode, $country,
       $impdcr, $clickdcr,
       $impd, $clickd,
       $cpmcr, $cpccr, $fixedcr,
       $cpmc, $cpcc, $fixedc, $hosting,
       $paid) = mysql_fetch_row($result);
  
  $header_string  = get_prefs('InvoiceHeaderString');
  $footer_string  = get_prefs('InvoiceFooterString');
  $header_graphic = get_prefs('InvoiceHeaderGraphic');
  $invoice_due    = get_prefs('InvoiceDue');

  $street = preg_replace("#\n#s", "<BR>\n", $street);

  $net_due = number_format($fixedc + $cpmc + $cpcc + $hosting
                           - ($fixedcr + $cpmcr + $cpccr),
                $OASIScurrdp, $OASISdecpt, $OASIStsep);

  $cpmcr    = number_format($cpmcr, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $cpccr    = number_format($cpccr, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $fixedcr  = number_format($fixedcr, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $cpmc     = number_format($cpmc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $cpcc     = number_format($cpcc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $fixedc   = number_format($fixedc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $hosting  = number_format($hosting, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $impdcr   = number_format($impdcr, 0, $OASISdecpt, $OASIStsep);
  $clickdcr = number_format($clickdcr, 0, $OASISdecpt, $OASIStsep);
  $impd     = number_format($impd, 0, $OASISdecpt, $OASIStsep);
  $clickd   = number_format($clickd, 0, $OASISdecpt, $OASIStsep);

  if($paid == 'Y')
  {
    $paid_label = ($cpm == 0 && $cpc == 0 && $fixed > 0 && $pay_fixed == 'CIA')
        ? $OASISmsg[Paid_in_Advance] : $OASISmsg[Paid];
    $paid_block = <<<__TEXT__
<TR>
<TD><B>$OASISmsg[Total]:</B></TD>
<TD></TD>
<TD></TD>
<TD ALIGN=right>$OASISlcurrsym$net_due$OASIStcurrsym</TD>
</TR>
<TR>
<TD><B>$paid_label:</B></TD>
<TD></TD>
<TD></TD>
<TD ALIGN=right>- $OASISlcurrsym$net_due$OASIStcurrsym</TD>
</TR>
__TEXT__;
    $net_due = "0.00";
  }


  $invoice = <<<__TEXT__
<HTML>
<HEAD>
<TITLE>$OASISmsg[OASIS_Invoice]</TITLE>
<LINK rel="stylesheet" type="text/css" href="oasis.css">
</HEAD>
<BODY BGCOLOR="#ffffff">
<DIV ALIGN=center>

<!-- /header table -->
<TABLE WIDTH=615><TR>
<TD VALIGN=top>
<IMG SRC="$header_graphic"><BR>
<FONT SIZE="+2"><B>$header_string</B></FONT><BR>
</TD>

<TD VALIGN=top>

<!-- upper-right box table -->
<TABLE CELLSPACING=0 BORDER=1 ALIGN=right><TR><TD>
<TABLE WIDTH="100%" CELLSPACING=2>
<TR>
<TD><B>$OASISmsg[Invoice__Number]:</B></TD>
<TD>$i_num</TD>
</TR>
<TR>
<TD><B>$OASISmsg[Invoice__Date]:</B></TD>
<TD>$i_date</TD>
</TR>
<TR>
<TD><B>$OASISmsg[Terms]:</B></TD>
<TD>$OASISmsg[Net] $invoice_due $OASISmsg[Days]</TD>
</TR>
<TR>
<TD><B>$OASISmsg[Due_Date]:</B></TD>
<TD>$dd</TD>
</TR>
</TABLE>
</TD></TR></TABLE>
<!-- /upper-right box table -->

</TD>

</TR></TABLE>
<!-- /header table -->
<P>


<!-- top third table -->
<TABLE WIDTH="615" BORDER=0><TR>
<TD VALIGN=top WIDTH="50%">

<!-- publisher details -->
<TABLE WIDTH=290>
<TR>
<TD VALIGN=top><B>$OASISmsg[Bill__To]:</B></TD>
<TD>$pname<BR>
$street<BR>
$city, $state  $pcode<BR>
$country
</TD>
</TR>
</TABLE>
<!-- /publisher details -->

</TD>

<TD VALIGN=top ALIGN=right>
</TD></TR></TABLE>
<!-- /top third table -->


<TABLE WIDTH=615>
<TR>
<TD><B>$OASISmsg[Period]:</B></TD>
<TD COLSPAN=3>$fd $OASISmsg[to] $td</TD>
</TR>

<TR>
<TD COLSPAN=4><HR NOSHADE SIZE=1 color='#000000' style="border-color:'#000000'"></TD>
</TR>

<TR>
<TD><B>$OASISmsg[Charges]:</B></TD>
</TR>

<TR>
<TD><B>$OASISmsg[Fixed]:</B></TD>
<TD WIDTH="25%"></TD>
<TD WIDTH="25%"></TD>
<TD ALIGN=right>$OASISlcurrsym$fixedc$OASIStcurrsym</TD>
</TR>

<TR>
<TD><B>$OASISmsg[Impressions]:</B></TD>
<TD WIDTH="25%">$impd</TD>
<TD WIDTH="25%"></TD>
<TD ALIGN=right>$OASISlcurrsym$cpmc$OASIStcurrsym</TD>
</TR>

<TR>
<TD><B>$OASISmsg[Clicks]:</B></TD>
<TD WIDTH="25%">$clickd</TD>
<TD WIDTH="25%"></TD>
<TD ALIGN=right>$OASISlcurrsym$cpcc$OASIStcurrsym</TD>
</TR>

<TR>
<TD><B>$OASISmsg[Hosting]:</B></TD>
<TD WIDTH="25%"></TD>
<TD WIDTH="25%"></TD>
<TD ALIGN=right>$OASISlcurrsym$hosting$OASIStcurrsym</TD>
</TR>

<TR>
<TD COLSPAN=4><HR NOSHADE SIZE=1 color='#000000' style="border-color:'#000000'"></TD>
</TR>

<TR>
<TD><B>$OASISmsg[Credits]:</B></TD>
</TR>

<TR>
<TD><B>$OASISmsg[Fixed]:</B></TD>
<TD WIDTH="25%"></TD>
<TD WIDTH="25%"></TD>
<TD ALIGN=right>$OASISlcurrsym$fixedcr$OASIStcurrsym</TD>
</TR>

<TR>
<TD><B>$OASISmsg[Impressions]:</B></TD>
<TD WIDTH="25%">$impdcr</TD>
<TD WIDTH="25%"></TD>
<TD ALIGN=right>$OASISlcurrsym$cpmcr$OASIStcurrsym</TD>
</TR>

<TR>
<TD><B>$OASISmsg[Clicks]:</B></TD>
<TD WIDTH="25%">$clickdcr</TD>
<TD WIDTH="25%"></TD>
<TD ALIGN=right>$OASISlcurrsym$cpccr$OASIStcurrsym</TD>
</TR>

<TR>
<TD></TD>
<TD></TD>
<TD></TD>
<TD><HR NOSHADE SIZE=1 color='#000000' style="border-color:'#000000'"></TD>
</TR>

$paid_block

<TR>
<TD><B>$OASISmsg[Net_Due_Amount]:</B></TD>
<TD></TD>
<TD></TD>
<TD ALIGN=right BGCOLOR="#cccccc">$OASISlcurrsym$net_due$OASIStcurrsym</TD>
</TR>
</TABLE>

__TEXT__;


  if($footer_string)
  {
    $invoice .= <<<__TEXT__
<TABLE WIDTH=615>
<TR>
<TD WIDTH=615><HR NOSHADE></TD>
</TR>
<TR><TD WIDTH=615>
<FONT SIZE="-1">
$footer_string
</FONT>
</TD></TR></TABLE>
__TEXT__;
  }

  $invoice .= <<<__TEXT__
</DIV>
</BODY>
</HTML>
__TEXT__;

  return $invoice;
}
?>
