<?php

require_once ("lib-companion.inc");
require_once ("lib-dc.inc");

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function compute_daily_targets($CampaignID, $sim_date)
{
  global $OASISmsg;

  if($sim_date)
  {
    $dt_table = 'SimDailyTargets';
    $ca_table = 'SimCampaigns';
    $cr_table = 'SimCreatives';
    $now = $sim_date;
    $sim_flag = 1;
  }
  else
  {
    $dt_table = 'DailyTargets';
    $ca_table = 'Campaigns';
    $cr_table = 'Creatives';
    $now = time();
    $sim_flag = 0;
  }

  if(!mysql_query("lock tables $dt_table write, $ca_table read, $cr_table read, TrafficProfile read"))
    die("Error locking $dt_table: " . mysql_error() . "\n");

  $filter_string = '';
  if($CampaignID)
  {
    if($sim_date)   sim_log("$OASISmsg[reloading_daily] $CampaignID");
    else          admin_log("$OASISmsg[reloading_daily] $CampaignID");
    $cr_list = array();

    if(!($result = mysql_query("select $cr_table.CreativeID, Target, Remaining from $cr_table left join $dt_table on $cr_table.CreativeID=$dt_table.CreativeID where CampaignID=$CampaignID")))
      die("$OASISmsg[Error_pulling_creatives] $CampaignID: " . mysql_error() . "\n");

    while(list($cr_id, $t, $r) = mysql_fetch_row($result))
    {
      array_push($cr_list, $cr_id);
      $delivered[$cr_id] = $t - $r;
      if($sim_date)   sim_log("$OASISmsg[saving] $delivered[$cr_id] $OASISmsg[deliveries_for_creative] $cr_id");
      else          admin_log("$OASISmsg[saving] $delivered[$cr_id] $OASISmsg[deliveries_for_creative] $cr_id");
    }
    $cr_list = join(",", $cr_list);

    if($cr_list
     && !mysql_query("delete from $dt_table where CreativeID in ($cr_list)"))
      die("Error deleting campaign $CampaignID's creatives from $dt_table: " . mysql_error() . "\n");

    $filter_string = " and CampaignID=$CampaignID";
  }
  else
  {
    if($sim_date)   sim_log("$OASISmsg[reloading_daily_all]");
    else          admin_log("$OASISmsg[reloading_daily_all]");

    if(!mysql_query("delete from $dt_table"))
      die("$OASISmsg[Error_clearing] $dt_table: " . mysql_error() . "\n");
  } 
  
  $dow_flag = 1 << date('w', $now);

  #### first pull all campaigns that have unmet impression goals and have
  #### end dates specified (or if a CampaignID was specified, see if it
  #### meets these criteria)
  $sql = "select CampaignID, Name, ImpressionsGuaranteed, ImpressionsDelivered, unix_timestamp(StartDate), unix_timestamp(EndDate), EvenDelivery, DaysOfWeek, HoursOfDay from $ca_table where Status='Active' and (DaysOfWeek & $dow_flag) and (ImpressionsGuaranteed - ImpressionsDelivered > 0) and unix_timestamp(StartDate) <= $now and unix_timestamp(EndDate) + 86400 > $now$filter_string";
  if(!($result = mysql_query($sql)))
    die("$OASISmsg[Error_querying] $ca_table: " . mysql_error() . "\n");

  while(list($ca_id, $ca_name, $impg, $impd, $st, $et, $evend, $ca_dow, $ca_hod)
         = mysql_fetch_row($result))
  {
    if($sim_date)   sim_log("[Ca $ca_id] $ca_name:");
    else          admin_log("[Ca $ca_id] $ca_name:");

    $ca_imp_per_day = schedule_imps($impg, $impd, $now, $st, $et, $evend, intval($ca_dow), $sim_flag);

    if($ca_imp_per_day <= 0) continue;

    #### find all creatives with guaranteed impressions
    $sql = "select CreativeID, Name, ImpressionsGuaranteed, ImpressionsDelivered, unix_timestamp(StartDate), unix_timestamp(EndDate), DaysOfWeek, HoursOfDay from $cr_table where CampaignID=$ca_id and Status='Active' and (DaysOfWeek & $dow_flag) and ImpressionsGuaranteed - ImpressionsDelivered > 0 and unix_timestamp(StartDate) <= $now and (unix_timestamp(EndDate) + 86400 > $now or EndDate = '0000-00-00')";
    if(!($result2 = mysql_query($sql)))
      die("$OASISmsg[Error_querying] $cr_table: " . mysql_error() . "\n$sql\n");

    while($ca_imp_per_day > 0 && list($cr_id, $cr_name, $cr_impg, $cr_impd, $cr_st, $cr_et, $cr_dow, $cr_hod) = mysql_fetch_row($result2))
    {
      $cr_hod = intval($cr_hod) & intval($ca_hod);
      $msg = "  [Cr $cr_id] $cr_name (dow: " . sprintf("%07b & %07b = %07b", $cr_dow, $ca_dow, intval($ca_dow) & intval($cr_dow)) . "):";
      if($sim_date)   sim_log($msg);
      else          admin_log($msg);

      $cr_dow = intval($cr_dow) & intval($ca_dow);
      if(!($cr_et > $now && $cr_et < $et)) $cr_et = $et;
      $cr_imp_per_day = schedule_imps($cr_impg, $cr_impd, $now, $cr_st, $cr_et, $evend, $cr_dow, $sim_flag);

      if($cr_imp_per_day > $ca_imp_per_day) $cr_imp_per_day = $ca_imp_per_day;
      $ca_imp_per_day -= $cr_imp_per_day;

      $remaining = $cr_imp_per_day - $delivered[$cr_id];
      if(!mysql_query("insert into $dt_table (CreativeID, Target, Remaining, HoursOfDay) values ($cr_id, $cr_imp_per_day, $remaining, $cr_hod)\n"))
        die("$OASISmsg[Error_inserting_into] $dt_table: CreativeID=$cr_id, Target=$cr_imp_per_day: " . mysql_error() . "\n");
    }

    #### if we've used up all the campaign's impressions on creatives
    #### with impression guarantees, then we won't bother checking for
    #### non-guaranteed creatives
    if($ca_imp_per_day <= 0) continue;

    #### now pull creatives with non-guaranteed impressions
    $sql = "select CreativeID, Name, Weight, HoursOfDay from $cr_table where CampaignID=$ca_id and Status='Active' and (DaysOfWeek & $dow_flag) and ImpressionsGuaranteed = 0 and unix_timestamp(StartDate) <= $now and (unix_timestamp(EndDate) + 86400 > $now or EndDate = '0000-00-00')";
    if(!($result2 = mysql_query($sql)))
      die("$OASISmsg[Error_querying] $cr_table: " . mysql_error() . "\n$sql\n");

    $total_weight = 0;
    while(list($cr_id, $cr_name, $cr_weight, $cr_hod) = mysql_fetch_row($result2))
      $total_weight += $cr_weight;

    if(!($result2 = mysql_query($sql)))
      die("$OASISmsg[Error_querying] $cr_table: " . mysql_error() . "\n$sql\n");

    while(list($cr_id, $cr_name, $cr_weight, $cr_hod) = mysql_fetch_row($result2))
    {
      $cr_hod = intval($cr_hod) & intval($ca_hod);
      $cr_imp_per_day = ceil($ca_imp_per_day * $cr_weight / $total_weight);

      if($sim_date)   sim_log("  [Cr $cr_id] $cr_name: $cr_imp_per_day ($cr_weight, $total_weight)");
      else          admin_log("  [Cr $cr_id] $cr_name: $cr_imp_per_day ($cr_weight, $total_weight)");

      $remaining = $cr_imp_per_day - $delivered[$cr_id];
      if(!mysql_query("insert into $dt_table (CreativeID, Target, Remaining, HoursOfDay) values ($cr_id, $cr_imp_per_day, $remaining, $cr_hod)\n"))
        die("$OASISmsg[Error_inserting] $dt_table: CreativeID=$cr_id, Target=$cr_imp_per_day " . mysql_error() . "\n");
    }
  }

  #### now pull all campaigns with no impression targets along with those
  #### that have impression targets with no end date specified
  $sql = "select CampaignID, Name, Weight, HoursOfDay from $ca_table where Status='Active' and (DaysOfWeek & $dow_flag)$filter_string and (ImpressionsGuaranteed = 0 and unix_timestamp(StartDate) <= $now and (unix_timestamp(EndDate) + 86400 > $now or EndDate = '0000-00-00')) or (ImpressionsGuaranteed - ImpressionsDelivered > 0 and EndDate = '0000-00-00')";
  if(!($result = mysql_query($sql)))
    die("$OASISmsg[Error_querying] $ca_table: " . mysql_error() . "\n");

  while(list($ca_id, $ca_name, $ca_weight, $ca_hod) = mysql_fetch_row($result))
  {
    if($sim_date)   sim_log("[Ca $ca_id] $ca_name: $OASISmsg[weight]: $ca_weight");
    else          admin_log("[Ca $ca_id] $ca_name: $OASISmsg[weight]: $ca_weight");

    #### pull creatives
    $sql = "select CreativeID, Name, Weight, HoursOfDay from $cr_table where CampaignID=$ca_id and Status='Active' and (DaysOfWeek & $dow_flag) and unix_timestamp(StartDate) <= $now and (unix_timestamp(EndDate) + 86400 > $now or EndDate = '0000-00-00')";
    $total_weight = 0;
    if(!($result2 = mysql_query($sql)))
      die("$OASISmsg[Error_querying] $cr_table: " . mysql_error() . "\n$sql\n");

    while(list($cr_id, $cr_name, $cr_weight, $cr_hod) = mysql_fetch_row($result2))
        $total_weight += $cr_weight;

    if(!($result2 = mysql_query($sql)))
      die("$OASISmsgError_querying] $cr_table: " . mysql_error() . "\n$sql\n");

    while(list($cr_id, $cr_name, $cr_weight, $cr_hod) = mysql_fetch_row($result2))
    {
      $cr_hod = intval($cr_hod) & intval($ca_hod);
      $adjusted_weight = round($ca_weight * ($cr_weight / $total_weight * 100));

      if($sim_date)   sim_log("  [Cr $cr_id] $cr_name: $OASISmsg[weight]: $ca_weight*$cr_weight/$total_weight*100=$adjusted_weight");
      else          admin_log("  [Cr $cr_id] $cr_name: $OASISmsg[weight]: $ca_weight*$cr_weight/$total_weight*100=$adjusted_weight");

      $remaining = 0 - $delivered[$cr_id];
      if(!mysql_query("insert into $dt_table (CreativeID, Remaining, Weight, HoursOfDay) values ($cr_id, $remaining, $adjusted_weight, $cr_hod)\n"))
        die("$OASISmsg[Error_inserting] $dt_table: CreativeID=$cr_id, Weight=$adjusted_weight: " . mysql_error() . "\n");
    }
  }
  mysql_query("unlock tables");

    $log_msg .= ($CampaignID)
              ? "$OASISmsg[daily_target_reloaded] $CampaignID"
              : "$OASISmsg[daily_target_reloaded_all]";

  if($sim_date)   sim_log($log_msg);
  else          admin_log($log_msg);
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function load_creative_content($CampaignID)
{
  global $OASISmsg, $OG_shm_cr_cont, $OG_shm_cr_click;

  #### FIXME!!! check for utilization of shared memory space; if over 90%,
  #### alert the system administrator

  $filter_string = '';

  #### if we got a CampaignID, we don't want to clear out the tables;
  #### we're just going to update creatives for this campaign
  if($CampaignID)
  {
    $filter_string = " where CampaignID=$CampaignID";
  }
  #### otherwise, we're updating everything, so we clear the tables here
  else
  {
    #### PHP version 4.0.7 changed the shm_remove() semantics
    if (get_php_version() >= 40007)
    {
      if(!@shm_remove(shm_attach($OG_shm_cr_cont,
                      get_prefs('ShmSizeCreativeContent'))))
        print("$OASISmsg[Error]: $OASISmsg[error_clear_shm] OAS2: $php_errormsg\n");
      if(!@shm_remove(shm_attach($OG_shm_cr_click,
                      get_prefs('ShmSizeCreativeClickthroughs'))))
        print("$OASISmsg[Error]: $OASISmsg[error_clear_shm] OAS3: $php_errormsg\n");
    }
    else
    {
      if(!@shm_remove($OG_shm_cr_cont))
        print("$OASISmsg[Error]: $OASISmsg[error_clear_shm] OAS2: $php_errormsg\n");
      if(!@shm_remove($OG_shm_cr_click))
        print("$OASISmsg[Error]: $OASISmsg[error_clear_shm] OAS3: $php_errormsg\n");
    }
  }

  #### attach to a shared memory segment
  #### identifier:     O A S 2
  if(!(@$smh1 = shm_attach($OG_shm_cr_cont, get_prefs('ShmSizeCreativeContent'))))
  {
    $msg = "$OASISmsg[Error]: $OASISmsg[error_connect_shm] OAS2: $php_errormsg";
    admin_log($msg);
    die("$msg\n");
  }

  #### attach to a shared memory segment
  #### identifier:     O A S 3
  if(!(@$smh2 = shm_attach($OG_shm_cr_click, get_prefs('ShmSizeCreativeClickthroughs'))))
  {
    $msg = "$OASISmsg[Error]: $OASISmsg[error_connect_shm] OAS3: $php_errormsg";
    admin_log($msg);
    die("$msg\n");
  }

  if(!($result = mysql_query("select DailyTargets.CreativeID, Content, Redirect, MIMEType, Animated, ClickthroughURL, AltText from DailyTargets left join Creatives on DailyTargets.CreativeID=Creatives.CreativeID$filter_string")))
    die("$OASISmsg[Error_querying] DailyTargets");

  while(list($cr_id, $con, $re, $mime, $an, $cr_url, $alt) = mysql_fetch_row($result))
  {
    if(!@shm_put_var($smh1, $cr_id, array($con, $re, $mime, $an, $alt)))
    {
      $msg = "$OASISmsg[error_loading_shm] OAS2: $php_errormsg";
      admin_log($msg);
      die("$msg\n");
    }

    if(!@shm_put_var($smh2, $cr_id, $cr_url))
    {
      $msg = "$OASISmsg[error_loading_shm] OAS3: $php_errormsg";
      admin_log($msg);
      die("$msg\n");
    }
  }

  if(!@shm_detach($smh1))
  {
    $msg = "$OASISmsg[error_detaching_shm] OAS2: $php_errormsg";
    admin_log($msg);
    die("$msg\n");
  }

  if(!@shm_detach($smh2))
  {
    $msg = "$OASISmsg[error_detaching_shm] OAS3: $php_errormsg";
    admin_log($msg);
    die("$msg\n");
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function days_remaining($st, $et, $dow)
{
  $year  = date("Y", $st);
  $month = date("n", $st);
  $day   = date("d", $st);
  $st_midnight = mktime(0, 0, 0, $month, $day, $year);

  #### add one day to timestamp, since we'll actually run ad campaigns
  #### through the entire day of the end date
  $et += 86400;
  $year  = date("Y", $et);
  $month = date("n", $et);
  $day   = date("d", $et);
  $et_midnight = mktime(0, 0, 0, $month, $day, $year);

  $num_days = 0;
  $tt = $st_midnight;
  while($tt < $et_midnight)
  {
    $dow_flag = 1 << date('w', $tt);
    if($dow_flag & $dow) $num_days++;
    $tt += 86400;
  }

  return $num_days;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function num_weeks($st, $et)
{
  $year  = date("Y", $st);
  $month = date("n", $st);
  $day   = date("d", $st);
  $st_midnight = mktime(0, 0, 0, $month, $day, $year);

  #### add one day to timestamp, since we'll actually run ad campaigns
  #### through the entire day of the end date
  $et += 86400;
  $year  = date("Y", $et);
  $month = date("n", $et);
  $day   = date("d", $et);
  $et_midnight = mktime(0, 0, 0, $month, $day, $year);

  #### we round here because of DST (if one date is on one side of the
  #### DST change, and the other is on the other side, you'll get a
  #### fractional date, which must be rounded down in the fall and up
  #### in the spring)
  $num_weeks = ceil((date("w", $st_midnight)
                    + round(($et_midnight - $st_midnight) / 86400)) / 7);

  return $num_weeks;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function days_left_in_week($st, $dow, $et)
{
  $tdow = date("w", $st);

  $num_days = 0;
  while($tdow < 7 && $st < $et + 86400)
  {
    $dow_flag = 1 << $tdow;
    if($dow_flag & $dow) $num_days++;
    $tdow++;
    $st += 86400;
  }

  return $num_days;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function num_months($st, $et)
{
  $year  = date("Y", $st);
  $month = date("n", $st);
  $day   = date("d", $st);
  $st_midnight = mktime(0, 0, 0, $month, $day, $year);

  $year  = date("Y", $et);
  $month = date("n", $et);
  $day   = date("d", $et);
  $et_midnight = mktime(0, 0, 0, $month, $day, $year);

  $num_months = 12 * (date("Y", $et_midnight) - date("Y", $st_midnight))
                   + (date("m", $et_midnight) - date("m", $st_midnight))
		   + 1;

  return $num_months;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function days_left_in_month($st, $dow, $et)
{
  $dom = date("d", $st);
  $m = date("n", $st);
  $y = date("Y", $st);
  $m++;
  if($m == 13)
  {
    $m = 1;
    $y++;
  }

  $days_in_month = date("d", mktime(0, 0, 0, $m, 0, $y));

  $num_days = 0;
  $td = $dom;
  $tt = $st;
  while($td <= $days_in_month && $tt < $et + 8400)
  {
    $tdow = date('w', ($td - $dom) * 86400 + $st);
    $dow_flag = 1 << $tdow;
    if($dow_flag & $dow) $num_days++;
    $td++;
    $tt += 86400;;
  }

  return $num_days;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function schedule_imps($impg, $impd, $now, $st, $et, $evend, $dow, $sim_flag)
{
  global $OASISmsg;

  $tot_impr = $impg - $impd;

  $tdow = date("w", $now);
  $dow_flags = sprintf("%07b", $dow);
  $dow_flags = preg_replace("#(.*?)(.)(.\{$tdow})$#",
                              "\\1[\\2]\\3", $dow_flags);

  if($evend == 'Day')
  {
    $dr = days_remaining($now, $et, $dow);
    if($dr == 0 && $impr > 0)
    {
      if(!$sim_flag)
        admin_log("$impr $OASISmsg[impressions_remaining], 0 $OASISmsg[days_left]!");
      else
        warn("$impr $OASISmsg[impressions_remaining], 0 $OASISmsg[days_left] (DOW: "
	     . sprintf("%7b", $dow) . ")!\n");
      return 0;
    }
    $impr = round($tot_impr / $dr);
    if(!$sim_flag)
    {
      admin_log("  $OASISmsg[days_of_week]: $dow_flags");
      admin_log("  $tot_impr $OASISmsg[impressions_remaining], $dr $OASISmsg[days]: $impr $OASISmsg[today]");
    }
  }
  elseif($evend == 'Week')
  {
    $wt = num_weeks($st, $et);
    $wp = num_weeks($st, $now) - 1;
    $dw = days_left_in_week($now, $dow, $et);

    $impg_per_week = $impg / $wt;
    #### negative numbers here are OK -- they will result in us delivering
    #### more this week to make up for a shortfall last week
    $impd_this_week = $impd - ($impg_per_week * $wp);
    $impr = round(($impg_per_week - $impd_this_week) / $dw);
    if($impr < 0) $impr = 0;
    if(!$sim_flag)
    {
      admin_log("  $impg $OASISmsg[impressions_guaranteed_over] $wt $OASISmsg[weeks] ($impg_per_week $OASISmsg[per_week])");
      admin_log("  $wp $OASISmsg[weeks_passed], $impd $OASISmsg[delivered]");
      admin_log("  $impd_this_week $OASISmsg[delivered_this_week]");
      admin_log("  $OASISmsg[days_of_week]: $dow_flags");
      admin_log("  $dw $OASISmsg[days_left_week]: $impr $OASISmsg[scheduled_for_today]");
    }
  }
  elseif($evend == 'Month')
  {
    $mt = num_months($st, $et);
    $mp = num_months($st, $now) - 1;
    $dm = days_left_in_month($now, $dow, $et);

    $impg_per_month = $impg / $mt;
    #### negative numbers here are OK -- they will result in us delivering
    #### more this week to make up for a shortfall last week
    $impd_this_month = $impd - ($impg_per_month * $mp);
    $impr = round(($impg_per_month - $impd_this_month) / $dm);
    if($impr < 0) $impr = 0;
    if(!$sim_flag)
    {
      admin_log("  $impg $OASISmsg[impressions_guaranteed_over] $mt $OASISmsg[months] ($impg_per_month $OASISmsg[per_month])");
      admin_log("  $mp $OASISmsg[months_passed], $impd $OASISmsg[delivered]");
      admin_log("  $impd_this_month $OASISmsg[delivered_this_month]");
      admin_log("  $OASISmsg[days_of_week]: $dow_flags");
      admin_log("  $dm $OASISmsg[days_left_month]: $impr $OASISmsg[scheduled_for_today]");
    }
  }

  return $impr;
}



####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function build_assignment_table($sim_flag, $hod)
{
  global $children, $children_done, $wiped_clean, $active;

  $hod = 1 << $hod;
  $dt_table = ($sim_flag) ? 'SimDailyTargets' : 'DailyTargets';

  #### build arrays of sections' children (unless we've already done this --
  #### which happens a lot when we're simulating)
  if(!$children_done)
  {
    $sql = <<<__TEXT__
SELECT 
  s.SectionID, s.PSectionID, s.Active, p.Status
FROM 
  Sections s LEFT JOIN Publishers p ON s.PublisherId=p.PublisherID
__TEXT__;
    if($result = mysql_query ($sql))
    {
      while(list($s, $p, $sa, $ps) = mysql_fetch_row($result))
      {
        $parent[$s] = $p;
        if(!$children[$p]) $children[$p] = array();
        array_push($children[$p], $s);
  
        $active[$s] = ($sa == 'Y' && $ps == 'Active') ? 1 : 0;
      }
    }
    $children_done = 1;
  }

  foreach(array('Include', 'Exclude', 'Exclusive') as $t)
  {
    $sql = "select CampaignAssignments.SectionID, $dt_table.CreativeID, CampaignAssignments.CampaignID, Width, Height from $dt_table left join Creatives on $dt_table.CreativeID=Creatives.CreativeID natural left join CampaignAssignments left join Campaigns on Campaigns.CampaignID=CampaignAssignments.CampaignID where CampaignAssignments.Type='$t' and $dt_table.HoursOfDay&$hod order by CampaignAssignments.SectionID";
    #admin_log("$sql");
    if($result = mysql_query($sql))
    {
      while(list($s, $cr_id, $ca_id, $w, $h) = mysql_fetch_row($result))
      {
        $dim = $w . "x" . $h;
        #admin_log("[b_a_t] assigning Cr $cr_id to S $s (Campaign $t)");
        assign_to_section($cr_id, $ca_id, $dim, $s, $t, 'Campaign');
      }
    }

    $sql = "select CreativeAssignments.SectionID, $dt_table.CreativeID, Creatives.CampaignID, Width, Height from $dt_table left join Creatives on $dt_table.CreativeID=Creatives.CreativeID natural left join CreativeAssignments where CreativeAssignments.Type='$t' and $dt_table.HoursOfDay&$hod order by CreativeAssignments.SectionID";
    #admin_log("$sql");
    if($result = mysql_query($sql))
    {
      while(list($s, $cr_id, $ca_id, $w, $h) = mysql_fetch_row($result))
      {
        $dim = $w . "x" . $h;
        #admin_log("[b_a_t] assigning Cr $cr_id to S $s (Creative $t)");
        assign_to_section($cr_id, $ca_id, $dim, $s, $t, 'Creative');
      }
    }
  }

  enforce_all_companion_groups ();
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function assign_to_section($cr_id, $ca_id, $dim, $s, $type, $atype)
{
  global $children, $wiped_clean, $active;
  global $OG_assignments;

  #### if a section is inactive, we will not assign any creatives to
  #### it or its children
  if(!$active[$s]) return;

  #print "creative $cr_id -> section $s ($type)\n";

  if($type == 'Include')
    $OG_assignments[$s][$dim][$cr_id] = 1;
  elseif($type == 'Exclude')
    $OG_assignments[$s][$dim][$cr_id] = 0;
  elseif($type == 'Exclusive' && $atype == 'Campaign')
  {
    #### if we've already wiped this section clean, then just
    #### tack on this creative;
    if($wiped_clean["$s-$dim-$ca_id"])
      $OG_assignments[$s][$dim][$cr_id] = 1;

    #### otherwise, remove all other creatives
    else
    {
      #admin_log("[a_t_s] wiping clean S $s, $dim");
      $OG_assignments[$s][$dim] = array($cr_id => 1);
      $wiped_clean["$s-$dim-$ca_id"] = 1;
    }
  }
  elseif($type == 'Exclusive' && $atype == 'Creative')
  {
    #### if we've already wiped this section clean, then just
    #### tack on this creative;
    if($wiped_clean["$s-$dim"])
      $OG_assignments[$s][$dim][$cr_id] = 1;

    #### otherwise, remove all other creatives
    else
    {
      #admin_log("[a_t_s] wiping clean S $s, $dim");
      $OG_assignments[$s][$dim] = array($cr_id => 1);
      $wiped_clean["$s-$dim"] = 1;
    }
  }

  if(!$children[$s]) return;

  reset($children[$s]);
  while(list(, $cs) = each ($children[$s]))
    assign_to_section($cr_id, $ca_id, $dim, $cs, $type, $atype);
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function compute_hourly_targets($hour, $sim_flag)
{
  global $OG_hourly_targets, $OG_overflowok, $OG_fulfilled;
  global $OG_imp_caps, $OG_delivery_controls;
  global $OASISmsg;

  $OG_overflowok = array ();
  $OG_imp_caps = array ();

  $dt_table = ($sim_flag) ? 'SimDailyTargets' : 'DailyTargets';

  $hod_flag = 1 << $hour;

  #### go through all daily targets; see how much needs to delievered
  #### this hour for each
  $sql = <<<__TEXT__
SELECT $dt_table.CreativeID, $dt_table.Target, $dt_table.Weight,
$dt_table.Remaining, $dt_table.HoursOfDay,
Creatives.MediaType, Creatives.OverflowOK,
Creatives.ImpCap, Creatives.ImpCapInterval
FROM $dt_table 
LEFT JOIN Creatives 
ON $dt_table.CreativeID=Creatives.CreativeID 
WHERE ($dt_table.HoursOfDay & $hod_flag)
__TEXT__;

  if(!($result = mysql_query($sql)))
    die("$OASISmsg[Error_querying] $dt_table: " . mysql_error() . "\n");

  $OG_fulfilled = array ();
  while(list($cr_id, $target, $weight, $rem, $hod, $mtype, $ofok, $ic, $ici)
        = mysql_fetch_row($result))
  {
    $hod_flags = sprintf("%024b", $hod);
    $hod_flags = preg_replace("#(.*?)(.)(.\{$hour})$#",
                              "\\1[\\2]\\3", $hod_flags);
    #### creative has an impression target
    if ($target > 0)
    {
      if($rem > 0)
      {
        $p = percentage_of_remaining($hour, intval($hod));
        $ht = ceil($rem * $p);
        $p = sprintf("%.1f", $p * 100);
        if(!$sim_flag)
          admin_log("[Cr $cr_id] $hod_flags $p% of $rem imps: ($ht,$weight,$ht,0)");
        $OG_hourly_targets[$cr_id] = array($ht, $weight, $ht, 0, $mtype);
      }
      else
      {
        $OG_fulfilled[$cr_id] = 1;
      }
    }
    #### creative is strictly weight-based 
    else
    {
      if(!$sim_flag) {
        $msg = "[Cr $cr_id] $hod_flags (0,$weight,0,0)";
        if ($ofok == 'Y')  $msg .= ' *';
        admin_log($msg);
      }
      $OG_hourly_targets[$cr_id] = array(0, $weight, 0, 0, $mtype);
    }

    if ($dc = get_delivery_controls ($cr_id))
      $OG_delivery_controls[$cr_id] = $dc;

    $OG_overflowok[$cr_id] = ($ofok == 'Y')  ? 1 : 0;

    if ($ic > 0) $OG_imp_caps[$cr_id] = array ($ic, $ici);
  }
  if(!$sim_flag)
    admin_log("$OASISmsg[hourly_targets_computed]");
}


####---------------------------------------------------------------------------
#### compute the traffic this hour as a percentage of the traffic remaining
#### in the day given a bitmask representing which hours the campaign will run
####---------------------------------------------------------------------------
function percentage_of_remaining($hour, $hod)
{
  global $pageviews;

  $h = $hour;
  $total_pageviews = 0;
  while($h < 24)
  {
    $hod_flag = 1 << $h;
    if($hod_flag & $hod) $total_pageviews += $pageviews[$h]; 
    $h++;
  }
  if($total_pageviews > 0)
    return $pageviews[$hour] / $total_pageviews;
  else
    return 1;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function read_traffic_profile()
{
  global $pageviews;

  $sql = "select Hour, Pageviews from TrafficProfile";

  $total_pageviews = 0;
  $pageviews = array();
  if($result = mysql_query($sql))
  {
    while(list($h, $pv) = mysql_fetch_row($result))
      $pageviews[$h] = $pv;
  }
}


?>
