<?php

####---------------------------------------------------------------------------
####  removes the campaign's creatives from all but one of the sections in
####  $sec_list;  does so in such a way that each hour, it cycles through
####  the sections in the list so that the campaign will run on all of the
####  sections (unless there are more than 24 of them!)
####---------------------------------------------------------------------------
function remove_campaign_from_sections ($ca_id_rm, $sec_list, $cr_rm_list) 
{
  global $OG_assignments;

  $num_sec = count ($sec_list);
  $hour = date('G', time());

  for ($i = 0; $i < $num_sec - 1; $i++) {
    $index = ($ca_id_rm + $hour + $i) % $num_sec;

    $s_id = $sec_list[$index];
    reset ($OG_assignments[$s_id]);
    while (list ($dim, $cr_list) = each ($OG_assignments[$s_id])) {

       #### remove all creatives in the campaign if assigned
       foreach ($cr_rm_list as $cr_id_rm) {
         if ($OG_assignments[$s_id][$dim][$cr_id_rm])
           $OG_assignments[$s_id][$dim][$cr_id_rm] = 0;
       }

    } 
  }
}

####---------------------------------------------------------------------------
####  removes the creative from all but one of the sections in
####  $sec_list;  does so in such a way that each hour, it cycles through
####  the sections in the list so that the creative will run on all of the
####  sections (unless there are more than 24 of them!)
####---------------------------------------------------------------------------
function remove_creative_from_sections ($cr_id_rm, $sec_list)
{
  global $OG_assignments;

  $num_sec = count ($sec_list);
  $hour = date('G', time());

  for ($i = 0; $i < $num_sec - 1; $i++) {
    $index = ($cr_id_rm + $hour + $i) % $num_sec;

    $s_id = $sec_list[$index];
    reset ($OG_assignments[$s_id]);
    while (list ($dim, $cr_list) = each ($OG_assignments[$s_id])) {

       #### remove it if assigned
       if ($OG_assignments[$s_id][$dim][$cr_id_rm])
         $OG_assignments[$s_id][$dim][$cr_id_rm] = 0;
    } 
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function get_campaign_info ($cr_id)
{
  global $OG_campaign_info;

  if (!$OG_campaign_info[$cr_id]) {
    $sql = <<<__TEXT__
SELECT 
  ca.CampaignID, ca.CompanionSharing
FROM
  Creatives cr LEFT JOIN
  Campaigns ca ON cr.CampaignID=ca.CampaignID
WHERE
  cr.CreativeID=$cr_id
__TEXT__;

    if(!($result = mysql_query($sql))) return array (0, 0);
    if(!(list($ca_id, $comp_share) = mysql_fetch_row($result)))
      return array (0, 0);

    $OG_campaign_info[$cr_id] = array ($ca_id, $comp_share);
  }

  return $OG_campaign_info[$cr_id];
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function get_overlap ($s_id)
{
  global $OG_assignments;
  global $OG_cr_overlap, $OG_ca_overlap, $OG_cr_list;

  #### go through the entire list of creatives assigned to this section
  reset ($OG_assignments[$s_id]);
  while (list ($dim, $cr_list) = each ($OG_assignments[$s_id])) {
    while (list ($cr_id, $junk) = each ($OG_assignments[$s_id][$dim])) {
      list ($ca_id, $comp_share) = get_campaign_info ($cr_id);

      #### does the campaign allow multiple creatives to appear
      #### on companion sections? 
      if ($comp_share == 'Y') {
        $OG_cr_overlap[$cr_id][$s_id] = 1;
      }
      else {
        $OG_ca_overlap[$ca_id][$s_id] = 1;
        $OG_cr_list[$ca_id][$cr_id] = 1;
      }
    }
  }
}

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function enforce_companion_group ($cg_id)
{
  global $OG_assignments;
  global $OG_cr_overlap, $OG_ca_overlap, $OG_cr_list;

  $OG_ca_overlap = array ();
  $OG_cr_list = array ();
  $OG_cr_overlap = array ();

  $sql = "SELECT SectionID FROM CompanionSections WHERE CompanionGroupID=$cg_id";
  if($result = mysql_query($sql))
  {
    while(list($s_id) = mysql_fetch_row($result))
    {
      get_overlap ($s_id);
    }
  }

  foreach (array_keys ($OG_ca_overlap) as $ca_id) {
    if (count ($OG_ca_overlap[$ca_id]) < 2) continue;

    remove_campaign_from_sections ($ca_id, array_keys ($OG_ca_overlap[$ca_id]),
                                  array_keys ($OG_cr_list[$ca_id]));
  }

  foreach (array_keys ($OG_cr_overlap) as $cr_id) {
    if (count ($OG_cr_overlap[$cr_id]) < 2) continue;

    remove_creative_from_sections ($cr_id, array_keys ($OG_cr_overlap[$cr_id]));
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function enforce_all_companion_groups ()
{
  $sql = "SELECT CompanionGroupID FROM CompanionGroups";
  if($result = mysql_query($sql))
  {
    while(list($cg_id) = mysql_fetch_row($result))
    {
      enforce_companion_group ($cg_id);
    }
  }
}


?>
