#!/usr/bin/php -q
<?php

$file1 = $argv[1];
$file2 = $argv[2];

require $file1;
foreach (array_keys($OASISmsg) as $msg)
{
  $orig_message_list[$msg] = 1;
  $orig_translation[$msg] = preg_replace ("#'#", "\\'", $OASISmsg[$msg]);
}

require $file2;
foreach (array_keys($OASISmsg) as $msg)
{
  if (!$orig_message_list[$msg]) print "Not found in $file1: $msg\n";
  $orig_message_list[$msg] = 0;
}

$newcode = '';
foreach (array_keys($orig_message_list) as $msg)
{
  if ($orig_message_list[$msg] == 1) {
    print "Not found in $file2: $msg\n";
    $newcode .= <<<__TEXT__
'$msg' =>
  '$orig_translation[$msg]',

__TEXT__;
  }
}

if ($newcode) {
  $fp = fopen ("newmsgs.php", "w");
  fwrite ($fp, $newcode);
  fclose ($fp);
  print "Missing messages written to newmsgs.php\n";
}

?>
