#!/usr/bin/perl

$year = (localtime())[5];
$year += 1900;
$date = scalar (localtime());
$version = `php -q ../../../echoversion.php`;

print "$year, $date, $version\n";

$contents = slurp ("000_title.htm.template");
$contents =~ s#\[YEAR\]#$year#gs;
$contents =~ s#\[DATE\]#$date#gs;
$contents =~ s#\[VERSION\]#$version#gs;
spit ("000_title.htm", $contents);

$contents = slurp ("100_oasis.html.template");
$contents =~ s#\[YEAR\]#$year#gs;
$contents =~ s#\[DATE\]#$date#gs;
$contents =~ s#\[VERSION\]#$version#gs;
spit ("100_oasis.html", $contents);

`htmldoc --duplex --left 0.5in --right 0.5in --top 0.5in --bottom 0.5in --bodyfont helvetica --browserwidth 700 --toclevels 3 --header .c. --footer .t1 --headfootsize 10 --titlefile 000_title.htm -f oasis.pdf *.html`;


####---------------------------------------------------------------------------
####  SUBROUTINE slurp
####---------------------------------------------------------------------------
sub slurp
{
  if (open(SLURPEE, $_[0]))
  {
    if (wantarray)
    {
      my @contents = ();
      foreach (<SLURPEE>) { push(@contents, $_); }
      return @contents;
    }
    else
    {
      local $/ = undef;
      my $contents = <SLURPEE>;
      close(SLURPEE);
      return $contents;
    }
  }
  "";
}


####----------------------------------------------------------------------------
####  SUBROUTINE spit
####----------------------------------------------------------------------------
sub spit
{
  $_ = shift @_;
  if (open(SPITTOON, ">$_-$$"))
  {
    print SPITTOON @_;
    close(SPITTOON);

    rename("$_-$$", $_) || ((warn("Could not rename $_ ($!)\n")) && return 1);

    return 0;
  }
  warn("Could not open $_-$$ ($!)\n");
  1;
}
