<?php

require("lib-mgmt.inc");

$campaignscript = "campaign.php";
$creativescript = "creative.php";

print_html_header($OASISmsg['Delivery_Controls']);
print_header('Campaigns', $CampaignID, $CreativeID);
if($error)
{
  print $error;
  print_footer();
  exit;
}

#### NOTE: don't use the globals, because the authentication code
#### will set campaign id based on the creative id; we don't want the
#### delivery control to apply to the campaign if we're trying to set
#### a creative-level delivery control
$CampaignID = 0;
if ($_POST['CampaignID']) $CampaignID = $_POST['CampaignID'];
elseif ($_GET['CampaignID']) $CampaignID = $_GET['CampaignID'];

$CreativeID = 0;
if ($_POST['CreativeID']) $CreativeID = $_POST['CreativeID'];
elseif ($_GET['CreativeID']) $CreativeID = $_GET['CreativeID'];
    

if($DeliveryControlID)
{
  if($reallydelete) really_delete_dc($DeliveryControlID);
  if($delete) delete_dc($DeliveryControlID);
}
else
{
  if($save) save_dc();
}

list_dc($CampaignID, $CreativeID);


print_footer();



####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function build_form_elements()
{
  global $deliver_dropdown, $type_dropdown, $sense_dropdown, $matches_dropdown;
  global $OASISmsg;

  $deliver_array = array('deliver'  => $OASISmsg['deliver'],
                          'deliver_only'  => $OASISmsg['deliver_only'],
                          'no_deliver' => $OASISmsg['no_deliver']
                         );

  $deliver_dropdown = build_select($deliver_array, 'Deliver', '', '', '');

  $type_array = array('IP' => $OASISmsg['IP'],
                      'domain' => $OASISmsg['domain'],
                      'language' => $OASISmsg['language'],
                      'user_agent' => $OASISmsg['user_agent'],
                      'keyword' => $OASISmsg['keyword'],
                      'gt_country' => $OASISmsg['gt_country'],
                      'gt_region' => $OASISmsg['gt_region'],
                      'gt_metro_area' => $OASISmsg['gt_metro_area'],
                      'gt_city' => $OASISmsg['gt_city'],
                      'expr' => $OASISmsg['expr'],
                     );
  $type_dropdown = build_select($type_array, 'Type', '', '', '');

  $sense_array = array(1  => $OASISmsg['sense1'],
                       0  => $OASISmsg['sense0'],
                         );

  $sense_dropdown = build_select($sense_array, 'Sense', '', '', '');

  $matches_array = array('exact'  => $OASISmsg['exact'],
                          'wildcard' => $OASISmsg['wildcard'],
                          'regex'  => $OASISmsg['regex'],
                         );

  $matches_dropdown = build_select($matches_array, 'Matches', '', '', '');
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function delete_dc($DeliveryControlID)
{
  global $campaignscript, $OASISmsg;
  global $CampaignID, $CreativeID;

  print <<<__TEXT__
<TABLE WIDTH=615><TR><TD>
$OASISmsg[confirm_delete_dc_1]
<A HREF="delivery_control.php?reallydelete=1&DeliveryControlID=$DeliveryControlID&CampaignID=$CampaignID&CreativeID=$CreativeID">$OASISmsg[here]</A>.
$OASISmsg[confirm_delete_dc_2]
<A HREF="delivery_control.php?CampaignID=$CampaignID&CreativeID=$CreativeID">$OASISmsg[here]</A>
$OASISmsg[confirm_delete_dc_3]
</TD></TR></TABLE>
__TEXT__;

  print_footer();
  exit;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function really_delete_dc($DeliveryControlID)
{
  $sql = "DELETE FROM DeliveryControls where DeliveryControlID=$DeliveryControlID";
  if(!mysql_query($sql)) {
    print "<EM>$OASISmsg[Error_deleting_creative]:<BR>\n"
          . mysql_error() . " .</EM><BR>\n";
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function save_dc()
{
  global $Deliver, $Type, $Sense, $Matches, $FilterString;
  global $CampaignID, $CreativeID;
  global $OASISmsg, $OASIStsep;

  $incomplete = false;
  if ($Type == 'expr') {
    if (!$Deliver || ("$Sense" == '') || !$FilterString) {
        $incomplete = true;
    }
  }
  else {
    if (!($Deliver && $Type && ("$Sense" != '') && $Matches && $FilterString)) {
        $incomplete = true;
    }
  }

  if ($incomplete) {
    print $OASISmsg['incomplete_delivery_control'] . "<P>";
    return 0;
  }

  $sql = <<<__TEXT__
INSERT INTO DeliveryControls
(CampaignID, CreativeID, Deliver, Type, Sense, Matches, FilterString)
VALUES
($CampaignID, $CreativeID, '$Deliver', '$Type', '$Sense', '$Matches',
'$FilterString');
__TEXT__;

  if(!($result = mysql_query($sql)))
  {
    print "$OASISmsg[MySQL_error]: " . mysql_error() . "<BR>\n";
  }

  return 1;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function list_dc($CampaignID, $CreativeID)
{
  global $PHP_AUTH_USER, $campaignscript, $campaign_access, $OASISmsg;
  global $deliver_dropdown, $type_dropdown, $sense_dropdown, $matches_dropdown; 

  build_form_elements();

  $filter = ($CreativeID) 
    ? "WHERE CreativeID=$CreativeID"
    : "WHERE CampaignID=$CampaignID";

  $sql = <<<__TEXT__
SELECT
  DeliveryControlID, Deliver, Type, Sense, Matches, FilterString
FROM
  DeliveryControls
$filter
ORDER BY DeliveryControlID
__TEXT__;

  #print "$sql<BR>\n";

  if($result = mysql_query($sql))
  {
    print <<<__TEXT__
<FORM METHOD="POST" ACTION="delivery_control.php">
<STRONG>{$OASISmsg['Delivery_Controls']}</STRONG><BR>
<INPUT TYPE=hidden NAME="CampaignID" VALUE="$CampaignID">
<INPUT TYPE=hidden NAME="CreativeID" VALUE="$CreativeID">
<TABLE WIDTH=615 CELLSPACING=0 CELLPADDING=0 BORDER=1>
__TEXT__;

    $bgcolor = '#cccccc';
    while(list($dc_id, $del, $type, $sense, $matches, $fs) = mysql_fetch_row($result))
    {
      $bgcolor = ($bgcolor == '#ffffff') ? '#cccccc' : '#ffffff';

      if ($type == 'expr') {
        $dctext = <<<__TEXT__
$OASISmsg[$del]
$OASISmsg[$type]
{ $fs }
{$OASISmsg["sense{$sense}a"]}
__TEXT__;
      }
      else {
        $dctext = <<<__TEXT__
$OASISmsg[$del]
$OASISmsg[$type]
{$OASISmsg["sense$sense"]}
$OASISmsg[$matches]
$fs
__TEXT__;
      }

      print <<<__TEXT__
<TR BACKGROUND='' BGCOLOR=$bgcolor>
<TD CLASS=smalldata>
$dctext
</TD>
<TD CLASS=smalldata><A HREF="delivery_control.php?DeliveryControlID=$dc_id&CampaignID=$CampaignID&CreativeID=$CreativeID&delete=1">{$OASISmsg['Delete']}</A></TD>
</TR>
__TEXT__;
    }

    $bgcolor = ($bgcolor == '#ffffff') ? '#cccccc' : '#ffffff';
    print <<<__TEXT__
</TABLE>
<P>
<STRONG>{$OASISmsg['Add_new']}</STRONG><BR>
<SPAN CLASS=smalldata>
$deliver_dropdown<BR>
$type_dropdown<BR>
$sense_dropdown<BR>
$matches_dropdown<BR>
<INPUT SIZE=20 NAME="FilterString"><BR>
<INPUT TYPE=submit NAME=save VALUE="{$OASISmsg['Add']}"><BR>
</SPAN>
</FORM>
__TEXT__;

  }
  else
  {
    print "$OASISmsg[MySQL_error]: " . mysql_error() . "<BR>\n";
  }
}

?>
