#!/usr/bin/php -q
<?php
set_time_limit(0);

require("lib-envvar.inc");
require("lib-oasis.inc");
require("lib-db.inc");
require("lib-dengine.inc");
require("lib-maint.inc");

$days_back = get_prefs('InvDaysBack');
$days_forward = get_prefs('InvDaysForward');

sim_log("projecting traffic...");
project_traffic($days_back, $days_forward,
		get_prefs('InvMethod'),
		get_prefs('InvCycle'));

sim_log("simulating traffic...");
copy_active_campaigns();
simulate_traffic($days_forward);

mail_warnings();

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function project_traffic($days_back, $days_forward, $method, $cycle)
{
  if(!mysql_query("delete from SimSectionDailyTraffic"))
    die("error clearing SimSectionDailyTraffic: " . mysql_error() . "\n");

  if($cycle == 'Day')       $element = '1';
  elseif($cycle == 'Week')  $element = 'dayofweek(Day) - 1';	#### 0-6
  elseif($cycle == 'Month') $element = 'dayofmonth(Day)';	#### 1-31
  elseif($cycle == 'Year')  $element = 'dayofyear(Day) - 1';	#### 0-365

  $sql = "select $element, SectionID, Width, Height, Impressions from SectionDailyTraffic where Day >= date_sub(now(), INTERVAL $days_back DAY) and Day < now()";
  if(!($result = mysql_query($sql)))
    die("error: " . mysql_error() . "\n");

  if($method == 'Average')
  {
    while(list($d, $s, $w, $h, $imp) = mysql_fetch_row($result))
    {
      $imp_count[$d][$s][$w][$h] += $imp;
      $rec_count[$d][$s][$w][$h]++;
      $all_sec_dim[$s][$w][$h] = 1;
    }

    #### compute the averages
    while(list($d, $a0) = each($imp_count))
      while(list($s, $a1) = each($a0))
        while(list($w, $a2) = each($a1))
          while(list($h, $imp) = each($a2))
	    $avg[$d][$s][$w][$h] = (int)($imp / $rec_count[$d][$s][$w][$h]);

    if($cycle == 'Day')       $dformat = '1';
    elseif($cycle == 'Week')  $dformat = 'w';	#### 0-6
    elseif($cycle == 'Month') $dformat = 'j';	#### 1-31
    elseif($cycle == 'Year')  $dformat = 'z';	#### 0-365

    $now = time();
    for($i = 0; $i < $days_forward; $i++)
    {
      $day = date('Y-m-d', $now + $i * 86400);
      $d = date($dformat, $now + $i * 86400);

      reset($all_sec_dim);
      while(list($s, $a0) = each($all_sec_dim))
        while(list($w, $a1) = each($a0))
          while(list($h, $a2) = each($a1))
	  {
	    $imp = $avg[$d][$s][$w][$h];
	    if($imp == 0) continue;

	    $sql = "insert into SimSectionDailyTraffic values('$day', $s, $w, $h, $imp, 0)";
	    if(!mysql_query($sql)) die("error: " . mysql_error() . "\n$sql\n");
          } 
    }
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function simulate_traffic($days_forward)
{
  global $pageviews, $total_pageviews;

  read_traffic_profile();
  for($h = 0; $h < 24; $h++) $total_pageviews += $pageviews[$h];

  $now = time();
  for($i = 0; $i < $days_forward; $i++)
  {
    $day = $now + $i * 86400;

    simulate_day($day);
  }

  global $overallocated;

  $thresh = get_prefs('InvWarningThreshold') / 100;
  $result = mysql_query("select date_format(Day, '%a, %b %e'), SectionID, Width, Height, Impressions, Allocated from SimSectionDailyTraffic where Allocated / Impressions > $thresh");
  while(list($day, $s, $w, $h, $imp, $alloc) = mysql_fetch_row($result))
  {
    sim_log("possible overallocation: section $s ($w x $h), $day ($alloc/$imp)");
    $overallocated[$s]["{$w}x{$h}"][$day] = array($imp, $alloc);
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function mail_warnings()
{
  global $underdelivery, $overallocated, $no_assignments;
  global $OASISdecpt, $OASIStsep;

  $scalefactor = get_prefs('InvScaleFactor');

  $message = '';
  if($underdelivery)
  {
    $message .= "\nPROJECTED UNDERDELIVERIES\n";
    while(list($ca_id, $a0) = each($underdelivery))
    {
      $result = mysql_query("select Name from Campaigns where CampaignID=$ca_id");
      list($ca_name) = mysql_fetch_row($result);
      while(list($cr_id, $a1) = each($a0))
      {
        $result = mysql_query("select Name from Creatives where CreativeID=$cr_id");
        list($cr_name) = mysql_fetch_row($result);
        $message .= "$ca_name ($cr_name)\n";
        while(list($day, $a2) = each($a1))
        {
          list($target, $remaining) = $a2;
	  $target /= $scalefactor;
	  $remaining /= $scalefactor;

	  $delivered = $target - $remaining;
	  $perc      = number_format($remaining / $target * 100, 1, $OASISdecpt, $OASIStsep);
	  $delivered = number_format($delivered, 0, $OASISdecpt, $OASIStsep);
	  $target    = number_format($target, 0, $OASISdecpt, $OASIStsep);
	  $day = date('D, M j', $day);
          $message .= "  $day: $delivered/$target ($perc % underdelivered)\n";
        }
        $message .= "\n";
      }
    }
  }
  
  if($overallocated)
  {
    $message .= "\nOVERALLOCATED SECTIONS\n";
    while(list($s, $a0) = each($overallocated))
    {
      $result = mysql_query("select ReportName from Sections where SectionID=$s");
      list($s_name) = mysql_fetch_row($result);
      while(list($dim, $a1) = each($a0))
      {
        $message .= "$s_name ($dim)\n";
        while(list($day, $a2) = each($a1))
        {
          list($imp, $alloc) = $a2;

	  $perc  = number_format($alloc / $imp * 100, 1, $OASISdecpt, $OASIStsep);
	  $imp   = number_format($imp, 0, $OASISdecpt, $OASIStsep);
	  $alloc = number_format($alloc, 0, $OASISdecpt, $OASIStsep);
          $message .= "  $day: $alloc/$imp ($perc %)\n";
        }
        $message .= "\n";
      }
    }
  }

  function cmp( $c1, $c2 ) { return (int) ( $c1 - $c2 ); }

  if($no_assignments)
  {
    $na_message = '';
    while(list($s, $a0) = each($no_assignments))
    {
      $result = mysql_query("select ReportName, Active from Sections where SectionID=$s");
      list($s_name, $active) = mysql_fetch_row($result);
      if($active == 'Y')
      {
        while(list($dim, $a1) = each($a0))
        {
          $na_message .= "$s_name ($dim)\n";
          while(list($day, $a2) = each($a1))
          {
	    $hours = array_keys($a2);
	    usort($hours, cmp);
            $na_message .= "  $day (" . join(",", $hours) . ")\n";
	  }
        }
      }
    }
    if($na_message) $message .= "\nEMPTY SECTIONS\n$na_message";
  }


  if($message)
  {
    $admin_email = get_prefs('AdminEmail');
    mail($admin_email, "Inventory Report", $message);
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function simulate_day($day)
{
  global $OG_assignments, $OG_hourly_targets;
  global $allocated;

  $scalefactor = get_prefs('InvScaleFactor');

  $allocated = array();

  $date = date('Y-m-d', $day);
  #$time = date('H:i', time());
  sim_log("Simulating $date:");

  #print "tr ";
  $dt = get_daily_traffic($date);

  #print "dt ";
  compute_daily_targets('', $day);
  mysql_query("update SimDailyTargets set Target=Target*$scalefactor, Remaining=Remaining*$scalefactor");

  #print "sim";
  for($h = 0; $h < 24; $h++)
  {
    sim_log("simulating hour $h");
    #print "at ";
    sim_log("building assignment table...");
    build_assignment_table(1, $h);
    sim_log("computing hourly targets...");
    compute_hourly_targets($h, 1);
    sim_log("getting traffic...");
    $hourly_traffic = get_hourly_traffic($dt, $h, $scalefactor);
    sim_log("simulating...");
    simulate_hour($hourly_traffic, $scalefactor, $h, $date);
  }

  ##### mark off allocations
  while(list($s, $a0) = each($allocated))
    while(list($w, $a1) = each($a0))
      while(list($h, $imp) = each($a1))
      {
        $imp /= $scalefactor;
        mysql_query("update SimSectionDailyTraffic set Allocated=Allocated+$imp where Day='$date' and SectionID=$s and Width=$w and Height=$h");
      }

  global $underdelivery;

  $result = mysql_query("select CampaignID, SimDailyTargets.CreativeID, Target, Remaining from SimDailyTargets left join Creatives on SimDailyTargets.CreativeID=Creatives.CreativeID where Remaining > 0");
  while(list($ca_id, $cr_id, $t, $r) = mysql_fetch_row($result))
  {
    sim_log("underdelivery: campaign $ca_id, creative $cr_id ($t, $r)");
    $underdelivery[$ca_id][$cr_id][$day] = array($t, $r);
  }
}



####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function get_daily_traffic($date)
{
  $dt = array();

  $sql = "select SectionID, Width, Height, Impressions from SimSectionDailyTraffic where Day='$date'";
  #print "$sql\n";

  $result = mysql_query($sql);
  while(list($s, $w, $h, $imp) = mysql_fetch_row($result))
    array_push($dt, array($s, $w, $h, $imp));

  return $dt;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function get_hourly_traffic($dt, $hour, $sfactor)
{
  global $pageviews, $total_pageviews;

  $multiplier = $pageviews[$hour] / $total_pageviews * $sfactor;

  $ht = array();
  foreach($dt as $d)
  {
    list($s, $w, $h, $imp) = $d;
    $imp = (int)($imp * $multiplier);

    array_push($ht, "$s-$w-$h-$imp");
  }

  return $ht;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function simulate_hour($hourly_traffic, $scalefactor, $hour, $day)
{
  global $no_assignments;

  $imptotal = 0;
  $count = 0;
  $hit_details = array();
  $impsr = array();
  foreach($hourly_traffic as $h)
  {
    list($s, $w, $h, $imp) = split ('-', $h);
    $count++;
    $hit_details[$count] = array($s, $w, $h);
    #print "$s ($w x $h): $imp\n";
    $impsr[$count] = $imp;
    $imptotal += $imp;
  }

  sim_log("$imptotal impressions...");

  $creative_imps = array();
  while($imptotal > 0)
  {
    $rn = @mt_rand(1, $imptotal);
    $s = 0; $w = 0; $h = 0;
    reset($impsr);
    while(list($c, $i) = each($impsr))
    {
      $rn -= $i;
      if($rn <= 0)
      {
        $impsr[$c]--;
        list($s, $w, $h) = $hit_details[$c];
	break;
      }
    }
    if($s == 0)
    {
      sim_log("error: $s, $w, $h");
      break;
    }

    $cr_id = select_creative($s, $w, $h);

    if($cr_id == 0)
    {
      $no_assignments[$s]["{$w}x{$h}"][$day][$hour] = 1;
    }
    else
    {
      #print "section $s ($w x $h): creative $cr_id\n";
      $creative_imps[$cr_id]++;
    }

    $imptotal--;
  }

  #### now record the impressions
  while(list($cr_id, $imps) = each($creative_imps))
  {
    sim_log("  [Cr $cr_id] $imps simulated imps...");
    #### daily targets have already been adjusted for scalefactor
    if(!mysql_query("update SimDailyTargets set Remaining=Remaining-$imps where CreativeID=$cr_id"))
      die("error updating SimDailyTargets: " . mysql_error() . "\n");

    #### adjust for scalefactor
    $imps = (int)($imps / $scalefactor);

    if(!mysql_query("update SimCreatives set ImpressionsDelivered=ImpressionsDelivered+$imps where CreativeID=$cr_id"))
      die("error updating SimCreatives: " . mysql_error() . "(Cr $cr_id, imps=$imps\n");

    $result = mysql_query("select CampaignID from SimCreatives where CreativeID=$cr_id");
    list($ca_id) = mysql_fetch_row($result);
    if(!mysql_query("update SimCampaigns set ImpressionsDelivered=ImpressionsDelivered+$imps where CampaignID=$ca_id"))
      die("error updating SimCampaigns: " . mysql_error() . "\n");
  }
}



####---------------------------------------------------------------------------
####  This is awfully similar to the code used in the delivery engine itself.
####  Too bad we can't reuse it, but for speed, we don't want the delivery
####  engine using "include" or "require".  Also, in the delivery engine, we
####  are worried about semaphores and shared memory, which isn't a concern
####  when we're just simulating.
####---------------------------------------------------------------------------
function select_creative($s, $w, $h)
{
  global $OG_assignments, $OG_hourly_targets, $allocated;

  #### loop through creatives, looking for best candidate
  $c_selection = 0;
  $total_weight = 0;
  $total_remaining = 0;
  $tcandidates = $OG_assignments[$s]["{$w}x$h"];
  while(list($c, $v) = @each($tcandidates))
  {
    list($target, $weight, $remaining, $clicks, $mtype) = $OG_hourly_targets[$c];

    #print "creative $c: [$target, $weight, $remaining]<BR>\n";
    if($remaining > 0)
    {
      $total_remaining += $remaining;
      $remaining_ads[$c] = $remaining;
    }
    elseif($target == 0)
    {
      $total_weight += $weight;
      $weight_ads[$c] = $weight;
    }
  }

  #### should we select a 'remaining' ad or a 'weight' ad?
  if($total_remaining <= 0)
  {
    $rmax = $total_weight;
    $candidates = $weight_ads;
    #print "running a weight ad ($rmax)<BR>\n";
  }
  else
  {
    $rmax = $total_remaining;
    $candidates = $remaining_ads;
    $allocated[$s][$w][$h]++;
    #print "running a remaining ad ($rmax)<BR>\n";
  }

  if($rmax > 0)
  {
    $rand_num = mt_rand(0, $rmax);
    #print "rand_num: $rand_num<BR>\n";
    while(list($c, $w) = each($candidates))
    {
      $rand_num -= $w;
  
      if($rand_num <= 0)
      {
        $c_selection = $c;
        break;
      }
    }
  }
  else
  {
    return 0;
  }

  list($target, $weight, $remaining, $clicks, $mtype)
    = $OG_hourly_targets[$c_selection];
  $remaining--;
  $OG_hourly_targets[$c_selection]
    = array($target, $weight, $remaining, $clicks, $mtype);
  return $c_selection;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function copy_active_campaigns()
{
  if(!mysql_query("delete from SimCampaigns"))
    die("Error clearing SimCampaigns: " . mysql_error() . "\n");
  if(!mysql_query("delete from SimCreatives"))
    die("Error clearing SimCreatives: " . mysql_error() . "\n");

  $sql = "select CampaignID, Name, Status, StartDate, EndDate, ImpressionsGuaranteed, EvenDelivery, ImpressionsDelivered, DaysOfWeek, HoursOfDay, Weight from Campaigns where Status='Active'";
  if(!($result1 = mysql_query($sql)))
    die("Error reading active campaigns: " . mysql_error() . "\n$sql\n");

  while(list($ca_id, $n, $s, $sd, $ed, $ig, $evend, $id, $dow, $hod, $wt)
        = mysql_fetch_row($result1))
  {
    $sql = "insert into SimCampaigns values ($ca_id, '$n', '$s', '$sd', '$ed', $ig, '$evend', $id, $dow, $hod, $wt)";
    mysql_query($sql);

    $sql = "select CreativeID, Name, Status, StartDate, EndDate, Width, Height, Weight, ImpressionsGuaranteed, ImpressionsDelivered, DaysOfWeek, HoursOfDay from Creatives where CampaignID=$ca_id";
    if(!($result2 = mysql_query($sql)))
      die("Error reading creatives for campaign $ca_id: " . mysql_error() . "\n$sql\n");
    while(list($cr_id, $n, $s, $sd, $ed, $w, $h, $wt, $ig, $id, $dow, $hod)
        = mysql_fetch_row($result2))
    {
      $sql = "insert into SimCreatives values ($cr_id, $ca_id, '$n', '$s', '$sd', '$ed', $w, $h, $wt, $ig, $id, $dow, $hod)";
      mysql_query($sql);
    }
  }
}


?>
