<?php

require("lib-mgmt.inc");

$shm_error_message = <<<__TEXT__
<H1>$OASISmsg[Error]</H1>
Error connecting to shared memory segment.
Please be sure you have run <CODE>hourly_maint.php</CODE>.  Use
<CODE>ipcs</CODE> to be sure that all OASIS shared memory segments
are created: 0x4f415300 through 0x4f415308

__TEXT__;

print_html_header ($OASISmsg['Admin']);
print_header('Admin', '', '');

if($function == 'show_admin_log')
{
  show_admin_log();
  print_footer();
  exit;
}
elseif($function == 'show_prefs')
{
  show_prefs();
  print_footer();
  exit;
}
elseif($function == 'save_prefs')
{
  save_prefs();
}
elseif($function == 'shm_hourly_assignments')
{
  show_hourly_assignments($_GET['overflow']);
  print_footer();
  exit;
}
elseif($function == 'shm_creative_content')
{
  show_creative_content($_GET['overflow']);
  print_footer();
  exit;
}
elseif($function == 'shm_creative_clickthrough')
{
  show_creative_clickthrough($_GET['overflow']);
  print_footer();
  exit;
}
elseif($function == 'shm_deliveries_full')
{
  show_deliveries(1);
  print_footer();
  exit;
}
elseif($function == 'shm_deliveries')
{
  show_deliveries(0);
  print_footer();
  exit;
}
elseif($function == 'targets')
{
  show_targets($_GET['overflow']);
  print_footer();
  exit;
}
elseif($function == 'reload')
{
  if ($OG_PubID == 1) {
    reload();
  }
  else {
    print $OASISmsg['no_permission'];
  }
  print_footer();
  exit;
}

elseif($function == 'show_max_sizes')
{
  show_max_sizes();
  print_footer();
  exit;
}
elseif($function == 'edit_max_size')
{
  edit_max_size($Width, $Height);
  print_footer();
  exit;
}
elseif($save_max_size)
{
  save_max_size($Width, $Height, $Size, $Name);
  show_max_sizes();
  print_footer();
  exit;
}
elseif($delete_max_size)
{
  delete_max_size($Width, $Height);
  show_max_sizes();
  print_footer();
  exit;
}

elseif($save_traffic)
  save_traffic();
elseif($function == 'traffic_shape')
{
  traffic_shape();
  print_footer();
  exit;
}

?>

<TABLE WIDTH=615><TR><TD>
<FONT SIZE="+1"><STRONG><?php echo $OASISmsg['Admin']; ?></STRONG></FONT><BR>
<?php echo $OASISmsg['OASIS_Version'] . ':' . $OASISversion; ?><BR>
<P>
<STRONG><A HREF="user.php"><?php echo $OASISmsg['User_Management']; ?></A></STRONG>
<BR>
<FONT SIZE="-1">
<?php echo $OASISmsg['user_mgmt_msg']; ?>
</FONT>

<P>
<STRONG><A HREF="publisher.php"><?php echo $OASISmsg['Publisher_Management']; ?></A></STRONG>
<BR>
<FONT SIZE="-1">
<?php echo $OASISmsg['publisher_mgmt_msg']; ?>
</FONT>

<P>
<STRONG><A HREF="admin.php?function=show_prefs"><?php echo $OASISmsg['Preferences']; ?></A></STRONG>
<BR>
<FONT SIZE="-1">
<?php echo $OASISmsg['prefs_msg']; ?>
</FONT>

<?php if ($OG_PubID == 1): ?>

<P>
<STRONG><A HREF="admin.php?function=show_max_sizes"><?php echo $OASISmsg['Max_Creative_Sizes']; ?></A></STRONG>
<BR>
<FONT SIZE="-1">
<?php echo $OASISmsg['max_creative_msg']; ?>
</FONT>

<P>
<STRONG><A HREF="admin.php?function=traffic_shape"><?php echo $OASISmsg['Traffic_Shaping'] ?></A></STRONG>
<BR>
<FONT SIZE="-1">
<?php echo $OASISmsg['traffic_msg']; ?>
</FONT>

<P>
<STRONG><A HREF="admin.php?function=show_admin_log"><?php echo $OASISmsg['View_Admin_Log']; ?></A></STRONG>
<BR>
<FONT SIZE="-1">
<?php echo $OASISmsg['admin_log_msg']; ?>
</FONT>


<P>
<STRONG><?php echo $OASISmsg['Delivery_Engine_Internals']; ?></STRONG>
<BR>
<FONT SIZE="-1">
<?php echo $OASISmsg['delivery_engine_msg']; ?>
View the contents of the various shared memory tables used by OASIS.
</FONT>
<UL>
<LI><A HREF="admin.php?function=shm_hourly_assignments"><?php echo $OASISmsg['Hourly_Assignments']; ?></A>
(<A HREF="admin.php?function=shm_hourly_assignments&overflow=1"><?php echo $OASISmsg['overflow']; ?></A>)
<BR>
<FONT SIZE="-1">
<?php echo $OASISmsg['hourly_assignments_msg']; ?>
</FONT>
<LI><A HREF="admin.php?function=targets"><?php echo $OASISmsg['Daily_Hourly_Targets']; ?></A>
(<A HREF="admin.php?function=targets&overflow=1"><?php echo $OASISmsg['overflow']; ?></A>)
<BR>
<FONT SIZE="-1">
<?php echo $OASISmsg['targets_msg']; ?>
</FONT>
<LI><A HREF="admin.php?function=shm_creative_content"><?php echo $OASISmsg['Creative_Content']; ?></A>
(<A HREF="admin.php?function=shm_creative_content&overflow=1"><?php echo $OASISmsg['overflow']; ?></A>)
<BR>
<FONT SIZE="-1">
<?php echo $OASISmsg['creative_msg']; ?>
</FONT>
<LI><A HREF="admin.php?function=shm_creative_clickthrough"><?php echo $OASISmsg['Creative_Clickthrough']; ?></A>
(<A HREF="admin.php?function=shm_creative_clickthrough&overflow=1"><?php echo $OASISmsg['overflow']; ?></A>)
<BR>
<FONT SIZE="-1">
<?php echo $OASISmsg['clickthrough_msg']; ?>
</FONT>
<LI><A HREF="admin.php?function=shm_deliveries"><?php echo $OASISmsg['Delivery_Table_Stats']; ?></A> 
(<A HREF="admin.php?function=shm_deliveries_full"><?php echo $OASISmsg['full_table'] ?></A> - <?php echo $OASISmsg['this_can_be_huge']; ?>)
<BR>
<FONT SIZE="-1">
<?php echo $OASISmsg['delivery_msg']; ?>
</FONT>
</UL>
<P>
<STRONG><A HREF="admin.php?function=reload"><?php echo $OASISmsg['Reload_Delivery_Engine']; ?></A></STRONG>
<BR>
<FONT SIZE="-1">
<?php echo $OASISmsg['reload_msg']; ?>
</FONT>
<?php endif; ?>

</TD></TR></TABLE>

<?php

print_footer();

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function save_prefs()
{
  global $keys;
  global $HTTP_POST_VARS;
  global $OASISmsg, $OG_PubID;

  foreach($keys as $k)
  {
    if(!mysql_query("update OASISPrefs set PrefValue='$HTTP_POST_VARS[$k]' where PrefKey='$k' AND PublisherID=$OG_PubID"))
    {
      print "$OASISmsg[error_save_pref]: " . mysql_error();
      exit;
    }
  }

  print "$OASISmsg[Preferences_saved]<BR>\n";
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function delete_max_size($w, $h)
{
  global $OASISmsg;

  if(!mysql_query("delete from MaxSizes where Width=$w and Height=$h"))
  {
    print "$OASISmsg[error_del_max_size] $w x $h: " . mysql_error();
    exit;
  }
}



####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function save_max_size($w, $h, $s, $n)
{
  global $OASISmsg;

  if(!mysql_query("delete from MaxSizes where Width=$w and Height=$h"))
  {
    print "$OASISmsg[error_del_max_size] $w x $h: " . mysql_error();
    exit;
  }
  if(!mysql_query("insert into MaxSizes values ($w, $h, $s, '$n')"))
  {
    print "$OASISmsg[error_save_max_size] $w x $h: " . mysql_error();
    exit;
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function edit_max_size($w, $h)
{
  global $OASISmsg;

  if($w == '' || $h == '')
  {
    $w_input = '<INPUT SIZE=4 NAME=Width>';
    $w_hidden = '';
    $h_input = '<INPUT SIZE=4 NAME=Height>';
    $h_hidden = '';
    $delete = '';
  }
  else
  {
    if(!$result = mysql_query("select Name, Size from MaxSizes where Width=$w and Height=$h"))
    {
      print "$OASISmsg[error_query_max_size]: " . mysql_error();
      exit;
    }

    list($n, $s) = mysql_fetch_row($result);
    $w_input = $w;
    $w_hidden = "<INPUT TYPE=hidden NAME=Width VALUE=\"$w\">";
    $h_input = $h;
    $h_hidden = "<INPUT TYPE=hidden NAME=Height VALUE=\"$h\">";
    $delete = "<INPUT TYPE=submit NAME=\"delete_max_size\" VALUE=\"$OASISmsg[Delete]\">";
  }

  print <<<__TEXT__
<FORM METHOD=POST ACTION=admin.php>
$w_hidden
$h_hidden
<TABLE>
<TR>
<TD>$OASISmsg[Name]</TD>
<TD ALIGN=right><INPUT MAXLENGTH=64 NAME="Name" VALUE="$n"></TD>
</TR>
<TR>
<TD>$OASISmsg[Width]</TD>
<TD ALIGN=right>$w_input</TD>
</TR>
<TR>
<TD>$OASISmsg[Height]</TD>
<TD ALIGN=right>$h_input</TD>
</TR>
<TR>
<TD>$OASISmsg[Size]</TD>
<TD ALIGN=right><INPUT SIZE=6 NAME=Size VALUE="$s"></TD>
</TR>
<TR>
<TD COLSPAN=2>
<INPUT TYPE=submit NAME="save_max_size" VALUE="$OASISmsg[Save]">
$delete
</TD>
</TABLE>
</FORM>
__TEXT__;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function show_admin_log()
{
  print "<TABLE WIDTH=615><TR><TD><FONT SIZE=\"-1\"><CODE>\n";
  $log_dir = get_prefs("LogDir");
  $fp = fopen("$log_dir/oasis_admin.log", "r");
  if($fp)
  {
    while(!feof($fp))
    {
      $buffer = fgets($fp, 4096);
      print "$buffer<BR>\n";
    }
  }
  fclose($fp);
  print "</CODE></FONT></TD></TR></TABLE>\n";
}



####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function show_max_sizes()
{
  global $OASISmsg;

  print <<<__TEXT__
<FORM METHOD=POST ACTION=admin.php>
<DIV ALIGN=center>
<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=1>
<TR>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Name]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Width] x $OASISmsg[Height]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Size]</SPAN></TD>
</TR>
__TEXT__;

  if(!$result = mysql_query("select Width, Height, Size, Name from MaxSizes order by Width, Height"))
  {
    print "$OASISmsg[error_query_max_size]: " . mysql_error();
    exit;
  }

  while(list($w, $h, $s, $n) = mysql_fetch_row($result))
  {
    $bgcolor = ($bgcolor == '#ffffff') ? '#cccccc' : '#ffffff';
    print <<<__TEXT__
<TR BACKGROUND='' BGCOLOR="$bgcolor">
<TD><A HREF="admin.php?function=edit_max_size&Width=$w&Height=$h">$n</A></TD>
<TD>$w x $h</TD>
<TD ALIGN=right>$s</TD>
</TR>
__TEXT__;
  }
  
  print <<<__TEXT__
</TABLE>
<A HREF="admin.php?function=edit_max_size">$OASISmsg[Add_new]</A>
</FORM>
__TEXT__;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function show_prefs()
{
  global $OASISmsg, $OG_PubID;

  if(!$result = mysql_query("select PrefKey, PrefValue from OASISPrefs WHERE PublisherID=$OG_PubID order by PrefKey"))
  {
    print "$OASISmsg[error_query_prefs]: " . mysql_error();
    exit;
  }

  print <<<__TEXT__
<FORM METHOD=POST ACTION=admin.php>
<INPUT TYPE=hidden NAME=function VALUE="save_prefs">
<TABLE>
__TEXT__;

  while(list($k, $v) = mysql_fetch_row($result))
  {
    print <<<__TEXT__
<INPUT TYPE=hidden NAME=keys[] VALUE="$k">
<TR>
<TD VALIGN=top>$k</TD>
<TD><TEXTAREA WRAP=virtual ROWS=3 COLS=25 NAME=$k>$v</TEXTAREA></TD>
</TR>
__TEXT__;
  }

  print <<<__TEXT__
<TR>
<TD COLSPAN=2>
<INPUT TYPE=submit VALUE="$OASISmsg[Save]">
</TD>
</TR>
</TABLE>
</FORM>
__TEXT__;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function show_hourly_assignments($overflow = 0)
{
  global $shm_error_message, $smh, $totalbytes;
  global $OASISmsg, $OASISdecpt, $OASIStsep;

  $shm = ($overflow) ? 0x4f415305 : 0x4f415300;

  if(!($smh = @shm_attach($shm, 0)))
  {
    print $shm_error_message;
    print_footer();
    exit;
  }

  print <<<__TEXT__
<P><FONT SIZE="+1"><STRONG>$OASISmsg[Hourly_Assignments]</STRONG></FONT><BR>
<TABLE WIDTH=615 CELLPADDING=0 CELLSPACING=0 BORDER=1>
<TR>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Section]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Creatives]</SPAN></TD>
</TR>
__TEXT__;

  $totalbytes = 0;
  display_section(0, 0);

  shm_detach($smh);

  $shm_size = get_prefs('ShmSizeHourlyAssignments');
  $perc_used = number_format($totalbytes / $shm_size * 100, 1, $OASISdecpt, $OASIStsep);
  $totalbytes = number_format($totalbytes, 0, $OASISdecpt, $OASIStsep);
  $shm_size = number_format($shm_size, 0, $OASISdecpt, $OASIStsep);
  print <<<__TEXT__
</TABLE>

$OASISmsg[Shared_memory_used]: $totalbytes B / $shm_size B ($perc_used %)
__TEXT__;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function display_section($PSectionID, $depth)
{
  global $smh, $bgcolor, $totalbytes;

  if(!($result = mysql_query("select SectionID, Name from Sections where PSectionID = $PSectionID order by Name")))
  {
    return;
  }

  $spacer = '';
  for($i = 0; $i < $depth; $i++) $spacer .= "&nbsp;&nbsp;&nbsp;";

  while(list($s_id, $s_name) = mysql_fetch_row($result))
  {
    @$s_assign = shm_get_var($smh, $s_id);
    $totalbytes += strlen(serialize($s_assign));

      $bgcolor = ($bgcolor == '#ffffff') ? '#cccccc' : '#ffffff';

      print <<<__TEXT__
<TR BACKGROUND='' BGCOLOR=$bgcolor>
<TD VALIGN=top>$spacer<A HREF="section.php?SectionID=$s_id">$s_name</A></TD>
<TD>
__TEXT__;

    if($s_assign)
    {
      ksort($s_assign);
      while(list($d, $sd_assign) = each($s_assign))
      {
        ksort($sd_assign);
        print "<STRONG>$d</STRONG>: ";
        while(list(, $c) = each($sd_assign))
	  print <<<__TEXT__
<A HREF="creative.php?CreativeID=$c">$c</A> 
__TEXT__;
        print "<BR>\n";
      }
    }
    else
    {
      print "&nbsp;\n";
    }
    print "</TD></TR>\n";

    display_section($s_id, $depth+1);
  }
}



####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function show_creative_content($overflow = 0)
{
  global $shm_error_message, $display_banners;
  global $OASISmsg, $OASISdecpt, $OASIStsep;

  $shm = ($overflow) ? 0x4f415307 : 0x4f415302;

  if(!($smh = @shm_attach($shm, 0)))
  {
    print $shm_error_message;
    print_footer();
    exit;
  }

  print <<<__TEXT__
<P><FONT SIZE="+1"><STRONG>$OASISmsg[Creative_Content]</STRONG></FONT><BR>
<TABLE WIDTH=615 CELLPADDING=0 CELLSPACING=0 BORDER=1>
<TR>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Creative]</SPAN></TD>
__TEXT__;

  if($display_banners)
    print "<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Content]</SPAN></TD>\n";

  print <<<__TEXT__
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Redirect]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[MIMEType]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Animated]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[AltText]</SPAN></TD>
</TR>

__TEXT__;

  $totalbytes = 0;
  if($result = mysql_query("select DailyTargets.CreativeID, Creatives.Name, Creatives.MediaType from DailyTargets left join Creatives on DailyTargets.CreativeID=Creatives.CreativeID order by Creatives.Name"))
  {
    while(list($cr_id, $cr_name, $mtype) = mysql_fetch_row($result))
    {
      @$cr_i = shm_get_var($smh, $cr_id);
      $totalbytes += strlen(serialize($cr_i));

      if(!$cr_i) continue;

      $bgcolor = ($bgcolor == '#ffffff') ? '#cccccc' : '#ffffff';
      $cr_prev = '';
      if($display_banners)
      {
        if($mtype == 'Image')
        {
          if($cr_i[1] == 'N')
	  {
            $cr_prev =<<<__TEXT__
<A HREF="creative_preview.php?CreativeID=$cr_id&overflow=$overflow"><IMG
SRC="creative_preview.php?CreativeID=$cr_id&overflow=$overflow"
HEIGHT=20 BORDER=0></A>
__TEXT__;
	  }
	  else
	  {
            $cr_prev =<<<__TEXT__
<A HREF="$cr_i[0]"><IMG SRC="$cr_i[0]" HEIGHT=20 BORDER=0></A>
__TEXT__;
	  }
        }
        elseif($mtype == 'RichMedia')
        {
          $cr_prev = $cr_i[0];
          $cr_prev = htmlspecialchars($cr_prev);
        }
      }

      print <<<__TEXT__
<TR BACKGROUND='' BGCOLOR=$bgcolor>
<TD><SPAN CLASS=smalldata>$cr_name</SPAN></TD>

__TEXT__;

      if($display_banners)
        print "<TD><SPAN CLASS=smalldata>$cr_prev</SPAN></TD>\n";

      print <<<__TEXT__
<TD><SPAN CLASS=smalldata>$cr_i[1]</SPAN></TD>
<TD><SPAN CLASS=smalldata>$cr_i[2]</SPAN></TD>
<TD><SPAN CLASS=smalldata>$cr_i[3]</SPAN></TD>
<TD><SPAN CLASS=smalldata>$cr_i[4]</SPAN></TD>
</TR>
__TEXT__;
    }
  }

  shm_detach($smh);

  $shm_size = get_prefs('ShmSizeCreativeContent');
  $perc_used = number_format($totalbytes / $shm_size * 100, 1, $OASISdecpt, $OASIStsep);
  $totalbytes = number_format($totalbytes, 0, $OASISdecpt, $OASIStsep);
  $shm_size = number_format($shm_size, 0, $OASISdecpt, $OASIStsep);

  print <<<__TEXT__
</TABLE>
$OASISmsg[Shared_memory_used]: $totalbytes B / $shm_size B ($perc_used %)
__TEXT__;

  if(!$display_banners)
  {
    print <<<__TEXT__
<P>
<A HREF="admin.php?function=shm_creative_content&display_banners=1&overflow=$overflow">$OASISmsg[Show_content]</A> ($OASISmsg[this_can_be_very_slow])
__TEXT__;
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function show_creative_clickthrough($overflow = 0)
{
  global $shm_error_message;
  global $OASISmsg, $OASISdecpt, $OASIStsep;

  $shm = ($overflow) ? 0x4f415308 : 0x4f415303;

  if(!($smh = @shm_attach($shm, 0)))
  {
    print $shm_error_message;
    print_footer();
    exit;
  }

  print <<<__TEXT__
<P><FONT SIZE="+1"><STRONG>$OASISmsg[Creative_Clickthrough]</STRONG></FONT><BR>
<TABLE WIDTH=615 CELLPADDING=0 CELLSPACING=0 BORDER=1>
<TR>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Creative]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[ClickthroughURL]</SPAN></TD>
</TR>
__TEXT__;

  $totalbytes = 0;
  if($result = mysql_query("select DailyTargets.CreativeID, Creatives.Name from DailyTargets left join Creatives on DailyTargets.CreativeID=Creatives.CreativeID order by Creatives.Name"))
  {
    while(list($cr_id, $cr_name) = mysql_fetch_row($result))
    {
      @$cr_i = shm_get_var($smh, $cr_id);
      $totalbytes += strlen(serialize($cr_i));

      if(!$cr_i) continue;

      $cr_printable = preg_replace('#([;&,])#', "\\1 ", $cr_i);

      $bgcolor = ($bgcolor == '#ffffff') ? '#cccccc' : '#ffffff';

      print <<<__TEXT__
<TR BACKGROUND='' BGCOLOR=$bgcolor>
<TD><A HREF="creative.php?CreativeID=$cr_id">$cr_name</A></TD>
<TD><A HREF="$cr_i">$cr_printable</A></TD>
</TR>
__TEXT__;
    }
  }

  shm_detach($smh);

  $shm_size = get_prefs('ShmSizeCreativeClickthroughs');
  $perc_used = number_format($totalbytes / $shm_size * 100, 1, $OASISdecpt, $OASIStsep);
  $totalbytes = number_format($totalbytes, 0, $OASISdecpt, $OASIStsep);
  $shm_size = number_format($shm_size, 0, $OASISdecpt, $OASIStsep);

  print <<<__TEXT__
</TABLE>
$OASISmsg[Shared_memory_used]: $totalbytes B / $shm_size B ($perc_used %)
__TEXT__;

}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function show_deliveries($full)
{
  global $OASISmsg, $OASISdecpt, $OASIStsep;

  print <<<__TEXT__
<P><FONT SIZE="+1"><STRONG>$OASISmsg[Delivery_Table]</STRONG></FONT><BR>
__TEXT__;

  $result = mysql_query("show table status");
  while(list($n, $t, $rf, $r, $arl, $dl, $mdl, $il) = mysql_fetch_row($result))
    if($n == 'Delivery') break;

  $result = mysql_query("select IDString, CreativeID, LastSeen from Delivery");

  $id_count = 0;
  $ip_count = 0;
  $instance_count = 0;
  while(list($id, $cr_id, $ls) = mysql_fetch_row($result))
  {
    $ls = preg_replace('#(\d+)(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})#',
                       '\2/\3/\1 \4:\5:\6', $ls);

    if(preg_match('#(.{24})(.{4})(.{4})(.{4})#', $id, $m))
    {
      list($j, $iid, $s, $w, $h) = $m;
      $instances[$iid] = array ();
      $instance_count++;
      $s = hexdec($s);
      array_push ($instances[$iid], array ($s, hexdec($w), hexdec($h), $cr_id, $ls));
      $section_instance_count[$s]++;
    }
    else if(preg_match('#(.{13})(.{4})(.{4})(.{4})#', $id, $m))
    {
      list($j, $u, $s, $w, $h) = $m;

      if(!$uniqids[$u])
      {
        $uniqids[$u] = array();
        $id_count++;
      }
      $s = hexdec($s);
      array_push($uniqids[$u], array($s, hexdec($w), hexdec($h), $cr_id, $ls));
      $section_id_count[$s]++;
    }
    else
    {
      preg_match('#(.{8})(.{4})(.{4})(.{4})#', $id, $m);
      list($j, $i, $s, $w, $h) = $m;

      if(!$ipaddrs[$i])
      {
        $ipaddrs[$i] = array();
        $ip_count++;
      }
      $s = hexdec($s);
      array_push($ipaddrs[$i], array($s, hexdec($w), hexdec($h), $cr_id, $ls));
      $section_ip_count[$s]++;
    }
  }

  $id_count       = number_format($id_count, 0, $OASISdecpt, $OASIStsep);
  $ip_count       = number_format($ip_count, 0, $OASISdecpt, $OASIStsep);
  $instance_count = number_format($instance_count, 0, $OASISdecpt, $OASIStsep);

  $r = number_format($r, 0, $OASISdecpt, $OASIStsep);
  $dil = number_format($dl + $il, 0, $OASISdecpt, $OASIStsep);
  $dl = number_format($dl, 0, $OASISdecpt, $OASIStsep);
  $il = number_format($il, 0, $OASISdecpt, $OASIStsep);

  print <<<__TEXT__
<TABLE WIDTH=615><TR><TD>
$OASISmsg[Table_Size]: $dl (data) + $il (index) = $dil<BR>
$OASISmsg[Rows]: $r<BR>
$OASISmsg[Unique_IDs]: $id_count<BR>
$OASISmsg[Unique_IPs]: $ip_count<BR>
$OASISmsg[Unique_Instances]: $instance_count<BR>
</TD></TR></TABLE>

<P>
<TABLE WIDTH=615 CELLPADDING=0 CELLSPACING=0 BORDER=1>
<TR>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Section]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[ID_Count]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[IP_Count]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Instance_Count]</SPAN></TD>
</TR>
__TEXT__;

  if($section_id_count || $section_instance_count)
  {
    while((list($k, $v) = @each($section_id_count))
          || (list($k2, $v2) = @each($section_instance_count)))

    {
      ## If we're still in the loop because we've started going through the
      ## list of Instance IDs, we need to see if we've already output
      ## this section due to the list of Unique IDs ... If we haven't, then
      ## we need to ... If we have, let's just move on to the next iteration
      if($k2)
      {
        if(!$section_id_count[$k2])
        {
          $k = $k2;
          $v = 0;
        }
        else
          continue;
      }

      if($k <= 0) continue;
      $result = mysql_query("select ReportName from Sections where SectionID=$k");
      if(!$result)
      {
        print "$OASISmsg[err_sel_report]$k: " . mysql_error() . "<BR>\n";;
        continue;
      }
      list($section_name) = mysql_fetch_row($result);

      $v1 = number_format($v, 0, $OASISdecpt, $OASIStsep);
      $v2 = number_format($section_ip_count[$k], 0, $OASISdecpt, $OASIStsep);
      $v3 = number_format($section_instance_count[$k], 0, $OASISdecpt, $OASIStsep);
      print <<<__TEXT__
<TR>
<TD><A HREF="section.php?SectionID=$k">$section_name</A></TD>
<TD ALIGN=right>$v1</TD>
<TD ALIGN=right>$v2</TD>
<TD ALIGN=right>$v3</TD>
</TR>
__TEXT__;
    }
  }
  print <<<__TEXT__
</TABLE>
__TEXT__;

  if(!$full) return;

  print <<<__TEXT__
<P>
<TABLE WIDTH=615 CELLPADDING=0 CELLSPACING=0 BORDER=1>
<TR>
<TD CLASS=tablehead WIDTH='25%'><SPAN CLASS=tablehead>$OASISmsg[Unique_ID]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Section]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[WxH]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[CreativeID]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Last_Seen]</SPAN></TD>
</TR>
__TEXT__;

  if ($uniqids)
  {
    ksort($uniqids);
    while(list($k, $v) = each($uniqids))
    {
      $rowspan = count($v);
      print "<TR><TD VALIGN=top ROWSPAN=$rowspan>$k</TD>\n";
      $i = 0;
      foreach($v as $delrec)
      {
        if($i++) print "<TR>\n";
        list($s, $w, $h, $c, $ls) = $delrec;
        print <<<__TEXT__
<TD><A HREF="section.php?SectionID=$s">$s</A></TD>
<TD>{$w}x$h</TD>
<TD><A HREF="creative.php?CreativeID=$c">$c</A></TD>
<TD>$ls</TD>
</TR>
__TEXT__;
      }
    }
  }
  print "</TABLE>\n";

  print <<<__TEXT__
<P>
<TABLE WIDTH=615 CELLPADDING=0 CELLSPACING=0 BORDER=1>
<TR>
<TD CLASS=tablehead WIDTH='25%'><SPAN CLASS=tablehead>$OASISmsg[Instance_ID]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Section]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[WxH]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[CreativeID]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Last_Seen]</SPAN></TD>
</TR>
__TEXT__;

  if ($instances)
  {
    ksort($instances);
    while(list($k, $v) = each($instances))
    {
      $rowspan = count($v);
      print "<TR><TD VALIGN=top ROWSPAN=$rowspan>$k</TD>\n";
      $i = 0;
      foreach($v as $delrec)
      {
        if($i++) print "<TR>\n";
        list($s, $w, $h, $c, $ls) = $delrec;
        print <<<__TEXT__
<TD><A HREF="section.php?SectionID=$s">$s</A></TD>
<TD>{$w}x$h</TD>
<TD><A HREF="creative.php?CreativeID=$c">$c</A></TD>
<TD>$ls</TD>
</TR>
__TEXT__;
      }
    }
  }

  print "</TABLE>\n";

  print <<<__TEXT__
<P>
<TABLE WIDTH=615 CELLPADDING=0 CELLSPACING=0 BORDER=1>
<TR>
<TD CLASS=tablehead WIDTH='25%'><SPAN CLASS=tablehead>$OASISmsg[IP_Address]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Section]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[WxH]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[CreativeID]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Last_Seen]</SPAN></TD>
</TR>
__TEXT__;

  if ($ipaddrs)
  {
    ksort($ipaddrs);
    while(list($k, $v) = each($ipaddrs))
    {
      preg_match('#(..)(..)(..)(..)#', $k, $m);
      list($j, $i1, $i2, $i3, $i4) = $m;
      $ip = hexdec($i1) . "." . hexdec($i2) . "."
          . hexdec($i3) . "." . hexdec($i4);

      $rowspan = count($v);
      print "<TR><TD VALIGN=top ROWSPAN=$rowspan>$ip</TD>\n";
      $i = 0;
      foreach($v as $delrec)
      {
        if($i++) print "<TR>\n";
        list($s, $w, $h, $c, $ls) = $delrec;
        print <<<__TEXT__
<TD><A HREF="section.php?SectionID=$s">$s</A></TD>
<TD>{$w}x$h</TD>
<TD><A HREF="creative.php?CreativeID=$c">$c</A></TD>
<TD>$ls</TD>
</TR>
__TEXT__;
      }
    }
  }

  print "</TABLE>\n";
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function show_targets($overflow = 0)
{
  global $shm_error_message;
  global $OASISmsg, $OASISdecpt, $OASIStsep;

  $shm = ($overflow) ? 0x4f415306 : 0x4f415301;
  if(!($smh = @shm_attach($shm, 0)))
  {
    print $shm_error_message;
    print_footer();
    exit;
  }

  print <<<__TEXT__
<P><FONT SIZE="+1"><STRONG>$OASISmsg[Targets]</STRONG></FONT><BR>
<TABLE WIDTH=615 CELLPADDING=0 CELLSPACING=0 BORDER=1>
<TR>
<TD VALIGN=bottom ROWSPAN=2 CLASS=smalltablehead><SPAN CLASS=smalltablehead>$OASISmsg[Campaign_Creative]</SPAN></TD>
<TD CLASS=smalltablehead COLSPAN=3 ALIGN=center><SPAN CLASS=smalltablehead>$OASISmsg[Daily]</SPAN></TD>
<TD BGCOLOR="#000000">&nbsp;</TD>
<TD CLASS=smalltablehead COLSPAN=5 ALIGN=center><SPAN CLASS=smalltablehead>$OASISmsg[Hourly]</SPAN></TD>
</TR>
<TR>
<TD CLASS=smalltablehead><SPAN CLASS=smalltablehead>$OASISmsg[Target]</SPAN></TD>
<TD CLASS=smalltablehead><SPAN CLASS=smalltablehead>$OASISmsg[Weight]</SPAN></TD>
<TD CLASS=smalltablehead><SPAN CLASS=smalltablehead>$OASISmsg[Remaining]</SPAN></TD>
<TD BGCOLOR="#000000">&nbsp;</TD>
<TD CLASS=smalltablehead><SPAN CLASS=smalltablehead>$OASISmsg[Target]</SPAN></TD>
<TD CLASS=smalltablehead><SPAN CLASS=smalltablehead>$OASISmsg[Weight]</SPAN></TD>
<TD CLASS=smalltablehead><SPAN CLASS=smalltablehead>$OASISmsg[Remaining]</SPAN></TD>
<TD CLASS=smalltablehead><SPAN CLASS=smalltablehead>$OASISmsg[Clicks]</SPAN></TD>
<TD CLASS=smalltablehead><SPAN CLASS=smalltablehead>$OASISmsg[Type]</SPAN></TD>
</TR>
__TEXT__;

  if($result = mysql_query("select RunningCreatives.CreativeID, Creatives.Name, Campaigns.CampaignID, Campaigns.Name, Target, DailyTargets.Weight, Remaining from RunningCreatives natural left join Creatives left join DailyTargets on DailyTargets.CreativeID=Creatives.CreativeID left join Campaigns on Creatives.CampaignID=Campaigns.CampaignID order by Remaining desc, DailyTargets.Weight desc"))
  {
    while(list($cr_id, $cr_name, $ca_id, $ca_name,
               $target, $weight, $remaining) = mysql_fetch_row($result))
    {
      $creative_name[$cr_id] = $cr_name;
      if (!(@$cr_i = shm_get_var($smh, $cr_id))) continue;
      
      $totalbytes += strlen(serialize($cr_i));

      $h_imp_total += ($cr_i[0] - $cr_i[2]);
      $d_imp_total += ($target - $remaining) + ($cr_i[0] - $cr_i[2]);
      $h_click_total += $cr_i[3];

      $bgcolor = ($bgcolor == '#ffffff') ? '#cccccc' : '#ffffff';

      print <<<__TEXT__
<TR BACKGROUND='' BGCOLOR=$bgcolor>
<TD>
<SPAN CLASS=smalldata>
<A HREF="campaign.php?CampaignID=$ca_id">$ca_name</A> /<BR>
<A HREF="creative.php?CreativeID=$cr_id">$cr_name</A>
</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$target</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$weight</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$remaining</SPAN></TD>
<TD BGCOLOR="#000000">&nbsp;</TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$cr_i[0]</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$cr_i[1]</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$cr_i[2]</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$cr_i[3]</SPAN></TD>
<TD ALIGN=right><SPAN CLASS=smalldata>$cr_i[4]</SPAN></TD>
</TR>
__TEXT__;
    }

    $h_click_perc = ($h_imp_total > 0)
                     ? number_format($h_click_total / $h_imp_total * 100, 2, $OASISdecpt, $OASIStsep)
                     : "0{$OASISdecpt}00";
    $d_imp_total = number_format($d_imp_total, 0, $OASISdecpt, $OASIStsep);
    $h_imp_total = number_format($h_imp_total, 0, $OASISdecpt, $OASIStsep);
    $h_click_total = number_format($h_click_total, 0, $OASISdecpt, $OASIStsep);

    print <<<__TEXT__
<TR>
<TD COLSPAN=9>
$OASISmsg[Impressions_today]: $d_imp_total<BR>
$OASISmsg[Impressions_this_hour]: $h_imp_total<BR>
$OASISmsg[Clicks_this_hour]: $h_click_total ($h_click_perc %)<BR>
</TD></TR>
</TABLE>
__TEXT__;

    shm_detach($smh);

    $shm_size = get_prefs('ShmSizeHourlyTargets');
    $perc_used = number_format($totalbytes / $shm_size * 100, 1, $OASISdecpt, $OASIStsep);
    $totalbytes = number_format($totalbytes, 0, $OASISdecpt, $OASIStsep);
    $shm_size = number_format($shm_size, 0, $OASISdecpt, $OASIStsep);
    print <<<__TEXT__
<P>
$OASISmsg[Shared_memory_used]: $totalbytes B / $shm_size B ($perc_used %)
__TEXT__;
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function reload()
{
  global $OASISmsg, $OASISdecpt, $OASIStsep;

  print <<<__TEXT__
<TABLE WIDTH=615><TR><TD>
$OASISmsg[Reloading_delivery_engine]:<BR>
<PRE>
__TEXT__;

  set_time_limit(0);

  if (file_exists ("./enterprise/master_reload.php")) {
    $cmd = "cd enterprise; ./master_reload.php";
  }
  else {
    $cmd = "./hourly_maint.php reload";
  }
  print "$cmd\n";
  print `$cmd\n`;

  print "</PRE></TD></TR></TABLE>\n";
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function save_traffic()
{
  global $h0, $h1, $h2, $h3, $h4, $h5, $h6, $h7, $h8, $h9;
  global $h10, $h11, $h12, $h13, $h14, $h15, $h16, $h17, $h18, $h19;
  global $h20, $h21, $h22, $h23;

  mysql_query("update TrafficProfile set Pageviews=$h0 where Hour=0");
  mysql_query("update TrafficProfile set Pageviews=$h1 where Hour=1");
  mysql_query("update TrafficProfile set Pageviews=$h2 where Hour=2");
  mysql_query("update TrafficProfile set Pageviews=$h3 where Hour=3");
  mysql_query("update TrafficProfile set Pageviews=$h4 where Hour=4");
  mysql_query("update TrafficProfile set Pageviews=$h5 where Hour=5");
  mysql_query("update TrafficProfile set Pageviews=$h6 where Hour=6");
  mysql_query("update TrafficProfile set Pageviews=$h7 where Hour=7");
  mysql_query("update TrafficProfile set Pageviews=$h8 where Hour=8");
  mysql_query("update TrafficProfile set Pageviews=$h9 where Hour=9");
  mysql_query("update TrafficProfile set Pageviews=$h10 where Hour=10");
  mysql_query("update TrafficProfile set Pageviews=$h11 where Hour=11");
  mysql_query("update TrafficProfile set Pageviews=$h12 where Hour=12");
  mysql_query("update TrafficProfile set Pageviews=$h13 where Hour=13");
  mysql_query("update TrafficProfile set Pageviews=$h14 where Hour=14");
  mysql_query("update TrafficProfile set Pageviews=$h15 where Hour=15");
  mysql_query("update TrafficProfile set Pageviews=$h16 where Hour=16");
  mysql_query("update TrafficProfile set Pageviews=$h17 where Hour=17");
  mysql_query("update TrafficProfile set Pageviews=$h18 where Hour=18");
  mysql_query("update TrafficProfile set Pageviews=$h19 where Hour=19");
  mysql_query("update TrafficProfile set Pageviews=$h20 where Hour=20");
  mysql_query("update TrafficProfile set Pageviews=$h21 where Hour=21");
  mysql_query("update TrafficProfile set Pageviews=$h22 where Hour=22");
  mysql_query("update TrafficProfile set Pageviews=$h23 where Hour=23");
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function traffic_shape()
{
  global $OASISmsg, $OASISdecpt, $OASIStsep;

  print <<<__TEXT__
<P><FONT SIZE="+1"><STRONG>$OASISmsg[Traffic_Shaping]</STRONG></FONT><BR>
<FORM METHOD=POST ACTION="admin.php">
<TABLE CELLPADDING=0 CELLSPACING=1 BORDER=0>
<TR>
<TD CLASS=tablehead><SPAN CLASS=tablehead>Hour</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>Pageviews</SPAN></TD>
<TD WIDTH=20><IMG SRC="graphics/1x1.gif" WIDTH=20></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>Hour</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>Pageviews</SPAN></TD>
</TR>
__TEXT__;

  if(!$result = mysql_query("select Hour, Pageviews from TrafficProfile order by Hour"))
  {
    print "$OASISmsg[err_load_profile]: " . mysql_error();
    exit;
  }

  while(list($hour, $pv) = mysql_fetch_row($result))
  {
    $traffic[$hour] = $pv;
  }

  for($i = 0; $i < 12; $i++)
  {
    $h1 = $i;
    $h2 = $i + 12;
    $t1 = $traffic[$h1];
    $t2 = $traffic[$h2];

    print <<<__TEXT__
<TR>
<TD>$h1</TD>
<TD><INPUT NAME=h$h1 VALUE="$t1" SIZE=10 MAXLENGTH=10></TD>
<TD></TD>
<TD>$h2</TD>
<TD><INPUT NAME=h$h2 VALUE="$t2" SIZE=10 MAXLENGTH=10></TD>
</TR>
__TEXT__;
  }

  print <<<__TEXT__
<TR>
<TD COLSPAN=5>
<INPUT TYPE=submit NAME=save_traffic VALUE="$OASISmsg[Save]">
</TD>
</TR>
</TABLE>
</FORM>
__TEXT__;
}


?>
