<?php

$OG_config_vars = array(
'db_user',
'db_passwd',
'identify_path',
'curl_path',
'gzip_path',
'htmldoc_path',
'web_user',
'web_conf_dir',
'admin_user',
'admin_passwd',
'log_dir',
'oasis_root',
'oasis_url',
'oasis_domain',
'oasis_host',
'oasis_port',
'oasis_lang',
'oasis_priv_pol',
'oasis_script_c',
'oasis_script_i',
'oasis_script_ie',
'oasis_script_ii',
'oasis_script_ij',
'geotarget_subsys',
'na_server',
'reload_secret',
);

$OG_interactive_vars = array (
'db_host',
'mysql_admin_user',
'mysql_admin_password',
);

$OG_install_vars = array_merge ($OG_config_vars, $OG_interactive_vars);

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function check_cfg_file()
{
    global $OG_config_vars, $setup;

    #### make sure that all variables in oasis.cfg are defined
    reset ($OG_config_vars);
    foreach ($OG_config_vars as $varname) {
        if (!$setup[$varname]) {
            print "Configuration variable '$varname' not specified in oasis.cfg.  Exiting\n";
            exit;
        }
    }

    #### make sure trailing slashes are in place
    $setup['oasis_url'] = preg_replace ('#/$#', '', $setup['oasis_url']) . '/';
    $setup['oasis_root'] = preg_replace ('#/$#', '', $setup['oasis_root']) . '/';
    $setup['web_conf_dir'] = preg_replace ('#/$#', '', $setup['web_conf_dir']) . '/';
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function check_lib_oasis()
{
    global $OASISversion;

    if (!file_exists ('templates/mgmt/lib-oasis.inc')) {
        print "templates/mgmt/lib-oasis.inc not found!\n";
        exit;
    }
    if ($OASISversion == '') {
        print "lib-oasis.inc not valid.  Please be sure that the Zend Optimizer is\nfunctioning properly with your command-line php interpreter.\n";
        exit;
    }
}

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function check_php_install()
{
  $version_number = get_php_version ();
  if($version_number < 40000)
  {
    print "OASIS requires PHP version 4.0.0 or greater\n";
    exit;
  }

  if(!ini_get('register_argc_argv'))
  { 
    print "register_argc_argv not set in php.ini\nYou must have this set to 'On' in php.ini\n";
    exit;
  }

  if(!((@$sem_id = sem_get(0x4f410000, 1)) && @sem_acquire($sem_id)))
  {
    print "Could not acquire semaphore: $php_errormsg\nYou must enable System V semaphores and shared memory to use OASIS.\n";
    exit;
  }
  @sem_release($sem_id);

  if(!(@$smh = shm_attach(0x4f415300, 1000)))
  {
    print "Could not attach to shared memory: $php_errormsg\nYou must enable System V semaphores and shared memory to use OASIS.\n";
    exit;
  }
  @shm_detach($smh);

  #### PHP version 4.0.7 changed the shm_remove() semantics
  if (get_php_version() >= 40007)
  {
    @shm_remove(shm_attach(0x4f415300, 1000));
  }
  else
  {
    @shm_remove(0x4f415300);
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function check_mysql()
{
  global $stdin, $setup;

  print "Enter MySQL hostname (blank for localhost): ";
  $hostname = chop(fgets($stdin, 65536));
  if ($hostname == '') $hostname = 'localhost';

  print "Enter MySQL username: ";
  $user = chop(fgets($stdin, 65536));

  print "Enter password for $user: ";
  $password = chop(fgets($stdin, 65536));

  if(!@mysql_pconnect($hostname, $user, $password))
  {
    print "Error: could not connect to MySQL server:\n" . mysql_error() . "\n";
    exit;
  }

  if(($result = mysql_query("select VERSION()"))
     && (list($v) = mysql_fetch_row($result)))
  {
    $v = preg_replace('#(\d+\.\d+).*#', '\1', $v);
    if($v < 3.23)
    {
      print "OASIS requires MySQL version 3.23 or greater\n";
      exit;
    }
  }
  else
  {
    print "Error: could not get MySQL version:\n" . mysql_error() . "\n";
    exit;
  }

  $setup['db_host'] = $hostname;
  $setup['mysql_admin_user'] = $user;
  $setup['mysql_admin_password'] = $password;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function get_setup_vals()
{
  global $stdin, $setup;

  foreach(file('oasis.cfg') as $line)
  {
    $line = chop($line);

    #### remove comments
    $line = preg_replace('/\#.*/', '', $line);

    list($key, $val) = split(':', $line);
    $key = preg_replace('#\s+#', '', $key);
    $val = preg_replace('#^\s+#', '', $val);

    if(!$key) continue;

    #print "$key => $val\n";
    $setup[$key] = $val;
    putenv("$key=$val");
  }

  if($setup['oasis_port'] != 80)
  {
    $setup['oasis_host'] .= ":" . $setup['oasis_port'];
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function setup_mysql($setup)
{
  global $stdin;

  #### create oasis database
  if(!mysql_query("create database oasis"))
  {
    if(!@mysql_select_db("oasis"))
    {
      print "Error creating oasis database: " . mysql_error() . "\n";
      exit;
    }
    else
    {
      print "Database already exists: continue loading database? (y/n) ";
      $answer = chop(fgets($stdin, 65536));

      if($answer == 'Y' || $answer == 'y') {}
      else return;
    }
  }

  @mysql_select_db("mysql");

  #### create mysql user
  $sql = <<<__TEXT__
INSERT INTO user
(Host, User, Password, Select_priv, Insert_priv, Update_priv, Delete_priv)
VALUES
('localhost', '{$setup['db_user']}', password('{$setup['db_passwd']}'),
'Y', 'Y', 'Y', 'Y')
__TEXT__;

  $result = mysql_query($sql);
  if (!$result) {
    print "Warning: creating mysql user: " . mysql_error() . "\n";
    print "$sql\n";
  }

  if(!($result = mysql_query("select * from user where User='$setup[db_user]'"))
      && (list($v) = mysql_fetch_row($result)))
  {
    print "Error: no mysql user created: " . mysql_error() . "\n";
    exit;
  }

  #### create tables
  @mysql_select_db("oasis");
  $sql = '';
  foreach(file('ddl/oasis.ddl') as $line)
  {
    $line = chop($line);

    $sql .= $line;
    if(preg_match('#;#', $line))
    {
      if(!mysql_query($sql))
      {
        print "Error executing SQL: " . mysql_error() . "\nSQL: $sql\n\n";
        #exit;
      }
      $sql = '';
    }
  }

  load_mysql($setup);
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function load_mysql($setup)
{
  @mysql_select_db("oasis");

  #### load prefs
  $server_prefs = array(
               "AdminEmail"   => "webmaster",
               "LogDir"       => "$setup[log_dir]",
               "IdentifyPath" => "$setup[identify_path]",
               "HtmldocPath" => "$setup[htmldoc_path]",
               "CurlPath" => "$setup[curl_path]",
               "GzipPath" => "$setup[gzip_path]",
               "ClickthroughWindow" => "7200",
               "KeepLogsFor" => "14",
               "KeepStatsFor" => "800",
               "InvDaysBack" => "90",
               "InvDaysForward" => "60",
               "InvMethod" => "Average",
               "InvCycle" => "Week",
               "InvScaleFactor" => "0.50",
               "InvWarningThreshold" => 80,
               "ShmSizeHourlyAssignments" => 500000,
               "ShmSizeHourlyTargets" => 50000,
               "ShmSizeCreativeContent" => 4000000,
               "ShmSizeCreativeClickthroughs" => 500000,
               "SlaveServers" => '',
               );

  $per_pub_prefs = array(
               "InvoiceDue"   => "30",
               "InvoiceHeaderString" => "Internet Advertising Invoice",
               "InvoiceHeaderGraphic" => "",
               "InvoiceFooterString" => "",
               "NewCampaignEmail" => "webmaster",
               "ValidateClickthrough" => "Y",
               "ValidateThirdParty" => "Y",
               "ReportFromAddr" => "",
               "InsertActive" => "N",
               "RevenueReportClicks" => "N",
  );

  while(list($k, $v) = each($server_prefs))
  {
    $sql = "insert into OASISPrefs values ('$k', '$v', 'N', 1)";
    if(!mysql_query($sql))
    {
      print "Error setting up server prefs: " . mysql_error() . "\n";
      exit;
    }
  }

  while(list($k, $v) = each($per_pub_prefs))
  {
    $sql = "insert into OASISPrefs values ('$k', '$v', 'Y', 1)";
    if(!mysql_query($sql))
    {
      print "Error setting up per-publisher prefs: " . mysql_error() . "\n";
      exit;
    }
  }

  #### create admin user
  if(!mysql_query("insert into Users values ('$setup[admin_user]', password('$setup[admin_passwd]'), '', '', '', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 1)"))
  {
    print "Error creating admin user: " . mysql_error() . "\n";
    exit;
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function create_directories($setup)
{
  global $stdin;

  $dir_list = array(
               $setup[oasis_root],
               $setup[oasis_root] . 'geotargeting',
               $setup[oasis_root] . 'geotargeting/netacuity',
               $setup[oasis_root] . 'mgmt',
               $setup[oasis_root] . 'mgmt/enterprise',
               $setup[oasis_root] . 'mgmt/graphics',
               $setup[oasis_root] . 'mgmt/docs',
               $setup[oasis_root] . 'mgmt/docs/images',
               $setup[log_dir]);

  foreach($dir_list as $dir)
  {
    if(is_dir($dir))
    {
      print "$dir exists!  Continue installing files? (y/n) ";
      $answer = chop(fgets($stdin, 65536));

      if($answer == 'Y' || $answer == 'y') break;
      else return;
    }
  }

  reset($dir_list);
  foreach($dir_list as $dir)
  {
    if(!@mkdir($dir, 0755) && !is_dir($dir))
    {
      print "error creating $dir: $php_errormsg\n";
      exit;
    }
  }
  
  if(!@chown($setup[log_dir], $setup[web_user]))
  {
    print "error changing ownership of $setup[log_dir] to $setup[web_user]: $php_errormsg\n";
    exit;
  }

  install_files($setup);
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function install_files($setup)
{
  #### get all language-specific files into place
  if(!copy("templates/mgmt/i18n/lib-i18n.$setup[oasis_lang].inc",
           "templates/mgmt/lib-i18n.inc"))
  {
    print "error opening lib-i18n.$setup[oasis_lang].inc: $php_errormsg\n";
    exit;
  }

  #### strip off charset info from language file
  $lang = $setup[oasis_lang];
  preg_match ('#([^.]+\.[^.]+)#', $lang, $matches);
  $lang = $matches[1]; 

  $lang_graphics_dir = "templates/mgmt/graphics/$lang";
  $dh = opendir($lang_graphics_dir);
  while (($file = readdir($dh))!==false)
  {
    if(preg_match('#\.gif$#', $file))
    {
      if(!copy("$lang_graphics_dir/$file", "templates/mgmt/graphics/$file"))
      {
        print "error opening lib-i18n.$setup[oasis_lang].inc: $php_errormsg\n";
        exit;
      }
    }
  }
  closedir($dh);

  $subdirs = array("geotargeting/", "geotargeting/netacuity/",
                   "mgmt/",
                   "mgmt/docs/", "mgmt/docs/images/",
                   "mgmt/enterprise/",
                   "mgmt/graphics/");

  foreach($subdirs as $subdir)
  {
    if (file_exists ("./templates/$subdir")) {
        $dh = opendir("./templates/$subdir");
        while (($file = readdir($dh))!==false)
        {
            if(preg_match('#\.(php|inc|css|gif|html?|pdf)$#', $file))
            {
                print "installing $setup[oasis_root]$subdir$file...\n";
                if(!copy("templates/$subdir$file", "$setup[oasis_root]$subdir$file"))
                {
                    print "error copying to $setup[oasis_root]$subdir$file: $php_errormsg\n";
                exit;
                }
            }
        }
        closedir($dh);
    }
  }

  if(!
    (copy("templates/oasisc.php", "$setup[oasis_root]$setup[oasis_script_c]")
    && copy("templates/oasisi.php", "$setup[oasis_root]$setup[oasis_script_i]")
    && copy("templates/oasisi-e.php", "$setup[oasis_root]$setup[oasis_script_ie]")
    && copy("templates/oasisi-i.php", "$setup[oasis_root]$setup[oasis_script_ii]")
    && copy("templates/oasisi-j.php", "$setup[oasis_root]$setup[oasis_script_ij]"))
    ) {
      print "error installing delivery script: $php_errormsg\n";
      exit;
  }

  $executables = array('check_inventory.php',
                       'hourly_maint.php', 'minutely_maint.php',
                       'enterprise/master_reload.php',
                       'enterprise/master_reload1.php',
                       'enterprise/master_reload2.php',
                       'enterprise/master_reload3.php',
                       );
  foreach($executables as $exe)
  {
    if (file_exists ("{$setup[oasis_root]}mgmt/$exe")) {
        chmod("$setup[oasis_root]mgmt/$exe", 0755);
    }
  }

  #### suck in templates; replace special tags; install in directories
  global $OG_install_vars;
  $search = array ();
  reset ($OG_install_vars);
  foreach ($OG_install_vars as $varname) {
    array_push ($search, '#\[' . $varname . '\]#');
  }

  $replace = array ();
  reset ($OG_install_vars);
  foreach ($OG_install_vars as $varname) {
    array_push ($replace, $setup[$varname]);
  }

  if (!(@$fp = fopen("$setup[oasis_root]/mgmt/lib-envvar.inc", "w"))) {
    print "error opening $setup[oasis_root]/mgmt/lib-envvar.inc for writing: $php_errormsg\n";
    exit;
  }
  $converted = preg_replace($search, $replace, file("lib-envvar.inc"));
  foreach($converted as $line) fputs($fp, $line);
  fclose ($fp);

  if (!(@$fp = fopen("$setup[web_conf_dir]oasis_httpd.conf", "w"))) {
    print "error opening oasis_httpd.conf for writing: $php_errormsg\n";
    exit;
  }
  $converted = preg_replace($search, $replace, file("oasis_httpd.conf.template"));

  foreach($converted as $line) fputs($fp, $line);
  fclose ($fp);
}
?>
