create table Advertisers (
AdvertiserID int(11) primary key auto_increment not null default '0',
Name varchar(128),
URL varchar(255),
ContactName varchar(128),
StreetAddress text,
City varchar(64),
State varchar(64),
PostalCode varchar(32),
Country varchar(64),
Phone varchar(64),
Fax varchar(64),
ContactEmail varchar(255),
Note text,
Login varchar(32),
Password varchar(32),
PublisherID int(11) not null
) Type=MyISAM;

create table Publishers (
PublisherID int(11) primary key auto_increment not null default '0',
PPublisherID int(11) not null default '1',
Name varchar(128) not null,
StreetAddress text,
City varchar(64),
State varchar(64),
PostalCode varchar(32),
Country varchar(64),
Phone varchar(64),
ContactName varchar(128),
ContactEmail varchar(255),
HostingCharge float(10,2) not null default '0.00',
CPMCharge float(10,2) not null default '0.00',
CPMChargePerc float(10,2) not null default '0.00',
CPCCharge float(10,2) not null default '0.00',
CPCChargePerc float(10,2) not null default '0.00',
FixedCharge float(10,2) not null default '0.00',
FixedChargePerc float(10,2) not null default '0.00',
CPM float(10,2) not null default '0.00',
CPMPerc float(10,2) not null default '0.00',
CPC float(10,2) not null default '0.00',
CPCPerc float(10,2) not null default '0.00',
Fixed float(10,2) not null default '0.00',
FixedPerc float(10,2) not null default '0.00',
Status enum('Active','Inactive') not null default 'Active',
RootSectionID smallint not null
) Type=MyISAM;

create table CampaignAssignments (
CampaignID int(11) not null default '0',
SectionID smallint not null default '0',
Type enum('Include','Exclude','Exclusive') not null default 'Include',
key(CampaignID),
key(SectionID)
) Type=MyISAM;

create table Campaigns (
CampaignID int(11) primary key auto_increment not null default '0',
AdvertiserID int(11) not null default '0',
Name varchar(128),
Status enum('Active','Cancelled','Completed','Inactive','Suspended') not null default 'Inactive',
StartDate date not null default '0000-00-00',
EndDate date not null default '0000-00-00',
OverflowOK enum('Y','N') not null default 'Y',
CompanionSharing enum('Y','N') not null default 'N',
ImpressionsGuaranteed int(11) not null default '0',
EvenDelivery enum('Day','Week','Month') default 'Day',
ImpressionsDelivered int(11) not null default '0',
ClicksGuaranteed int(11) not null default '0',
ClicksDelivered int(11) not null default '0',
DaysOfWeek tinyint unsigned default 127,
HoursOfDay mediumint unsigned default 16777215,
Weight int(11) not null default '10',
ImpCap int(11) not null default '0',
ImpCapInterval int(11) not null default '0',
Note text,
CPM float(10,2) not null default '0.00',
CPC float(10,2) not null default '0.00',
Fixed float(10,2) not null default '0.00',
PayFixed enum('By Period','CIA','End of Campaign') not null default 'End of Campaign',
AgencyCommission float(10,2) not null default '0.00',
PurchaseOrder varchar(64),
ForceInvoice enum('Y','N') not null default 'N',
Notify text,
PublisherID int(11) not null,
key(AdvertiserID),
key(Status),
key(StartDate),
key(EndDate)
) Type=MyISAM;

create table CreativeAssignments (
CreativeID int(11) not null default '0',
SectionID smallint not null default '0',
Type enum('Include','Exclude','Exclusive') not null default 'Include',
key(CreativeID),
key(SectionID)
) Type=MyISAM;

create table Creatives (
CreativeID int(11) primary key auto_increment not null default '0',
CampaignID int(11) not null default '0',
Name varchar(64),
Status enum('Active','Cancelled','Completed', 'Suspended') not null default 'Active',
StartDate date not null default '0000-00-00',
EndDate date not null default '0000-00-00',
OverflowOK enum('Y','N') not null default 'Y',
Redirect enum('Y','N') not null default 'N',
MediaType enum('Image','RichMedia') not null default 'Image',
MIMEType varchar(64),
Animated enum('Y','N') not null default 'N',
Width smallint unsigned not null default '0',
Height smallint unsigned not null default '0',
Weight int(11) not null default '10',
Content blob,
AltText varchar(255),
ClickthroughURL varchar(255),
ImpressionsGuaranteed int(11) not null default '0',
ImpressionsDelivered int(11) not null default '0',
ClicksGuaranteed int(11) not null default '0',
ClicksDelivered int(11) not null default '0',
DaysOfWeek tinyint unsigned default 127,
HoursOfDay mediumint unsigned default 16777215,
ImpCap int(11) not null default '0',
ImpCapInterval int(11) not null default '0',
key(CampaignID),
key(Status),
key(Width),
key(Height)
) Type=MyISAM;


create table DeliveryControls (
DeliveryControlID int(11) primary key auto_increment not null default '0',
CampaignID int(11) not null default '0',
CreativeID int(11) not null default '0',
Deliver enum ('deliver', 'deliver_only', 'no_deliver'),
Type char(32),
Sense int(11) not null default '1',
Matches enum ('exact', 'regex', 'wildcard'),
FilterString varchar (255),
key(Type),
key(CreativeID),
key(CampaignID)
) Type=MyISAM;


create table DailyTargets (
CreativeID int(11) not null default '0',
Target int(11) not null default '0',
Weight int(11) not null default '10',
Remaining int(11) not null default '0',
HoursOfDay mediumint unsigned default 16777215,
key(CreativeID)
) Type=MyISAM;

create table HourlyStats (
Day date not null default '0000-00-00',
Hour tinyint(4) not null default '0',
SectionID smallint not null default '0',
CreativeID int(11) not null default '0',
Impressions int(11) not null default '0',
Clicks int(11) not null default '0',
ImpressionErrors int(11) not null default '0',
ClickErrors int(11) not null default '0',
key(Day),
key(Hour),
key(SectionID),
key(CreativeID)
) Type=MyISAM;

create table SectionDailyTraffic (
Day date not null,
SectionID int not null,
Width smallint unsigned not null default '0',
Height smallint unsigned not null default '0',
Impressions int not null,
index(Day),
index(SectionID),
index(Width),
index(Height)
) Type=MyISAM;


create table CampaignDailyStats (
Day date not null,
CampaignID int not null,
PublisherID int not null,
Impressions int not null,
Clicks int not null,
ImpressionErrors int not null,
ClickErrors int not null,
index(Day),
index(CampaignID),
index(PublisherID)
) Type=MyISAM;

create table PublisherInvoices (
InvoiceID int(11) primary key auto_increment not null default '0',
PublisherID int(11) not null default '0',
InvoiceNumber char(64) not null default '',
FromDate date,
ToDate date,
InvoiceDate date,
DueDate date,
ImpressionsDeliveredCredit int(11),
ClicksDeliveredCredit int(11),
ImpressionsDelivered int(11),
ClicksDelivered int(11),
CPMCredit float(10,2),
CPCCredit float(10,2),
FixedCredit float(10,2),
CPMCharge float(10,2),
CPCCharge float(10,2),
FixedCharge float(10,2),
HostingCharge float(10,2),
Sent enum('Y','N') not null default 'N',
Paid enum('Y','N') not null default 'N',
key(PublisherID),
unique(InvoiceNumber)
) Type=MyISAM;


create table Invoices (
InvoiceID int(11) primary key auto_increment not null default '0',
CampaignID int(11) not null default '0',
InvoiceNumber char(64) not null default '',
FromDate date,
ToDate date,
InvoiceDate date,
DueDate date,
ImpressionsDelivered int(11),
ClicksDelivered int(11),
CPM float(10,2),
CPC float(10,2),
Fixed float(10,2),
AgencyCommission float(10,2),
CPMCharge float(10,2),
CPCCharge float(10,2),
AgencyCommissionCharge float(10,2),
PurchaseOrder char(64),
Sent enum('Y','N') not null default 'N',
Paid enum('Y','N') not null default 'N',
FixedCharge float(10,2),
key(CampaignID),
unique(InvoiceNumber)
) Type=MyISAM;

create table MaxSizes (
Width smallint unsigned not null default '0',
Height smallint unsigned not null default '0',
Size int(11),
Name char(64),
key(Width),
key(Height)
) Type=MyISAM;

create table OASISPrefs (
PrefKey varchar(32) not null default '',
PrefValue text,
PerPublisher enum('Y','N') not null default 'N',
PublisherID int(11) not null default '0',
key(PrefKey),
key(PerPublisher),
key(PublisherID)
) Type=MyISAM;

create table Sections (
SectionID smallint primary key auto_increment not null default '0',
PSectionID smallint not null default '0',
Name char(64),
ReportName char(64),
Active enum('Y','N') not null default 'Y',
PublisherID int(11) not null,
key(PSectionID),
key(PublisherID)
) Type=MyISAM;


CREATE TABLE CompanionGroups (
CompanionGroupID int(11) primary key auto_increment not null default '0'
) Type=MyISAM;


CREATE TABLE CompanionSections (
CompanionGroupID int(11) NOT NULL DEFAULT '0',
SectionID int(11) NOT NULL DEFAULT '0',
key(CompanionGroupID),
key(SectionID)
) Type=MyISAM;


create table TrafficProfile (
Hour int(11) primary key not null default '0',
Pageviews int(11)
) Type=MyISAM;

create table Users (
Login char(32) primary key not null default '',
Password char(32),
FirstName char(64),
LastName char(64),
EmailAddress char(255),
Campaigns enum('Y','N') not null default 'N',
Advertisers enum('Y','N') not null default 'N',
Sections enum('Y','N') not null default 'N',
Reports enum('Y','N') not null default 'Y',
Admin enum('Y','N') not null default 'N',
CampaignInsertion enum('Y','N') not null default 'Y',
Invoicing enum('Y','N') not null default 'N',
LimitedCampaigns enum('Y','N') not null default 'N',
PublisherID int(11) not null
) Type=MyISAM;

create table Delivery (
IDString char(36) not null primary key, 
CreativeID integer not null, 
LastSeen timestamp
) type=heap;


create table SimSectionDailyTraffic (
Day date not null,
SectionID int not null,
Width smallint unsigned not null default '0',
Height smallint unsigned not null default '0',
Impressions int not null,
Allocated int not null,
index(Day),
index(SectionID),
index(Width),
index(Height)
) Type=MyISAM;


create table SimDailyTargets (
CreativeID int(11) not null default '0',
Target int(11) not null default '0',
Weight int(11) not null default '10',
Remaining int(11) not null default '0',
HoursOfDay mediumint unsigned default 16777215,
key(CreativeID)
) Type=MyISAM;


create table SimCampaigns (
CampaignID int(11) primary key not null default '0',
Name varchar(128),
Status enum('Active','Cancelled','Completed','Inactive') not null default 'Inactive',
StartDate date not null default '0000-00-00',
EndDate date not null default '0000-00-00',
ImpressionsGuaranteed int(11) not null default '0',
EvenDelivery enum('Day','Week','Month') default 'Day',
ImpressionsDelivered int(11) not null default '0',
DaysOfWeek tinyint unsigned default 127,
HoursOfDay mediumint unsigned default 16777215,
Weight int(11) not null default '10',
key(Status),
key(StartDate),
key(EndDate)
) Type=MyISAM;


create table SimCreatives (
CreativeID int(11) primary key not null default '0',
CampaignID int(11) not null default '0',
Name varchar(64),
Status enum('Active','Cancelled','Completed') not null default 'Active',
StartDate datetime not null default '0000-00-00 00:00:00',
EndDate datetime not null default '0000-00-00 00:00:00',
Width smallint unsigned not null default '0',
Height smallint unsigned not null default '0',
Weight int(11) not null default '10',
ImpressionsGuaranteed int(11) not null default '0',
ImpressionsDelivered int(11) not null default '0',
DaysOfWeek tinyint unsigned default 127,
HoursOfDay mediumint unsigned default 16777215,
key(CampaignID),
key(Status),
key(Width),
key(Height)
) Type=MyISAM;


create table RunningCreatives (
CreativeID int(11) not null default '0',
Hour tinyint(4) not null default '0',
index(Hour),
unique(CreativeID, Hour)
) Type=MyISAM;


create table CampaignAccess (
CampaignID int(11) not null default '0',
Login char(32) not null default '',
index(CampaignID),
index(Login)
) Type=MyISAM;


insert into MaxSizes values (468, 60, 18000, "IAB - Banner, Full");
insert into MaxSizes values (234, 60, 9000, "IAB - Banner, Half");
insert into MaxSizes values (120, 90, 7000, "IAB - Button 1");
insert into MaxSizes values (120, 60, 4600, "IAB - Button 2");
insert into MaxSizes values (120, 240, 18500, "IAB - Banner, Vertical");
insert into MaxSizes values (125, 125, 10000, "IAB - Button, Square");
insert into MaxSizes values (88, 31, 2000, "IAB - Bar, Micro");
insert into MaxSizes values (160, 600, 35000, "IAB - Skyscraper, Wide");
insert into MaxSizes values (120, 600, 27500, "IAB - Skyscraper");
insert into MaxSizes values (300, 250, 45000, "IAB - Rectangle, Medium");
insert into MaxSizes values (250, 250, 37500, "IAB - Pop-up, Square");
insert into MaxSizes values (240, 400, 50000, "IAB - Rectangle, Vertical");
insert into MaxSizes values (336, 280, 50000, "IAB - Rectangle, Large");
insert into MaxSizes values (180, 150, 18000, "IAB - Rectangle");

insert into TrafficProfile values (0, 100);
insert into TrafficProfile values (1, 100);
insert into TrafficProfile values (2, 100);
insert into TrafficProfile values (3, 100);
insert into TrafficProfile values (4, 100);
insert into TrafficProfile values (5, 100);
insert into TrafficProfile values (6, 100);
insert into TrafficProfile values (7, 100);
insert into TrafficProfile values (8, 100);
insert into TrafficProfile values (9, 100);
insert into TrafficProfile values (10, 100);
insert into TrafficProfile values (11, 100);
insert into TrafficProfile values (12, 100);
insert into TrafficProfile values (13, 100);
insert into TrafficProfile values (14, 100);
insert into TrafficProfile values (15, 100);
insert into TrafficProfile values (16, 100);
insert into TrafficProfile values (17, 100);
insert into TrafficProfile values (18, 100);
insert into TrafficProfile values (19, 100);
insert into TrafficProfile values (20, 100);
insert into TrafficProfile values (21, 100);
insert into TrafficProfile values (22, 100);
insert into TrafficProfile values (23, 100);

insert into Sections (PSectionID, Name, ReportName, Active, PublisherID)
values (0, 'OASIS Server', 'OASIS Server', 'Y', 1);

insert into Publishers (PPublisherID, Name, Status, RootSectionID)
values (0, 'OASIS Owner', 'Active', 1);

insert into Advertisers (Name, URL, Note, PublisherID) values
('OASIS Professional Services', 'http://www.oasispros.com/', 'This is a sample advertiser.  It is created at install time to run the default campaign.  Feel free to delete it and its campaigns.', 1);

insert into Campaigns (AdvertiserID, Name, Status, Note, PublisherID)
values
(1, 'OASIS Default', 'Active',
'This is a sample campaign.  It is created at install time.  Feel free to delete it, but make sure that you have a default campaign set with no impressions specified so that you will always have something to run when you reach impression goals.', 1);

insert into Creatives (CampaignID, Name, Status, Redirect, MediaType,
MIMEType, Width, Height, Content, ClickthroughURL, AltText)
values
(1, 'OASIS Default 1', 'Active', 'Y', 'Image', 'image/gif', 468, 60, 'http://oasis.sourceforge.net/oasis_banner.gif', 'http://www.oasispros.com/', 'OASIS: industrial-strength ad serving, open source comfort');

insert into CampaignAssignments values (1, 1, 'Include');
