#### this upgrades from 1.2.0 open source to 1.2.0 Professional

CREATE TABLE Publishers (
PublisherID int(11) primary key auto_increment not null default '0',
PPublisherID int(11) not null default '1',
Name varchar(128) not null,
StreetAddress text,
City varchar(64),
State varchar(64),
PostalCode varchar(32),
Country varchar(64),
Phone varchar(64),
ContactName varchar(128),
ContactEmail varchar(255),
HostingCharge float(10,2) not null default '0.00',
CPMCharge float(10,2) not null default '0.00',
CPMChargePerc float(10,2) not null default '0.00',
CPCCharge float(10,2) not null default '0.00',
CPCChargePerc float(10,2) not null default '0.00',
FixedCharge float(10,2) not null default '0.00',
FixedChargePerc float(10,2) not null default '0.00',
CPM float(10,2) not null default '0.00',
CPMPerc float(10,2) not null default '0.00',
CPC float(10,2) not null default '0.00',
CPCPerc float(10,2) not null default '0.00',
Fixed float(10,2) not null default '0.00',
FixedPerc float(10,2) not null default '0.00',
Status enum('Active','Inactive') not null default 'Active',
RootSectionID smallint not null
) Type=MyISAM;

ALTER TABLE Advertisers ADD COLUMN PublisherID int(11) not null;

ALTER TABLE Sections ADD COLUMN PublisherID int(11) not null;
ALTER TABLE Sections ADD INDEX (PublisherID);

ALTER TABLE Users ADD COLUMN PublisherID int(11) not null;

ALTER TABLE Campaigns ADD COLUMN PublisherID int(11) not null;
ALTER TABLE Campaigns ADD COLUMN ImpCap int(11) NOT NULL DEFAULT '0';
ALTER TABLE Campaigns ADD COLUMN ImpCapInterval int(11) NOT NULL DEFAULT '0';
ALTER TABLE Campaigns ADD COLUMN CompanionSharing ENUM ('Y', 'N') NOT NULL DEFAULT 'N';

ALTER TABLE Creatives ADD COLUMN ImpCap int(11) NOT NULL DEFAULT '0';
ALTER TABLE Creatives ADD COLUMN ImpCapInterval int(11) NOT NULL DEFAULT '0';

ALTER TABLE OASISPrefs ADD COLUMN PerPublisher enum('Y', 'N') NOT NULL DEFAULT 'N';
ALTER TABLE OASISPrefs ADD COLUMN PublisherID int(11) not null;
ALTER TABLE OASISPrefs DROP PRIMARY KEY;
ALTER TABLE OASISPrefs ADD INDEX (PerPublisher);
ALTER TABLE OASISPrefs ADD INDEX (PublisherID);
UPDATE OASISPrefs SET PublisherID=1;
UPDATE OASISPrefs SET PerPublisher='Y' WHERE PrefKey IN
('InvoiceDue', 'InvoiceHeaderString', 'InvoiceHeaderGraphic',
'InvoiceFooterString', 'NewCampaignEmail', 'ValidateClickthrough',
'ValidateThirdParty', 'ReportFromAddr', 'InsertActive', 'RevenueReportClicks');


CREATE TABLE CompanionGroups ( 
CompanionGroupID int(11) primary key auto_increment not null default '0'
) Type=MyISAM;

CREATE TABLE CompanionSections ( 
CompanionGroupID smallint NOT NULL DEFAULT '0',
SectionID smallint NOT NULL DEFAULT '0',
key(CompanionGroupID),
key(SectionID)
) Type=MyISAM;

INSERT INTO Publishers (PPublisherID, Name, Status, RootSectionID)
VALUES (0, 'OASIS Owner', 'Active', 1);

UPDATE Users SET PublisherID=1;
UPDATE Campaigns SET PublisherID=1;
UPDATE Sections SET PublisherID=1;
UPDATE Advertisers SET PublisherID=1;

create table PublisherInvoices (
InvoiceID int(11) primary key auto_increment not null default '0',
PublisherID int(11) not null default '0',
InvoiceNumber char(64) not null default '',
FromDate date,
ToDate date,
InvoiceDate date,
DueDate date,
ImpressionsDeliveredCredit int(11),
ClicksDeliveredCredit int(11),
ImpressionsDelivered int(11),
ClicksDelivered int(11),
CPMCredit float(10,2),
CPCCredit float(10,2),
FixedCredit float(10,2),
CPMCharge float(10,2),
CPCCharge float(10,2),
FixedCharge float(10,2),
HostingCharge float(10,2),
Sent enum('Y','N') not null default 'N',
Paid enum('Y','N') not null default 'N',
key(PublisherID),
unique(InvoiceNumber)
) Type=MyISAM;


ALTER TABLE CampaignDailyStats ADD COLUMN PublisherID int(11) not null;
ALTER TABLE CampaignDailyStats ADD INDEX (PublisherID);
UPDATE CampaignDailyStats SET PublisherID=1;
