#!/usr/local/bin/php -q
<?
/*
** Easy Oasis configuration file generator
** (C) 2001 Marcin Orlowski <carlos@amiga.com.pl>
**
** Released under GPL. No warranty blah, blah...
**
** 2001.09.27 - 1.0 - initial release
** 2001.09.28 - 1.1 - fixed template file
**
*/


$config_file     = "oasis.cfg";
$config_template = "makeconfig.template";


$fields = array(
	array( "S", "DB_USER", "oasis", "Specify DB user name for Oasis to use" ),
	array( "S", "DB_PASSWD", "SetOwnPasswordOrBeHACKED", "Specify DB password" ),
	array( "P", "IDENTIFY_PATH", "/usr/bin/identify", "Path to ImageMagick's identify tool; mandatory" ),
	array( "P", "CURL_PATH", "/usr/local/bin/curl", "Path to the executable for curl; mandatory" ),
	array( "P", "GZIP_PATH", "/usr/bin/gzip", "Path to gzip command; mandatory" ),
	array( "S", "WEB_USER", "nobody", "The user as which your Web server runs" ),
	array( "P", "HTMLDOC_PATH", "/usr/local/bin/htmldoc", "Path to htmldoc version 1.8.8 or greater; not necessary but useful" ),
	array( "S", "ADMIN_USER", "admin", "The login for the first administrative user of OASIS" ),
	array( "S", "ADMIN_PASSWD", "SetOwnPasswordOrBeHACKED", "The password for the first administrative user of OASIS" ),
	array( "S", "LOG_DIR", "/var/log/oasis", "Directory in which OASIS should log" ),
	array( "S", "OASIS_ROOT", "/usr/local/apache/htdocs/", "Root directory for the OASIS scripts (should be under your Web server's document root)\nMUST HAVE have a trailing slash (/)!" ),
	array( "S", "OASIS_URL", "/", "URL for the directory in which the OASIS delivery scripts will live,\nrelative to OASIS_ROOT;  MUST HAVE a trailing slash ('/')\nNOTE: if you are putting the scripts right in OASIS_ROOT, this should be '/' (slash)" ),
	array( "S", "OASIS_DOMAIN", "yourdomain.com", "domain for the server running OASIS" ),
	array( "S", "OASIS_HOST", "oasis.yourdomain.com", "hostname for the server running OASIS" ),
	array( "S", "OASIS_PORT", "80", "port on which OASIS runs" ),
	array( "S", "OASIS_LANG", "us.en", "language -- currently supported languages include: 'us.en', 'fr.fr'" )
	);





define( "MODE", 0 );
define( "KEY", 1 );
define( "VALUE", 2 );
define( "INFO", 3 );



function Abort()
{
	echo "\n*** Script terminated\n";
	exit();
}
function WaitEnter( $prompt="Press ENTER to continue..." )
{
	echo $prompt;
	GetInput();
}


function GetYN( $prompt="Do you want to proceed [y/N]: " )
{
	echo $prompt;
	return( (strtolower(GetInput()) == 'y' ) ? TRUE : FALSE );
}


function GetInput()
{
	if( $fh = fopen( "php://stdin", "rb" ) )
		{
		$result = chop( fgets( $fh, 4096 ) );
		fclose( $fh );
		}
	else
		{
		echo "\n*** FATAL ERROR: Can't open STDIN for reading!\n";
		Abort();
		}

	return( $result );
}

function GetAnswer( &$array )
{
		$result = GetInput();
		if( $result == "" )
			$result = $array[VALUE];

		$array[VALUE] = $result;
}

// GetString
function S( &$array )
{
	printf("\n%s\n%s [%s]: ", $array[INFO], $array[KEY], $array[VALUE] );
	GetAnswer( $array );
}

// GetPath
function P( &$array )
{
	$info = "Default path is valid for your system. Just press ENTER.";
	if( !(file_exists( $array[VALUE] )) )
		{
		// no file there. Let's adjust the defaults then...
		$new_path = exec( sprintf( "which %s", basename( $array[VALUE] ) ) );
		if( $new_path != "" )
			$array[VALUE] = $new_path;
		else
			{
			$info = sprintf( "PROBLEM! Failed to locate %s! Seems it's not installed", 
					 basename( $array[VALUE] )
					 );
			}
		}
	printf("\n%s\n%s\n%s [%s]: ", $array[INFO], $info, $array[KEY], $array[VALUE] );
	GetAnswer( $array );
}

// the code begins... 

$fields = array(
	array( "S", "DB_USER", "oasis", "Specify DB user name for Oasis to use" ),
	array( "S", "DB_PASSWD", "SetOwnPasswordOrBeHACKED", "Specify DB password" ),
	array( "P", "IDENTIFY_PATH", "/usr/bin/identify", "Path to ImageMagick's identify tool; mandatory" ),
	array( "P", "CURL_PATH", "/usr/local/bin/curl", "Path to the executable for curl; mandatory" ),
	array( "P", "GZIP_PATH", "/usr/bin/gzip", "Path to gzip command; mandatory" ),
	array( "S", "WEB_USER", "nobody", "The user as which your Web server runs" ),
	array( "P", "HTMLDOC_PATH", "/usr/local/bin/htmldoc", "Path to htmldoc version 1.8.8 or greater; not necessary but useful" ),
	array( "S", "ADMIN_USER", "admin", "The login for the first administrative user of OASIS" ),
	array( "S", "ADMIN_PASSWD", "SetOwnPasswordOrBeHACKED", "The password for the first administrative user of OASIS" ),
	array( "S", "LOG_DIR", "/var/log/oasis", "Directory in which OASIS should log" ),
	array( "S", "OASIS_ROOT", "/usr/local/apache/htdocs/", "Root directory for the OASIS scripts (should be under your Web server's document root)\nMUST HAVE have a trailing slash (/)!" ),
	array( "S", "OASIS_URL", "/", "URL for the directory in which the OASIS delivery scripts will live,\nrelative to OASIS_ROOT;  MUST HAVE a trailing slash ('/')\nNOTE: if you are putting the scripts right in OASIS_ROOT, this should be '/' (slash)" ),
   array( "S", "OASIS_DOMAIN", "yourdomain.com", "domain for the server running OASIS" ),
   array( "S", "OASIS_HOST", "oasis.yourdomain.com", "hostname for the server running OASIS" ),
   array( "S", "OASIS_PORT", "80", "port on which OASIS runs" ),
   array( "S", "OASIS_LANG", "us.en", "language -- currently supported languages include: 'us.en', 'fr.fr'" )
   );


//
	echo "
Welcome to OASIS-FOR-DUMMIES setup ;-)
----------------------------------------

Keep answering my questions and I make a nice '$config_file' for you.
Values in [square brackets] are default one. If you give no answer
and just press ENTER, this value will be used. For most cases, default
values are valid and it's strongly advised to not change the defaults
(except for passwords and web server related questions).

I'll check the availability of external programs Oasis requires,
and you will be noticed if I fail to find any. Otherwise I'll try
to determine a valid path to them, so you shall accept defaults.

At any time you can abort by pressing CTRL-C. Before I output the
config file, I'll ask you for a confirmaiton. Enjoy.

";

	WaitEnter();

	if( !(file_exists( $config_template ) ) )
		{
		echo "\n*** FATAL ERROR: Can't find config template file ($config_template)\n";
		Abort();
		}

	if( file_exists( $config_file ) )
		{
		echo "\n";
		echo "*********************************************\n";
		echo "Config file '$config_file' already exists!\n";
		echo "It will be OVERWRITTEN by newly created config file\n";
		echo "Choose [N]o to abort, and [Y]es to continue\n";
		echo "*********************************************\n";
		if( !GetYN() )
			Abort();
		}
	
	while( list( $arr ) = each( $fields ) )
		$fields[$arr][0]( $fields[$arr] );


	echo "

====
Ok, I got no more questions your runner...

I'd like to write '$config_file'...
";

	if( GetYN() )
		{
		echo "  Reading template: $config_template...\n";
		$template = file( $config_template ); 
		if( $fh = fopen( $config_template, "rb") )
			{
			$template = fread( $fh, filesize( $config_template ) );
			fclose( $fh );

			echo "  Processing config template...\n";
			reset( $fields );
			while( list( $arr ) = each ( $fields ) )
				{
				$template = str_replace( sprintf( "#%s#", $fields[$arr][KEY] ),
										$fields[$arr][VALUE], $template );
				}

			echo "  Writting $config_file...\n";

			if( $fh = fopen( $config_file, "wb" ) )
				{
				fwrite( $fh, $template );
				fclose( $fh );
				echo "Done. $config_file created sucessfuly.\n\n";
				}
			else
				{
				echo "\n*** FATAL ERROR: Can't open '$config_file' for writting.\n";
				Abort();
				}
			}
		else
			{
			echo "\n*** FATAL ERROR: Can't open '$config_template' for reading.\n";
			Abort();
			}
		}

?>
