<?php
# Ciao EmailList Manager - a customizable mass e-mail program that is administrator/subscriber friendly.
# Copyright (C) 2000,2001 Benjamin Drushell
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful.
# There is NO WARRANTY.  NO implied warranty of MERCHANTABILITY.
# NO implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
# The entire risk is with you. 
# See the GNU General Public License for more details.
#
# A copy of the GNU General Public License is included with this program.
#
# For questions regarding the Ciao EmailList Manager license, 
# contact Ben Drushell: http://www.technobreeze.com/
#---------------------------------------------------------
# FILE: ciaoadm.php4
# LOCAL VERSION: alpha 0.05
# CREATED ON: 10/30/2000
# CREATED BY: Ben Drushell - http://www.technobreeze.com/
# CONTRIBUTORS:
# 2001.01.20 - BD - added variable $DB-size to VARS
# 2001.01.30 - BD - added line of code suggested by Tom Sokolis for use with "magic_quotes" settings
# 2001.01.31 - BD - added extra "magic_quotes" detection
# 2001.03.14 - BD - modified "magic_quotes" detection by using get method 3.0.6
# 2001.06.13 - BD - added db update for verison 0.90
# 2001.06.20 - BD - compensation for PHP4.0.5 magic_quotes_runtime detection bug
#
# 2001.07.01 - BD - enhanced magic_quotes_runtime fix
# 2001.07.05 - BD - added db update for version 0.98
#---------------------------------------------------------
?>

<?
$x; $DB; $PW; $T; $CFG;
$VARS = array();
$VARS['DB_magic_quotes_gpc'] = get_magic_quotes_gpc();

if(floor(phpversion()) <= 3)
{ # PHP3 - use get_magic_quotes_runtime function
    $runtime_handle = "\$VARS['DB_magic_quotes_runtime'] = get_magic_quotes_runtime();";
}
else
{ # PHP4 - avoid buggy get_magic_quotes_runtime function
  # PHP4 - turn off magic_quotes_runtime using ini_set
    $runtime_handle = "\$VARS['DB_magic_quotes_runtime'] = 0;\n";
    $runtime_handle .= "ini_set(\"magic_quotes_runtime\",0);";
}
eval($runtime_handle);

if($VARS['DB_magic_quotes_gpc'])
{
    if($HTTP_POST_FILES['importfile']['tmp_name'] != '')
    {# USED WITH IMPORT FEATURE FOR PHP4 AND GREATER
        $VARS['importfile'] = $HTTP_POST_FILES['importfile']['tmp_name'];
        $VARS['importfile_name'] = $HTTP_POST_FILES['importfile']['name'];
        $VARS['importfile_type'] = $HTTP_POST_FILES['importfile']['type'];
        $VARS['importfile_size'] = $HTTP_POST_FILES['importfile']['size'];
    }
    if($importfile != '')
    {# USED WITH IMPORT FEATURE FOR LESS THAN PHP4
        $VARS['importfile'] = $importfile;
        $VARS['importfile_name'] = $importfile_name;
        $VARS['importfile_type'] = $importfile_type;
        $VARS['importfile_size'] = $importfile_size;
    }
}

if(! file_exists("gpl.txt"))
{ die(""); }

# create instance of screen template module
include("ciao_t.php4");
$T = new Template;

if(! file_exists("ciaocredits.html"))
{ die(""); }

if (file_exists('ciao_db.php4'))
{# if database/tables and module have been created
# first create instance of db module
    include("ciao_db.php4");
    $DB = new DBmod;
# then open connection to database
    $VARS['DB'] = mysql_connect($T->CiaoDecode($DB->server),$T->CiaoDecode($DB->userid),$T->CiaoDecode($DB->password));
    $VARS['DB_TablePrefix'] = $T->CiaoDecode($DB->tableprefix);
    $VARS['DB_Size'] = $DB->size;
    $VARS['DB_magic_quotes_sybase'] = $DB->magic_quotes_sybase;
    mysql_select_db($T->CiaoDecode($DB->name),$VARS['DB']);

# read in variables
    if($VARS['DB_magic_quotes_gpc'] && $VARS['DB_magic_quotes_sybase'])
    {
        if(gettype($HTTP_POST_VARS) == 'array')
        {
            while(list($key,$value) = each($HTTP_POST_VARS))
            { $VARS[$key] = stripslashes(ereg_replace("''","'",$value)); }
        }
        if(gettype($HTTP_GET_VARS) == 'array')
        {
            while(list($key,$value) = each($HTTP_GET_VARS))
            { $VARS[$key] = stripslashes(ereg_replace("''","'",$value)); }
        }
    }
    elseif($VARS['DB_magic_quotes_gpc'])
    {
        if(gettype($HTTP_POST_VARS) == 'array')
        {
            while(list($key,$value) = each($HTTP_POST_VARS))
            { $VARS[$key] = stripslashes($value); }
        }
        if(gettype($HTTP_GET_VARS) == 'array')
        {
            while(list($key,$value) = each($HTTP_GET_VARS))
            { $VARS[$key] = stripslashes($value); }
        }
    }
    else
    {
        if(gettype($HTTP_POST_VARS) == 'array')
        {
            while(list($key,$value) = each($HTTP_POST_VARS))
            { $VARS[$key] = $value; }
        }
        if(gettype($HTTP_GET_VARS) == 'array')
        {
            while(list($key,$value) = each($HTTP_GET_VARS))
            { $VARS[$key] = $value; }
        }
    }

# create instance of password module
    include("ciao_p.php4");
    $PW = new PWmod;
    $PW->Verify($VARS,$T);
    if(file_exists('ciao_cfg.php4'))
    {# create instance of list configuration module
        include("ciao_cfg.php4");
        $CFG = new CFGmod;
    }

    if($x == "")
    { $x = "w"; }
    elseif((! $VARS['s']) && (substr($x,0,1) == 's'))
    { $x = "w"; }

# create instance of update module
    include("ciao_update.php4");
    $fix = new update;

    if($VARS['DB'] && (! file_exists("ciao_0_65.txt")))
    { $fix->update_0_65($VARS,$CFG,$T); }
    if($VARS['DB'] && (! file_exists("ciao_0_90.txt")))
    { $fix->update_0_90($VARS,$CFG,$T); }
    if($VARS['DB'] && (! file_exists("ciao_0_98.txt")))
    { $fix->update_0_98($VARS,$CFG,$T); }
}
else # create database/tables and module
{
    if(gettype($HTTP_POST_VARS) == 'array')
    {
        while(list($key,$value) = each($HTTP_POST_VARS))
        { $VARS[$key] = $value; }
    }
    if(gettype($HTTP_GET_VARS) == 'array')
    {
        while(list($key,$value) = each($HTTP_GET_VARS))
        { $VARS[$key] = $value; }
    }

    $x = "s00";
}

# create instance of dynamic worker module and run it
require("ciao_" . $x . ".php4");
$ciaomod = new module($VARS,$CFG,$T);

if($VARS['DB'])
{ mysql_close($VARS['DB']); }
?>
