<?php
# Ciao EmailList Manager - a customizable mass e-mail program that is administrator/subscriber friendly.
# Copyright (C) 2000,2001 Benjamin Drushell
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful.
# There is NO WARRANTY.  NO implied warranty of MERCHANTABILITY.
# NO implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
# The entire risk is with you.
# See the GNU General Public License for more details.
#
# A copy of the GNU General Public License is included with this program.
#
# For questions regarding the Ciao EmailList Manager license, 
# contact Ben Drushell: http://www.technobreeze.com/
#---------------------------------------------------------
# FILE: ciao_s08.php4
# LOCAL VERSION: alpha 0.03
# CREATED ON: 2001.06.14
# CREATED BY: Ben Drushell - http://www.technobreeze.com/
# CONTRIBUTORS:
#(date - name - brief description of enhancement)
#
# 2001.06.16 - BD - Fixed SQL statement "GROUP BY" clause adversly affecting custom categories
# 2001.07.05 - BD - Added code for "ALL" category.
#---------------------------------------------------------
?>

<?php
# SHORT DESCRIPTION
# This module handles export of subscribers.
#---------------------------------------------------------
?>

<?
class module
{
    var $BATCH = 1000;
    var $TRANS = array("lk"=>"LIKE", "nl"=>"NOT LIKE", "eq"=>"=", "ne"=>"!=", "lt"=>"<", "gt"=>">", "le"=>"<=", "ge"=>">=");
    var $SORT = 3;

    function module($VARS,$CFG,$T)
    {
        if($VARS['f_process'] == '')
        {
            $T->head($VARS);
            echo "<h2 align=\"center\"><font color=\"" . $T->body_title . "\">E-MAIL LIST EXPORT</font></h2>";
            $this->HTML_FORM($VARS,$CFG,$T);
            $T->tail($VARS);
        }
        else
        {
            if($VARS['f_btnEXPORT'] != '')
            {
                $T->head($VARS);
                echo "<h2 align=\"center\"><font color=\"" . $T->body_title . "\">EXPORT</font></h2>";
                $this->START_EXPORT($VARS,$CFG,$T);
                $this->HTML_FORM($VARS,$CFG,$T);
                $T->tail($VARS);
            }
            elseif($VARS['frame_EXPORT'] != '')
            { $this->HTML_EXPORT($VARS,$CFG,$T); }
            else
            { $this->HTML_FRAMES($VARS,$CFG,$T); }
        }
    }

    function HTML_FORM($VARS,$CFG,$T)
    {
?>

<center>
<table border="0" width="70%" align="center"><tr><td>
This export utility facilitates those wanting to sync Ciao EmailList Manager
information with other databases.  Be sure that PHP has write access to the
directory the export file will be written to.
</td></tr></table>
</center>

<form name="client" method="post">

<input type="hidden" name="u" value="<?echo $VARS['u'] ?>">
<input type="hidden" name="p" value="<?echo $VARS['p'] ?>">
<input type="hidden" name="x" value="<?echo $VARS['x'] ?>">
<input type="hidden" name="o" value="<?echo (1 * $VARS['o']) ?>">
<input type="hidden" name="f_process" value="1">

<center>
<table border="1" bgcolor="<?echo $T->table_bgcolor ?>" align="center">
<tr><td align="center">

<table border="0" align="center">
<tr>
<td align="left">
<select size="1" name="first">
<option value="0">Do Not Use
<option value="email">Email Address
<option value="date">Date
<?
        for($i = 1; $i <= $CFG->optSize; $i++)
        { echo "\n<option value=\"$i\">" . $CFG->optName[$i]; }
?>
</select>
</td>
<td>
<select size="1" name="second">
<option value="0">Do Not Use
<option value="email">Email Address
<option value="date">Date
<?
        for($i = 1; $i <= $CFG->optSize; $i++)
        { echo "\n<option value=\"$i\">" . $CFG->optName[$i]; }
?>
</select>
</td>
<?
        for($i = 1; $i <= $CFG->optSize; $i++)
        {
?>
<td>
<select size="1" name="<?echo "opt" . $i ?>">
<option value="0">Do Not Use
<option value="email">Email Address
<option value="date">Date
<?
            for($j = 1; $j <= $CFG->optSize; $j++)
            { echo "\n<option value=\"$j\">" . $CFG->optName[$j]; }
?>
</select>
</td>
<?
        }
?>
</td></tr>
</table>

</td></tr>
<tr><td align="left"><font color="<?echo $T->table_Text ?>">
Sort by:
<?
        for($i=1;$i <= $this->SORT;$i++)
        {
?>
<select name="f_sortby<?echo $i ?>">
<option value="0">Do Not Sort
<option value="email">Email Address
<option value="date">Date
<?
            for($j = 1; $j <= $CFG->optSize; $j++)
            { echo "\n<option value=\"$j\">" . $CFG->optName[$j]; }
?>
</select>
<?
        }
?>
</font></td></tr>
<tr><td align="left">
<font color="<?echo $T->table_Text ?>">
Category:
<select name="f_category">
 <option value="General">All Subscribers
<?
        $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_category;";
        $results = mysql_query($query,$VARS['DB']);
        while($row = mysql_fetch_array($results,1))
        {
            if($row['cat_id'] != "ALL")
            { echo "\n <option value=\"" . $row['cat_id'] . "\">(" . $row['cat_id'] . ") " . $row['cat_name']; }
        }
        $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_sql;";
        $results = mysql_query($query,$VARS['DB']);
        while($row = mysql_fetch_array($results,1))
        { echo "\n <option value=\"custom_" . $row['sql_id'] . "\">(" . $row['sql_id'] . ") " . $row['sql_name']; }
?>
</select>
</font></td></tr>
<tr><td align="left">
<font color="<?echo $T->table_Text ?>">
Search Field
<select name="f_searchfield">
 <option value="0" SELECTED>NO SEARCH
 <option value="email">Email Address
 <option value="date">Signup Date
<?
        $i = 1;
        while($i <= $CFG->optSize)
        {
            if($CFG->optReq[$i] != 'n')
            {
?>
 <option value="<?echo $i ?>">
<?
                echo $CFG->optName[$i] . "\n";
            }
            $i = $i + 1;
        }
?>
</select>

<select name="f_searchby">
 <option value="lk">LIKE
 <option value="nl">NOT LIKE
 <option value="eq">EQUAL TO
 <option value="ne">NOT EQUAL TO
 <option value="gt">GREATER THAN
 <option value="lt">LESS THAN
 <option value="ge">&gt;=
 <option value="le">&lt;=
</select>

<input name="f_searchvalue" type="text">

</font></td></tr>
<tr><td align="left">
<font color="<?echo $T->table_Text ?>">
Delimiter (text used to seperate information)
<input type="text" name="delimiter" value=",">
</font></td></tr>
<tr><td align="left">
<font color="<?echo $T->table_Text ?>">
File Name/Location (PHP needs write access to this)
<input type="text" name="exportfile" value="listexport.dat">
</font></td></tr>
<tr><td align="left">
<input type="submit" name="f_btnEXPORT" value="Export File">
</td></tr>
</table>
</form>

<?
    }

    function START_EXPORT($VARS,$CFG,$T)
    {
        if($fw = fopen($VARS['exportfile'],"w"))
        {
            fwrite($fw,"");
            fclose($fw);

            $link = "ciaoadm.php4?u=" . urlencode($VARS['u']) . "&p=" . urlencode($VARS['p']) . "&x=s08&f_process=1";
            $link .= "&delimiter=" . urlencode($VARS['delimiter']) . "&exportfile=" . urlencode($VARS['exportfile']);
            if(strlen($VARS['first']) > 0)
            { $link .= "&first=" . urlencode($VARS['first']); }
            if(strlen($VARS['second']) > 0)
            { $link .= "&second=" . urlencode($VARS['second']); }
            for($i=1;$i <= $CFG->optSize; $i++)
            {
                if(strlen($VARS['opt' . $i]) > 0)
                { $link .= "&opt$i=" . urlencode($VARS['opt' . $i]); }
            }
            if(strlen($VARS['f_category']) > 0)
            { $link .= "&f_category=" . urlencode($VARS['f_category']); }
            if(strlen($VARS['f_searchfield']) > 0)
            { $link .= "&f_searchfield=" . urlencode($VARS['f_searchfield']); }
            if(strlen($VARS['f_searchby']) > 0)
            { $link .= "&f_searchby=" . urlencode($VARS['f_searchby']); }
            if(strlen($VARS['f_searchvalue']) > 0)
            { $link .= "&f_searchvalue=" . urlencode($VARS['f_searchvalue']); }
            for($i=1;$i <= $this->SORT; $i++)
            {
                if(strlen($VARS['f_sortby' . $i]) > 0)
                { $link .= "&f_sortby$i=" . urlencode($VARS['f_sortby' . $i]); }
            }
?>
<script language="javascript">
<!--
var win = window.open("<?echo $link ?>","","width=300,height=100,scrollbars");
// -->
</script>
<h2 align="center">WARNING: do NOT hit reload button on browser or the page will start exporting again.</h2>
<?
        }
        else
        {
?>
<h2 align="center">
ERROR: could NOT access file "<?echo $VARS['exportfile'] ?>"!<br>
Please check that PHP has file write access to that location.<br>
Then press the browser reload button to attempt export again.
</h2>
<?
        }
    }

    function HTML_EXPORT($VARS,$CFG,$T)
    {
        $reload=0;
        $errors = "";

        if($VARS['f_searchfield'] == 'date')
        { $searchvalue = addslashes($VARS['f_searchvalue']); }
        else
        { $searchvalue = $T->CiaoEncode($VARS['f_searchvalue']); }
        if($VARS['f_searchby']=="lk" || $VARS['f_searchby']=="nl")
        { $searchvalue = "%" . $searchvalue . "%"; }

        $addsortcomma = 0;
        $sortby = "";
        $sortstart = "";
        for($i = 1;$i <= $this->SORT; $i++)
        {
            if($VARS['f_sortby' . $i] == 'email')
            {
                $sortstart = " ORDER BY";
                if($addsortcomma)
                { $sortby .= ","; }
                $sortby .= " list.email_id ASC";
                $addsortcomma = 1;
            }
            elseif($VARS['f_sortby' . $i] == 'date')
            {
                $sortstart = " ORDER BY";
                if($addsortcomma)
                { $sortby .= ","; }
                $sortby .= " list.signup_dt ASC";
                $addsortcomma = 1;
            }
            elseif($VARS['f_sortby' . $i] > 0)
            {
                $sortstart = " ORDER BY";
                if($addsortcomma)
                { $sortby .= ","; }
                $sortby .= " list.option" . $VARS['f_sortby' . $i] . " ASC";
                $addsortcomma = 1;
            }
        }
        if($VARS['f_category'] == "General")
        { $sortby = eregi_replace("list.","",$sortby); }
        $sortby = $sortstart . $sortby;

        $where = "";
        if($VARS['f_category'] == "General")
        {
            if($VARS['f_searchfield'] == 'email')
            { $where .= "email_id " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
            elseif($VARS['f_searchfield'] == 'date')
            { $where .= "signup_dt " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
            elseif($VARS['f_searchfield'] && ($VARS['f_searchfield'] <= $CFG->optSize))
            { $where .= "option" . $VARS['f_searchfield'] . " " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
        }
        elseif(strlen($VARS['f_category']) <= 3)
        { # list is a category ID
            $where .= "cat_id = \"" . $VARS['f_category'] . "\"";
            if($VARS['f_searchfield'] == 'email')
            { $where .= " AND list.email_id " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
            elseif($VARS['f_searchfield'] == 'date')
            { $where .= " AND signup_dt " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
            elseif($VARS['f_searchfield'] && ($VARS['f_searchfield'] <= $CFG->optSize))
            { $where .= " AND option" . $VARS['f_searchfield'] . " " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
        } else { # list is a custom SQL statement
            $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_sqlstmt WHERE sql_id = \"" . ereg_replace("custom_","",$VARS['f_category']) . "\"";
            $result = mysql_query($query,$VARS['DB']);
            $row = mysql_fetch_array($result,1);
            $where .= "((" . $row['sql_stmt'] . ")";
            while($row = mysql_fetch_array($result,1))
            { $where .= " OR (" . $row['sql_stmt'] . ")"; }
            $where .= ")";
            if($VARS['f_searchfield'] == 'email')
            { $where .= " AND list.email_id " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
            elseif($VARS['f_searchfield'] == 'date')
            { $where .= " AND signup_dt " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
            elseif($VARS['f_searchfield'] && ($VARS['f_searchfield'] <= $CFG->optSize))
            { $where .= " AND option" . $VARS['f_searchfield'] . " " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
        }
        if($where == "")
        { $query = "SELECT COUNT(*) FROM " . $VARS['DB_TablePrefix'] . "_list;"; }
        else
        {
            if($VARS['f_category'] == "General")
            { $query = "SELECT COUNT(*) FROM " . $VARS['DB_TablePrefix'] . "_list WHERE " . $where . ";"; }
            elseif(strlen($VARS['f_category']) <= 3)
            { $query = "SELECT COUNT(*) FROM " . $VARS['DB_TablePrefix'] . "_list AS list, " . $VARS['DB_TablePrefix'] . "_catlist AS catlist WHERE ((list.email_id = catlist.email_id) AND (" . $where . "));"; }
            else
            { $query = "SELECT COUNT(DISTINCT list.email_id) FROM " . $VARS['DB_TablePrefix'] . "_list AS list, " . $VARS['DB_TablePrefix'] . "_catlist AS catlist WHERE ((list.email_id = catlist.email_id) AND (" . $where . "));"; }
        }
        $result = mysql_query($query,$VARS['DB']);
        list($totrec) = mysql_fetch_array($result,2);
        if($totrec == 0)
        { $totrec = 1; }

        if($where == "")
        { $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list $sortby LIMIT " . ($VARS['o'] * 1) . "," . $this->BATCH . ";"; }
        else
        {
            if($VARS['f_category'] == "General")
            { $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list WHERE $where $sortby LIMIT " . ($VARS['o'] * 1) . "," . $this->BATCH . ";"; }
            elseif(strlen($VARS['f_category']) <= 3)
            { $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list AS list, " . $VARS['DB_TablePrefix'] . "_catlist AS catlist WHERE (list.email_id = catlist.email_id) AND ($where) $sortby LIMIT " . ($VARS['o'] * 1) . "," . $this->BATCH . ";"; }
            else
            { $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list AS list, " . $VARS['DB_TablePrefix'] . "_catlist AS catlist WHERE (list.email_id = catlist.email_id) AND ($where) GROUP BY list.email_id $sortby LIMIT " . ($VARS['o'] * 1) . "," . $this->BATCH . ";"; }
        }
        $results = mysql_query($query,$VARS['DB']);

        if($fw = fopen($VARS['exportfile'],"a"))
        {
            while($row = mysql_fetch_array($results,1))
            {
                if($VARS['first'])
                {
                    if($VARS['first'] == 'email')
                    { fwrite($fw,$T->CiaoDecode($row['email_id']) . $VARS['delimiter']); }
                    elseif($VARS['first'] == 'date')
                    { fwrite($fw,$row['signup_dt'] . $VARS['delimiter']); }
                    elseif($VARS['first'] > 0)
                    { fwrite($fw,$T->CiaoDecode($row['option' . $VARS['first']]) . $VARS['delimiter']); }
                }
                if($VARS['second'])
                {
                    if($VARS['second'] == 'email')
                    { fwrite($fw,$T->CiaoDecode($row['email_id']) . $VARS['delimiter']); }
                    elseif($VARS['second'] == 'date')
                    { fwrite($fw,$row['signup_dt'] . $VARS['delimiter']); }
                    elseif($VARS['second'] > 0)
                    { fwrite($fw,$T->CiaoDecode($row['option' . $VARS['second']]) . $VARS['delimiter']); }
                }
                for($i = 1;$i <= $CFG->optSize; $i++)
                {
                    if($VARS['opt' . $i] == 'email')
                    { fwrite($fw,$T->CiaoDecode($row['email_id']) . $VARS['delimiter']); }
                    elseif($VARS['opt' . $i] == 'date')
                    { fwrite($fw,$row['signup_dt'] . $VARS['delimiter']); }
                    elseif($VARS['opt' . $i] > 0)
                    { fwrite($fw,$T->CiaoDecode($row['option' . $VARS['opt' . $i]]) . $VARS['delimiter']); }
                }
                fwrite($fw,"\n");
                $reload=1;
            }
            fclose($fw);
        }
        $VARS['o'] += $this->BATCH;
?>
<html><head><title>export status</title>
<script language="JavaScript">
<!--
function MySubmit()
{ document.form_export.submit(); }
// -->
</script>
</head>
<?
        if($reload)
        { echo "<body onLoad=\"MySubmit()\">\n"; }
        else
        { echo "<body>\n"; }
?>
<form name="form_export">
<input type="hidden" name="u" value="<?echo $VARS['u'] ?>">
<input type="hidden" name="p" value="<?echo $VARS['p'] ?>">
<input type="hidden" name="x" value="<?echo $VARS['x'] ?>">
<input type="hidden" name="o" value="<?echo (1 * $VARS['o']) ?>">
<input type="hidden" name="f_process" value="1">
<input type="hidden" name="frame_EXPORT" value="1">
<input type="hidden" name="delimiter" value="<?echo $VARS['delimiter'] ?>">
<input type="hidden" name="exportfile" value="<?echo $VARS['exportfile'] ?>">

<input type="hidden" name="first" value="<?echo $VARS['first'] ?>">
<input type="hidden" name="second" value="<?echo $VARS['second'] ?>">
<?
        for($i = 1;$i <= $CFG->optSize; $i++)
        {
?>
<input type="hidden" name="opt<?echo $i ?>" value="<?echo $VARS['opt' . $i] ?>">
<?
        }

        for($i = 1;$i <= $this->SORT; $i++)
        {
?>
<input type="hidden" name="f_sortby<?echo $this->SORT ?>" value="<?echo $VARS['f_sortby' . $i] ?>">
<?
        }
?>

<input type="hidden" name="f_category" value="<?echo $VARS['f_category'] ?>">
<input type="hidden" name="f_searchfield" value="<?echo $VARS['f_searchfield'] ?>">
<input type="hidden" name="f_searchby" value="<?echo $VARS['f_searchby'] ?>">
<input type="hidden" name="f_searchvalue" value="<?echo $VARS['f_searchvalue'] ?>">

</form>
<h2 align="center">
<?
        if($reload)
        { echo "Export In Progress"; }
        else
        { echo "Export Finished"; }

        $percent_finished = ceil(($VARS['o']/$totrec) * 100);
        $percent_remain = 100 - $percent_finished;
?>
</h2>

<table border="1" width="100%"><tr>
<?
        if($percent_finished > 100)
        {
?>
<td align="center" bgcolor="#0000ff" width="100%">
<font color="#ffffff"><b>100%</b></font>
</td></tr></table>
<?
        }
        else
        {
?>
<td align="center" bgcolor="#0000ff" width="<?echo $percent_finished ?>%">
<font color="#ffffff"><b><?echo $percent_finished ?>%</b></font>
</td><td width="<?echo $percent_remain ?>%">&nbsp;</td>
</tr></table>
<?
        }
?>

</body>
</html>
<?
    }

    function HTML_FRAMES($VARS,$CFG,$T)
    {
?>
<html>
<head><title></title></head>
<frameset rows="1,*">
<frame name="filler" noresize scrolling="no">
<?
        echo "\n<frame name=\"EXPORT\" src=\"ciaoadm.php4?";
        echo "u=" . urlencode($VARS['u']) . "&p=" . urlencode($VARS['p']) . "&x=s08&f_process=1&frame_EXPORT=1";
        echo "&delimiter=" . urlencode($VARS['delimiter']) . "&exportfile=" . urlencode($VARS['exportfile']);
        if(strlen($VARS['first']) > 0)
        { echo "&first=" . urlencode($VARS['first']); }
        if(strlen($VARS['second']) > 0)
        { echo "&second=" . urlencode($VARS['second']); }
        for($i=1;$i <= $CFG->optSize; $i++)
        {
            if(strlen($VARS['opt' . $i]) > 0)
            { echo "&opt$i=" . urlencode($VARS['opt' . $i]); }
        }
        if(strlen($VARS['f_category']) > 0)
        { echo "&f_category=" . urlencode($VARS['f_category']); }
        if(strlen($VARS['f_searchfield']) > 0)
        { echo "&f_searchfield=" . urlencode($VARS['f_searchfield']); }
        if(strlen($VARS['f_searchby']) > 0)
        { echo "&f_searchby=" . urlencode($VARS['f_searchby']); }
        if(strlen($VARS['f_searchvalue']) > 0)
        { echo "&f_searchvalue=" . urlencode($VARS['f_searchvalue']); }
        for($i=1;$i <= $this->SORT; $i++)
        {
            if(strlen($VARS['f_sortby' . $i]) > 0)
            { echo "&f_sortby$i=" . urlencode($VARS['f_sortby' . $i]); }
        }
        echo "\">\n";
?>
</frameset>
</html>
<?
    }
}
?>
