<?php
# Ciao EmailList Manager - a customizable mass e-mail program that is administrator/subscriber friendly.
# Copyright (C) 2000,2001 Benjamin Drushell
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful.
# There is NO WARRANTY.  NO implied warranty of MERCHANTABILITY.
# NO implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
# The entire risk is with you. 
# See the GNU General Public License for more details.
#
# A copy of the GNU General Public License is included with this program.
#
# For questions regarding the Ciao EmailList Manager license, 
# contact Ben Drushell: http://www.technobreeze.com/
#---------------------------------------------------------
# FILE: ciao_s06.php4
# LOCAL VERSION: alpha 0.09
# CREATED ON: 11/16/2000
# CREATED BY: Ben Drushell - http://www.technobreeze.com/
# CONTRIBUTORS:
#(date - name - brief description of enhancement)
# 2000.12.23 - BD - Increased import file size to 30kb
# 2001.01.20 - BD - Modifications for customizable verification message
# 2001.01.29 - BD - Modification for handling equals in xml parsed field
# 2001.01.30 - BD - Modification for handling magic equals
# 2001.03.07 - BD - Modification for inability to upload
# 2001.04.05 - BD - Modified to handle extra modules
# 2001.05.22 - BD - Added "return-path" field to email headers sent
# 2001.06.13 - BD - Added duplication verification checking to import
# 2001.06.22 - BD - Added feature so comma is no longer required following the email address that has no extra import data.
#
# 2001.06.24 - BD - Added Error-To email header for bounce messages on some servers
# 2001.07.05 - BD - Moved email retrieval statement so that import next line bug is fixed.
#---------------------------------------------------------
?>

<?php
# SHORT DESCRIPTION
# This module handles import of subscribers.
#---------------------------------------------------------
?>

<?
class module
{
    var $BATCH = 20;

    function module($VARS,$CFG,$T)
    {
        if($VARS['f_process'] == '')
        {
            $T->head($VARS);
            echo "<h2 align=\"center\"><font color=\"" . $T->body_title . "\">E-MAIL LIST IMPORT</font></h2>";
            $this->HTML_FORM($VARS,$CFG,$T);
            $T->tail($VARS);
        }
        else
        {
            if($VARS['f_btnUPLOAD'] != '' || $VARS['f_btnIMPORT'] != '')
            {
                $T->head($VARS);
                echo "<h2 align=\"center\"><font color=\"" . $T->body_title . "\">IMPORT</font></h2>";
                $this->START_IMPORT($VARS,$CFG,$T);
                $this->HTML_FORM($VARS,$CFG,$T);
                $T->tail($VARS);
            }
            elseif($VARS['frame_SEND'] != '')
            { $this->HTML_SEND($VARS,$CFG,$T); }
            elseif($VARS['frame_PAUSE'] != '')
            { $this->HTML_PAUSE(); }
            elseif($VARS['frame_TOOLBAR'] != '')
            { $this->HTML_TOOLBAR($VARS,$CFG,$T); }
            else
            { $this->HTML_FRAMES($VARS); }
        }
    }

    function HTML_FORM($VARS,$CFG,$T)
    {
?>

<center>
<table border="0" width="70%" align="center"><tr><td>
To facilitate those with existing e-mail lists, this import utility enables
list transfer to CIAO.  Anti-spam features (that are subscriber friendly) have
been added to deter misuse of this utility.
</td></tr></table>
</center>

<center>
<form enctype="multipart/form-data" name="client" method="post">
<input type="hidden" name="MAX_FILE_SIZE" value="30000">

<input type="hidden" name="u" value="<?echo $VARS['u'] ?>">
<input type="hidden" name="p" value="<?echo $VARS['p'] ?>">
<input type="hidden" name="x" value="<?echo $VARS['x'] ?>">
<input type="hidden" name="o" value="<?echo (1 * $VARS['o']) ?>">
<input type="hidden" name="f_process" value="1">

<table border="1" bgcolor="<?echo $T->table_bgcolor ?>" width="90%" align="center">
<tr><td align="center"><big><b><font color="<?echo $T->table_Text ?>">FILE TO UPLOAD & IMPORT FROM</font></b></big></td></tr>
<tr><td align="center">
<input name="importfile" type="file">
<input type="submit" name="f_btnUPLOAD" value="Upload & Import File">
</td></tr>
</table>
</form>

<br><br>
<b>NOTE: UPLOAD LIMIT OF 30KB</b>
<br><br>

<form name="client" method="post">
<input type="hidden" name="u" value="<?echo $VARS['u'] ?>">
<input type="hidden" name="p" value="<?echo $VARS['p'] ?>">
<input type="hidden" name="x" value="<?echo $VARS['x'] ?>">
<input type="hidden" name="o" value="<?echo (1 * $VARS['o']) ?>">
<input type="hidden" name="f_process" value="1">

<center>
<table border="1" bgcolor="<?echo $T->table_bgcolor ?>" width="90%" align="center">
<tr><td align="center"><big><b><font color="<?echo $T->table_Text ?>">LOCAL FILE TO IMPORT FROM</font></b></big></td></tr>
<tr><td align="center"><font color="<?echo $T->table_Text ?>">
<input name="importfile" type="text">.dat
<input type="submit" name="f_btnIMPORT" value="Import Local DAT File">
</font></td></tr>
</table>
</form>

<br>

<b>Import file is a comma-delimitered text file with order of fields being:</b>
<br><br>E-mail Address
<?
        for($i = 1; $i <= $CFG->optSize; $i++)
        { echo ",\nOption" . $i; }
?>

<?
    }

    function START_IMPORT($VARS,$CFG,$T)
    {
        if($VARS['f_btnIMPORT'])
        { $VARS['importfile'] .= ".dat"; }
        if($import = file($VARS['importfile']))
        {
            unlink($VARS['importfile']);

            while(list($num,$rec) = each($import))
            {
                $ok2insert = 1;
                $fields = split(",",$rec,($CFG->optSize + 2));
                $rEmail = $T->CiaoEncode(trim($fields[0]));
                $lEmail = $T->CiaoEncode(strtolower(trim($fields[0])));

                $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_verify WHERE (email_id = \"$lEmail\" OR email_id = \"$rEmail\");";
                $result = mysql_query($query,$VARS['DB']);
                if($verify = mysql_fetch_array($result,1))
                { $ok2insert = 0; }

                if($ok2insert)
                {
                    $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list WHERE (email_id = \"$lEmail\" OR email_id = \"$rEmail\");";
                    $result = mysql_query($query,$VARS['DB']);
                    if($list = mysql_fetch_array($result,1))
                    { $ok2insert = 0; }

                    if($ok2insert)
                    {
                        $query = "INSERT INTO " . $VARS['DB_TablePrefix'] . "_verify VALUES(\"";
                        $query .= $num . substr($T->GenerateID(32),5) . "\",\"" . $lEmail . "\",\"";
                        $query .= $T->CiaoEncode($num . $T->GenerateID(5)) . "\",\"5000-11-11 11:11:11\"";
                        for($i = 1; $i <= $CFG->optSize; $i++)
                        { $query .= ",\"" . $T->CiaoEncode($fields[$i]) . "\""; }
                        $query .= ");";
                        mysql_query($query,$VARS['DB']);
                    }
                }
            }

?>
<script language="javascript">
<!--
var win = window.open("ciaoadm.php4?u=<?echo $VARS['u'] ?>&p=<?echo $VARS['p'] ?>&x=s06&f_process=1","","width=300,height=125,scrollbars");
// -->
</script>
<h2 align="center">WARNING: do not hit reload button on browser or the page will start importing again.</h2>
<?
        }
    }

    function HTML_SEND($VARS,$CFG,$T)
    {
# modifications for magic quotes
        $xml = array();
        $xml['DB_magic_quotes_runtime'] = $VARS['DB_magic_quotes_runtime'];
        $xml['DB_magic_quotes_sybase'] = $VARS['DB_magic_quotes_sybase'];
# end modifications

        $T->PARSE_XML_DOC("template",$xml);
        $VARS['msgImport'] = $xml['msgImport'];

        $reload=0;
        $errors = "";
        $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_verify WHERE signup_dt = \"5000-11-11 11:11:11\" LIMIT 0," . $this->BATCH . ";";
        $result = mysql_query($query,$VARS['DB']);
        while($row = mysql_fetch_array($result,1))
        {
            $query = "UPDATE " . $VARS['DB_TablePrefix'] . "_verify SET signup_dt = \"" . date("Y-m-d H:i:s") . "\" WHERE verify_id = \"" . $row['verify_id'] . "\";";
            $result2 = mysql_query($query,$VARS['DB']);
            $errors .= $this->SEND_EMAIL($T->CiaoDecode($row['email_id']),$row['verify_id'],$T->CiaoDecode($row['password']),$CFG,$VARS);
            $reload=1;
        }
?>
<html><head><title>import status</title>
<script language="JavaScript">
<!--
function MySubmit()
{ location.reload(); }
// -->
</script>
</head>
<?
        if($reload)
        { echo "<body onLoad=\"MySubmit()\">"; }
        else
        { echo "<body>"; }
?>

<h2 align="center">
<?
        if($reload)
        { echo "Import In Progress"; }
        else
        { echo "Import Finished"; }
?>
</h2>

</body>
</html>
<?
    }

    function HTML_PAUSE()
    { echo "\n<h2 align='center'>IMPORT PAUSED</h2>"; }

    function HTML_TOOLBAR($VARS)
    {
?>
<html><head><title>toolbar</title></head>
<body>
<a href="ciaoadm.php4?u=<?echo urlencode($VARS['u']) ?>&p=<?echo urlencode($VARS['p']) ?>&x=s06&f_process=1&frame_PAUSE=1" target="SEND">(pause import)</a>
<a href="ciaoadm.php4?u=<?echo urlencode($VARS['u']) ?>&p=<?echo urlencode($VARS['p']) ?>&x=s06&f_process=1&frame_SEND=1" target="SEND">(continue import)</a>
</body>
</html>
<?
    }

    function SEND_EMAIL($TO,$ID,$PASSWORD,$CFG,$VARS)
    {
# function modified on 2001.01.20 by Ben Drushell
# uses customizable message
        $error = "";
        $MESSAGE = $VARS['msgImport'];

        $VERIFYURL = $CFG->url . "ciao.php4?v=" . $ID;
        if(! eregi("#VERIFYURL#",$MESSAGE))
        { $MESSAGE .= "\n" . $VERIFYURL; }

        $MESSAGE = eregi_replace("#PASSWORD#",$PASSWORD,$MESSAGE);
        $MESSAGE = eregi_replace("#VERIFYURL#",$VERIFYURL,$MESSAGE);
        $MESSAGE = eregi_replace("#URL#",$CFG->url,$MESSAGE);
        $MESSAGE = eregi_replace("#EMAIL#",$TO,$MESSAGE);
        $MESSAGE = eregi_replace("#REMOTE_IP#",$VARS['REMOTE_ADDR'],$MESSAGE);
        $MESSAGE = eregi_replace("#REMOTE_HOST#",$VARS['REMOTE_HOST'],$MESSAGE);
        $MESSAGE = eregi_replace("#BROWSER#",$VARS['HTTP_USER_AGENT'],$MESSAGE);
        $MESSAGE = ereg_replace("--","=",$MESSAGE);

        $TO = "<" . $TO . ">"; 
        $SUBJECT = "Request Verification";
        $FROM = "From: <" . $CFG->email . ">\n";
        $FROM .= "Return-Path: <" . $CFG->email . ">\n";
        $FROM .= "Error-To: <" . $CFG->email . ">\n";
        $MESSAGE = "\n" . $MESSAGE . "\n\n";
        mail($TO,$SUBJECT,$MESSAGE,$FROM) or $error = "\n<br>Error Sending To: $TO";
        return($error);
    }

    function HTML_FRAMES($VARS)
    {
?>
<html>
<head><title></title></head>
<frameset rows="*,50">
<frame name="SEND" src="ciaoadm.php4?u=<?echo $VARS['u'] ?>&p=<?echo $VARS['p'] ?>&x=s06&f_process=1&frame_SEND=1">
<frame name="TOOLBAR" src="ciaoadm.php4?u=<?echo $VARS['u'] ?>&p=<?echo $VARS['p'] ?>&x=s06&f_process=1&frame_TOOLBAR=1">
</frameset>
</html>
<?
    }
}
?>
