<?
# Ciao EmailList Manager - a customizable mass e-mail program that is administrator/subscriber friendly.
# Copyright (C) 2000 Benjamin Drushell
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful.
# There is NO WARRANTY.  NO implied warranty of MERCHANTABILITY.
# NO implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
# The entire risk is with you. 
# See the GNU General Public License for more details.
#
# A copy of the GNU General Public License is included with this program.
#
# For questions regarding the Ciao EmailList Manager license, 
# contact Ben Drushell: http://www.technobreeze.com/
#---------------------------------------------------------
# FILE: ciao_s01.php4
# LOCAL VERSION: alpha 0.05
# CREATED ON: 10/30/2000
# CREATED BY: Ben Drushell - http://www.technobreeze.com/
# CONTRIBUTORS:
#(date - name - brief description of enhancement)
# 2000.12.23 - BD - Added comment about custom messages
# 2001.01.20 - BD - Altered code to work with new custom quantity of optional data fields
# 2001.03.21 - BD - Added default value capabilities to optional data fields
# 2001.04.30 - BD - Made password optional.
#
# 2001.06.16 - BD - Added multiple field type capabilities
#---------------------------------------------------------
?>

<?
# SHORT DESCRIPTION
# This module handles sending e-mail address information.
#---------------------------------------------------------
# FORM VARIABLE DEFINITIONS
# f_email - email address to be used as "FROM" for all sent messages
# f_url - url to directory where Ciao EmailList Manager will reside
#         Format: "http://somedomain/optionaldirectory/"
# f_option1 to f_option16 - used to store requirement status of fields
#         Values: ( n = "not used" | r = "required" | o = "optional" )
# f_option1n to f_option16n - used to store output name of field
# f_process - (true/false) process data request
# x - used to store module id
# u - used to store user id
# p - used to store twice encryt password
?>

<?
class module
{
    function module($VARS,$CFG,$T)
    {
        $T->head($VARS);
        if ($VARS['f_process'])
        {
            $errors = "";
            if ($VARS['f_email'] == '')
            { $errors .= "\n<br>No from email address was entered."; }
            if ($VARS['f_url'] == '')
            { $errors .= "\n<br>No URL was entered."; }
            if ($errors == '')
            {
                $fw = fopen("ciao_cfg.php4","w");
                fwrite($fw,"\n<" . "?\n");
                fwrite($fw,"class CFGmod {\n");
                fwrite($fw," var \$email = \"" . $VARS['f_email'] . "\";\n");

                if(substr($VARS['f_url'],strlen($VARS['f_url'])-1,1) != "/")
                { $VARS['f_url'] .= "/"; }
                fwrite($fw," var \$url = \"" . $VARS['f_url'] . "\";\n");

                if($VARS['f_notifyonrequest'] == "CHECKED")
                { fwrite($fw," var \$notifyonrequest = \"1\";\n"); }
                else
                { fwrite($fw," var \$notifyonrequest = \"0\";\n"); }
                if($VARS['f_notifyonverify'] == "CHECKED")
                { fwrite($fw," var \$notifyonverify = \"1\";\n"); }
                else
                { fwrite($fw," var \$notifyonverify = \"0\";\n"); }
                if($VARS['f_notifyonedit'] == "CHECKED")
                { fwrite($fw," var \$notifyonedit = \"1\";\n"); }
                else
                { fwrite($fw," var \$notifyonedit = \"0\";\n"); }
                if($VARS['f_notifyondelete'] == "CHECKED")
                { fwrite($fw," var \$notifyondelete = \"1\";\n"); }
                else
                { fwrite($fw," var \$notifyondelete = \"0\";\n"); }
                if($VARS['f_usepassword'] == "CHECKED")
                { fwrite($fw," var \$usepassword = \"1\";\n"); }
                else
                { fwrite($fw," var \$usepassword = \"0\";\n"); }
                fwrite($fw," var \$optSize = \"" . (0 + $VARS['DB_Size']) . "\";\n");
                $optReq = " var \$optReq = array(";
                $optName = " var \$optName = array(";
                $optDefault = " var \$optDefault = array(";
                $optType = " var \$optType = array(";
                $optReq .= "\"1\"=>\"" . $VARS['f_option1'] . "\"";
                $optName .= "\"1\"=>\"" . $VARS['f_option1n'] . "\"";
                $optDefault .= "\"1\"=>\"" . $VARS['f_option1d'] . "\"";
                $optType .= "\"1\"=>\"" . $VARS['f_option1t'] . "\"";
                $i = 2;
                while($i <= (0 + $VARS['DB_Size']))
                {
                    $optReq .= ",\"" . $i . "\"=>\"" . $VARS['f_option' . $i] . "\"";
                    $optName .= ",\"" . $i . "\"=>\"" . addslashes($VARS['f_option' . $i . 'n']) . "\"";
                    $optDefault .= ",\"" . $i . "\"=>\"" . addslashes($VARS['f_option' . $i . 'd']) . "\"";
                    $optType .= ",\"" . $i . "\"=>\"" . $VARS['f_option' . $i . 't'] . "\"";
                    $i = $i + 1;
                }
                fwrite($fw,$optReq . "  );\n");
                fwrite($fw,$optName . "  );\n");
                fwrite($fw,$optDefault . " );\n");
                fwrite($fw,$optType . " );\n");
                fwrite($fw,"}\n?" . ">\n\n");
                fclose($fw);
                $this->HTML_SUCCESS($VARS);
            } else {
                $this->HTML_ERRORS($errors);
                $this->HTML_FORM($VARS,$CFG,$T);
            }
        } else {
            $this->HTML_FORM($VARS,$CFG,$T);
        }
        $T->tail($VARS);
    }

    function HTML_SUCCESS($VARS)
    {
?>
<H2 align="center">"EMAIL SETUP" SUCCESSFUL</H2>
<big><b><center><a href="ciaoadm.php4?x=s02&u=<?echo urlencode($VARS['u']) ?>&p=<?echo urlencode($VARS['p']) ?>">Click Here To Continue With Setup</a></center></b></big>
<?
    }

    function HTML_ERRORS($errors)
    {
?>
<H2 align="center">"EMAIL SETUP" ERRORS</H2>
<?echo $errors ?><br>
<?
    }

    function HTML_FORM($VARS,$CFG,$T)
    {
        if(gettype($CFG) == 'object')
        {
            if($VARS['f_email'] == '')
            { $VARS['f_email'] = $CFG->email; }
            if($VARS['f_url'] == '')
            { $VARS['f_url'] = $CFG->url; }
            if($CFG->notifyonrequest)
            { $VARS['f_notifyonrequest'] = "CHECKED"; }
            if($CFG->notifyonverify)
            { $VARS['f_notifyonverify'] = "CHECKED"; }
            if($CFG->notifyonedit)
            { $VARS['f_notifyonedit'] = "CHECKED"; }
            if($CFG->notifyondelete)
            { $VARS['f_notifyondelete'] = "CHECKED"; }
            if($CFG->usepassword)
            { $VARS['f_usepassword'] = "CHECKED"; }
        }
?>
<form action="ciaoadm.php4" method="post">
<input type="hidden" name="f_process" value="1">
<input type="hidden" name="u" value="<?echo $VARS['u'] ?>">
<input type="hidden" name="p" value="<?echo $VARS['p'] ?>">
<input type="hidden" name="x" value="<?echo $VARS['x'] ?>">
<center>
<h2 align="center"><font color="<?echo $T->body_title ?>">CONFIGURATION</font></h2>
<br>
<table align="center" bgcolor="<?echo $T->table_bgcolor ?>" cellpadding="1" cellspacing="0">
<tr><td><font color="<?echo $T->table_Text ?>">From E-mail Address:</font></td><td><input type="text" name="f_email" value="<?echo $VARS['f_email'] ?>"></td></tr>
<tr><td><font color="<?echo $T->table_Text ?>">URL To Directory:</font></td><td><input type="text" name="f_url" value="<?echo $VARS['f_url'] ?>"></td></tr>
<tr><td>&nbsp;</td><td><font color="<?echo $T->table_Text ?>">Example: http://yourdomain/directory/</font></td></tr>
<tr><td colspan="2"><font color="<?echo $T->table_Text ?>"><input type="checkbox" name="f_notifyonrequest" value="CHECKED" <?echo $VARS['f_notifyonrequest'] ?>>Notify me when request to join e-mail list is made.</td></tr>
<tr><td colspan="2"><font color="<?echo $T->table_Text ?>"><input type="checkbox" name="f_notifyonverify" value="CHECKED" <?echo $VARS['f_notifyonverify'] ?>>Notify me when e-mail address is verified and added to the list.</td></tr>
<tr><td colspan="2"><font color="<?echo $T->table_Text ?>"><input type="checkbox" name="f_notifyonedit" value="CHECKED" <?echo $VARS['f_notifyonedit'] ?>>Notify me when subscriber edits data.</td></tr>
<tr><td colspan="2"><font color="<?echo $T->table_Text ?>"><input type="checkbox" name="f_notifyondelete" value="CHECKED" <?echo $VARS['f_notifyondelete'] ?>>Notify me when person unsubscribes from list.</td></tr>
</table>
<br><br><br>
<h2 align="center"><font color="<?echo $T->body_title ?>">OPTIONAL SUBSCRIBER DATA</font></h2>

<table align="center" width="50%" border="0"><tr><td>
Automatically, the program requests subscriber e-mail address.
Use below form for requesting additional information
(such as: name, city, whatever) from subscribers.
This information is used to create custom mailing
lists. It can also be used for creating custom messages
by inserting tags like #option1# into your message.
If option1 was defined as "Name", the tag #name# would
also work.
In the sending process, the tag will be replaced with the subscriber data.
</td></tr>
</table>
<br>
<br>
<table align="center" bgcolor="<?echo $T->table_bgcolor ?>" cellpadding="1" cellspacing="0">
<tr><td colspan="5"><font color="<?echo $T->table_Text ?>"><input type="checkbox" name="f_usepassword" value="CHECKED" <?echo $VARS['f_usepassword'] ?>>Use the subscriber password option.</td></tr>
<tr>
    <td> &nbsp; </td>
    <td> &nbsp; </td>
    <td><font color="<?echo $T->table_Text ?>">Field Type</font></td>
    <td><font color="<?echo $T->table_Text ?>">Field Name</font></td>
    <td><font color="<?echo $T->table_Text ?>">Default Value</font></td>
</tr>

<?
        $i = 1;
        while($i <= (0 + $VARS['DB_Size']))
        {
            if(gettype($CFG) == 'object')
            {
                if($VARS['f_option' . $i] == '')
                { $VARS['f_option' . $i] = $CFG->optReq[$i]; }
                if($VARS['f_option' . $i . 'n'] == '')
                { $VARS['f_option' . $i . 'n'] = $CFG->optName[$i]; }
                if($VARS['f_option' . $i . 'd'] == '')
                { $VARS['f_option' . $i . 'd'] = $CFG->optDefault[$i]; }
                if($VARS['f_option' . $i . 't'] == '')
                { $VARS['f_option' . $i . 't'] = $CFG->optType[$i]; }
            }

            $optR = "";
            $optO = "";
            $optN = "";
            if($VARS['f_option' . $i] == 'r')
            { $optR = "SELECTED"; }
            elseif($VARS['f_option' . $i] == 'o')
            { $optO = "SELECTED"; }
            else
            { $optN = "SELECTED"; }

            $optText = "";
            $optSelect = "";
            $optRadio = "";
            $optCheckbox = "";
            if($VARS['f_option' . $i . 't'] == 'select')
            { $optSelect = "SELECTED"; }
            elseif($VARS['f_option' . $i . 't'] == 'radio')
            { $optRadio = "SELECTED"; }
            elseif($VARS['f_option' . $i . 't'] == 'checkbox')
            { $optCheckbox = "SELECTED"; }
            else
            { $optText = "SELECTED"; }

            if($i % 2)
            {
                $color = $T->table_row;
                $text = $T->table_row_text;
            }
            else
            {
                $color = $T->table_altrow;
                $text = $T->table_altrow_text;
            }
?>
<tr><td bgcolor="<?echo $color ?>" align="right"><font color="<?echo $text ?>"><?echo $i ?></font>
&nbsp;&nbsp;</td><td bgcolor="<?echo $color ?>"><font color="<?echo $text ?>">

<select name="f_option<?echo $i ?>">
<option value="r" <?echo $optR ?>>required
<option value="o" <?echo $optO ?>>optional
<option value="n" <?echo $optN ?>>not used
</select>

</font>
</td><td bgcolor="<?echo $color ?>">
<font color="<?echo $text ?>">

<select name="f_option<?echo $i ?>t">
<option value="text" <?echo $optText ?>>text field
<option value="select" <?echo $optSelect ?>>select field
<option value="radio" <?echo $optRadio ?>>radio field
<option value="checkbox" <?echo $optCheckbox ?>>checkbox field
</select>

</font>
</td><td bgcolor="<?echo $color ?>">
<input type="text" name="f_option<?echo $i ?>n" value="<?echo $VARS['f_option' . $i . 'n'] ?>">
</td><td bgcolor="<?echo $color ?>">
<input type="text" name="f_option<?echo $i ?>d" value="<?echo $VARS['f_option' . $i . 'd'] ?>">
</td></tr>
<?
            $i = $i + 1;
        }
?>
</table>
<br>

<p align="center">
<b><big>
Use semicolons to seperate default options for "select" and "radio" type fields.
<br>The option selected by default should be listed first.
</big></b>
</p>

<br>
<table align="center" bgcolor="<?echo $T->table_bgcolor ?>" cellpadding="1" cellspacing="0">
<tr><td><input type="submit" value="SUBMIT DATA"></td></tr>
</table>
</form>
</center>
<?
    }
}
?>
