<?php
# Ciao EmailList Manager - a customizable mass e-mail program that is administrator/subscriber friendly.
# Copyright (C) 2000,2001 Benjamin Drushell
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful.
# There is NO WARRANTY.  NO implied warranty of MERCHANTABILITY.
# NO implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
# The entire risk is with you. 
# See the GNU General Public License for more details.
#
# A copy of the GNU General Public License is included with this program.
#
# For questions regarding the Ciao EmailList Manager license,
# contact Ben Drushell: http://www.technobreeze.com/
#---------------------------------------------------------
# FILE: ciao_s00.php4
# LOCAL VERSION: alpha 0.06
# CREATED ON: 10/30/2000
# CREATED BY: Ben Drushell - http://www.technobreeze.com/
# CONTRIBUTORS:
#(date - name - brief description of enhancement)
# 2001.01.19 - Maxim Maletsky - isolated code error; error limited database password to 8 characters
# 2001.01.20 - BD - added customizable quantity of additional subscriber fields
# 2001.01.30 - BD - modified for compatibility with PHP magic_quotes
# 2001.03.14 - BD - modified for get_magic_quotes_gpc/runtime 3.0.6
# 2001.03.18 - BD - modified for capturing shift value for new encode/decode
#
# 2001.05.31 - BD - added code so that install does not require creation of new tables
#---------------------------------------------------------
?>

<?php
# SHORT DESCRIPTION
# This module is used the first time the program is launched.
# It is the interface for inputing the very first password and user id.
#---------------------------------------------------------
# FORM VARIABLE DEFINITIONS
# f_server - "domain:port" or "localhost"
# f_userid - user identification used to access mysql server
# f_password - password used to access mysql server
# f_password2 - verifies password was entered correctly
# f_dbname - name of the mysql database
# f_dbtableprefix - prefix appended to the begining of table names
# f2_email - email address of 1st user
# f2_password - password user will use to access Ciao EmailList
# f2_password2 - verifies password was entered correctly
# f_process - (true/false) process data request
# x - used to store module id
# u - used to store user id
# p - used to store twice encryt password
?>

<?
class module
{
    var $SIZE = 5; # number of optional data fields (default)

    function module($VARS,$CFG,$T)
    {
        $T->head($VARS);
        if(! file_exists("ciao_db.php4"))
        {
?>
<H2 align="center"><font color="<?echo $T->body_title ?>">
Ciao EmailList Manager
</font></H2>
<p align="center">IMPORTANT:<br>
CONFIGURE DIRECTORY TO GIVE PHP READ/WRITE ACCESS<br>
AND READ HELP FILE
"<a href="ciaohelp.html" target="_blank">ciaohelp.html</a>"
BEFORE PROCEEDING</p>
<?
        }
        if ($VARS['f_process'])
        {
            $magic_quotes_gpc = get_magic_quotes_gpc();
            $magic_quotes_sybase = 0;
            $magic_quotes_runtime = get_magic_quotes_runtime();

            $testread = fopen("ciaocredits.html","r");
            fgets($testread,256);
            fgets($testread,256);
            fgets($testread,256);
            $testvalue = trim(fgets($testread,256)); # <meta name='Author' content="Ben Drushell">
            fclose($testread);

            if(ereg("''",$testvalue))
            { $magic_quotes_sybase = 1; }
            if(ereg("''",$VARS['f_magic_quotes_sybase']))
            { $magic_quotes_sybase = 1; }

            if($magic_quotes_gpc && $magic_quotes_sybase)
            {
                while(list($key,$value) = each($VARS))
                { $VARS[$key] = ereg_replace("''","'",$value); }
            }

            if ($VARS['f_server'] != '' && $VARS['f_userid'] != '' && $VARS['f_password'] != '' && $VARS['f_password'] == $VARS['f_password2'] && $VARS['f2_email'] != '' && $VARS['f2_password'] != '' && $VARS['f2_password'] == $VARS['f2_password2'])
            {
                $fw = fopen("ciao_0_65.txt","w");
                fwrite($fw,"Ciao EmailList Manager v0.65 (alpha) - database updated\n");
                fclose($fw);

                $fw = fopen("ciao_0_90.txt","w");
                fwrite($fw,"Ciao EmailList Manager v0.90 (alpha) - database updated\n");
                fclose($fw);

                $fw = fopen("ciao_0_98.txt","w");
                fwrite($fw,"Ciao EmailList Manager v0.98 (alpha) - database updated\n");
                fclose($fw);

                $VARS['f_shift'] = (0 + $VARS['f_shift']);
                $fin = file("ciao_t.php4");
                $output = "";
                while(list($key,$value) = each($fin))
                {
                    if(strpos($value,"var \$shift"))
                    { $output .= "    var \$shift = " . (0 + $VARS['f_shift']) . ";\n"; }
                    else
                    { $output .= $value; }
                }
                unset($fin);
                if($fout = fopen("ciao_t.php4","w"))
                {
                    fputs($fout,$output);
                    fclose($fout);
                }
                unset($output);

                $fw = fopen("ciao_db.php4","w");
                fwrite($fw,"\n<" . "?\n");
                fwrite($fw,"class DBmod {\n");
                fwrite($fw," var \$magic_quotes_runtime = \"" . (0 + $magic_quotes_runtime) . "\";\n");
                fwrite($fw," var \$magic_quotes_gpc = \"" . (0 + $magic_quotes_gpc) . "\";\n");
                fwrite($fw," var \$magic_quotes_sybase = \"" . (0 + $magic_quotes_sybase) . "\";\n");
                fwrite($fw," var \$size = \"" . (0 + $VARS['f3_quantity']) . "\";\n");
                fwrite($fw," var \$server = \"" . $T->CiaoEncode($VARS['f_server'],$VARS['f_shift']) . "\";\n");
                fwrite($fw," var \$userid = \"" . $T->CiaoEncode($VARS['f_userid'],$VARS['f_shift']) . "\";\n");
                fwrite($fw," var \$password = \"" . $T->CiaoEncode($VARS['f_password'],$VARS['f_shift']) . "\";\n");
                fwrite($fw," var \$name = \"" . $T->CiaoEncode($VARS['f_dbname'],$VARS['f_shift']) . "\";\n");
                fwrite($fw," var \$tableprefix = \"" . $T->CiaoEncode($VARS['f_dbtableprefix'],$VARS['f_shift']) . "\";\n");
                fwrite($fw,"}\n?" . ">\n\n");
                fclose($fw);

                $myDB = mysql_connect($VARS['f_server'],$VARS['f_userid'],$VARS['f_password']);

                if(strlen($VARS['f_skipcreate']) > 0)
                { # don't create tables! just link to existing database!
                    mysql_select_db($VARS['f_dbname'],$myDB);
                    $tEmail = $T->CiaoEncode($VARS['f2_email'],$VARS['f_shift']);
                    $query = "SELECT * FROM " . $VARS['f_dbtableprefix'] . "_user WHERE email = \"" . $tEmail . "\" AND password = \"" . crypt($VARS['f2_password'],$tEmail) . "\" AND access = 1;";
                    $result = mysql_query($query,$myDB);
                    if($founduser = mysql_fetch_array($result,1))
                    {
                        $tSession = $T->GenerateID(32);
                        $query = "INSERT INTO " . $VARS['f_dbtableprefix'] . "_session VALUES(";
                        $query .= "\"" . $tSession . "\",\"" . date("Y-m-d H:i:s") . "\",1);";
                        mysql_query($query,$myDB);
                    }
                }
                else
                {
                    $DB_List = mysql_list_dbs($myDB);
                    $found = false;
                    while ($row = mysql_fetch_row($DB_List))
                    {
                        if($row == $VARS['f_dbname'])
                        { $found = true; }
                    }
                    if (! $found)
                    { mysql_create_db($VARS['f_dbname'],$myDB); }
                    mysql_select_db($VARS['f_dbname'],$myDB);
                    $query = "CREATE TABLE " . $VARS['f_dbtableprefix'] . "_mail (";
                    $query .= "mail_id INT NOT NULL PRIMARY KEY AUTO_INCREMENT,";
                    $query .= "owner_id INT,";
                    $query .= "owner_email CHAR(200),";
                    $query .= "subject CHAR(200),";
                    $query .= "body LONGTEXT,";
                    $query .= "sql_stmt TEXT,";
                    $query .= "offset INT,";
                    $query .= "start_dt DATETIME,";
                    $query .= "finish_dt DATETIME,";
                    $query .= "errors TEXT);";
                    mysql_query($query,$myDB);

                    $query = "CREATE TABLE " . $VARS['f_dbtableprefix'] . "_user (";
                    $query .= "user_id INT NOT NULL PRIMARY KEY AUTO_INCREMENT,";
                    $query .= "email CHAR(200),";
                    $query .= "password CHAR(32),";
                    $query .= "access TINYINT(1)";
                    $query .= ");";
                    mysql_query($query,$myDB);

                    $query = "CREATE TABLE " . $VARS['f_dbtableprefix'] . "_session (";
                    $query .= "session_id CHAR(32) NOT NULL PRIMARY KEY,";
                    $query .= "status_dt DATETIME,";
                    $query .= "access TINYINT(1)";
                    $query .= ");";
                    mysql_query($query,$myDB);

                    $query = "CREATE TABLE " . $VARS['f_dbtableprefix'] . "_publicsession (";
                    $query .= "session_id CHAR(32) NOT NULL PRIMARY KEY,";
                    $query .= "user_id CHAR(200) NOT NULL,";
                    $query .= "status_dt DATETIME";
                    $query .= ");";
                    mysql_query($query,$myDB);

                    $query = "CREATE TABLE " . $VARS['f_dbtableprefix'] . "_sqlstmt (";
                    $query .= "stmt_id INT NOT NULL PRIMARY KEY AUTO_INCREMENT,";
                    $query .= "stmt_name CHAR(200),";
                    $query .= "sql_id CHAR(4),";
                    $query .= "sql_stmt TEXT);";
                    mysql_query($query,$myDB);

                    $query = "CREATE TABLE " . $VARS['f_dbtableprefix'] . "_sql (";
                    $query .= "sql_id CHAR(4) NOT NULL PRIMARY KEY,";
                    $query .= "sql_name CHAR(200));";
                    mysql_query($query,$myDB);

                    $query = "CREATE TABLE " . $VARS['f_dbtableprefix'] . "_catlist (";
                    $query .= "email_id CHAR(200) NOT NULL,";
                    $query .= "cat_id CHAR(3) NOT NULL,";
                    $query .= "KEY(email_id,cat_id));";
                    mysql_query($query,$myDB);

                    $query = "CREATE TABLE " . $VARS['f_dbtableprefix'] . "_category (";
                    $query .= "cat_nid INT(10) UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT,";
                    $query .= "cat_id CHAR(3) NOT NULL,";
                    $query .= "cat_name CHAR(80));";
                    mysql_query($query,$myDB);

                    $query = "CREATE TABLE " . $VARS['f_dbtableprefix'] . "_block (";
                    $query .= "block_id INT NOT NULL PRIMARY KEY AUTO_INCREMENT,";
                    $query .= "block_value CHAR(200) NOT NULL,";
                    $query .= "block_reason TEXT,";
                    $query .= "block_dt DATETIME);";
                    mysql_query($query,$myDB);

                    $query = "CREATE TABLE " . $VARS['f_dbtableprefix'] . "_list (";
                    $query .= "email_id CHAR(200) NOT NULL PRIMARY KEY,";
                    $query .= "password CHAR(200),";
                    $query .= "signup_dt DATETIME";
                    $i = 1;
                    while ($i <= (0 + $VARS['f3_quantity']))
                    { $query .= ", option" . $i . " CHAR(200)"; $i = $i + 1; }
                    $query .= ");";
                    mysql_query($query,$myDB);

                    $query = "CREATE TABLE " . $VARS['f_dbtableprefix'] . "_verify (";
                    $query .= "verify_id CHAR(32) NOT NULL PRIMARY KEY,";
                    $query .= "email_id CHAR(200) NOT NULL,";
                    $query .= "password CHAR(200),";
                    $query .= "signup_dt DATETIME";
                    $i = 1;
                    while ($i <= (0 + $VARS['f3_quantity']))
                    { $query .= ", option" . $i . " CHAR(200)"; $i = $i + 1; }
                    $query .= ");";
                    mysql_query($query,$myDB);


                    $tEmail = $T->CiaoEncode($VARS['f2_email'],$VARS['f_shift']);

# md5 version... crypt version depricated
                    $mPassword = md5(urlencode($T->CiaoEncode($VARS['f2_password'],$VARS['f_shift'])) . urlencode($tEmail)); # md5-version-replacement
# w!nd*ws version
#                   $mPassword = $T->CiaoEncode($VARS['f2_password'],$VARS['f_shift']); # w!nd*ws-version-replacement

                    $query = "INSERT INTO " . $VARS['f_dbtableprefix'] . "_user VALUES(";
                    $query .= "NULL,\"" . $tEmail . "\",\"" . $mPassword . "\",1);";
                    mysql_query($query,$myDB);

                    $tSession = $T->GenerateID(32);
                    $query = "INSERT INTO " . $VARS['f_dbtableprefix'] . "_session VALUES(";
                    $query .= "\"" . $tSession . "\",\"" . date("Y-m-d H:i:s") . "\",1);";
                    mysql_query($query,$myDB);

                    $query = "INSERT INTO " . $VARS['f_dbtableprefix'] . "_category VALUES(NULL,\"ALL\",\"All Subscribers\");";
                    mysql_query($query,$myDB);
                }

                mysql_close($myDB);
                $this->HTML_SUCCESS($tEmail,$tSession,$magic_quotes_runtime,$magic_quotes_gpc,$magic_quotes_sybase);
            }
            else
            { $this->HTML_SETUP('ERROR - Please fill in all fields of data',$VARS,$T); }
        }
        else
        { $this->HTML_SETUP("",$VARS,$T); }
        $T->tail($VARS);
    }

    function HTML_SETUP($ERROR,$VARS,$T)
    {
?>
<center>

<form method="post" action="ciaoadm.php4">
<input type="hidden" name="f_process" value="1">

<!-- test for magic_quotes -->
<input type="hidden" name="f_magic_quotes_gpc" value='"'>
<input type="hidden" name="f_magic_quotes_sybase" value="'">
<!-- end test -->

<?
        if(file_exists("ciao_db.php4"))
        { $skipcreatechecked = "CHECKED"; }
?>

<table align="center" bgcolor="<?echo $T->table_bgcolor ?>" cellpadding="1" cellspacing="0">
<tr><td><font color="<?echo $T->table_Text ?>"><input type="checkbox" name="f_skipcreate" value="1" <?echo $skipcreatechecked ?>>Click here if you do NOT want to create new tables. This would be advantageous when linking to existing Ciao EmailList Manager database tables.</font></td></tr>
</table>


<H2 align="center"><font color="<?echo $T->body_title ?>">
MySQL DATABASE INFORMATION
<?echo $ERROR ?>
</font></H2>

Requires access to a MySQL server.<br>
If you do not know this information,<br>
contact your website administrator or provider.<br>

<table align="center" bgcolor="<?echo $T->table_bgcolor ?>" cellpadding="1" cellspacing="0">
<tr><td><font color="<?echo $T->table_Text ?>">Server:</font></td><td><input type="text" name="f_server" value="<?echo $VARS['f_server'] ?>"></td></tr>
<tr><td><font color="<?echo $T->table_Text ?>">User ID:</font></td><td><input type="text" name="f_userid" value="<?echo $VARS['f_userid'] ?>"></td></tr>
<tr><td><font color="<?echo $T->table_Text ?>">Password:</font></td><td><input type="password" name="f_password" value="<?echo $VARS['f_password'] ?>"></td></tr>
<tr><td><font color="<?echo $T->table_Text ?>">Password Verification:</font></td><td><input type="password" name="f_password2" value="<?echo $VARS['f_password2'] ?>"></td></tr>
<tr><td><font color="<?echo $T->table_Text ?>">Database Name:</font></td><td><input type="text" name="f_dbname" value="<?echo $VARS['f_dbname'] ?>"></td></tr>
<tr><td><font color="<?echo $T->table_Text ?>">Data Encode (optional safety):</font></td><td><input type="text" name="f_shift" value="<?echo (0 + $VARS['f_shift']) ?>"></td></tr>
<?
    if (! $VARS['f_dbtableprefix'])
    { $VARS['f_dbtableprefix'] = "ciao"; }
?>
<tr><td><font color="<?echo $T->table_Text ?>">Database Table Prefix:</font></td><td><input type="text" name="f_dbtableprefix" value="<?echo $VARS['f_dbtableprefix'] ?>"></td></tr>
</table>
<br><br><br>
<H2 align="center"><font color="<?echo $T->body_title ?>">
USER INFORMATION
<?echo $ERROR ?>
</font></H2>

This creates an administrative user for accessing CIAO.<br>
Additional general or administrative users can be added later.
<br><br>

<table align="center" bgcolor="<?echo $T->table_bgcolor ?>" cellpadding="1" cellspacing="0">
<tr><td><font color="<?echo $T->table_Text ?>">User Email:</font></td><td><input type="text" name="f2_email" value="<?echo $VARS['f2_email'] ?>"></td></tr>
<tr><td><font color="<?echo $T->table_Text ?>">Password:</font></td><td><input type="password" name="f2_password" value="<?echo $VARS['f2_password'] ?>"></td></tr>
<tr><td><font color="<?echo $T->table_Text ?>">Password Verification:</font></td><td><input type="password" name="f2_password2" value="<?echo $VARS['f2_password2'] ?>"></td></tr>
</table>

<br><br><br>
<H2 align="center"><font color="<?echo $T->body_title ?>">
ADDITIONAL SUBSCRIBER DATA
</font></H2>

<?
    if (! $VARS['f3_quantity'])
    { $VARS['f3_quantity'] = $this->SIZE; }
?>

<table align="center" bgcolor="<?echo $T->table_bgcolor ?>" cellpadding="1" cellspacing="0">
<tr><td><font color="<?echo $T->table_Text ?>">Quantity of additional subscriber fields:</font></td><td><input type="text" name="f3_quantity" value="<?echo (0 + $VARS['f3_quantity']) ?>"></td></tr>
</table>
<br><br>

<p align="center"><center>
<table align="center" border="1" bgcolor="#ffffff" cellpadding="15" cellspacing="0" width="90%"><tr><td>
Ciao EmailList Manager - a customizable mass e-mail program that is administrator/subscriber friendly.<br>
Copyright (C) 2000,2001 Benjamin Drushell
<br><br>
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.
<br><br>
This program is distributed in the hope that it will be useful.
There is NO WARRANTY.  NO implied warranty of MERCHANTABILITY.
NO implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The entire risk is with you. 
See the 
<a href="gpl.txt" target="_blank">GNU General Public License</a>
for more details.
<br><br>
A copy of the GNU General Public License is included with this program.
<br><br>
For questions regarding the Ciao EmailList Manager license, 
contact Ben Drushell: http://www.technobreeze.com/
</td></tr></table>
</center></p>

<br><br>
<table align="center" bgcolor="<?echo $T->table_bgcolor ?>" cellpadding="1" cellspacing="0">
<tr><td><input type="submit" value="SETUP/AGREE TO TERMS"></td></tr>
</table>
</form>
</center>
<?
    }

    function HTML_SUCCESS($u,$p,$magic_quotes_runtime,$magic_quotes_gpc,$magic_quotes_sybase)
    {
?>
<H2 align="center">INITIAL SETUP SUCCESSFUL</H2>

<center>
<table width="400" border="0" align="center"><tr><td>
    PROBING FOR USE OF "magic_quotes_" PHP SERVER SETTINGS...<br><br>
<b>
    "magic_quotes_runtime": <? if($magic_quotes_runtime){ echo "ON"; }else{ echo "OFF"; } ?><br>
    "magic_quotes_gpc": <? if($magic_quotes_gpc){ echo "ON"; }else{ echo "OFF"; } ?><br>
    "magic_quotes_sybase": <? if($magic_quotes_sybase){ echo "ON"; }else{ echo "OFF"; } ?>
</b>
</td></tr>
<tr><td>&nbsp;</td></tr>
<tr><td>
If "magic_quotes_" settings are turned on for your PHP server, extra backslashes "\" created by 
these settings will be automatically removed so that Ciao EmailList Manager operates properly.  
If you change the "magic_quotes_" settings in the future, it will be necessary to re-use 
the "Database Setup" admin utility or alter the code in "ciao_db.php4".
</td></tr></table>
<br><br>
<big><b><a href="ciaoadm.php4?x=s01&u=<?echo urlencode($u) ?>&p=<?echo urlencode($p) ?>">Continue With Setup</a></b></big>
</center>

<?
    }
}
?>
