<?php
# Ciao EmailList Manager - a customizable mass e-mail program that is administrator/subscriber friendly.
# Copyright (C) 2000 Benjamin Drushell
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful.
# There is NO WARRANTY.  NO implied warranty of MERCHANTABILITY.
# NO implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
# The entire risk is with you. 
# See the GNU General Public License for more details.
#
# A copy of the GNU General Public License is included with this program.
#
# For questions regarding the Ciao EmailList Manager license, 
# contact Ben Drushell: http://www.technobreeze.com/
#---------------------------------------------------------
# FILE: ciao_m06.php4
# LOCAL VERSION: alpha 0.01
# CREATED ON: 10/30/2000
# CREATED BY: Ben Drushell - http://www.technobreeze.com/
# CONTRIBUTORS:
#(date - name - brief description of enhancement)
# 2001.06.15 - BD - Added search/sort feature
#---------------------------------------------------------
?>

<?php
# SHORT DESCRIPTION
# This module handles the deletion/viewing of the verification list database.
#---------------------------------------------------------
# VARIABLE DEFINITIONS
# x - used to store current module
# u - used to store user ID
# p - used to store twice encryt password
# n - used to store id number of item
# f_option - used to store first menu option (n|e|d)
# f_name - used to store new name
# f_menu - menu item with id number
# SIZE - global variable setting number of option fields
?>

<?
class module
{
    var $SIZE = 10;
    var $TRANS = array("lk"=>"LIKE", "nl"=>"NOT LIKE", "eq"=>"=", "ne"=>"!=", "lt"=>"<", "gt"=>">", "le"=>"<=", "ge"=>">=");
    var $SORT = 2; # number of sort items available

    function module($VARS,$CFG,$T)
    {
        $T->head($VARS);
        echo "<h2 align=\"center\"><font color=\"" . $T->body_title . "\">VIEW PENDING LIST</font></h2>";
        if($VARS['f_process'] != '')
        {
            if($VARS['f_delete'] != '')
            { $this->DELETE($VARS,$CFG,$T); }
            elseif($VARS['f_block'] != '')
            { $this->BLOCK($VARS,$CFG,$T); }
            $this->PROCESS_FORM($VARS,$CFG,$T);
        }
        else
        { $this->HTML_FORM($VARS,$CFG,$T); }
        $T->tail($VARS);
    }

    function HTML_FORM($VARS,$CFG,$T)
    {
?>
<center>
<form action="ciaoadm.php4" method="post">
<input type="hidden" name="f_process" value="1">
<input type="hidden" name="x" value="<?echo $VARS['x'] ?>">
<input type="hidden" name="u" value="<?echo $VARS['u'] ?>">
<input type="hidden" name="p" value="<?echo $VARS['p'] ?>">
<table border="1" align="center" bgcolor="<?echo $T->table_bgcolor ?>" cellpadding="5" cellspacing="0">
<tr><td align="center"><font color="<?echo $T->table_Text ?>">CHOOSE WHAT ADDITIONAL DATA YOU WANT TO VIEW</font></td></tr>
<tr><td>
<table border="0" width="60%" align="center">
<tr><td><font color="<?echo $T->table_Text ?>">E-mail Address</font></td></tr>
<tr><td><font color="<?echo $T->table_Text ?>">
<input type="checkbox" name="f_UseDate">
Date of Sign-up
</font></td></tr>
<?
        $i = 1;
        while($i <= $CFG->optSize)
        {
            if($CFG->optReq[$i] != 'n')
            {
?>
<tr><td><font color="<?echo $T->table_Text ?>">
<input type="checkbox" name="f_UseOpt<?echo $i ?>">
<?echo $CFG->optName[$i] ?>
</font></td></tr>
<?
            }
            $i = $i + 1;
        }
?>
</table>
</td></tr>

<tr><td align="left">
<font color="<?echo $T->table_Text ?>">
Search Field
<select name="f_searchfield">
 <option value="0" SELECTED>NO SEARCH
 <option value="email">Email Address
 <option value="date">Signup Date
<?
        $i = 1;
        while($i <= $CFG->optSize)
        {
            if($CFG->optReq[$i] != 'n')
            {
?>
 <option value="<?echo $i ?>">
<?
                echo $CFG->optName[$i] . "\n";
            }
            $i = $i + 1;
        }
?>
</select>

<select name="f_searchby">
 <option value="lk">LIKE
 <option value="nl">NOT LIKE
 <option value="eq">EQUAL TO
 <option value="ne">NOT EQUAL TO
 <option value="gt">GREATER THAN
 <option value="lt">LESS THAN
 <option value="ge">&gt;=
 <option value="le">&lt;=
</select>

<input name="f_searchvalue" type="text">

</font>
</td></tr>

<tr><td align="left"><font color="<?echo $T->table_Text ?>">
Sort by:
<?
        for($i=1;$i <= $this->SORT; $i++)
        {
?>
<select name="f_sortby<?echo $i ?>">
<option value="0">Do Not Sort
<option value="email">Email Address
<option value="date">Date
<?
            for($j = 1; $j <= $CFG->optSize; $j++)
            { echo "\n<option value=\"$j\">" . $CFG->optName[$j]; }
?>
</select>
<?
        }
?>
</font></td></tr>

<tr><td align="center"><input type="submit" name="f_btnSelect" value="VIEW SELECTED DATA"></td></tr>
</table>
</form>
</center>
<?
    }

    function PROCESS_FORM($VARS,$CFG,$T)
    {
?>
<center>
<table border="0"><tr><td valign="top"><b>You have selected to view:</b></td><td>E-mail Address;<br>
<?
        if($VARS['f_UseDate'] != '')
        { echo " Date of Request; <br>"; }
        for($i = 1; $i <= $CFG->optSize; $i++)
        {
            if($VARS["f_UseOpt" . $i] != '')
            { echo " " . $CFG->optName[$i] . "; <br>"; }
        }
        echo "\n</td></tr></table>\n";

        if($VARS['f_searchfield'] == 'date')
        { $searchvalue = addslashes($VARS['f_searchvalue']); }
        else
        { $searchvalue = $T->CiaoEncode($VARS['f_searchvalue']); }
        if($VARS['f_searchby']=="lk" || $VARS['f_searchby']=="nl")
        { $searchvalue = "%" . $searchvalue . "%"; }

        $addsortcomma = 0;
        $sortby = "";
        $sortstart = "";
        for($i = 1;$i <= $this->SORT; $i++)
        {
            if($VARS['f_sortby' . $i] == 'email')
            {
                $sortstart = " ORDER BY";
                if($addsortcomma)
                { $sortby .= ","; }
                $sortby .= " email_id ASC";
                $addsortcomma = 1;
            }
            elseif($VARS['f_sortby' . $i] == 'date')
            {
                $sortstart = " ORDER BY";
                if($addsortcomma)
                { $sortby .= ","; }
                $sortby .= " signup_dt ASC";
                $addsortcomma = 1;
            }
            elseif($VARS['f_sortby' . $i] > 0)
            {
                $sortstart = " ORDER BY";
                if($addsortcomma)
                { $sortby .= ","; }
                $sortby .= " option" . $VARS['f_sortby' . $i] . " ASC";
                $addsortcomma = 1;
            }
        }
        $sortby = $sortstart . $sortby;

        $where = "";
        if($VARS['f_searchfield'] == 'email')
        { $where .= "email " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
        elseif($VARS['f_searchfield'] == 'date')
        { $where .= "signup_dt " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
        elseif($VARS['f_searchfield'] && ($VARS['f_searchfield'] <= $CFG->optSize))
        { $where .= "option" . $VARS['f_searchfield'] . " " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }

        if($where == "")
        { $query = "SELECT COUNT(*) FROM " . $VARS['DB_TablePrefix'] . "_verify;"; }
        else
        { $query = "SELECT COUNT(*) FROM " . $VARS['DB_TablePrefix'] . "_verify WHERE $where;"; }
        $result = mysql_query($query,$VARS['DB']);
        list($totrec) = mysql_fetch_array($result,2);

        if($where == "")
        { $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_verify $sortby LIMIT " . ($VARS['o'] * $this->SIZE) . "," . $this->SIZE . ";"; }
        else
        { $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_verify WHERE $where $sortby LIMIT " . ($VARS['o'] * $this->SIZE) . "," . $this->SIZE . ";"; }
        $result = mysql_query($query,$VARS['DB']);
?>
There are <?echo $totrec ?> e-mail addresses awaiting verification.<br>
<?
        if($VARS['f_searchfield'])
        {
            echo "With applied search: ";
            if(is_int($VARS['f_searchfield']))
            { echo $CFG->optName[$VARS['f_searchfield']]; }
            else
            { echo "Email Address"; }
            echo " " . $this->TRANS[$VARS['f_searchby']] . " \"" . $VARS['f_searchvalue'] . "\"<br>\n";
        }
?>
<center>
<table border="1" width="98%" cellpadding="5" cellspacing="0" bgcolor="#ffffff">
<?
        while($column1 = mysql_fetch_array($result,1))
        {
            $counter = 1;
            while($counter <= $CFG->optSize)
            {
                if($column1['option' . $counter] == '')
                { $column1['option' . $counter] = $CFG->optName[$counter] . " N/A"; }
                else
                { $column1['option' . $counter] = $T->CiaoDecode($column1['option' . $counter]); }
                $counter = $counter + 1;
            }
            if($column2 = mysql_fetch_array($result,1))
            {
                $counter = 1;
                while($counter <= $CFG->optSize)
                {
                    if($column2['option' . $counter] == '')
                    { $column2['option' . $counter] = $CFG->optName[$counter] . " N/A"; }
                    else
                    { $column2['option' . $counter] = $T->CiaoDecode($column2['option' . $counter]); }
                    $counter = $counter + 1;
                }
            }
            echo "\n<tr><td width=\"50%\"><font color=\"#000000\"><b>\n";
            echo " (" . $this->CreateLink("delete",$VARS,$CFG,"&f_delete=1&m=" . $column1['email_id']) . ") &nbsp; &nbsp;";
            echo " (" . $this->CreateLink("block",$VARS,$CFG,"&f_block=1&m=" . $column1['email_id']) . ") ";
            echo "\n</b></font></td><td width=\"50%\"><font color=\"#000000\"><b>";
            if($column2['email_id'] != '')
            {
                echo " (" . $this->CreateLink("delete",$VARS,$CFG,"&f_delete=1&m=" . $column2['email_id']) . ") &nbsp; &nbsp;";
                echo " (" . $this->CreateLink("block",$VARS,$CFG,"&f_block=1&m=" . $column2['email_id']) . ") ";
            }
            else { echo " &nbsp; "; }
            echo "</b></font></td></tr>";
            echo "\n<tr><td width=\"50%\"><font color=\"#000000\">\n";
            echo $T->CiaoDecode($column1['email_id']);
            echo "\n</font></td><td width=\"50%\"><font color=\"#000000\">";
            if($column2['email_id'] != '')
            { echo $T->CiaoDecode($column2['email_id']); }
            else { echo " &nbsp; "; }
            echo "</font></td></tr>";
            if($VARS['f_UseDate'] != '')
            {
                echo "\n<tr><td width=\"50%\"><font color=\"#000000\">" . $column1['signup_dt'] . "&nbsp;</font></td>";
                echo "<td width=\"50%\"><font color=\"#000000\">" . $column2['signup_dt'] . "&nbsp;</font></td></tr>";
            }
            $counter = 1;
            while($counter <= $CFG->optSize)
            {
                if($VARS['f_UseOpt' . $counter] != '')
                {
                    echo "\n<tr><td width=\"50%\"><font color=\"#000000\">" . $column1['option' . $counter] . "&nbsp;</font></td>";
                    echo "<td width=\"50%\"><font color=\"#000000\">" . $column2['option' . $counter] . "&nbsp;</font></td></tr>";
                }
                $counter = $counter + 1;
            }
?>
<tr><td width="50%"> &nbsp; </td>
<td width="50%"> &nbsp; </td></tr>
<?
        }
        echo "\n</table></center>";
        $this->PageSetup($VARS,$CFG,$totrec);
    }

#--------------------------------------------
#This function will create the multiple page
#numbered bar.
#--------------------------------------------
    function PageSetup($VARS,$CFG,$totrec)
    {
?>
<br>
<center>
<b>Page <?echo ($VARS['o'] + 1) ?> of <?echo ceil($totrec/$this->SIZE) ?></b>
<br>
<table border="1" bgcolor="#ffffff" width="98%" align="center" cellpadding="5" cellspacing="0"><tr><td align="center">
<font color="#000000">
<?
        if($VARS['o'] >= 10)
        {
            $VARS['o'] = $VARS['o'] - 10;
            echo $this->CreateLink("(Back 10 Pages)",$VARS,$CFG);
            $VARS['o'] = $VARS['o'] + 10;
        }
        else
        { echo "(Back 10 Pages)"; }
        echo "</font></td><td align=\"center\"><font color=\"#000000\">";
        if($VARS['o'] > 0)
        {
            $VARS['o'] = $VARS['o'] - 1;
            echo $this->CreateLink("(Previous Page)",$VARS,$CFG);
            $VARS['o'] = $VARS['o'] + 1;
        }
        else
        { echo "(Previous Page)"; }
        echo "</font></td><td align=\"center\"><font color=\"#000000\">";
        if(($VARS['o'] + 1) < ceil($totrec/$this->SIZE))
        {
            $VARS['o'] = $VARS['o'] + 1;
            echo $this->CreateLink("(Next Page)",$VARS,$CFG);
            $VARS['o'] = $VARS['o'] - 1;
        }
        else
        { echo "(Next Page)"; }
        echo "</font></td><td align=\"center\"><font color=\"#000000\">";
        if(($VARS['o'] + 10) < ceil($totrec/$this->SIZE))
        {
            $VARS['o'] = $VARS['o'] + 10;
            echo $this->CreateLink("(Forward 10 Pages)",$VARS,$CFG);
            $VARS['o'] = $VARS['o'] - 10;
        }
        else
        { echo "(Forward 10 Pages)"; }
?>
</font></td></tr></table></center>
<br>
<?
    }

#--------------------------------------------
#This function will create the multiple page
#numbered bar.
#--------------------------------------------
    function CreateLink($TEXT,$VARS,$CFG,$EXTRA="")
    {
        $link = "<a href=\"ciaoadm.php4?u=" . urlencode($VARS['u']) . "&p=" . urlencode($VARS['p']) . "&x=" . urlencode($VARS['x']) . "&o=" . (0 + $VARS['o']);
        $link .= "&f_process=1";
        if($VARS['f_UseDate'] != '')
        { $link .= "&f_UseDate=1"; }
        if($VARS['f_searchfield'])
        {
            $link .= "&f_searchfield=" . urlencode($VARS['f_searchfield']);
            $link .= "&f_searchby=" . urlencode($VARS['f_searchby']);
            $link .= "&f_searchvalue=" . urlencode($VARS['f_searchvalue']);
        }
        for($counter=1;$counter <= $CFG->optSize; $counter++)
        {
            if($VARS['f_UseOpt' . $counter] != '')
            { $link .= "&f_UseOpt" . $counter . "=1"; }
        }
        for($i=1;$i <= $this->SORT; $i++)
        {
            if(strlen($VARS['f_sortby' . $i]) > 0)
            { $link .= "&f_sortby$i=" . urlencode($VARS['f_sortby' . $i]); }
        }
        $link .= $EXTRA . "\" style=\"color:#000000\"><font color=\"#000000\">" . $TEXT . "</font></a>";
        return($link);
    }

#--------------------------------------------
#This function will delete a record pending 
#verification.
#--------------------------------------------
    function DELETE($VARS,$CFG,$T)
    {
        $query = "DELETE FROM " . $VARS['DB_TablePrefix'] . "_verify WHERE email_id = \"" . $VARS['m'] . "\";";
        mysql_query($query,$VARS['DB']);
    }

#--------------------------------------------
#This function will purge record from 
#verify database, and add their email address
#to the block database.
#--------------------------------------------
    function BLOCK($VARS,$CFG,$T)
    {
        $query = "DELETE FROM " . $VARS['DB_TablePrefix'] . "_verify WHERE email_id = \"" . $VARS['m'] . "\";";
        mysql_query($query,$VARS['DB']);
        $query = "INSERT INTO " . $VARS['DB_TablePrefix'] . "_block VALUES(NULL,\"" . $VARS['m'] . "\",NULL,\"" . date("Y-m-d H:i:s") . "\");";
        mysql_query($query,$VARS['DB']);
    }
}
?>
