<?php
# Ciao EmailList Manager - a customizable mass e-mail program that is administrator/subscriber friendly.
# Copyright (C) 2000,2001 Benjamin Drushell
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful.
# There is NO WARRANTY.  NO implied warranty of MERCHANTABILITY.
# NO implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
# The entire risk is with you.
# See the GNU General Public License for more details.
#
# A copy of the GNU General Public License is included with this program.
#
# For questions regarding the Ciao EmailList Manager license,
# contact Ben Drushell: http://www.technobreeze.com/
#---------------------------------------------------------
# FILE: ciao_m05.php4
# LOCAL VERSION: alpha 0.05
# CREATED ON: 10/30/2000
# CREATED BY: Ben Drushell - http://www.technobreeze.com/
# CONTRIBUTORS:
#(date - name - brief description of enhancement)
# 2001.04.23 - BD - Modified "edit" link to utilize passwords
# 2001.06.05 - BD - Added search feature.
# 2001.06.15 - BD - Added sort feature.
# 2001.06.16 - BD - Fixed SQL statement "GROUP BY" clause adversly affecting custom categories
#
# 2001.07.05 - BD - Fixed SQL statement "SORT" clause adversly affecting custom categories
# 2001.07.05 - BD - Added code for "ALL" category.
#---------------------------------------------------------
?>

<?php
# SHORT DESCRIPTION
# This module handles the deletion/viewing of the e-mail list database.
#---------------------------------------------------------
# FORM VARIABLE DEFINITIONS
# f_process - (true/false) process data request
# x - used to store module id
# u - used to store user id
# p - used to store twice encryt password
# o - used to store page offset
# m - used to store id number of item
# f_UseDate - (1|0)
# f_UseOpt# - (1|0)
# f_delete - contains email address to delete
# f_block - contains email address to block
# f_option - used to store first menu option (n|e|d)
# f_category - menu item with id number
?>

<?
class module
{
    var $SIZE = 20; # number of items listed per page
    var $TRANS = array("lk"=>"LIKE", "nl"=>"NOT LIKE", "eq"=>"=", "ne"=>"!=", "lt"=>"<", "gt"=>">", "le"=>"<=", "ge"=>">=");
    var $SORT = 2; # number of sort items available

    function module($VARS,$CFG,$T)
    {
        $T->head($VARS);
        echo "<h2 align=\"center\"><font color=\"" . $T->body_title . "\">VIEW/EDIT/DELETE SUBSCRIBERS</font></h2>";
        if($VARS['f_process'] != '')
        {
            if($VARS['f_delete'] != '')
            { $this->DELETE($VARS,$CFG,$T); }
            elseif($VARS['f_block'] != '')
            { $this->BLOCK($VARS,$CFG,$T); }
            $this->PROCESS_FORM($VARS,$CFG,$T);
        }
        else
        { $this->HTML_FORM($VARS,$CFG,$T); }
        $T->tail($VARS);
    }

    function HTML_FORM($VARS,$CFG,$T)
    {
?>
<center>
<form action="ciaoadm.php4" method="post">
<input type="hidden" name="f_process" value="1">
<input type="hidden" name="x" value="<?echo $VARS['x'] ?>">
<input type="hidden" name="u" value="<?echo $VARS['u'] ?>">
<input type="hidden" name="p" value="<?echo $VARS['p'] ?>">
<table border="1" align="center" bgcolor="<?echo $T->table_bgcolor ?>" cellpadding="5" cellspacing="0">
<tr><td align="center"><font color="<?echo $T->table_Text ?>">CHOOSE WHAT ADDITIONAL DATA YOU WANT TO VIEW</font></td></tr>
<tr><td>
<table border="0" width="60%" align="center">
<tr><td><font color="<?echo $T->table_Text ?>">E-mail Address</font></td></tr>
<tr><td><font color="<?echo $T->table_Text ?>">
<input type="checkbox" name="f_UseDate">
Date of Sign-up
</font></td></tr>
<?
        $i = 1;
        while($i <= $CFG->optSize)
        {
            if($CFG->optReq[$i] != 'n')
            {
?>
<tr><td><font color="<?echo $T->table_Text ?>">
<input type="checkbox" name="f_UseOpt<?echo $i ?>">
<?echo $CFG->optName[$i] ?>
</font></td></tr>
<?
            }
            $i = $i + 1;
        }
?>
</table>
</td></tr>
<tr><td align="left">
<font color="<?echo $T->table_Text ?>">
Category:

<select name="f_category">
 <option value="General">All Subscribers
<?
        $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_category;";
        $results = mysql_query($query,$VARS['DB']);
        while($row = mysql_fetch_array($results,1))
        {
            if($row['cat_id'] != "ALL")
            { echo "\n <option value=\"" . $row['cat_id'] . "\">(" . $row['cat_id'] . ") " . $row['cat_name']; }
        }
        $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_sql;";
        $results = mysql_query($query,$VARS['DB']);
        while($row = mysql_fetch_array($results,1))
        { echo "\n <option value=\"custom_" . $row['sql_id'] . "\">(" . $row['sql_id'] . ") " . $row['sql_name']; }
?>
</select>
</font>
</td></tr>

<tr><td align="left">
<font color="<?echo $T->table_Text ?>">
Search Field
<select name="f_searchfield">
 <option value="0" SELECTED>NO SEARCH
 <option value="email">Email Address
 <option value="date">Signup Date
<?
        $i = 1;
        while($i <= $CFG->optSize)
        {
            if($CFG->optReq[$i] != 'n')
            {
?>
 <option value="<?echo $i ?>">
<?
                echo $CFG->optName[$i] . "\n";
            }
            $i = $i + 1;
        }
?>
</select>

<select name="f_searchby">
 <option value="lk">LIKE
 <option value="nl">NOT LIKE
 <option value="eq">EQUAL TO
 <option value="ne">NOT EQUAL TO
 <option value="gt">GREATER THAN
 <option value="lt">LESS THAN
 <option value="ge">&gt;=
 <option value="le">&lt;=
</select>

<input name="f_searchvalue" type="text">

</font>
</td></tr>

<tr><td align="left"><font color="<?echo $T->table_Text ?>">
Sort by:
<?
        for($i=1;$i <= $this->SORT; $i++)
        {
?>
<select name="f_sortby<?echo $i ?>">
<option value="0">Do Not Sort
<option value="email">Email Address
<option value="date">Date
<?
            for($j = 1; $j <= $CFG->optSize; $j++)
            { echo "\n<option value=\"$j\">" . $CFG->optName[$j]; }
?>
</select>
<?
        }
?>
</font></td></tr>

<tr><td align="center"><input type="submit" name="f_btnSelect" value="VIEW SELECTED DATA"></td></tr>
</table>
</form>
</center>
<?
    }

    function PROCESS_FORM($VARS,$CFG,$T)
    {
?>
<center>
<table align="center" border="0"><tr><td valign="top"><b>You have selected to view:</b></td><td>E-mail Address;<br>
<?
        if($VARS['f_UseDate'] != '')
        { echo " Date of Sign-up; <br>"; }
        $i = 1;
        while($i <= $CFG->optSize)
        {
            if($VARS["f_UseOpt" . $i] != '')
            { echo " " . $CFG->optName[$i] . "; <br>"; }
            $i = $i + 1;
        }
        echo "\n</td></tr></table>\n";

        if($VARS['f_searchfield'] == 'date')
        { $searchvalue = addslashes($VARS['f_searchvalue']); }
        else
        { $searchvalue = $T->CiaoEncode($VARS['f_searchvalue']); }
        if($VARS['f_searchby']=="lk" || $VARS['f_searchby']=="nl")
        { $searchvalue = "%" . $searchvalue . "%"; }

        $addsortcomma = 0;
        $sortby = "";
        $sortstart = "";
        for($i = 1;$i <= $this->SORT; $i++)
        {
            if($VARS['f_sortby' . $i] == 'email')
            {
                $sortstart = " ORDER BY";
                if($addsortcomma)
                { $sortby .= ","; }
                $sortby .= " list.email_id ASC";
                $addsortcomma = 1;
            }
            elseif($VARS['f_sortby' . $i] == 'date')
            {
                $sortstart = " ORDER BY";
                if($addsortcomma)
                { $sortby .= ","; }
                $sortby .= " list.signup_dt ASC";
                $addsortcomma = 1;
            }
            elseif($VARS['f_sortby' . $i] > 0)
            {
                $sortstart = " ORDER BY";
                if($addsortcomma)
                { $sortby .= ","; }
                $sortby .= " list.option" . $VARS['f_sortby' . $i] . " ASC";
                $addsortcomma = 1;
            }
        }
        if($VARS['f_category'] == "General")
        { $sortby = eregi_replace("list.","",$sortby); }
        $sortby = $sortstart . $sortby;

        $where = "";
        if($VARS['f_category'] == "General")
        {
            $where = "";
            if($VARS['f_searchfield'] == 'email')
            { $where .= "email_id " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
            elseif($VARS['f_searchfield'] == 'date')
            { $where .= "signup_dt " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
            elseif($VARS['f_searchfield'] && ($VARS['f_searchfield'] <= $CFG->optSize))
            { $where .= "option" . $VARS['f_searchfield'] . " " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
        }
        elseif(strlen($VARS['f_category']) <= 3)
        { # list is a category ID
            $where .= "cat_id = \"" . $VARS['f_category'] . "\"";
            if($VARS['f_searchfield'] == 'email')
            { $where .= " AND list.email_id " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
            elseif($VARS['f_searchfield'] == 'date')
            { $where .= " AND signup_dt " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
            elseif($VARS['f_searchfield'] && ($VARS['f_searchfield'] <= $CFG->optSize))
            { $where .= " AND option" . $VARS['f_searchfield'] . " " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
        } else { # list is a custom SQL statement
            $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_sqlstmt WHERE sql_id = \"" . ereg_replace("custom_","",$VARS['f_category']) . "\"";
            $result = mysql_query($query,$VARS['DB']);
            $row = mysql_fetch_array($result,1);
            $where .= "((" . $row['sql_stmt'] . ")";
            while($row = mysql_fetch_array($result,1))
            { $where .= " OR (" . $row['sql_stmt'] . ")"; }
            $where .= ")";
            if($VARS['f_searchfield'] == 'email')
            { $where .= " AND list.email_id " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
            elseif($VARS['f_searchfield'] == 'date')
            { $where .= " AND signup_dt " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
            elseif($VARS['f_searchfield'] && ($VARS['f_searchfield'] <= $CFG->optSize))
            { $where .= " AND option" . $VARS['f_searchfield'] . " " . $this->TRANS[$VARS['f_searchby']] . " \"" . $searchvalue . "\""; }
        }
        if($where == "")
        { $query = "SELECT COUNT(*) FROM " . $VARS['DB_TablePrefix'] . "_list;"; }
        else
        {
            if($VARS['f_category'] == "General")
            { $query = "SELECT COUNT(*) FROM " . $VARS['DB_TablePrefix'] . "_list WHERE " . $where . ";"; }
            elseif(strlen($VARS['f_category']) <= 3)
            { $query = "SELECT COUNT(*) FROM " . $VARS['DB_TablePrefix'] . "_list AS list, " . $VARS['DB_TablePrefix'] . "_catlist AS catlist WHERE (list.email_id = catlist.email_id) AND (" . $where . ");"; }
            else
            { $query = "SELECT COUNT(DISTINCT list.email_id) FROM " . $VARS['DB_TablePrefix'] . "_list AS list, " . $VARS['DB_TablePrefix'] . "_catlist AS catlist WHERE (list.email_id = catlist.email_id) AND (" . $where . ");"; }
        }
        $result = mysql_query($query,$VARS['DB']);

        if($where == "" || strlen($VARS['f_category']) <= 3 || $VARS['f_category'] == "General")
        { list($totrec) = mysql_fetch_array($result,2); }
        else # count for custom list
        {
            $customcount = mysql_fetch_array($result,1);
            $totrec = $customcount['COUNT(DISTINCT list.email_id)'];
        }

        if($where == "")
        { $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list $sortby LIMIT " . ($VARS['o'] * $this->SIZE) . "," . $this->SIZE . ";"; }
        else
        {
            if($VARS['f_category'] == "General")
            { $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list WHERE $where $sortby LIMIT " . ($VARS['o'] * $this->SIZE) . "," . $this->SIZE . ";"; }
            elseif(strlen($VARS['f_category']) <= 3)
            { $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list AS list, " . $VARS['DB_TablePrefix'] . "_catlist AS catlist WHERE (list.email_id = catlist.email_id) AND ($where) $sortby LIMIT " . ($VARS['o'] * $this->SIZE) . "," . $this->SIZE . ";"; }
            else
            { $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list AS list, " . $VARS['DB_TablePrefix'] . "_catlist AS catlist WHERE (list.email_id = catlist.email_id) AND ($where) GROUP BY list.email_id $sortby LIMIT " . ($VARS['o'] * $this->SIZE) . "," . $this->SIZE . ";"; }
        }
        $results = mysql_query($query,$VARS['DB']);
?>
The category '<?echo $VARS['f_category'] ?>' contains <?echo $totrec ?> e-mail addresses.<br>
<?
        if($VARS['f_searchfield'])
        {
            echo "With applied search: ";
            if(is_int($VARS['f_searchfield']))
            { echo $CFG->optName[$VARS['f_searchfield']]; }
            else
            { echo "Email Address"; }
            echo " " . $this->TRANS[$VARS['f_searchby']] . " \"" . $VARS['f_searchvalue'] . "\"<br>\n";
        }
?>
<table border="1" width="98%" bgcolor="#ffffff" cellpadding="5" cellspacing="0">
<?
        while($column1 = mysql_fetch_array($results,1))
        {
            $counter = 1;
            while($counter <= $CFG->optSize)
            {
                if($column1['option' . $counter] == '')
                { $column1['option' . $counter] = $CFG->optName[$counter] . " N/A"; }
                else
                { $column1['option' . $counter] = $T->CiaoDecode($column1['option' . $counter]); }
                $counter = $counter + 1;
            }
            if($column2 = mysql_fetch_array($results,1))
            {
                $counter = 1;
                while($counter <= $CFG->optSize)
                {
                    if($column2['option' . $counter] == '')
                    { $column2['option' . $counter] = $CFG->optName[$counter] . " N/A"; }
                    else
                    { $column2['option' . $counter] = $T->CiaoDecode($column2['option' . $counter]); }
                    $counter = $counter + 1;
                }
            }
            echo "\n<tr><td width=\"50%\"><b>";
            echo "(<a href=\"ciao.php4?f=" . urlencode($column1['email_id']) . "&fp=" . urlencode($column1['password']) . "&f_process=1\" target=\"_blank\" style=\"color:#000000\"><font color=\"#000000\">edit</font></a>) &nbsp;";
            if(($VARS['f_category'] == "General") || (strlen($VARS['f_category']) <= 3))
            { echo " (" . $this->CreateLink("delete",$VARS,$CFG,"&f_delete=1&m=" . $column1['email_id']) . ") &nbsp;"; }
            echo " (" . $this->CreateLink("block",$VARS,$CFG,"&f_block=1&m=" . $column1['email_id']) . ")";
            echo "\n</b></td><td width=\"50%\"><b>";
            if($column2['email_id'] != '')
            {
                echo "(<a href=\"ciao.php4?f=" . urlencode($column2['email_id']) . "&fp=" . urlencode($column2['password']) . "&f_process=1\" target=\"_blank\" style=\"color:#000000\"><font color=\"#000000\">edit</font></a>) &nbsp;";
                if(($VARS['f_category'] == "General") || (strlen($VARS['f_category']) <= 3))
                { echo " (" . $this->CreateLink("delete",$VARS,$CFG,"&f_delete=1&m=" . $column2['email_id']) . ") &nbsp;"; }
                echo " (" . $this->CreateLink("block",$VARS,$CFG,"&f_block=1&m=" . $column2['email_id']) . ")";
            }
            else
            { echo "&nbsp;"; }
            echo "</b></td></tr>";
            echo "\n<tr><td width=\"50%\"><font color=\"#000000\">";
            echo $T->CiaoDecode($column1['email_id']);
            echo "\n</font></td><td width=\"50%\"><font color=\"#000000\">";
            if($column2['email_id'] != '')
            { echo $T->CiaoDecode($column2['email_id']); }
            else { echo " &nbsp; "; }
            echo "</font></td></tr>";
            if($VARS['f_UseDate'] != '')
            {
                echo "\n<tr><td width=\"50%\"><font color=\"#000000\">" . $column1['signup_dt'] . "&nbsp;</font></td>";
                echo "<td width=\"50%\"><font color=\"#000000\">" . $column2['signup_dt'] . "&nbsp;</font></td></tr>";
            }
            $counter = 1;
            while($counter <= $CFG->optSize)
            {
                if($VARS['f_UseOpt' . $counter] != '')
                {
                    echo "\n<tr><td width=\"50%\"><font color=\"#000000\">" . $column1['option' . $counter] . "&nbsp;</font></td>";
                    echo "<td width=\"50%\"><font color=\"#000000\">" . $column2['option' . $counter] . "&nbsp;</font></td></tr>";
                }
                $counter = $counter + 1;
            }
?>
<tr><td width="50%"> &nbsp; </td>
<td width="50%"> &nbsp; </td></tr>
<?
        }
        echo "\n</table>";
        $this->PageSetup($VARS,$CFG,$totrec);
    }

#--------------------------------------------
#This function will create the multiple page
#numbered bar.
#--------------------------------------------
    function PageSetup($VARS,$CFG,$totrec)
    {
?>
<br>
<center>
<b>Page <?echo ($VARS['o'] + 1) ?> of <?echo ceil($totrec/$this->SIZE) ?></b>
<br>
<table border="1" width="98%" bgcolor="#ffffff" cellpadding="1" cellspacing="0" align="center"><tr><td align="center"><font color="#000000">
<?
        if($VARS['o'] >= 10)
        {
            $VARS['o'] = $VARS['o'] - 10;
            echo $this->CreateLink("(Back 10 Pages)",$VARS,$CFG);
            $VARS['o'] = $VARS['o'] + 10;
        }
        else
        { echo "(Back 10 Pages)"; }
        echo "</font></td><td align=\"center\"><font color=\"#000000\">";
        if($VARS['o'] > 0)
        {
            $VARS['o'] = $VARS['o'] - 1;
            echo $this->CreateLink("(Previous Page)",$VARS,$CFG);
            $VARS['o'] = $VARS['o'] + 1;
        }
        else
        { echo "(Previous Page)"; }
        echo "</font></td><td align=\"center\"><font color=\"#000000\">";
        if(($VARS['o'] + 1) < ceil($totrec/$this->SIZE))
        {
            $VARS['o'] = $VARS['o'] + 1;
            echo $this->CreateLink("(Next Page)",$VARS,$CFG);
            $VARS['o'] = $VARS['o'] - 1;
        }
        else
        { echo "(Next Page)"; }
        echo "</font></td><td align=\"center\"><font color=\"#000000\">";
        if(($VARS['o'] + 10) < ceil($totrec/$this->SIZE))
        {
            $VARS['o'] = $VARS['o'] + 10;
            echo $this->CreateLink("(Forward 10 Pages)",$VARS,$CFG);
            $VARS['o'] = $VARS['o'] - 10;
        }
        else
        { echo "(Forward 10 Pages)"; }
?>
</font>
</td></tr></table></center>
<br>
<?
    }

#--------------------------------------------
#This function will create the multiple page
#numbered bar.
#--------------------------------------------
    function CreateLink($TEXT,$VARS,$CFG,$EXTRA="")
    {
        $link = "<a href=\"ciaoadm.php4?u=" . urlencode($VARS['u']) . "&p=" . urlencode($VARS['p']) . "&x=" . urlencode($VARS['x']) . "&o=" . (0 + $VARS['o']);
        $link .= "&f_category=" . urlencode($VARS['f_category']);
        $link .= "&f_process=1";
        if($VARS['f_UseDate'] != '')
        { $link .= "&f_UseDate=1"; }
        if($VARS['f_searchfield'])
        {
            $link .= "&f_searchfield=" . urlencode($VARS['f_searchfield']);
            $link .= "&f_searchby=" . urlencode($VARS['f_searchby']);
            $link .= "&f_searchvalue=" . urlencode($VARS['f_searchvalue']);
        }
        for($counter=1;$counter <= $CFG->optSize; $counter++)
        {
            if($VARS['f_UseOpt' . $counter] != '')
            { $link .= "&f_UseOpt" . $counter . "=1"; }
        }
        for($i=1;$i <= $this->SORT; $i++)
        {
            if(strlen($VARS['f_sortby' . $i]) > 0)
            { $link .= "&f_sortby$i=" . urlencode($VARS['f_sortby' . $i]); }
        }
        $link .= $EXTRA . "\" style=\"color:#000000\"><font color=\"#000000\">" . $TEXT . "</font></a>";
        return($link);
    }

#--------------------------------------------
#This function will delete a user from a
#category.  If they are not subscribed to
#any category, they are deleted.
#--------------------------------------------
    function DELETE($VARS,$CFG,$T)
    {
        if($VARS['f_category'] == "General")
        {
            $query = "DELETE FROM " . $VARS['DB_TablePrefix'] . "_catlist WHERE email_id = \"" . $VARS['m'] . "\";";
            mysql_query($query,$VARS['DB']);
            $query = "DELETE FROM " . $VARS['DB_TablePrefix'] . "_list WHERE email_id = \"" . $VARS['m'] . "\";";
            mysql_query($query,$VARS['DB']);
        }
        elseif(strlen($VARS['f_category']) <= 3)
        {
            $query = "DELETE FROM " . $VARS['DB_TablePrefix'] . "_catlist WHERE email_id = \"" . $VARS['m'] . "\" AND cat_id = \"" . $VARS['f_category'] . "\";";
            mysql_query($query,$VARS['DB']);
        }
    }

#--------------------------------------------
#This function will purge all records regarding
#user from database, and add their email address
#to the block database.
#--------------------------------------------
    function BLOCK($VARS,$CFG,$T)
    {
        $query = "DELETE FROM " . $VARS['DB_TablePrefix'] . "_catlist WHERE email_id = \"" . $VARS['m'] . "\";";
        mysql_query($query,$VARS['DB']);
        $query = "DELETE FROM " . $VARS['DB_TablePrefix'] . "_list WHERE email_id = \"" . $VARS['m'] . "\";";
        mysql_query($query,$VARS['DB']);
        $query = "INSERT INTO " . $VARS['DB_TablePrefix'] . "_block VALUES(NULL,\"" . $VARS['m'] . "\",NULL,\"" . date("Y-m-d H:I:00") . "\");";
        mysql_query($query,$VARS['DB']);
    }
}
?>
