<?php
# Ciao EmailList Manager - a customizable mass e-mail program that is administrator/subscriber friendly.
# Copyright (C) 2000,2001 Benjamin Drushell
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful.
# There is NO WARRANTY.  NO implied warranty of MERCHANTABILITY.
# NO implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
# The entire risk is with you.
# See the GNU General Public License for more details.
#
# A copy of the GNU General Public License is included with this program.
#
# For questions regarding the Ciao EmailList Manager license,
# contact Ben Drushell: http://www.technobreeze.com/
#---------------------------------------------------------
# FILE: ciao_m04.php4
# LOCAL VERSION: alpha 0.13
# CREATED ON: 10/30/2000
# CREATED BY: Ben Drushell - http://www.technobreeze.com/
# CONTRIBUTORS:
#(date - name - brief description of enhancement)
# 2000.12.19 - Wayne Davis - Code changed because of mysql_insert_id bug in PHP4
# 2000.12.22 - BD - Fixed pause/continue; Fixed sending status bar;
# 2000.12.23 - BD - Added customized message with tags like #option1#
# 2001.01.28 - BD - Added HTML email capabilities
# 2001.02.01 - BD - Added codes so <script> tags get removed from email
# 2001.04.22 - BD - Added character-set code... changed test send to test/individual send
# 2001.05.07 - BD - replaced quoted-printable with 8-bit
# 2001.05.08 - BD - fixed link to sending html frame; charset data passing; multi-type send errors
# 2001.05.11 - Gerbrand van Dieijen - added MIME-Version 1.0 to html email header for PINE compatibility
# 2001.05.22 - BD - Added "return-path" field to email headers sent
# 2001.05.24 - Ryan Foster - added MIME-Version 1.0 to multi-part email header for various email client compatibility
# 2001.05.31 - BD - Removed codes so that script and comment tags are permitted again
# 2001.06.16 - BD - Fixed SQL statement "GROUP BY" clause adversly affecting custom categories
#
# 2001.06.24 - BD - Added Error-To email header for bounce messages on some servers
# 2001.07.05 - BD - Added code for "ALL" category.
#---------------------------------------------------------
?>

<?php
# SHORT DESCRIPTION
# This module handles the composing and sending operations.
#---------------------------------------------------------
# FORM VARIABLE DEFINITIONS
# f_process - (true/false) process data request
# x - used to store module id
# u - used to store user id
# p - used to store twice encryt password
# m - used to store mail_id
# f_title - message subject
# f_message - message
# f_menu - custom list or category in which to send message
# f_address - test address to send to
# f_btnSAVE - button to save copy of message for later use.
# f_btnEDIT - command received from saved area to further edit message
# f_btnTEST - send a test e-mail message to see what it looks like
# f_btnSEND - begin sending message to the list
# frame_send - (1|0) frame for sending the message
# frame_pause - (1|0) frame for sending paused message
# frame_toolbar - (1|0) toolbar frame for pausing/resuming sending
?>

<?
class module
{
    var $BATCH = 20; # number of e-mails to send per batch

    function module($VARS,$CFG,$T)
    {
        if($VARS['f_process'] != '')
        { $this->PROCESS_FORM($VARS,$CFG,$T); }
        else
        {
            $T->head($VARS);
            echo "<h2 align=\"center\"><font color=\"" . $T->body_title . "\">COMPOSE MESSAGE</font></h2>";
            $this->HTML_FORM($VARS,$CFG,$T);
            $T->tail($VARS);
        }
    }

    function PROCESS_FORM($VARS,$CFG,$T)
    {
        if($VARS['f_btnSAVE'] != '')
        {
            $T->head($VARS);
            echo "<h2 align=\"center\"><font color=\"" . $T->body_title . "\">COMPOSE MESSAGE</font></h2>";
            $this->SAVE_MESSAGE($VARS,$CFG,$T);
            $this->HTML_FORM($VARS,$CFG,$T);
            $T->tail($VARS);
        }
        elseif($VARS['e'] != '')
        { # edit saved message
            $T->head($VARS);
            echo "<h2 align=\"center\"><font color=\"" . $T->body_title . "\">COMPOSE MESSAGE</font></h2>";
            $this->RETRIEVE_MESSAGE($VARS,$CFG,$T);
            $this->HTML_FORM($VARS,$CFG,$T);
            $T->tail($VARS);
        }
        elseif($VARS['f_btnTEST'] != '')
        {
            $T->head($VARS);
            echo "<h2 align=\"center\"><font color=\"" . $T->body_title . "\">COMPOSE MESSAGE</font></h2>";
            $this->TEST_SEND($VARS,$CFG,$T);
            $this->HTML_FORM($VARS,$CFG,$T);
            $T->tail($VARS);
        }
        elseif($VARS['f_btnSEND'] != '')
        {
            $T->head($VARS);
            echo "<h2 align=\"center\"><font color=\"" . $T->body_title . "\">COMPOSE MESSAGE</font></h2>";
            $this->START_SEND($VARS,$CFG,$T);
            $T->tail($VARS);
        }
        elseif($VARS['frame_SEND'] != '')
        { $this->HTML_SEND($VARS,$CFG,$T); }
        elseif($VARS['frame_PAUSE'] != '')
        { $this->HTML_PAUSE(); }
        elseif($VARS['frame_TOOLBAR'] != '')
        { $this->HTML_TOOLBAR($VARS,$CFG,$T); }
        else
        { $this->HTML_FRAMES($VARS); }
    }

    function HTML_FORM($VARS,$CFG,$T)
    {
?>

<form method="post" name="emailer" action="ciaoadm.php4">
<input type="hidden" name="f_process" value="1">
<input type="hidden" name="u" value="<?echo $VARS['u'] ?>">
<input type="hidden" name="p" value="<?echo $VARS['p'] ?>">
<input type="hidden" name="x" value="<?echo $VARS['x'] ?>">

<script language="JavaScript">
<!--

function MultiCheck()
{
    if(document.emailer.f_sendtype[document.emailer.f_sendtype.selectedIndex].value == "multi")
    {
        var charset = document.emailer.f_charset.value;
        var multitext = "------=_Ciao_EmailList_Manager.ContentBoundary\n";
        multitext = multitext + "Content-Type: text/plain; charset=\"" + charset + "\"; ";
        multitext = multitext + "Content-Transfer-Encoding: 8bit\n\n";
        multitext = multitext + "\n-INSERT PLAIN TEXT HERE-\n\n\n";
        multitext = multitext + "------=_Ciao_EmailList_Manager.ContentBoundary\n";
        multitext = multitext + "Content-Type: text/html; charset=\"" + charset + "\"; ";
        multitext = multitext + "Content-Transfer-Encoding: 8bit\n\n";
        multitext = multitext + "\n<b>INSERT HTML/TEXT HERE</b>\n\n\n";
        multitext = multitext + "------=_Ciao_EmailList_Manager.ContentBoundary--\n";
        document.emailer.f_message.value = multitext;
    }
    else
    { document.emailer.f_message.value = ""; }
}

// -->
</script>

<br>
<center>
<table align="center" border=1 bgcolor="<?echo $T->table_bgcolor ?>">
<?
        if($VARS['f_charset'] == '')
        { $VARS['f_charset'] = 'iso-8859-1'; }
?>
<tr><td align="right"><font color="<?echo $T->table_Text ?>">Character Set:</font></td><td><input TYPE="TEXT" NAME="f_charset" VALUE="<?echo $VARS['f_charset'] ?>"></td></tr>
<tr><td colspan=2><font color="<?echo $T->table_Text ?>">
FORMAT:

<SELECT name="f_sendtype" onChange="MultiCheck(this)">

<? if($VARS['f_sendtype'] == "text" || $VARS['f_sendtype'] == ""){ ?>
<option value="text" SELECTED>
<? } else { ?>
<option value="text">
<? } ?>
Send in Plain Text Format

<? if($VARS['f_sendtype'] == "html"){ ?>
<option value="html" SELECTED>
<? } else { ?>
<option value="html">
<? } ?>
Send in HTML Format

<? if($VARS['f_sendtype'] == "multi"){ ?>
<option value="multi" SELECTED>
<? } else { ?>
<option value="multi">
<? } ?>
Send in Multiple Formats (Plain Text & HTML)

</SELECT>

</font></td></tr>

<tr><td align="right"><font color="<?echo $T->table_Text ?>">Reply-To (optional):</font></td><td><input TYPE="TEXT" NAME="f_replyto" VALUE="<?echo $VARS['f_replyto'] ?>"></td></tr>
<tr><td align="right"><font color="<?echo $T->table_Text ?>">Subject:</font></td><td><input TYPE="TEXT" NAME="f_title" VALUE="<?echo $VARS['f_title'] ?>"></td></tr>
<tr><td colspan=2 align="center"><TEXTAREA NAME="f_message" COLS="50" ROWS="10" WRAP="VIRTUAL"><?echo $VARS['f_message'] ?></TEXTAREA></td></tr>
<tr><td colspan=2 align="center"><font color="<?echo $T->table_Text ?>">
Sending List:</font>
<select name="f_menu">
 <option value="General">All Subscribers
<?
        $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_category;";
        $result = mysql_query($query,$VARS['DB']);
        while($row = mysql_fetch_array($result,1))
        {
            if($row['cat_id'] != "ALL")
            { echo "\n <option value=\"" . $row['cat_id'] . "\">(" . $row['cat_id'] . ") " . $row['cat_name']; }
        }
        $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_sql;";
        $result = mysql_query($query,$VARS['DB']);
        while($row = mysql_fetch_array($result,1))
        { echo "\n <option value=\"custom_" . $row['sql_id'] . "\">(". $row['sql_id'] .") " . $row['sql_name']; }
?>
</select>
</td></tr>
<tr><td align="center" width="50%" rowspan="2"><font color="<?echo $T->table_Text ?>">
<input type="submit" name="f_btnTEST" value="TEST/INDIVIDUAL SEND"><br>
TO: <input type="text" name="f_address" value="<?echo $VARS['f_address'] ?>">
</font></td><td align="center" width="50%">
<input type="submit" NAME="f_btnSAVE" VALUE="Save E-mail"></td></tr>
<tr><td align="center" width="50%"><input type="submit" name="f_btnSEND" VALUE="Send E-mail"></td></tr>
<tr><td colspan="2" bgcolor="<?echo $T->table_Text ?>" align="center">

<table width="400" border="0"><tr><td>

<font color="<?echo $T->table_bgcolor ?>">
<b>CUSTOM MESSAGE:</b><br><br>
You may want to customize your message based on
subscriber data.  There are two means of referencing
this data.  One method is to insert an #option1# tag.
The other method is to use the name given to the field.
If option1 was defined as "Name", you could use #name#.
<br>
Example Message:<br>
#name#,<br>
The new computers have arrived.  A sales
representative is available at xxx-xxx-xxxx
and will be happy to quote a price for a
#option2# computer.
<br><br>
John Doe,<br>
The new computers have arrived.  A sales
representative is available at xxx-xxx-xxxx
and will be happy to quote a price for a
wearable computer.
</font>

</td></tr></table>

</td></tr>
</table>
</center>
</form>
<?
    }

    function SAVE_MESSAGE($VARS,$CFG,$T)
    {
        $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_user WHERE email = \"" . $VARS['u'] . "\";";
        $result = mysql_query($query,$VARS['DB']);
        $row = mysql_fetch_array($result,1);
        $query = "INSERT INTO " . $VARS['DB_TablePrefix'] . "_mail VALUES(NULL," . $row['user_id'] . ",\"" . $VARS['u'] . "\",\"" . $T->CiaoEncode($VARS['f_title']) . "\",\"" . $T->CiaoEncode($VARS['f_message']) . "\",NULL,NULL,\"0000-00-00 00:00:00\",\"0000-00-00 00:00:00\",NULL);";
        mysql_query($query,$VARS['DB']);
    }

    function RETRIEVE_MESSAGE(&$VARS,$CFG,$T)
    {
        $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_mail WHERE mail_id = " . $VARS['e'] . ";";
        $result = mysql_query($query,$VARS['DB']);
        $row = mysql_fetch_array($result,1);
        $VARS['f_title'] = $T->CiaoDecode($row['subject']);
        $VARS['f_message'] = $T->CiaoDecode($row['body']);
    }

    function TEST_SEND($VARS,$CFG,$T)
    {
        $errors = "";
        $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list WHERE email_id = \"" . $T->CiaoEncode($VARS['f_address']) . "\";";
        $result = mysql_query($query,$VARS['DB']);
        if($row = mysql_fetch_array($result,1))
        {
            for($i=1; $i <= $CFG->optSize; $i++)
            { # 2000.12.23 - Ben Drushell - customized email messages
                $VARS['f_message'] = eregi_replace("#option$i#",$T->CiaoDecode($row['option' . $i]),$VARS['f_message']);
                $VARS['f_message'] = eregi_replace("#" . $CFG->optName[$i] . "#",$T->CiaoDecode($row['option' . $i]),$VARS['f_message']);
                $VARS['f_title'] = eregi_replace("#option$i#",$T->CiaoDecode($row['option' . $i]),$VARS['f_title']);
                $VARS['f_title'] = eregi_replace("#" . $CFG->optName[$i] . "#",$T->CiaoDecode($row['option' . $i]),$VARS['f_title']);
            }
        }

        if($VARS['f_address'] != '')
        { $this->SEND_EMAIL($VARS['f_address'],$VARS['f_title'],$VARS['f_message'],$VARS['f_replyto'],$VARS['f_sendtype'],$CFG,$VARS['f_charset']); }
        else
        { $error = "\nNO destination address was specified to test send.<br>"; }
        return($error);
    }

    function START_SEND($VARS,$CFG,$T)
    {
        $where = " ";
        if($VARS['f_menu'] == "General")
        { $where = ""; }
        elseif(strlen($VARS['f_menu']) <= 3)
        { # list is a category ID
            $where .= "cat_id = \"" . $VARS['f_menu'] . "\"";
        } else { # list is a custom SQL statement
            $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_sqlstmt WHERE sql_id = \"" . ereg_replace("custom_","",$VARS['f_menu']) . "\";";
            $result = mysql_query($query,$VARS['DB']);
            $row = mysql_fetch_array($result,1);
            $where .= "((" . $row['sql_stmt'] . ")";
            while($row = mysql_fetch_array($result,1))
            { $where .= " OR (" . $row['sql_stmt'] . ")"; }
            $where .= ")";
        }
        $query = "SELECT user_id FROM " . $VARS['DB_TablePrefix'] . "_user WHERE email = \"" . $VARS['u'] . "\";";
        $result = mysql_query($query,$VARS['DB']);
        $id = mysql_fetch_array($result,1);

        $query = "INSERT INTO " . $VARS['DB_TablePrefix'] . "_mail VALUES(NULL," . $id['user_id'] . ",\"" . $VARS['u'] . "\",\"" . $T->CiaoEncode($VARS['f_title']) . "\",\"" . $T->CiaoEncode($VARS['f_message']) . "\",\"" . addslashes($where) . "\",0,\"" . date("Y-m-d H:i:s") . "\",NULL,NULL);";
        $result = mysql_query($query,$VARS['DB']);
        $mail_id = mysql_insert_id(); # altered by Wayne Davis because of PHP4 bug
# becuase mysql_insert_id no longer specifies result
# value do NOT place any additional query in between
# mysql_query and mysql_insert_id or the wrong value
# will be stored in mail_id
?>
<script language="javascript">
<!--

<?

echo "var win = window.open(\"ciaoadm.php4?u=" . $VARS['u'] . "&p=" . $VARS['p'] . "&x=" . $VARS['x'] . "&f_process=1&m=" . $mail_id;
echo "&sendtype=" . $VARS['f_sendtype'];
if($VARS['f_replyto'])
{ echo "&replyto=" . urlencode($VARS['f_replyto']); }
if($VARS['f_charset'])
{ echo "&charset=" . urlencode($VARS['f_charset']); }
echo "\",\"\",\"width=300,height=150,scrollbars\");";

?>

// -->
</script>
<h2 align="center">WARNING: do not hit reload button on browser or the page will start sending again.</h2>
<?
    }

    function HTML_SEND($VARS,$CFG,$T)
    {
        $errors = "";
        $reload = 0;
        $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_mail WHERE mail_id = \"" . $VARS['m'] . "\";";
        $result = mysql_query($query,$VARS['DB']);
        $mail = mysql_fetch_array($result,1);
        if($mail['sql_stmt'] != "") #fixed error Ben Drushell 2000.12.22
        { $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list list, " . $VARS['DB_TablePrefix'] . "_catlist catlist WHERE (list.email_id = catlist.email_id) AND " . $mail['sql_stmt'] . " GROUP BY list.email_id LIMIT " . $mail['offset'] . ", " . $this->BATCH . ";"; }
        else
        { $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list LIMIT " . $mail['offset'] . ", " . $this->BATCH . ";"; }
        $result = mysql_query($query,$VARS['DB']);
        while($row = mysql_fetch_array($result,1))
        {
            $mail_subject = $T->CiaoDecode($mail['subject']);
            $mail_body = $T->CiaoDecode($mail['body']);
            for($i=1; $i <= $CFG->optSize; $i++)
            { # 2000.12.23 - Ben Drushell - customized email messages
                $mail_body = eregi_replace("#option$i#",$T->CiaoDecode($row['option' . $i]),$mail_body);
                $mail_body = eregi_replace("#" . $CFG->optName[$i] . "#",$T->CiaoDecode($row['option' . $i]),$mail_body);
                $mail_subject = eregi_replace("#option$i#",$T->CiaoDecode($row['option' . $i]),$mail_subject);
                $mail_subject = eregi_replace("#" . $CFG->optName[$i] . "#",$T->CiaoDecode($row['option' . $i]),$mail_subject);
            }
            $errors .= $this->SEND_EMAIL($T->CiaoDecode($row['email_id']),$mail_subject,$mail_body,urldecode($VARS['replyto']),$VARS['sendtype'],$CFG,$VARS['charset']);
            $reload = 1;
        }
        $query = "UPDATE " . $VARS['DB_TablePrefix'] . "_mail SET errors = \"" . $T->CiaoEncode($T->CiaoDecode($mail['errors']) . $errors) . "\", offset = " . ($mail['offset'] + $this->BATCH) . " WHERE mail_id = " . $VARS['m'] . ";";
        mysql_query($query,$VARS['DB']);
        if($mail['sql_stmt'] != "")
        { $query = "SELECT COUNT(DISTINCT list.email_id) FROM " . $VARS['DB_TablePrefix'] . "_list AS list, " . $VARS['DB_TablePrefix'] . "_catlist AS catlist WHERE (list.email_id = catlist.email_id) AND " . $mail['sql_stmt'] . ";"; }
        else
        { $query = "SELECT COUNT(*) FROM " . $VARS['DB_TablePrefix'] . "_list;"; }
        $result = mysql_query($query,$VARS['DB']);
        list($totrec) = mysql_fetch_array($result,2);

        if($totrec == 0)
        { $totrec = 1; }

        $percent_finished = ceil((($mail['offset'] + $this->BATCH)/$totrec) * 100); #fixed error Ben Drushell 2000.12.22
        $percent_remain = 100 - $percent_finished;
?>
<html><head><title>send status</title>
<script language="JavaScript">
<!--
function MyReload()
{ location.reload(); }
// -->
</script>
</head>
<?
        if($reload)
        {
            echo "<body onLoad=\"MyReload()\">";
            echo "<h2 align=\"center\">SENDING TO LIST</h2>";
        }
        else
        {
            $query = "UPDATE " . $VARS['DB_TablePrefix'] . "_mail SET finish_dt = \"" . date("Y-m-d H:i:s") . "\", offset = " . $totrec . " WHERE mail_id = " . $VARS['m'] . ";";
            mysql_query($query,$VARS['DB']);
            echo "<body>";
            echo "<h2 align=\"center\">FINISHED SENDING</h2>";
        }
?>
<table border="1" width="100%"><tr>
<?
        if($percent_finished > 100)
        {
?>
<td align="center" bgcolor="#0000ff" width="100%">
<font color="#ffffff"><b>100%</b></font>
</td></tr></table>
</body>
</html>
<?
        }
        else
        {
?>
<td align="center" bgcolor="#0000ff" width="<?echo $percent_finished ?>%">
<font color="#ffffff"><b><?echo $percent_finished ?>%</b></font>
</td><td width="<?echo $percent_remain ?>%">&nbsp;</td>
</tr></table>
</body>
</html>
<?
        }
    }

    function HTML_PAUSE()
    { echo "\n<h2 align='center'>SENDING PAUSED</h2>"; }

    function HTML_TOOLBAR($VARS)
    {
?>
<html><head><title>toolbar</title></head>
<body>
<center>
<a href="ciaoadm.php4?u=<?echo urlencode($VARS['u']) ?>&p=<?echo urlencode($VARS['p']) ?>&x=m04&m=<?echo $VARS['m'] ?>&f_process=1&frame_PAUSE=1" target="SEND">(pause sending)</a>
&nbsp; &nbsp;
<?

echo "<a href=\"ciaoadm.php4?u=" . urlencode($VARS['u']) . "&p=" . urlencode($VARS['p']) . "&x=m04&m=" . $VARS['m'] . "&f_process=1&frame_SEND=1";
echo "&sendtype=" . $VARS['sendtype'];
if($VARS['replyto'])
{ echo "&replyto=" . urlencode($VARS['replyto']); }
if($VARS['charset'])
{ echo "&charset=" . urlencode($VARS['charset']); }
echo "\" target=\"SEND\">(continue sending)</a>\n";

?>
</center>
</body>
</html>
<?
    }

    function HTML_ERRORS($errors)
    { echo "\nERROR:<br> $errors <br>"; }

    function SEND_EMAIL($TO,$SUBJECT,$MESSAGE,$REPLYTO,$TYPE,$CFG,$CHARSET='iso-8859-1')
    {
        $error = "";
        $header = "From: <" . $CFG->email . ">\n";
        $header .= "Return-Path: <" . $CFG->email . ">\n";
        $header .= "Error-To: <" . $CFG->email . ">\n";
        if($REPLYTO)
        { $header .= "Reply-To: <" . $REPLYTO . ">\n"; }
        if($TYPE == "text")
        { $header .= "Content-Type: text/plain; charset=\"$CHARSET\"\n"; }
        elseif($TYPE == "html")
        {
            $header .= "MIME-Version: 1.0\n";
            $header .= "Content-Type: text/html; charset=\"$CHARSET\"\n";
            $header .= "Content-Transfer-Encoding: 8bit\n";
            $header .= "Content-Disposition: inline\n";
        }
        elseif($TYPE == "multi")
        {
            $header .= "MIME-Version: 1.0\n";
            $header .= "Content-Type: multipart/alternative; ";
            $header .= "boundary=\"----=_Ciao_EmailList_Manager.ContentBoundary\"\n";
        }
        mail("<" . $TO . ">",$SUBJECT,$MESSAGE,$header) or $error = "\n<br>Error Sending To: $TO";
        return($error);
    }

    function HTML_FRAMES($VARS)
    {
?>
<html>
<head><title></title></head>
<frameset rows="*,50">

<?
echo "<frame name=\"SEND\" src=\"ciaoadm.php4?u=" . urlencode($VARS['u']) . "&p=" . urlencode($VARS['p']) . "&m=" . $VARS['m'] . "&x=m04&f_process=1&frame_SEND=1";
echo "&sendtype=" . $VARS['sendtype'];
if($VARS['replyto'])
{ echo "&replyto=" . urlencode($VARS['replyto']); }
if($VARS['charset'])
{ echo "&charset=" . urlencode($VARS['charset']); }
echo "\">\n";

echo "<frame name=\"TOOLBAR\" src=\"ciaoadm.php4?u=" . urlencode($VARS['u']) . "&p=" . urlencode($VARS['p']) . "&m=" . $VARS['m'] . "&x=m04&f_process=1&frame_TOOLBAR=1";
echo "&sendtype=" . $VARS['sendtype'];
if($VARS['replyto'])
{ echo "&replyto=" . urlencode($VARS['replyto']); }
if($VARS['charset'])
{ echo "&charset=" . urlencode($VARS['charset']); }
echo "\">\n";

?>

</frameset>
</html>
<?
    }
}
