<?php
# Ciao EmailList Manager - a customizable mass e-mail program that is administrator/subscriber friendly.
# Copyright (C) 2000,2001 Benjamin Drushell
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful.
# There is NO WARRANTY.  NO implied warranty of MERCHANTABILITY.
# NO implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
# The entire risk is with you.
# See the GNU General Public License for more details.
#
# A copy of the GNU General Public License is included with this program.
#
# For questions regarding the Ciao EmailList Manager license,
# contact Ben Drushell: http://www.technobreeze.com/
#---------------------------------------------------------
# FILE: ciao_il.php4
# LOCAL VERSION: alpha 0.25
# CREATED ON: 10/30/2000
# CREATED BY: Ben Drushell - http://www.technobreeze.com/
# CONTRIBUTORS:
#(date - name - brief description of enhancement)
# 2000.12.22 - contributed in Perl by Bob Hurt & ported to PHP by BD - SENDMAIL and DIG validation routines
# 2000.12.23 - BD - email structure validation routine
# 2001.01.05 - BD - fixed VerifyFields variable error
# 2001.01.20 - BD - modifications for customizable sign-up verification message
# 2001.01.21 - Bret Chrismer - Discovered that popen command had not totally been ported from perl in SENDMAIL and DIG validation routines.
# 2001.01.29 - BD - modified code so "Subscribe" button is hidden when updating info
# 2001.01.30 - BD - modified for magic_quotes PHP settings
# 2001.02.09 - BD - added extra admin notification for editing and unsubscribing; added id field for email
# 2001.03.14 - BD - updated magic-quotes code to utilizing get_magic_quotes_gpc 3.0.6
# 2001.03.21 - BD - added default value capability for optional subscriber data
# 2001.04.05 - BD - modified to "member area"... added passwords...
# 2001.04.13 - BD - removed ending '|' pipe on dig command
# 2001.05.10 - BD - fixed the form not displaying bug by declaring $REMOTE_ADDR as global
# 2001.05.18 - BD - fixed the admin link/ data update problem
# 2001.05.19 - BD - delete (unsubscribe) now requires password, if passwords are being used
# 2001.05.19 - BD - added "category" variable input, so people can tie a template to a category
# 2001.05.20 - BD - Admin notification now contains categories subscribed info
# 2001.05.22 - BD - Added "return-path" field to email headers sent
# 2001.05.22 - BD - added php-include header/footer file capability
# 2001.05.31 - BD - added xml tags for lblRequired and lblOptional to replace hard-text "required" and "optional"
# 2001.06.13 - BD - added "unsubscribe all" button/function for when category-templates are applied
# 2001.06.13 - BD - added code to lower case all email addresses
# 2001.06.16 - BD - added multiple field type capabilities
#
# 2001.07.05 - BD - Added code for "ALL" category.
#---------------------------------------------------------
?>

<?php
class PWmod
{
    function Verify(&$VARS,$T,$CFG,$xml)
    {
        $query = "DELETE FROM " . $VARS['DB_TablePrefix'] . "_publicsession WHERE status_dt < \"" . date("Y-m-d H:i:s",(time()-21600)) . "\";";
        mysql_query($query,$VARS['DB']);

        # REMOVE EXPIRED VERIFICATIONS
        $query = "DELETE FROM " . $VARS['DB_TablePrefix'] . "_verify WHERE signup_dt < \"" . date("Y-m-d H:i:s",(time() - 1036800)) . "\";";
        mysql_query($query,$VARS['DB']);

        global $REMOTE_ADDR;
        $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_block WHERE block_value LIKE \"%" . $T->CiaoEncode($REMOTE_ADDR) . "%\";";
        $result = mysql_query($query,$VARS['DB']);
        if(($row = mysql_fetch_array($result,1)) && ($REMOTE_ADDR != ''))
        { die($VARS['html_end']); } # user blocked
        elseif(! file_exists("ciaocredits.html"))
        { die("<h1 align='center'>setup incomplete</h1>" . $VARS['html_end']); }
        elseif($VARS['logout'] != '')
        {
            $query = "DELETE FROM " . $VARS['DB_TablePrefix'] . "_publicsession WHERE session_id = \"" . $VARS['p'] . "\";";
            mysql_query($query,$VARS['DB']);
            $VARS['p'] = '';
            $VARS['f_EMAIL'] = "";
            $VARS['f_PASSWORD'] = "";
            for($counter=1;$counter <= $CFG->optSize;$counter++)
            { $VARS['f_OPTION' . $counter] = ""; }
            $this->showForm("\n" . $xml['okLogout'] . "\n",$VARS,$CFG,$T,$xml);
            if(file_exists($xml['footer']))
            { include($xml['footer']); }
            else
            { echo $VARS['html_end']; }
            die("");
        }
        elseif($VARS['v'] != '')
        {# VERIFY LINK ID AND TRANSFER TO LIST
            $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_verify WHERE verify_id = \"" . $VARS['v'] . "\";";
            $result = mysql_query($query,$VARS['DB']);
            if($row = mysql_fetch_array($result,1))
            {
                $VARS['x'] = "il";
                $VARS['p'] = $T->GenerateID(32);
                $VARS['user_id'] = $row['email_id'];
                $query = "INSERT INTO " . $VARS['DB_TablePrefix'] . "_publicsession VALUES(\"" . $VARS['p'] .  "\",\"" . $VARS['user_id'] . "\",\"" . date("Y-m-d H:i:s") . "\");";
                mysql_query($query,$VARS['DB']);

                $VARS['f_EMAIL'] = $T->CiaoDecode($row['email_id']);
                $VARS['f_PASSWORD'] = $T->CiaoDecode($row['password']);

                if(strlen($VARS['category']) > 0)
                {
                    $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list WHERE email_id = \"" . $VARS['user_id'] . "\"";
                    $result = mysql_query($query,$VARS['DB']);
                    if(! ($alreadyinlist = mysql_fetch_array($result,1)))
                    { # add to list
                        $query = "INSERT INTO " . $VARS['DB_TablePrefix'] . "_list VALUES(\"" . $row['email_id'] . "\",\"" . $row['password'] . "\",\"" . $row['signup_dt'] . "\"";
                        for($counter=1;$counter <= $CFG->optSize;$counter++)
                        {
                            $query .= ",\"" . $row['option' . $counter] . "\"";
                            if($CFG->optType[$counter] != 'checkbox')
                            { $VARS['f_OPTION' . $counter] = $T->CiaoDecode($row['option' . $counter]); }
                        }
                        $query .= ");";
                        mysql_query($query,$VARS['DB']);
                    }

                    $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_category WHERE cat_id = \"" . addslashes($VARS['category']) . "\"";
                    $result = mysql_query($query,$VARS['DB']);
                    if($category = mysql_fetch_array($result,1))
                    { # if category exists add to that category
                        $query = "INSERT INTO " . $VARS['DB_TablePrefix'] . "_catlist VALUES(\"" . $VARS['user_id'] . "\",\"" . addslashes($VARS['category']) . "\");";
                        mysql_query($query,$VARS['DB']);
                    }

                    if($CFG->notifyonverify)
                    { $this->NotifyAdmin($VARS,$CFG,$T,"NEW SUBSCRIBER TO CATEGORY -" . addslashes($VARS['category']) . "-"); }
                }
                else
                { # just add to list
                    $query = "INSERT INTO " . $VARS['DB_TablePrefix'] . "_list VALUES(\"" . $row['email_id'] . "\",\"" . $row['password'] . "\",\"" . $row['signup_dt'] . "\"";
                    for($counter=1;$counter <= $CFG->optSize;$counter++)
                    {
                        $query .= ",\"" . $row['option' . $counter] . "\"";
                        if($CFG->optType[$counter] != 'checkbox')
                        { $VARS['f_OPTION' . $counter] = $T->CiaoDecode($row['option' . $counter]); }
                    }
                    $query .= ");";
                    mysql_query($query,$VARS['DB']);

                    if($CFG->notifyonverify)
                    { $this->NotifyAdmin($VARS,$CFG,$T,"NEW SUBSCRIBER"); }
                }
                $query = "INSERT INTO " . $VARS['DB_TablePrefix'] . "_catlist VALUES(\"" . $VARS['user_id'] . "\",\"ALL\");";
                mysql_query($query,$VARS['DB']);

                $this->showNavigation($VARS,$xml);
                $this->showForm("\n" . $xml['okVerify'] . "\n",$VARS,$CFG,$T,$xml,1);
                $query = "DELETE FROM " . $VARS['DB_TablePrefix'] . "_verify WHERE verify_id = \"" . $VARS['v'] . "\";";
                mysql_query($query,$VARS['DB']);
                if(file_exists($xml['footer']))
                { include($xml['footer']); }
                else
                { echo $VARS['html_end']; }
                die("");
            }
            else
            {
                $this->showForm("\n" . $xml['errVerify'] . "\n",$VARS,$CFG,$T,$xml);
                if(file_exists($xml['footer']))
                { include($xml['footer']); }
                else
                { echo $VARS['html_end']; }
                die("");
            }
        }
        elseif($VARS['f_btnADD'] != '')
        {
            if($VARS['f_PASSWORD'] == '')
            { $VARS['f_PASSWORD'] = 'changethis'; }

            $verify = $this->VerifyFields($xml,$VARS,$CFG,$T);
            if($verify == 0)
            {
                $ID = $T->GenerateID(32);
                $query = "INSERT INTO " . $VARS['DB_TablePrefix'] . "_verify VALUES(";
                $query .= "\"" . $ID . "\"";
                $query .= ",\"" . $T->CiaoEncode(strtolower($VARS['f_EMAIL'])) . "\"";
                $query .= ",\"" . $T->CiaoEncode($VARS['f_PASSWORD']) . "\"";
                $query .= ",\"" . date("Y-m-d H:i:s") . "\"";
                for($i = 1; $i <= $CFG->optSize; $i++)
                { $query .= ",\"" . $T->CiaoEncode($VARS['f_OPTION' . $i]) . "\""; }
                $query .= ");";
                mysql_query($query,$VARS['DB']);
                $VARS['msgSignup'] = $xml['msgSignup'];
                $this->SendVerify($VARS,$CFG,$ID);
                if($CFG->notifyonrequest)
                { $this->NotifyAdmin($VARS,$CFG,$T,"SUBSCRIBER VERIFICATION PENDING"); }
                $this->showForm("\n" . $xml['okAdd'] . "\n",$VARS,$CFG,$T,$xml);
                if(file_exists($xml['footer']))
                { include($xml['footer']); }
                else
                { echo $VARS['html_end']; }
                die("");
            }
            elseif($verify == 1)
            {
                $this->showForm("\n" . $xml['errRequired'] . "\n",$VARS,$CFG,$T,$xml);
                if(file_exists($xml['footer']))
                { include($xml['footer']); }
                else
                { echo $VARS['html_end']; }
                die("");
            }
            elseif($verify == 2)
            {
                $this->showForm("\n" . $xml['errAddVerify'] . "\n",$VARS,$CFG,$T,$xml);
                if(file_exists($xml['footer']))
                { include($xml['footer']); }
                else
                { echo $VARS['html_end']; }
                die("");
            }
            elseif($verify == 3)
            {
                if(strlen($VARS['category']) > 0)
                {
                    $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_catlist WHERE email_id = \"" . $T->CiaoEncode($VARS['f_EMAIL']) . "\" AND cat_id = \"" . addslashes($VARS['category']) . "\";";
                    $result = mysql_query($query,$VARS['DB']);
                    if($isalreadyincategory = mysql_fetch_array($result,1))
                    {
                        $this->showForm("\n" . $xml['errAddList'] . "\n",$VARS,$CFG,$T,$xml);
                        if(file_exists($xml['footer']))
                        { include($xml['footer']); }
                        else
                        { echo $VARS['html_end']; }
                        die("");
                    }
                    else
                    {
                        $ID = $T->GenerateID(32);
                        $query = "INSERT INTO " . $VARS['DB_TablePrefix'] . "_verify VALUES(";
                        $query .= "\"" . $ID . "\"";
                        $query .= ",\"" . $T->CiaoEncode($VARS['f_EMAIL']) . "\"";
                        $query .= ",\"" . $T->CiaoEncode($VARS['f_PASSWORD']) . "\"";
                        $query .= ",\"" . date("Y-m-d H:i:s") . "\"";
                        for($i = 1; $i <= $CFG->optSize; $i++)
                        { $query .= ",\"" . $T->CiaoEncode($VARS['f_OPTION' . $i]) . "\""; }
                        $query .= ");";
                        mysql_query($query,$VARS['DB']);
                        $VARS['msgSignup'] = $xml['msgSignup'];
                        $this->SendVerify($VARS,$CFG,$ID);
                        if($CFG->notifyonrequest)
                        { $this->NotifyAdmin($VARS,$CFG,$T,"SUBSCRIBER VERIFICATION PENDING"); }
                        $this->showForm("\n" . $xml['okAdd'] . "\n",$VARS,$CFG,$T,$xml);
                        if(file_exists($xml['footer']))
                        { include($xml['footer']); }
                        else
                        { echo $VARS['html_end']; }
                        die("");
                    }
                }
                else
                {
                    $this->showForm("\n" . $xml['errAddList'] . "\n",$VARS,$CFG,$T,$xml);
                    if(file_exists($xml['footer']))
                    { include($xml['footer']); }
                    else
                    { echo $VARS['html_end']; }
                    die("");
                }
            }
            elseif($verify == 5) # 4 means blocked... don't display
            {
                $this->showForm("\n" . $xml['errAddEmail'] . "\n",$VARS,$CFG,$T,$xml);
                if(file_exists($xml['footer']))
                { include($xml['footer']); }
                else
                { echo $VARS['html_end']; }
                die("");
            }
            else # 4 means blocked... don't display
            {
                if(file_exists($xml['footer']))
                { include($xml['footer']); }
                else
                { echo $VARS['html_end']; }
                die("");
            }
        }
        elseif(($VARS['f_btnFIND'] != '') && ($VARS['f_EMAIL'] != ''))
        {
            $rEmail = $T->CiaoEncode($VARS['f_EMAIL']);
            $lEmail = $T->CiaoEncode(strtolower($VARS['f_EMAIL']));

            if($CFG->usepassword)
            { $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list WHERE (email_id = \"" . $lEmail . "\" OR email_id = \"" . $rEmail . "\") AND password = \"" . $T->CiaoEncode($VARS['f_PASSWORD']) . "\";"; }
            else
            { $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list WHERE (email_id = \"" . $lEmail . "\" OR email_id = \"" . $rEmail . "\");"; }
            $result = mysql_query($query,$VARS['DB']);
            if($row = mysql_fetch_array($result,1))
            {
                $VARS['p'] = $T->GenerateID(32);
                $VARS['user_id'] = $row['email_id'];
                $query = "INSERT INTO " . $VARS['DB_TablePrefix'] . "_publicsession VALUES(\"" . $VARS['p'] .  "\",\"" . $VARS['user_id'] . "\",\"" . date("Y-m-d H:i:s") . "\");";
                mysql_query($query,$VARS['DB']);

                for($counter=1;$counter <= $CFG->optSize;$counter++)
                {
                    if($CFG->optType[$counter] != 'checkbox')
                    { $VARS['f_OPTION' . $counter] = $T->CiaoDecode($row['option' . $counter]); }
                }
                $this->showNavigation($VARS,$xml);
                $this->showForm("\n" . $xml['okFind'] . "\n",$VARS,$CFG,$T,$xml,1);
                if(file_exists($xml['footer']))
                { include($xml['footer']); }
                else
                { echo $VARS['html_end']; }
                die("");
            }
            else
            {
                $this->showForm("\n" . $xml['errFind'] . "\n",$VARS,$CFG,$T,$xml);
                if(file_exists($xml['footer']))
                { include($xml['footer']); }
                else
                { echo $VARS['html_end']; }
                die("");
            }
        }
        elseif(($VARS['f_btnDELETECAT'] != '') && ($VARS['f_EMAIL'] != ''))
        {
            $rEmail = $T->CiaoEncode($VARS['f_EMAIL']);
            $lEmail = $T->CiaoEncode(strtolower($VARS['f_EMAIL']));

            if($CFG->usepassword)
            { $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list WHERE (email_id = \"" . $lEmail . "\" OR email_id = \"" . $rEmail . "\") AND password = \"" . $T->CiaoEncode($VARS['f_PASSWORD']) . "\";"; }
            else
            { $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list WHERE (email_id = \"" . $lEmail . "\" OR email_id = \"" . $rEmail . "\");"; }
            $result = mysql_query($query,$VARS['DB']);
            if($row = mysql_fetch_array($result,1))
            {
                $delete = 0;
                if(strlen($VARS['category'])>0)
                {
                    $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_catlist WHERE cat_id = \"" . addslashes($VARS['category']) . "\";";
                    $result = mysql_query($query,$VARS['DB']);
                    if($categoryfound = mysql_fetch_array($result,1))
                    {
                        $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_catlist WHERE (email_id = \"" . $lEmail . "\" OR email_id = \"" . $rEmail . "\");";
                        $result = mysql_query($query,$VARS['DB']);
                        if(mysql_num_rows($result) > 2)
                        {
                            $query = "DELETE FROM " . $VARS['DB_TablePrefix'] . "_catlist WHERE (email_id = \"" . $lEmail . "\" OR email_id = \"" . $rEmail . "\") AND cat_id = \"" . addslashes($VARS['category']) . "\";";
                            mysql_query($query,$VARS['DB']);
                            if($CFG->notifyonedit)
                            { $this->NotifyAdmin($VARS,$CFG,$T,"SUBSCRIBER RECORD UPDATED"); }
                        }
                        else
                        { $delete = 1; }
                    }
                    else
                    {
                        $this->showForm("\n" . $xml['errFind'] . "\n",$VARS,$CFG,$T,$xml);
                        if(file_exists($xml['footer']))
                        { include($xml['footer']); }
                        else
                        { echo $VARS['html_end']; }
                        die("");
                    }
                }
                else
                { $delete = 1; }

                if($delete > 0)
                {
                    for($counter=1;$counter <= $CFG->optSize;$counter++)
                    {
                        if($CFG->optType[$counter] != 'checkbox')
                        { $VARS['f_OPTION' . $counter] = $T->CiaoDecode($row['option' . $counter]); }
                    }

                    $query = "DELETE FROM " . $VARS['DB_TablePrefix'] . "_list WHERE (email_id = \"" . $lEmail . "\" OR email_id = \"" . $rEmail . "\");";
                    mysql_query($query,$VARS['DB']);
                    $query = "DELETE FROM " . $VARS['DB_TablePrefix'] . "_catlist WHERE (email_id = \"" . $lEmail . "\" OR email_id = \"" . $rEmail . "\");";
                    mysql_query($query,$VARS['DB']);
                    if($CFG->notifyondelete)
                    { $this->NotifyAdmin($VARS,$CFG,$T,"SUBSCRIBER RECORD DELETED"); }
                }
                $this->showForm("\n" . $xml['okDelete'] . "\n",$VARS,$CFG,$T,$xml);
                if(file_exists($xml['footer']))
                { include($xml['footer']); }
                else
                { echo $VARS['html_end']; }
                die("");
            }
            else
            {
                $this->showForm("\n" . $xml['errFind'] . "\n",$VARS,$CFG,$T,$xml);
                if(file_exists($xml['footer']))
                { include($xml['footer']); }
                else
                { echo $VARS['html_end']; }
                die("");
            }
        }
        elseif(($VARS['f_btnDELETE'] != '') && ($VARS['f_EMAIL'] != ''))
        {
            $rEmail = $T->CiaoEncode($VARS['f_EMAIL']);
            $lEmail = $T->CiaoEncode(strtolower($VARS['f_EMAIL']));

            if($CFG->usepassword)
            { $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list WHERE (email_id = \"" . $lEmail . "\" OR email_id = \"" . $rEmail . "\") AND password = \"" . $T->CiaoEncode($VARS['f_PASSWORD']) . "\";"; }
            else
            { $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list WHERE (email_id = \"" . $lEmail . "\" OR email_id = \"" . $rEmail . "\");"; }
            $result = mysql_query($query,$VARS['DB']);
            if($row = mysql_fetch_array($result,1))
            {
                for($counter=1;$counter <= $CFG->optSize;$counter++)
                {
                    if($CFG->optType[$counter] != 'checkbox')
                    { $VARS['f_OPTION' . $counter] = $T->CiaoDecode($row['option' . $counter]); }
                }

                $query = "DELETE FROM " . $VARS['DB_TablePrefix'] . "_list WHERE (email_id = \"" . $lEmail . "\" OR email_id = \"" . $rEmail . "\");";
                mysql_query($query,$VARS['DB']);
                $query = "DELETE FROM " . $VARS['DB_TablePrefix'] . "_catlist WHERE (email_id = \"" . $lEmail . "\" OR email_id = \"" . $rEmail . "\");";
                mysql_query($query,$VARS['DB']);
                if($CFG->notifyondelete)
                { $this->NotifyAdmin($VARS,$CFG,$T,"SUBSCRIBER RECORD DELETED"); }

                $this->showForm("\n" . $xml['okDelete'] . "\n",$VARS,$CFG,$T,$xml);
                if(file_exists($xml['footer']))
                { include($xml['footer']); }
                else
                { echo $VARS['html_end']; }
                die("");
            }
            else
            {
                $this->showForm("\n" . $xml['errFind'] . "\n",$VARS,$CFG,$T,$xml);
                if(file_exists($xml['footer']))
                { include($xml['footer']); }
                else
                { echo $VARS['html_end']; }
                die("");
            }
        }
        elseif($VARS['f'] != '')
        {
            $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list WHERE email_id = \"" . $VARS['f'] . "\" AND password = \"" . $VARS['fp'] . "\";";
            $result = mysql_query($query,$VARS['DB']);
            if($row = mysql_fetch_array($result,1))
            {
                $VARS['p'] = $T->GenerateID(32);
                $VARS['user_id'] = $row['email_id'];
                $query = "INSERT INTO " . $VARS['DB_TablePrefix'] . "_publicsession VALUES(\"" . $VARS['p'] .  "\",\"" . $VARS['user_id'] . "\",\"" . date("Y-m-d H:i:s") . "\");";
                mysql_query($query,$VARS['DB']);

                $VARS['f_EMAIL'] = $T->CiaoDecode($row['email_id']);
                $VARS['f_PASSWORD'] = $T->CiaoDecode($row['password']);
                for($counter=1;$counter <= $CFG->optSize;$counter++)
                {
                    if($CFG->optType[$counter] != 'checkbox')
                    { $VARS['f_OPTION' . $counter] = $T->CiaoDecode($row['option' . $counter]); }
                }
                $this->showForm("\n" . $xml['okFind'] . "\n",$VARS,$CFG,$T,$xml,1);
                if(file_exists($xml['footer']))
                { include($xml['footer']); }
                else
                { echo $VARS['html_end']; }
                die("");
            }
            else
            {
                $this->showForm("\n" . $xml['errFind'] . "\n",$VARS,$CFG,$T,$xml);
                if(file_exists($xml['footer']))
                { include($xml['footer']); }
                else
                { echo $VARS['html_end']; }
                die("");
            }
        }
        elseif($CFG->usepassword && $VARS['f_btnPASSWORD'] != '')
        {
            $rEmail = $T->CiaoEncode($VARS['f_EMAIL']);
            $lEmail = $T->CiaoEncode(strtolower($VARS['f_EMAIL']));

            $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list WHERE (email_id = \"" . $lEmail . "\" OR email_id = \"" . $rEmail . "\");";
            $result = mysql_query($query,$VARS['DB']);
            if($row = mysql_fetch_array($result,1))
            { $this->SendPassword($VARS,$CFG,$xml,$T->CiaoDecode($row['password'])); }
            $this->showForm("\n" . $xml['okPassword'] . "\n",$VARS,$CFG,$T,$xml);
            if(file_exists($xml['footer']))
            { include($xml['footer']); }
            else
            { echo $VARS['html_end']; }
            die("");
        }
        elseif(! file_exists("gpl.txt"))
        {
            echo "<h1 align='center'>setup incomplete</h1>";
            if(file_exists($xml['footer']))
            { include($xml['footer']); }
            else
            { echo $VARS['html_end']; }
            die("");
        }
        elseif ($VARS['p'] != '')
        {
            $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_publicsession WHERE session_id = \"" . $VARS['p'] . "\";";
            $result = mysql_query($query,$VARS['DB']);
            if($row = mysql_fetch_array($result,1))
            {
                $VARS['user_id'] = $row['user_id'];
                $query = "UPDATE " . $VARS['DB_TablePrefix'] . "_publicsession SET status_dt = \"" . date("Y-m-d H:i:s") . "\" WHERE session_id = \"" . $VARS['p'] . "\";";
                mysql_query($query,$VARS['DB']);
                if($VARS['frame'] == '')
                { $this->showNavigation($VARS,$xml); }
                if(($VARS['f_btnUPDATE'] != '') && ($VARS['f_EMAIL'] != '') && (($VARS['f_PASSWORD'] != '' && $CFG->usepassword) || (! $CFG->usepassword)))
                {
                    $rEmail = $T->CiaoEncode($VARS['f_EMAIL']);
                    $lEmail = $T->CiaoEncode(strtolower($VARS['f_EMAIL']));

                    $verify = $this->VerifyFields($xml,$VARS,$CFG,$T);
                    if($verify != 1)
                    {
                        if($CFG->usepassword)
                        { $setpassword = "password = \"" . $T->CiaoEncode($VARS['f_PASSWORD']) . "\", "; }
                        $query = "UPDATE " . $VARS['DB_TablePrefix'] . "_list SET " . $setpassword . "option1 = \"" . $T->CiaoEncode($VARS['f_OPTION1']) . "\"";
                        for($counter=2;$counter <= $CFG->optSize;$counter++)
                        { $query .= ", option" . $counter . " = \"" . $T->CiaoEncode($VARS['f_OPTION' . $counter]) . "\""; }
                        $query .= " WHERE (email_id = \"" . $lEmail . "\" OR email_id = \"" . $rEmail . "\");";
                        mysql_query($query,$VARS['DB']);
                        $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_category;";
                        $result = mysql_query($query,$VARS['DB']);
                        while($row = mysql_fetch_array($result,1))
                        {
                            if(($VARS['f_' . $row['cat_id']] != '') && ($VARS['f_' . $row['cat_id'] . '_old'] == ''))
                            { # ADD TO NEW CATEGORY
                                $query = "INSERT INTO " . $VARS['DB_TablePrefix'] . "_catlist VALUES(\"" . $lEmail . "\",\"" . $row['cat_id'] . "\");";
                                mysql_query($query,$VARS['DB']);
                            }
                            elseif(($VARS['f_' . $row['cat_id']] == '') && ($VARS['f_' . $row['cat_id'] . '_old'] != ''))
                            { # REMOVE FROM CATEGORY
                                $query = "DELETE FROM " . $VARS['DB_TablePrefix'] . "_catlist WHERE (email_id = \"" . $lEmail . "\" OR email_id = \"" . $rEmail . "\") AND cat_id = \"" . $row['cat_id'] . "\";";
                                mysql_query($query,$VARS['DB']);
                            }
                        }
                        if($CFG->notifyonedit)
                        { $this->NotifyAdmin($VARS,$CFG,$T,"SUBSCRIBER RECORD UPDATED"); }
                        $this->showForm("\n" . $xml['okUpdate'] . "\n",$VARS,$CFG,$T,$xml,1);
                        if(file_exists($xml['footer']))
                        { include($xml['footer']); }
                        else
                        { echo $VARS['html_end']; }
                        die("");
                    }
                    elseif($verify == 1)
                    {
                        $this->showForm("\n" . $xml['errRequired'] . "\n",$VARS,$CFG,$T,$xml,1);
                        if(file_exists($xml['footer']))
                        { include($xml['footer']); }
                        else
                        { echo $VARS['html_end']; }
                        die("");
                    }
                }
                elseif($VARS['x'] == 'il') # display profile
                {
                    $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list WHERE email_id = \"" . $VARS['user_id'] . "\";";
                    $result = mysql_query($query,$VARS['DB']);
                    if($row = mysql_fetch_array($result,1))
                    {
                        $VARS['f_EMAIL'] = $T->CiaoDecode($row['email_id']);
                        for($counter=1;$counter <= $CFG->optSize;$counter++)
                        {
                            if($CFG->optType[$counter] != 'checkbox')
                            { $VARS['f_OPTION' . $counter] = $T->CiaoDecode($row['option' . $counter]); }
                        }
                    }
                    $this->showForm("",$VARS,$CFG,$T,$xml,1);
                    if(file_exists($xml['footer']))
                    { include($xml['footer']); }
                    else
                    { echo $VARS['html_end']; }
                    die("");
                }
            }
            else
            {
                $this->showForm("",$VARS,$CFG,$T,$xml);
                if(file_exists($xml['footer']))
                { include($xml['footer']); }
                else
                { echo $VARS['html_end']; }
                die("");
            }
        }
        else
        {
            $this->showForm("",$VARS,$CFG,$T,$xml);
            if(file_exists($xml['footer']))
            { include($xml['footer']); }
            else
            { echo $VARS['html_end']; }
            die("");
        }
    }

    function showForm($message,$VARS,$CFG,$T,$xml,$ShowCategories=0)
    {
        if(strlen($xml['lblRequired']) <= 0)
        { $xml['lblRequired'] = "required"; }
        if(strlen($xml['lblOptional']) <= 0)
        { $xml['lblOptional'] = "optional"; }

        $f_EMAIL = ereg_replace("[[:space:]]","",$this->SECURE_FIELD($f_EMAIL));
        for($i=1;$i <= $CFG->optSize;$i++)
        { $VARS['txtOPTION' . $i] = $this->SECURE_FIELD($VARS['f_OPTION' . $i]); }
?>

<form method="post" action="ciao.php4">
<?
        if($VARS['p'] != '')
        { echo "\n<input type='hidden' name='p' value='" . $VARS['p'] . "'>\n"; }
        echo "\n<input type='hidden' name='x' value='xl'>\n";
        if($VARS['template'] != '')
        { echo "\n<input type='hidden' name='template' value='" . $VARS['template'] . "'>\n"; }
        if($VARS['category'] != '')
        { echo "\n<input type='hidden' name='category' value='" . $VARS['category'] . "'>\n"; }
?>
<table bgcolor="<?echo $xml['rgbBackground'] ?>" cellpadding="5" cellspacing="0" border="1">
<tr><td colspan="2" align="center"><font face="<?echo $xml['fontFace'] ?>" color="<?echo $xml['rgbText'] ?>">
<big><?echo $xml['txtTitle'] ?></big>
</font></td></tr>

<tr><td colspan="2" align="center" bgcolor="<?echo $xml['rgbText'] ?>">
<font face="<?echo $xml['fontFace'] ?>" color="<?echo $xml['rgbBackground'] ?>"><b>

<?echo $message ?>

</b></font></td></tr>

<tr><td colspan="2" align="center"><font face="<?echo $xml['fontFace'] ?>" color="<?echo $xml['rgbText'] ?>">
<?echo $xml['txtPrompt'] ?>
<input TYPE="TEXT" NAME="f_EMAIL" VALUE="<?echo $VARS['f_EMAIL'] ?>" SIZE="20" MAXLENGTH="125">
</font></td></tr>

<?
        if($CFG->usepassword)
        {
?>
<tr><td><font face="<?echo $xml['fontFace'] ?>" color="<?echo $xml['rgbText'] ?>" size="-1">
<?echo $xml['txtPassword'] ?>(<?echo $xml['lblRequired'] ?>)
</font></td><td>
<input TYPE="password" NAME="f_PASSWORD" VALUE="<?echo $VARS['f_PASSWORD'] ?>" SIZE="25" MAXLENGTH="25">
</td></tr>
<?
        }

        for($counter=1;$counter <= $CFG->optSize;$counter++)
        {
            if($CFG->optReq[$counter] != 'n')
            {
?>
<tr><td width="50%">
<font face="<?echo $xml['fontFace'] ?>" color="<?echo $xml['rgbText'] ?>" size="-1">
<?
                echo $CFG->optName[$counter] . ":";
                if($CFG->optReq[$counter] == 'r')
                { echo "(" . $xml['lblRequired'] . ")"; }
                else
                { echo "(" . $xml['lblOptional'] . ")"; }
                if(strlen($VARS['f_OPTION' . $counter]) == 0)
                {
                    if($CFG->optType[$counter] != 'checkbox')
                    { $VARS['f_OPTION' . $counter] = $CFG->optDefault[$counter]; }
                }
?>
</font></td>
<td align="center" width="50%">
<font face="<?echo $xml['fontFace'] ?>" color="<?echo $xml['rgbText'] ?>" size="-1">
<?
                if($CFG->optType[$counter] == 'select')
                {
?>
<SELECT NAME="f_OPTION<?echo $counter ?>">
<?
                    for($token=strtok($CFG->optDefault[$counter],";"); $token != ''; $token = strtok(";"))
                    {
                        if($VARS['f_OPTION' . $counter] == $token)
                        { $selected = "SELECTED"; }
                        else
                        { $selected = ""; }

?>

<OPTION VALUE="<?echo $token ?>" <?echo $selected ?>><?echo $token ?>

<?
                    }
?>
</SELECT>
<?
                }
                elseif($CFG->optType[$counter] == 'radio')
                {
                    $first = 1;
                    for($token=strtok($CFG->optDefault[$counter],";"); $token != ''; $token = strtok(";"))
                    {
                        if($VARS['f_OPTION' . $counter] == $token)
                        { $selected = "CHECKED"; }
                        elseif(($VARS['f_OPTION' . $counter] == $CFG->optDefault[$counter]) && $first)
                        {
                            $selected = "CHECKED";
                            $first = 0;
                        }
                        else
                        { $selected = ""; }
?>

(<INPUT TYPE="radio" NAME="f_OPTION<?echo $counter ?>" VALUE="<?echo $token ?>" <?echo $selected ?>><?echo $token ?>)

<?
                    }
                }
                elseif($CFG->optType[$counter] == 'checkbox')
                {
                    if($VARS['f_OPTION' . $counter] == $CFG->optDefault[$counter])
                    { $checked = "CHECKED"; }
                    else
                    { $checked = ""; }
?>

<INPUT TYPE="CHECKBOX" NAME="f_OPTION<?echo $counter ?>" VALUE="<?echo $CFG->optDefault[$counter] ?>" <?echo $checked ?>>

<?
                }
                else
                {
?>

<INPUT TYPE="TEXT" NAME="f_OPTION<?echo $counter ?>" VALUE="<?echo $VARS['f_OPTION' . $counter] ?>" SIZE="25" MAXLENGTH="125">

<?
                }
?>
</font>
</td></tr>
<?
            }
        }
        if($ShowCategories && ($VARS['category'] == ''))
        {
            $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_category;";
            $result = mysql_query($query,$VARS['DB']);
            if(mysql_num_rows($result) > 1)
            {
?>
<tr><td colspan="2" align="center"><font face="<?echo $xml['fontFace'] ?>" color="<?echo $xml['rgbText'] ?>">
<?echo $xml['txtCategory'] ?>
</font></td></tr>
<?
                while($row = mysql_fetch_array($result,1))
                {
                    if($row['cat_id'] == "ALL")
                    { $row = mysql_fetch_array($result,1); }
                    if($row['cat_id'] != "")
                    {
?>
<tr><td width="50%"><font face="<?echo $xml['fontFace'] ?>" color="<?echo $xml['rgbText'] ?>">
<?
                        $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_catlist WHERE cat_id = \"" . $row['cat_id'] . "\" AND email_id = \"" . $T->CiaoEncode($VARS['f_EMAIL']) . "\";";
                        $incatlist = mysql_query($query,$VARS['DB']);
                        if($true = mysql_fetch_array($incatlist,1))
                        {
?>
<input type="hidden" name="f_<?echo $row['cat_id'] ?>_old" value="1">
<input type="checkbox" name="f_<?echo $row['cat_id'] ?>" value="1" CHECKED>
<?
                        }
                        else
                        {
?>
<input type="checkbox" name="f_<?echo $row['cat_id'] ?>" value="1">
<?
                        }
                        echo $row['cat_name'];
?>
</font></td><td width="50%"><font face="<?echo $xml['fontFace'] ?>" color="<?echo $xml['rgbText'] ?>">
<?
                        $row = mysql_fetch_array($result,1);
                        if($row['cat_id'] == "ALL")
                        { $row = mysql_fetch_array($result,1); }
                        if($row['cat_id'] != "")
                        {
                            $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_catlist WHERE cat_id = \"" . $row['cat_id'] . "\" AND email_id = \"" . $T->CiaoEncode($VARS['f_EMAIL']) . "\";";
                            $incatlist = mysql_query($query,$VARS['DB']);
                            if($true = mysql_fetch_array($incatlist,1))
                            {
?>
<input type="hidden" name="f_<?echo $row['cat_id'] ?>_old" value="1">
<input type="checkbox" name="f_<?echo $row['cat_id'] ?>" value="1" CHECKED>
<?
                            }
                            else
                            {
?>
<input type="checkbox" name="f_<?echo $row['cat_id'] ?>" value="1">
<?
                            }
                            echo $row['cat_name'];
                        }
                        echo "&nbsp;</font></td></tr>";
                    }
                }
            }
        }

?>
<tr><td align="center" colspan="2"><font face="<?echo $xml['fontFace'] ?>" color="<?echo $xml['rgbText'] ?>" size="-1">
<?echo $xml['txtInstructions'] ?>
</font></td></tr>
<tr><td align="center" colspan="2">
<font face="<?echo $xml['fontFace'] ?>" color="<?echo $xml['rgbText'] ?>">
<?
        if(strlen($xml['btnAdd']) <= 0)
        { $xml['btnAdd'] = "Subscribe"; }
        if(strlen($xml['btnDelete']) <= 0)
        { $xml['btnDelete'] = "Unsubscribe"; }
        if(strlen($xml['btnDeleteCat']) <= 0)
        { $xml['btnDeleteCat'] = "Unsubscribe from Category"; }
        if(strlen($xml['btnFind']) <= 0)
        { $xml['btnFind'] = "Logout"; }
        if(strlen($xml['btnUpdate']) <= 0)
        { $xml['btnUpdate'] = "Update Info"; }
        if(strlen($xml['txtLogout']) <= 0)
        { $xml['txtLogout'] = "Logout"; }
        if(strlen($xml['btnPassword']) <= 0)
        { $xml['btnPassword'] = "Forgot Password"; }

        if(! $ShowCategories)
        { echo "<input TYPE=\"SUBMIT\" NAME=\"f_btnADD\" VALUE=\"" . $xml['btnAdd'] . "\">"; }
        echo "<input TYPE=\"SUBMIT\" NAME=\"f_btnDELETE\" VALUE=\"" . $xml['btnDelete'] . "\">";
        if(strlen($VARS['category']) > 0)
        { echo "<input TYPE=\"SUBMIT\" NAME=\"f_btnDELETECAT\" VALUE=\"" . $xml['btnDeleteCat'] . "\">"; }
        if($v == '' && $p == '' && $ShowCategories == '')
        { echo "<input TYPE=\"SUBMIT\" NAME=\"f_btnFIND\" VALUE=\"" . $xml['btnFind'] . "\">"; }

        if($ShowCategories)
        {
            echo "<input TYPE=\"SUBMIT\" NAME=\"f_btnUPDATE\" VALUE=\"" . $xml['btnUpdate'] . "\">";
            echo "<input TYPE=\"SUBMIT\" NAME=\"logout\" VALUE=\"" . $xml['txtLogout'] . "\">";
        }
        elseif($CFG->usepassword)
        { echo "<input TYPE=\"SUBMIT\" NAME=\"f_btnPASSWORD\" VALUE=\"" . $xml['btnPassword'] . "\">"; }
?>
</font>
</td></tr>
</table>
</form>
<?
    }

    function NotifyAdmin($VARS,$CFG,$T,$SUBJECT)
    {
        $TO = "<" . $CFG->email . ">";
        $HEADERS = "From: <" . $CFG->email . ">\n";
        $HEADERS .= "Return-Path: <" . $CFG->email . ">\n";
        $HEADERS .= "Error-To: <" . $CFG->email . ">\n";
        $HEADERS .= "Reply-to: <" . $VARS['f_EMAIL'] . ">\n";
        $MESSAGE = "\n\n" . $SUBJECT . "\n";
        $MESSAGE .= "\nDATE: " . date("Y-m-d H:i:s");
        $MESSAGE .= "\nE-mail Address: " . $VARS['f_EMAIL'] . "\n\n";
        $MESSAGE .= "Request submitted by\n";
        $MESSAGE .= "Remote IP: " . $VARS['REMOTE_ADDR'] . "\n";
        $MESSAGE .= "Remote Host: " . $VARS['REMOTE_HOST'] . "\n";
        $MESSAGE .= "Browser: " . $VARS['HTTP_USER_AGENT'] . "\n\n";
        $MESSAGE .= "---Subscriber Information---\n";

        for($i=1;$i<$CFG->optSize;$i++)
        {
            if($VARS['f_OPTION' . $i])
            { $MESSAGE .= $CFG->optName[$i] . ": " . $VARS['f_OPTION' . $i] . "\n"; }
        }

        $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_catlist L, " . $VARS['DB_TablePrefix'] . "_category C WHERE L.email_id = \"" . $T->CiaoEncode($VARS['f_EMAIL']) . "\" AND L.cat_id = C.cat_id;";
        $result = mysql_query($query,$VARS['DB']);
        if(mysql_num_rows($result)>0)
        {
            $MESSAGE .= "\n---Categories Subscribed---\n";
            for($count=1;$category = mysql_fetch_array($result,1);$count++)
            { $MESSAGE .= $count . ": " . $category['cat_name'] . "\n"; }
        }

        return(mail($TO,$SUBJECT,$MESSAGE,$HEADERS));
    }

    function SendPassword($VARS,$CFG,$xml,$PASSWORD)
    {
        $MESSAGE = $xml['msgPassword'];

        if(! eregi("#PASSWORD#",$MESSAGE))
        { $MESSAGE .= "\n" . $PASSWORD; }

        $MESSAGE = eregi_replace("#PASSWORD#",$PASSWORD,$MESSAGE);
        $MESSAGE = eregi_replace("#URL#",$CFG->url,$MESSAGE);
        $MESSAGE = eregi_replace("#EMAIL#",$VARS['f_EMAIL'],$MESSAGE);
        $MESSAGE = eregi_replace("#REMOTE_IP#",$VARS['REMOTE_ADDR'],$MESSAGE);
        $MESSAGE = eregi_replace("#REMOTE_HOST#",$VARS['REMOTE_HOST'],$MESSAGE);
        $MESSAGE = eregi_replace("#BROWSER#",$VARS['HTTP_USER_AGENT'],$MESSAGE);
        $MESSAGE = ereg_replace("--","=",$MESSAGE);

        $TO = "<" . $VARS['f_EMAIL'] . ">";
        $SUBJECT = "RE: Password Request";
        $FROM = "From: <" . $CFG->email . ">\n";
        $FROM .= "Return-Path: <" . $CFG->email . ">\n";
        $FROM .= "Error-To: <" . $CFG->email . ">\n";
        $MESSAGE = "\n" . $MESSAGE . "\n\n";
        return(mail($TO,$SUBJECT,$MESSAGE,$FROM));
    }

    function SendVerify($VARS,$CFG,$ID)
    {
    # function modified on 2001.01.20 by Ben Drushell
    # uses customizable message

        $MESSAGE = $VARS['msgSignup'];
        $VERIFYURL = $CFG->url . "ciao.php4?v=" . $ID;
        if($VARS['category'] != "")
        { $VERIFYURL .= "&category=" . $VARS['category']; }
        elseif($VARS['template'] != "template")
        { $VERIFYURL .= "&template=" . $VARS['template']; }

        if(! eregi("#VERIFYURL#",$MESSAGE))
        { $MESSAGE .= "\n" . $VERIFYURL; }

        $MESSAGE = eregi_replace("#VERIFYURL#",$VERIFYURL,$MESSAGE);
        $MESSAGE = eregi_replace("#ID#",$ID,$MESSAGE);
        $MESSAGE = eregi_replace("#URL#",$CFG->url,$MESSAGE);
        $MESSAGE = eregi_replace("#EMAIL#",$VARS['f_EMAIL'],$MESSAGE);
        $MESSAGE = eregi_replace("#REMOTE_IP#",$VARS['REMOTE_ADDR'],$MESSAGE);
        $MESSAGE = eregi_replace("#REMOTE_HOST#",$VARS['REMOTE_HOST'],$MESSAGE);
        $MESSAGE = eregi_replace("#BROWSER#",$VARS['HTTP_USER_AGENT'],$MESSAGE);
        $MESSAGE = ereg_replace("--","=",$MESSAGE);

        $TO = "<" . $VARS['f_EMAIL'] . ">";
        $SUBJECT = "Request Verification";
        $FROM = "From: <" . $CFG->email . ">\n";
        $FROM .= "Return-Path: <" . $CFG->email . ">\n";
        $FROM .= "Error-To: <" . $CFG->email . ">\n";
        $MESSAGE = "\n" . $MESSAGE . "\n\n";
        return(mail($TO,$SUBJECT,$MESSAGE,$FROM));
    }

    function VERIFY_VIA_SENDMAIL($sendmail,$address)
    {
    # perl function contributed by Bob Hurt http://www.bobhurt.com/ 2000.12.14
    # ported to PHP by Ben Drushell 2000.12.22
        $good = 1;
        $sendmail = ereg_replace("[[:space:]]+(.*)","\\1",$sendmail);
        $sendmail = ereg_replace("\|","",$sendmail);
        $MAIL = popen("$sendmail -bv $address|","r");
        while(! feof($MAIL))
        {
            $i = fgets($MAIL,255);
            if(ereg("^.+undeliverable.+",$i))
            { $good = 0; } # Sendmail thinks the email address is undeliverable
        }
        pclose($MAIL);
        return($good);
    }

    function VERIFY_VIA_DIG($address)
    {
    # perl function contributed by Bob Hurt http://www.bobhurt.com/ 2000.12.14
    # ported to PHP by Ben Drushell 2000.12.22
        $good = 0;
        list($user,$domain) = split("\@",$address);
        $DIG = popen("dig mx $domain|grep MX|grep -v ';'","r");
        while(! feof($DIG))
        {
            $i = fgets($DIG,255);
            if(ereg("MX",$i))
            { $good++; } # DIG thinks domain is good
        }
        pclose($DIG);
        return($good);
    }

    function VERIFY_EMAIL($EMAIL)
    { # Added 2000.12.22 by Ben Drushell
      # 2001.03.16 - BD - converted to regular expression to fix error where aaa@bbb.ccc.ddd failed
        $valid = 0;
        if(ereg(".+\@.+\..+",$EMAIL))
        { $valid = 1; }
        return($valid);
    }

    function VerifyFields($xml,$VARS,$CFG,$T)
    {
        $rEmail = $T->CiaoEncode($VARS['f_EMAIL']);
        $lEmail = $T->CiaoEncode(strtolower($VARS['f_EMAIL']));

        $valid = 0;
        for($counter = 1;$counter <= $CFG->optSize;$counter++)
        {
            if(($CFG->optReq[$counter] == 'r') && ($VARS['f_OPTION' . $counter] == ''))
            { $valid = 1; }
        }
        if($valid == 0)
        {
            $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_verify WHERE (email_id = \"" . $lEmail . "\" OR email_id = \"" . $rEmail . "\");";
            $result = mysql_query($query,$VARS['DB']);
            if($row = mysql_fetch_array($result,1))
            { $valid = 2; }
        }
        if($valid == 0)
        {
            $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_list WHERE (email_id = \"" . $lEmail . "\" OR email_id = \"" . $rEmail . "\");";
            $result = mysql_query($query,$VARS['DB']);
            if($row = mysql_fetch_array($result,1))
            { $valid = 3; }
        }
        if($valid == 0)
        {
            $query = "SELECT * FROM " . $VARS['DB_TablePrefix'] . "_block WHERE (LOCATE(block_value,\"" . $lEmail . "\") > 0 OR LOCATE(block_value,\"" . $rEmail . "\") > 0);";
            $result = mysql_query($query,$VARS['DB']);
            if($row = mysql_fetch_array($result,1))
            { $valid = 4; }
        }
        if($valid == 0)
        {
            if($xml['VERIFY_VIA_SENDMAIL'] > 0 && strlen($xml['SENDMAIL']) > 0)
            { if(! $this->VERIFY_VIA_SENDMAIL($xml['SENDMAIL'],$VARS['f_EMAIL'])){ $valid = 5; } }
            if($xml['VERIFY_VIA_DIG'] > 0)
            { if(! $this->VERIFY_VIA_DIG($VARS['f_EMAIL'])){ $valid = 5; } }
            if(! $this->VERIFY_EMAIL($VARS['f_EMAIL']))
            { $valid = 5; }
        }
        return($valid);
    }

    function SECURE_FIELD($FIELD)
    { return(ereg_replace("[\!\"\#\$\%\&\'\*\+\|\\\=\`]","_",$FIELD)); }

    function showNavigation($VARS,$xml)
    { // researved for adding public (member) modules
        global $PHP_SELF;
?>
<!--p align="center"><center>
<a href="<?
echo $PHP_SELF . "?logout=1&p=" . urlencode($VARS['p']);
if($VARS['category']!='')
{ echo "&category=" . urlencode($VARS['category']); }
if($VARS['template']!='template')
{ echo "&template=" . urlencode($VARS['template']); }
?>"><?echo urlencode($xml['txtLogout']) ?></a>
<a href="<?
echo $PHP_SELF . "?x=il&p=" . urlencode($VARS['p']);
if($VARS['category']!='')
{ echo "&category=" . urlencode($VARS['category']); }
if($VARS['template']!='template')
{ echo "&template=" . urlencode($VARS['template']); }
?>"><?echo urlencode($xml['txtLink']) ?></a>
</center></p-->
<?
    }
}
?>
