<?php
if (file_exists("stats_month.png")) {unlink("stats_month.png");}

$url="stats_month.php";
require("header.inc.php");
include ("lib/jpgraph.php");
setlocale(LC_TIME,"DE");
$value_array = array();
$i=0;
$cur_sym = "EUR";
if (!isset($nthisyear) || $nthisyear==date("Y"))
{
  $thisyear = date("Y");
  $thismonth = date("m");
  $thisday = date("d");
}
else
{
  $thisyear = $nthisyear;
  $thismonth = 12;
  $thisday = 31;
}
$now = mktime(0,0,0,$thismonth,$thisday,$thisyear);
if ($yearbutton != "") { $sd=0; $ed=0; }
if ($sd>0) { $text = "vom Monat ".date("F",$sd);}
else { $text = ""; }
echo <<<EOS
<table border=1 bordercolor=000000 cellpadding=4 cellspacing=0 width=100% height=99%>
<tr height=16><td>
  <form action="$url" method="get">
  <input type=hidden name=sd value="$sd">
  <input type=hidden name=ed value="$ed">
  <font size=4><b>Statistik</b>
  $text
EOS;
$minyear_res = db_query("SELECT MIN(ltime) FROM bestell");
$minyear_row = db_fetch_row($minyear_res);
$minyear = date("Y",$minyear_row[0]);
$maxyear = date("Y");
$year_arr = array();
for ($y = $minyear; $y<=$maxyear; $y++) { $year_arr[$y] = $y; }

build_dropdown($year_arr, "nthisyear",$thisyear);
echo "\n";
echo "&nbsp;&nbsp;dargestellt als&nbsp;&nbsp;\n";
$type_arr = array("line" => "Liniendiagramm",
                  "pie"  => "Kreisdiagramm");
build_dropdown($type_arr, "type", $type, "onchange=\"document.forms[0].submit()\"");

echo <<<EOS
  </font>
  <input type=submit name="yearbutton" value="anzeigen">
  </form>
</td></tr>
<tr valign=top><td>
    <table border=1 cellpadding=2 bordercolor="#C0C0C0" cellspacing=0 class="white">
     <tr valign=top><td align=left>

EOS;

if ($sd<=0) {
  $thismonth==1 ? $startmonth=0 : $startmonth=1;
  for ($mi=$startmonth; $mi<=$thismonth; $mi++) {
    $startdate = mktime(0,0,0,$mi,1,$thisyear);
    $enddate = mktime(0,0,0,$mi+1,0,$thisyear);
    $mres = db_query("select sum( statistics.price_value* statistics.vat* statistics.quantity) from statistics, bestell where bestell.ltime>'$startdate'
            and bestell.ltime<'$enddate' and bestell.ID = statistics.orderID and bestell.stat!='del'") or db_die();
    $mrow = db_fetch_row($mres);

    $ps_sumres = db_query("select sum( pm_price + sm_price) from bestell where bestell.ltime>'$startdate'
            and bestell.ltime<'$enddate' and bestell.stat!='del'") or db_die();
    $ps_sumrow = db_fetch_row($ps_sumres);

    $mrow0 = number_format($mrow[0]+$ps_sumrow[0],2,",",".");

    $month = date("F",$startdate);
    $day_array[] = date("M",$startdate);
    $value_array[] = $mrow[0]+$ps_sumrow[0];
    $label_array[] = "$month: $mrow0 $cur_sym";
    $target = "stats_month.php?sd=$startdate&ed=$enddate&type=$type&nthisyear=$thisyear";
    $target_array[] = $target;
    $total0 += $mrow[0]+$ps_sumrow[0];
    echo "<a href=\"$target\">$month</a>: $mrow0 $cur_sym<br>\n";
  }
}
else {
  $i=0;
  $total0=0;
  $heute = time();
  for ($j=$sd; $j<$ed; $j=$j+86400) {
    if ($j>$heute) {break;}
    $endday=$j+86400;
    $dres = db_query("select sum( statistics.price_value* statistics.vat* statistics.quantity) from statistics, bestell where bestell.ltime>='$j' and
            bestell.ltime<'$endday' and bestell.ID = statistics.orderID and bestell.stat!='del'") or db_die();
    $drow = db_fetch_row($dres);

    $ps_sumres = db_query("select sum( pm_price + sm_price) from bestell where bestell.ltime>='$j' and
            bestell.ltime<='$endday' and bestell.stat!='del'") or db_die();
    $ps_sumrow = db_fetch_row($ps_sumres);

    $drow0 = number_format($drow[0]+$ps_sumrow[0],2,",",".");

    $day = date("d. (D)",$j);
    echo "$day: $drow0 $cur_sym<br>\n";
    if ($type=="pie")
    {
      if ($drow[0]>0)
      {
        $da = date("j",$j);
        if($da % 2 == 0) $day_array[$i] = $da;
        else $day_array[$i] = " ";
        $value_array[$i] = $drow[0];
        $label_array[$i] = "$day: $drow0 $cur_sym";
        $i++;
        $total0 += $drow[0]+$ps_sumrow[0];
      }
    }
    else
    {
      $da = date("j",$j);
      if($da % 2 == 0) $day_array[$i] = $da;
      else $day_array[$i] = " ";
      $value_array[$i] = $drow[0]=="" ? 0 : $drow[0];
      $label_array[$i] = "$day: $drow0 $cur_sym";
      $i++;
      $total0 += $drow[0]+$ps_sumrow[0];
    }
  }
}

echo "<td align=center>\n";

EOS;
if ($total0 != 0)
{
  $total0 = number_format($total0,2,",",".");
  if ($type == "pie")
  {
    include ("lib/jpgraph_pie.php");
    include ("lib/jpgraph_pie3d.php");
    $graph = new PieGraph(400,300);
    $graph->SetShadow();
    $graph->title->Set("Umsatz gesamt: $total0 $cur_sym");
    $graph->title->SetFont(FF_FONT1,FS_BOLD);
    $p1 = new PiePlot3D($value_array);
    $p1->SetLegends($label_array);
    $p1->SetTheme("earth");
    $p1->SetLabelType(PIE_VALUE_PER);
    $p1->value->SetFormat("%.1f%%");
    if ($sd==0) {$p1->SetCSIMTargets($target_array,$label_array); }
    $p1->SetCenter(0.3,0.5);
    $graph->Add($p1);
    $graph->Stroke(GenImgName());
    echo $graph->GetHTMLImageMap("myimagemap");
  }
  else
  {
    include ("./lib/jpgraph_line.php");
    $monat = date("F Y",$sd);
    $graph = new Graph(400,300,"auto");
    $graph->img->SetMargin(40,40,20,40);
    $graph->SetScale("textlin");
    $graph->SetShadow();
    $lineplot=new LinePlot($value_array);
    $lineplot->SetColor("blue");
    $lineplot->SetWeight(1);
    $graph->Add($lineplot);
    $graph->title->Set("Umsatz $total0");
    if ($sd!=0) $graph->xaxis->title->Set("$monat");
    $graph->yaxis->title->Set("EUR");
    $graph->title->SetFont(FF_FONT1,FS_BOLD);
    $graph->yaxis->title->SetFont(FF_FONT1,FS_BOLD);
    $graph->xaxis->title->SetFont(FF_FONT1,FS_BOLD);
    $graph->xaxis->SetTickLabels($day_array);
    $graph->yaxis->SetColor("blue");
    $graph->Stroke(GenImgName());
  }
  mt_srand ((double)microtime()*1000000);
  $dummy=time()+mt_rand();
  echo "<img src=\"".GenImgName()."?dummy=$dummy\" ISMAP USEMAP=\"#myimagemap\" border=0>";
}
else
{
  echo "Keine Daten zum Anzeigen.";
}
echo "</td></tr>\n</table>\n";
echo "<tr height=16 align=center><td><a href=\"http://www.shopweezle.de\">&copy 2003 Shopweezle</a></td></tr>\n";
exit ("</td></tr></table></body></html>");
