# phpMyAdmin MySQL-Dump
# http://phpwizard.net/phpMyAdmin/
#
# Host: localhost Database : shopcart

# Create the shopcart database and use it.
# You can delete these lines if you intend to import this into another database.

CREATE DATABASE shopcart;
USE DATABASE shopcart;

# --------------------------------------------------------
#
# Table structure for table 'carts'
#

CREATE TABLE carts (
   cart_id mediumint(9) DEFAULT '0' NOT NULL auto_increment,
   session_id tinyint(4) DEFAULT '0' NOT NULL,
   item_id tinyint(4) DEFAULT '0' NOT NULL,
   PRIMARY KEY (cart_id),
   KEY session_id (session_id, item_id)
);


# --------------------------------------------------------
#
# Table structure for table 'categories'
#

CREATE TABLE categories (
   category_id tinyint(4) DEFAULT '0' NOT NULL auto_increment,
   category_name varchar(15) NOT NULL,
   PRIMARY KEY (category_id),
   KEY category_id (category_id),
   UNIQUE category_name (category_name)
);


# --------------------------------------------------------
#
# Table structure for table 'images'
#

CREATE TABLE images (
   image_id mediumint(9) DEFAULT '0' NOT NULL auto_increment,
   image_type varchar(30) NOT NULL,
   image_data longblob,
   PRIMARY KEY (image_id)
);


# --------------------------------------------------------
#
# Table structure for table 'items'
#

CREATE TABLE items (
   item_id int(11) DEFAULT '0' NOT NULL auto_increment,
   item_name varchar(30),
   item_description tinytext,
   item_price float(10,2) DEFAULT '0.00' NOT NULL,
   category_id tinyint(4) DEFAULT '0' NOT NULL,
   image_id mediumint(9) DEFAULT '0' NOT NULL,
   PRIMARY KEY (item_id),
   KEY image_id (image_id),
   KEY category_id (category_id)
);


# --------------------------------------------------------
#
# Table structure for table 'sessions'
#

CREATE TABLE sessions (
   session_id int(11) DEFAULT '0' NOT NULL auto_increment,
   user_id int(11) DEFAULT '0',
   session_status tinyint(4) DEFAULT '0' NOT NULL,
   category_id tinyint(4),
   PRIMARY KEY (session_id)
);


# --------------------------------------------------------
#
# Table structure for table 'users'
#

CREATE TABLE users (
   user_id int(11) DEFAULT '0' NOT NULL auto_increment,
   user_first_name varchar(15),
   user_last_name varchar(15),
   user_mail_address varchar(100),
   user_credit_card varchar(20),
   user_password varchar(30) NOT NULL,
   user_perm tinyint(4) DEFAULT '0' NOT NULL,
   PRIMARY KEY (user_id)
);

