<?PHP

// Shopping Cart Application
// By Jamie Becker
/*
Copyright (C) 2000, Jamie Becker

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// Please see www.gnu.org or www.fsf.org for the full text of the license.

// You may contact the author at:
// jamiebecker@symetix.com
// Jamie Becker
// 4 Fox Hollow Road
// Cortland, NY 13045

// Source Code modified <80 cols. (JamieBecker,2/16/99)

// strongly recommend this function be separated into a separate, non-public
// file and included here.

function init_db_variables()
{
global $db_server;
global $db_username;
global $db_password;
$db_server='localhost';
$db_username='username';
$db_password='password';
$db_name='shopcart';
}

function set_color_theme()
{
// Set color scheme
global $body_background_color;
global $body_font_color;
global $top_header_color;
global $top_header_font_color;
global $top_header_company_font_color;
global $main_index_tab_color;
global $main_index_tab_font_color;
global $index_tab_color;
global $index_tab_font_color;
global $dividing_hline_color;
global $dividing_vline_color;
global $shopping_cart_color;
global $shopping_cart_font_color;
global $browse_color;
global $browse_font_color;
global $shopping_cart_width; // minimum width
global $shopping_cart_height; // minimum height
global $company_name;
global $search_categories; // if $search_categories=='current', only the
// current category will be searched.
global $table_row_rows;
global $table_row_cols;
$table_row_rows=5;
$table_row_cols=30;
$body_background_color='336699';
$body_font_color='000000';
$top_header_color='336699';
$top_header_font_color='EEEEEE';
$top_header_company_font_color='EEEEEE';
$main_index_tab_color='990000';
$main_index_tab_font_color='EEEEEE';
$index_tab_color='003366';
$index_tab_font_color='EEEEEE';
$dividing_hline_color='990000';
$dividing_vline_color='990000';
$shopping_cart_color='336699';
$shopping_cart_font_color='FFFFFF';
$browse_color='FFFFFF';
$browse_font_color='336699';
$shopping_cart_width='100'; // minimum width
$shopping_cart_height='0'; // minimum height
$company_name='phpshopcart';
// if $search_categories=='current', only the current category will be
// searched.
// $search_categories=='current';
}

// Initiate connection to database
// userid and password should be stored in a separate, non-public file and be
// include()'d here.
function connect_db()
{ 
global $db_server;
global $db_username;
global $db_password;
MYSQL_CONNECT($db_server,$db_username,$db_password) OR DIE("Unable to
connect to database");
@MYSQL_SELECT_DB("$db_name") or die("Unable to select database");
}

// If an image is requested, display the image and exit. Exit is critical! 
function display_image()
{
    global $image_id;
    $result=mysql_query("SELECT * FROM images WHERE image_id=$image_id");
    WHILE ($row=mysql_fetch_array($result))
    {
	$image_type=$row["image_type"];
	$image_data=$row["image_data"];
	}
   header("Content-type: $image_type");
   print $image_data;
   exit();
}

// Set up cookies
function init_cookies()
{
global $session_id;
if (!isset($session_id)):
	// session_status values:
	// 0 - not logged in, just browsing...
	// 1 - logged in
	// 2 - purchase completed.
	$query = "INSERT INTO sessions (session_status) VALUES('0')";
	$result = MYSQL_QUERY($query);
	$session_id=mysql_insert_id();
	setcookie("session_id",$session_id);
	// Warning - note that this is inherently insecure. For example, it would
	// be easy to simply increment your cookie ID on your browser and hijack
	// someone's session. It would be better to generate a pseudorandom number
	// or a unique ID that couldn't be easily guessed. DO NOT implement this on
	// a production machine. 
endif;
}

// Register User in Database
function register_user()
{
global $register_form;
global $user_id;
global $user_first_name;
global $user_last_name;
global $user_mail_address;
global $user_credit_card;
global $user_password;
global $session_id;
If ($register_form!=""):
	// Verify that information is accurate and acceptable for input
	// into the database.
	// (Insert your info checking routines here)
	// Insert the information into database.
	$fields="user_first_name, user_last_name, user_mail_address, ";
	$fields=$fields."user_credit_card, user_password";
	$values="'$user_first_name', '$user_last_name', '$user_mail_address', ";
	$values=$values."'$user_credit_card', '$user_password'";
	$query = "INSERT INTO users ($fields) VALUES($values)";
	$result = MYSQL_QUERY($query);
	$user_id=mysql_insert_id();
	$query="UPDATE sessions SET user_id = '$user_id' WHERE session_id = ";
	$query=$query."'$session_id'";
	$result=MYSQL_QUERY($query);
Endif;
}

// Log out user
function logout_user()
{
global $session_id;
global $session_status;
global $login_success;
global $logout;
If ($logout):
   $query="UPDATE sessions SET user_id = '' WHERE session_id = '$session_id'";
   $result=MYSQL_QUERY($query);
   $query="UPDATE sessions SET session_status = '0' WHERE session_id = ";
   $query=$query."'$session_id'";
   $result=MYSQL_QUERY($query);
   $session_status=0;
   $login_success=0;
Endif;
}

// Log in user
function login_user()
{
global $login;
If ($login):
   global $user_id;
   global $user_password;
   global $session_id;
   global $session_status;
   global $login_success;
   $query="SELECT user_password from users WHERE user_id='$user_id'";
   $result=mysql_query($query);
   $num_results=mysql_num_rows($result);
   If ($num_results!=0):
   	  $row=mysql_fetch_array($result);
	  $test_password=$row["user_password"];
	  If ($test_password == $user_password):
	  	$query = "UPDATE sessions SET user_id = '$user_id' WHERE session_id =";
		$query = $query." '$session_id'";
		$result = MYSQL_QUERY($query);
		$query = "UPDATE sessions SET session_status = '1' WHERE session_id =";
		$query = $query." '$session_id'";
		$result = MYSQL_QUERY($query);
		$session_status=1;
	    $login_success=1;
	  Else:
        $login_success=0;
      Endif;
   Else:
      $login_success=0;
   Endif;
Endif;
}

// See if User has logged in yet and read info if so.
function read_user_info()
{
global $user_id;
global $user_first_name;
global $user_last_name;
global $user_mail_address;
global $user_credit_card;
global $user_password;
global $user_perm;
global $session_status;
global $session_id;
global $uc_user_first_name;
$query="SELECT user_id from sessions WHERE session_id=$session_id";
$result=mysql_query($query);
$num_results=mysql_num_rows($result);
If ($num_results==1):
	$row=mysql_fetch_array($result);
	$user_id=$row["user_id"];
	$result=mysql_query("SELECT * from users WHERE user_id=$user_id");
	$num_results=mysql_num_rows($result);
	If ($num_results==1):
		$row=mysql_fetch_array($result);
		$user_id=$row["user_id"];
		$user_first_name=$row["user_first_name"];
		$uc_user_first_name=ucwords($user_first_name);
		$user_last_name=$row["user_last_name"];
		$user_mail_address=$row["user_mail_address"];
		$user_credit_card=$row["user_credit_cart"];
		$user_password=$row["user_password"];
		$user_perm=$row["user_perm"];
		$session_status=1;
		$query = "UPDATE sessions SET session_status = '1' WHERE session_id =";
		$query = " '$session_id'";
		$result = MYSQL_QUERY($query);
	Endif;
Endif;
}

// Layout Page
function layout_page()
{
global $company_name;
global $body_background_color;
global $body_font_color;
Print "<HTML>\n";
Print "<HEAD>\n";
Print "<TITLE>\n$company_name</TITLE>\n";
Print "</HEAD>\n";
Print "<BODY MARGINWIDTH=0 MARGINHEIGHT=0 LEFTMARGIN=0 TOPMARGIN=0 ";
Print "TEXT='$body_font_color' VLINK='$body_font_color' ";
Print "BGCOLOR='#$body_background_color' ";
Print "ALINK='$body_font_color' LINK='$body_font_color'>\n";
}

// Select initial category
function init_category()
{
global $category_id;
global $session_id;
// get category id from current session, if it exists.
If ($category_id=="" || $category_id=="0"):
   $query="SELECT category_id from sessions WHERE session_id=$session_id";
   $result=mysql_query($query);
   $row=mysql_fetch_array($result);
   $category_id=$row["category_id"];
Else:
	 // this would get executed if category id was set on the URL, for example
	 // when changing categories.
	 $query = "UPDATE sessions SET category_id = '$category_id' WHERE ";
	 $query = $query."session_id = '$session_id'";
	 $result = MYSQL_QUERY($query);
Endif;
// If $category_id is still 0 or "", then go ahead and set it to 1.
If ($category_id=="" || $category_id=="0"):
	  $category_id='1';
	 $query = "UPDATE sessions SET category_id = '$category_id' WHERE ";
	 $query = $query."session_id = '$session_id'";
	 $result = MYSQL_QUERY($query);
Endif;
}

// Draw Header Table
function header_table()
{
global $top_header_color;
global $top_header_font_color;
global $top_header_company_font_color;
global $company_name;
global $search;
global $category_id;
global $session_status;
global $uc_user_first_name;
global $PHP_SELF;
Print "<TABLE BORDER=0 WIDTH='100%' CELLSPACING='0' CELLPADDING='0' ";
Print "BGCOLOR='#$top_header_color'>\n";
// Print "<TR><TD>\n<IMG SRC='img/clear.gif'>\n</TD>\n</TR>\n";
Print "<TR><TD ALIGN='LEFT'>";
Print "<FONT FACE='Helvetica, Verdana, Arial' SIZE=+4 COLOR=";
Print "'$top_header_company_font_color'><EM>$company_name</EM></FONT></TD>\n";
If ($session_status == 1):
	Print "<TD COLSPAN=2 ALIGN='CENTER'><FONT FACE=";
	Print "'Helvetica, Verdana, Arial' COLOR='$top_header_font_color'>";
	Print "Welcome, $uc_user_first_name!</FONT></TD>\n";
Endif;
Print "<TD ALIGN='RIGHT'><FONT FACE='Helvetica, Verdana, Arial'";
Print "COLOR='$top_header_font_color' SIZE=-2><FORM ACTION='$PHP_SELF'";
Print " METHOD=POST>\n";
Print "<INPUT TYPE=text NAME='search' VALUE='$search'>";
Print "<INPUT TYPE=hidden NAME='current_category_id' VALUE='$category_id'>";
Print "<INPUT TYPE=SUBMIT VALUE='Search'></FORM></FONT></TD></TR>\n";
Print "</TABLE>\n";
}

// Draw dividing line
function divide_lineh()
{
global $dividing_hline_color;
Print "<TABLE WIDTH=100% BORDER=0 CELLSPACING='0' CELLPADDING='0'>\n";
Print "<TR>\n<TD HEIGHT=1 WIDTH='100%' BGCOLOR='#$dividing_hline_color'>\n";
Print "<IMG SRC='img/clear.gif' HEIGHT=1 WIDTH=1></TD>\n</TR>\n";
Print "</TABLE>\n";
}

// Draw dividing line
function divide_colv()
{
global $dividing_vline_color;
Print "<TD HEIGHT='100%' ROWSPAN=1 WIDTH='1' ";
Print "BGCOLOR='#$dividing_vline_color'>";
Print "<IMG SRC='img/clear.gif' HEIGHT=1 WIDTH=1></TD>\n";
}

// Checkout!!! Another successful sale!
function checkout()
{
global $session_status;
global $session_id;
$session_status=2;
$query = "UPDATE sessions SET session_status = '2' WHERE session_id = ";
$query = $query."'$session_id'";
$result = MYSQL_QUERY($query);
If ($result):
	Print "<H3>Checkout Successful! Thank you!</H3><HR><BR>";
Else:
	Print "<H3>Checkout Failed! Thank you!</H3><HR><BR>";
Endif;
}

// Start table for shopping cart and browse columns
function start_shop_browse_table()
{
global $browse_color;
Print "<TABLE BORDER=0 WIDTH='100%' CELLSPACING='0' CELLPADDING='0'";
Print " BGCOLOR='#$browse_color'>\n<TR>\n";
}

// Start Shopping Cart Column
function start_shop_column()
{
global $shopping_cart_color;
global $shopping_cart_height;
global $shopping_cart_width;
Print "<TD BGCOLOR='#$shopping_cart_color' HEIGHT='$shopping_cart_height'";
Print " WIDTH='$shopping_cart_width' VALIGN=TOP>";
}

// Delete an item from the cart before display.
function delete_item()
{
global $delete_cart_id;
If ($delete_cart_id!=""):
	// Delete item from the carts database
	$query = "DELETE FROM carts WHERE cart_id='$delete_cart_id'";
	$result = MYSQL_QUERY($query);
Endif;
}

// Buy (Add) an item to the cart before display.
function buy_item()
{
global $buy_item_id;
global $session_id;
If ($buy_item_id!=""):
	// Insert this buy item into the carts database
	$query = "INSERT INTO carts (session_id,item_id) VALUES('$session_id',";
	$query = $query."'$buy_item_id')";
	$result = MYSQL_QUERY($query);
Endif;
}

// Print Shopping Cart contents
function print_shopping_cart()
{
	global $session_id;
	global $shopping_cart_font_color;
	global $shopping_cart_width;
	global $PHP_SELF;
	global $session_status;
	global $uc_user_first_name;
	global $user_perm;
	global $total;
	global $items_in_cart;
	$query="SELECT items.item_id, items.item_name, items.item_price, ";
	$query=$query."carts.cart_id FROM items, carts WHERE carts.session_id ";
	$query=$query."='$session_id' AND carts.item_id=items.item_id ORDER BY ";
	$query=$query." items.item_name";
	$result=mysql_query($query);
	If (mysql_num_rows($result)>0):
	   If ($session_status>0):
	   		Print "<FONT FACE='Helvetica, Verdana, Arial' COLOR=";
	   		Print "'$shopping_cart_font_color'>$uc_user_first_name's ";
			Print "Selections:<BR></FONT>\n";
	   Else:
	   		Print "<FONT FACE='Helvetica, Verdana, Arial' COLOR=";
			Print "'$shopping_cart_font_color'>My Selections:<BR></FONT>\n";
	   Endif;
	Endif;
	// start microtable
	Print "<TABLE WIDTH=100% BORDER=0 CELLSPACING='0' CELLPADDING='0'>\n";
	Print "<TR><TD COLSPAN=2><IMG SRC='img/clear.gif' HEIGHT='10' WIDTH=";
	Print "'$shopping_cart_width'></TD></TR>";
	$items_in_cart=0;
	WHILE ($row=mysql_fetch_array($result))
		{
		$items_in_cart++;
		$cart_id=$row["cart_id"];
		$item_id=$row["item_id"];
		$item_name=$row["item_name"];
		$item_price=$row["item_price"];
		$total=$item_price+$total;
		// allow the opportunity to review an item in the cart.
		Print "<TR><TD VALIGN=TOP>";
		Print "<a href='$PHP_SELF?review_cart_id=$cart_id";
		Print "&reviewbuy_item_id=$item_id'>";
		Print "<FONT FACE='Helvetica, Verdana, Arial' SIZE=-3 COLOR=";
		Print "'$shopping_cart_font_color'>$item_name</FONT>";
		Print "</a></TD>";
		Print "<TD VALIGN=TOP ALIGN=RIGHT><FONT FACE='Helvetica, Verdana,";
		Print "Arial' SIZE=-2 COLOR='#$shopping_cart_font_color'>";
		$item_price_str=number_format($item_price,2,'.',',');
		Print "$item_price_str</FONT></TD>";
		Print "<TR><TD COLSPAN=2><IMG SRC='img/clear.gif' HEIGHT='5' ";
		Print "WIDTH='$shopping_cart_width'></TD></TR>";
		}
	If ($items_in_cart>0):
		Print "<TR><TD VALIGN=TOP>";
		Print "<FONT FACE='Helvetica, Verdana, Arial' SIZE=-3 COLOR=";
		Print "'$shopping_cart_font_color'>Total:</FONT>";
		Print "</TD>";
		Print "<TD VALIGN=TOP ALIGN=RIGHT><FONT FACE='Helvetica, Verdana, ";
		Print "Arial' SIZE=-2 COLOR='#$shopping_cart_font_color'>";
		$total_str=number_format($total,2,'.',',');
		Print "$$total_str</FONT></TD>";
		Print "<TR><TD COLSPAN=2><IMG SRC='img/clear.gif' HEIGHT='5' WIDTH=";
		Print "'$shopping_cart_width'></TD></TR>";
	Endif;
	Print "</TABLE>\n";
	// end microtable
}

// Start Browse Column
function start_browse_column()
{
global $browse_color;
global $browse_font_color;
Print "<TD WIDTH='100%' VALIGN=TOP BGCOLOR='#$browse_color' ROWSPAN=1>";
Print "<FONT FACE='Helvetica, Verdana, Arial' COLOR='#$browse_font_color'>";
}

// Draw Category Table
function category_table()
{
global $index_tab_color;
global $index_tab_font_color;
global $main_index_tab_color;
global $main_index_tab_font_color;
global $PHP_SELF;
global $category_id;
Print "<TABLE WIDTH=100% BORDER=0 CELLSPACING='0' CELLPADDING='3'>\n";
Print "<TR BGCOLOR='#$index_tab_color'>\n";
$result=mysql_query("SELECT * FROM categories ORDER BY category_name");
WHILE ($row=mysql_fetch_array($result))
{
$col_category_id=$row["category_id"];
$col_category_name=$row["category_name"];
If ($col_category_id==$category_id):
	$category_name=$col_category_name;
	Print "<TD BGCOLOR='#$main_index_tab_color'>\n<CENTER>\n";
	Print "<a href='$PHP_SELF?category_id=$col_category_id'>\n";
	Print "<FONT FACE='Helvetica, Verdana, Arial'";
	Print " COLOR='#$main_index_tab_font_color'>\n";
	Print "$category_name</FONT>\n</a>\n</CENTER>\n</TD>\n";
Else:
	Print "<TD BGCOLOR='#$index_tab_color'>\n<CENTER>\n";
	Print "<a href='$PHP_SELF?category_id=$col_category_id'>\n";
	Print "<FONT FACE='Helvetica, Verdana, Arial' COLOR=";
	Print "'#$index_tab_font_color'>\n";
	Print "$col_category_name</FONT>\n</a>\n</CENTER>\n</TD>\n";
Endif;
}
Print "</TR>\n</TABLE>\n";
}

// Inform the user of userid after registration
function inform_user()
{
global $register_form;
global $user_id;
global $user_first_name;
global $user_last_name;
global $user_mail_address;
global $user_credit_card;
global $user_password;
global $browse_font_color;
global $browse_color;
If (register_form!=""):
Print "<FONT FACE='Helvetica, Verdana, Arial' COLOR='#$browse_font_color'>\n";
Print "<H1>Please write this down!</H1>";
Print "<CENTER><TABLE BORDER=0 WIDTH=75% VALIGN=TOP CELLSPACING='0'";
Print "CELLPADDING='0' BGCOLOR='#$browse_color'>";
Print "<TR><TD><FONT FACE='Helvetica, Verdana, Arial' COLOR=";
Print "'#$browse_font_color'>Your user ID is:</TD>";
Print "<TD><FONT FACE='Helvetica, Verdana, Arial' COLOR=";
Print "'#$browse_font_color'>$user_id</TD></TR>";
Print "<TR><TD><FONT FACE='Helvetica, Verdana, Arial' COLOR=";
Print "'#$browse_font_color'>Your password is:</TD>";
Print "<TD><FONT FACE='Helvetica, Verdana, Arial' COLOR=";
Print "'#$browse_font_color'>$user_password</TD></TR>";
Print "</TABLE>";
Endif;
}

// Inform a user if he was successfully logged in or out.
function inform_auth()
{
global $login;
global $logout;
global $login_success;
global $uc_user_first_name;
If ($login):
   If ($login_success):
   	  Print "<H3>Login Successful! Welcome, $uc_user_first_name!</H3><HR><BR>";
   Else:
      Print "<H3>Login Failed!</H3>";
	  Print "Unauthorized access is prohibited and will be prosecuted. Please";
	  Print " <a href='$PHP_SELF?create_account=1'>";
	  Print "create an account</a>. If you already have a valid account, ";
	  Print "please try again.<BR><HR><BR>";
   Endif;
Endif;
If ($logout):
   // Logout always succeeds unless there is a database problem.
   // It might be useful to remove the cookie from the user's PC.
   Print "<H3>Logout Successful! Feel free to continue browsing.</H3><HR><BR>";
Endif;   
}

// Input Table Row Form
function row_form($field_title,$field_name,$field_type)
{
global $browse_color;
global $browse_font_color;
global $table_row_rows;
global $table_row_cols;
If ($field_type==""):
   $field_type="text";
Endif;
Print "<TR><TD>";
Print "<FONT FACE='Helvetica, Verdana, Arial' COLOR='#$browse_font_color'>";
Print "$field_title";
Print "</FONT></TD><TD>";
Print "<FONT FACE='Helvetica, Verdana, Arial' COLOR='#$browse_font_color'>";
If ($field_type=="textarea"):
   Print "<$field_type ROWS=$table_row_rows COLS=$table_row_cols NAME=";
   Print "'$field_name'></$field_type>";
Else:
   Print "<INPUT TYPE='$field_type' NAME='$field_name'>";
Endif;
Print "</FONT>";
Print "</TD></TR>\n";
}

// Admin the site
function admin()
{
global $PHP_SELF;
global $browse_color;
global $browse_font_color;
global $category_id;
global $table_row_rows;
global $table_row_cols;
$table_row_rows=5;
$table_row_cols=30;
Print "<CENTER><TABLE BORDER=0 WIDTH=75% VALIGN=TOP CELLSPACING='0'";
Print " CELLPADDING='0' BGCOLOR='#$browse_color'>";
Print "<FORM ACTION='$PHP_SELF' ENCTYPE='multipart/form-data' METHOD=POST>";
Print "<INPUT TYPE=hidden NAME='admin_add' VALUE='1'>\n";
Print "<TR><TD COLSPAN=2 ALIGN=CENTER>";
Print "<FONT FACE='Helvetica, Verdana, Arial' COLOR='#$browse_font_color'>";
Print "<H3>Add an Item</H3></FONT></TD></TR>\n";
row_form("Item Name:","item_name","");
row_form("Item Description:","item_description","textarea");
row_form("Item Price:","item_price","text");
// Make Category Pull-down
$result=mysql_query("SELECT * FROM categories ORDER BY category_name");
Print "<TR><TD>";
Print "<FONT FACE='Helvetica, Verdana, Arial' COLOR='#$browse_font_color'>";
Print "Category:</FONT></TD><TD>";
Print "<FONT FACE='Helvetica, Verdana, Arial' COLOR='#$browse_font_color'>";
Print "<SELECT NAME='add_item_category_id'>";
WHILE ($row=mysql_fetch_array($result))
{
$col_category_id=$row["category_id"];
$col_category_name=$row["category_name"];
Print "<OPTION VALUE=$col_category_id>$col_category_name";
}
Print "</SELECT></TD></TR>\n";
Print "<TR><TD>";
Print "<FONT FACE='Helvetica, Verdana, Arial' COLOR='#$browse_font_color'>";
Print "Select an Image: (optional)</FONT></TD><TD>";
Print "<FONT FACE='Helvetica, Verdana, Arial' COLOR='#$browse_font_color'>";
Print "<INPUT TYPE='hidden' name='MAX_FILE_SIZE' value=500000>";
Print "<input type=file name=image accept='image/*'></FONT></TD></TR>\n";
Print "<TR><TD COLSPAN=2 ALIGN=CENTER><INPUT TYPE=SUBMIT></FONT></TD></TR>\n";
Print "</FORM>";
Print "</TABLE></CENTER>";
}

// Add an item to the site
function admin_add_item()
{
global $category_id;
global $item_name;
global $item_description;
global $item_price;
global $add_item_category_id;
global $image_id;
global $image; // PHP-provided variable (temporary filename)
global $image_name; // PHP-provided variable (original filename)
global $image_size; // PHP-provided variable (in bytes)
global $image_type; // PHP-provided variable (mime-type: image/gif,image/jpeg)
global $PHP_SELF;
If ($image != 'none'):
   $image_data = addslashes(fread(fopen($image,"r"),filesize($image)));
   // insert mime type into images database and get an id #.
   $fields="image_type, image_data";
   $values="'$image_type', '$image_data'";
   $query = "INSERT INTO images ($fields) VALUES($values)";
   $result = MYSQL_QUERY($query);
   $image_id=mysql_insert_id();
   Print "<img src='$PHP_SELF?image_id=$image_id'><BR>";
Endif;
$fields="item_name, item_description, item_price, category_id, image_id";
$values="'$item_name', '$item_description', '$item_price', ";
$values=$values."'$add_item_category_id', '$image_id'";
$query = "INSERT INTO items ($fields) VALUES($values)";
$result = MYSQL_QUERY($query);
$item_id=mysql_insert_id();
If ($result):
   Print "Item ID#$item_id addition ($item_name) succeeded.";
Else:
   Print "Item ID#$item_id addition ($item_name) failed.";
Endif;
}

// Create_account
function create_account()
{
global $PHP_SELF;
global $browse_color;
global $browse_font_color;
// Start Create Account Form
// We recommend that this form is secured in secure server!!
Print "<CENTER><TABLE BORDER=0 WIDTH=75% VALIGN=TOP CELLSPACING='0' ";
Print "CELLPADDING='0' BGCOLOR='#$browse_color'>";
Print "<FORM ACTION='$PHP_SELF' METHOD=POST>";
Print "<INPUT TYPE=hidden NAME='register_form' VALUE='1'>\n";
row_form("Your First Name:","user_first_name","");
row_form("Your Last Name:","user_last_name","");
row_form("Your Mail Address:","user_mail_address","");
row_form("Your Credit Card:","user_credit_card","");
row_form("Password:","user_password","");
// OR row_form("Password:","user_password","password");
// Recommend you confirm password if you conceal what is typed
Print "<TR><TD COLSPAN=2 ALIGN=CENTER><INPUT TYPE=SUBMIT></FONT></TD></TR>";
Print "</FORM>";
Print "</TABLE></CENTER>";
}

// Review an individual item
function review_item()
{
global $review_item_id;
global $PHP_SELF;
global $browse_font_color;
$result=mysql_query("SELECT * FROM items WHERE item_id=$review_item_id");
WHILE ($row=mysql_fetch_array($result))
	{
	$item_name=$row["item_name"];
	$item_description=$row["item_description"];
	$item_price=$row["item_price"];
	$image_id=$row["image_id"];
	If ($image_id!='0'):
	    Print "<img src='$PHP_SELF?image_id=$image_id'><BR>";
	Endif;
	Print "$item_name<BR>\n$item_description<BR>\n<BR>\n\$$item_price<BR><BR>";
	Print "<a href='$PHP_SELF?buy_item_id=$review_item_id'>\n";
	Print "<FONT FACE='Helvetica,Verdana,Arial' COLOR='#$browse_font_color'>";
	Print "Purchase this Item";
	Print "</FONT>";
	Print "</a>\n";
	}
}

// Review the purchase of an individual item
function review_purchase()
{
global $reviewbuy_item_id;
global $review_cart_id;
global $PHP_SELF;
global $browse_font_color;
$result=mysql_query("SELECT * FROM items WHERE item_id=$reviewbuy_item_id");
WHILE ($row=mysql_fetch_array($result))
	{
	$item_name=$row["item_name"];
	$item_description=$row["item_description"];
	$item_price=$row["item_price"];
	Print "$item_name<BR>\n$item_description<BR><BR>\$$item_price<BR><BR>";
	Print "<a href='$PHP_SELF?delete_cart_id=$review_cart_id'>\n";
	Print "<FONT FACE='Helvetica,Verdana,Arial' COLOR='#$browse_font_color'>";
	Print "Delete this Item from shopping basket.";
	Print "</FONT>";
	Print "</a>\n";
	}
}

// Start Browse Column, but for search items
function search_column()
{
global $category_id;
global $category_name;
global $search;
global $lower_limit;
global $browse_font_color;
global $PHP_SELF;
global $search_categories;
If ($lower_limit==""):
	$lower_limit=1;
Endif;
$upper_limit=$lower_limit+4;
If ($search_categories=='current'):
   $query="SELECT * FROM items WHERE item_name LIKE '%$search%' OR item_";
   $query=$query."description LIKE '%$search%' AND category_id=$category_id";
   $result=mysql_query($query);
Else:
   $query="SELECT * FROM items WHERE item_name LIKE '%$search%' OR item_";
   $query=$query."description LIKE '%$search%'";
   $result=mysql_query($query);
Endif;   
$num_results=mysql_num_rows($result);
$upper_limit=$num_results+$lower_limit-1;
Print "Displaying $category_name containing '$search' from $lower_limit to ";
Print "$upper_limit:<BR>\n<BR>\n";
WHILE ($row=mysql_fetch_array($result))
	{
	$item_id=$row["item_id"];
	$item_name=$row["item_name"];
	$item_description=$row["item_description"];
	$item_price=$row["item_price"];
	Print "<a href='$PHP_SELF?review_item_id=$item_id&current_category_id=";
	Print "$category_id'>\n";
	Print "<FONT FACE='Helvetica,Verdana,Arial' COLOR='#$browse_font_color'>";
	Print "$item_name \$$item_price";
	Print "</FONT>\n";
	Print "</a>\n";
	Print "<BR>\n<BR>\n";
	}
}

// Display the normal browse window.
function browse_column()
{
global $category_id;
global $category_name;
global $search;
global $lower_limit;
global $browse_font_color;
global $PHP_SELF;
// display photos first...
$query="SELECT * FROM items WHERE category_id=$category_id AND image_id>0";
$result=mysql_query($query);
$num_results=mysql_num_rows($result);
$max_pics=4;
If ($num_results>0):
   Print ("<BR><CENTER><TABLE WIDTH='80%' BORDER=0>");
   If ($num_results > $max_pics):
   	  $num_results=$max_pics;
   Endif;
   FOR ($x=1;$x<=$num_results;$x++) 
	{
	$row=mysql_fetch_array($result);
	$item_id=$row["item_id"];
	$item_name=$row["item_name"];
	$item_description=$row["item_description"];
	$item_price=$row["item_price"];
	$image_id=$row["image_id"];
	If ($x%2 != 0): // if $x is odd
		Print "<TR><TD><CENTER>\n<a href='$PHP_SELF?review_item_id=$item_id'>";
		Print "<img src='$PHP_SELF?image_id=$image_id' BORDER=0 WIDTH=225>";
		Print "<BR><FONT FACE='Helvetica,Verdana,Arial'";
		Print " COLOR='#$browse_font_color'>";
		Print "$item_name \$$item_price</FONT></a>";
		Print "</TD>\n";
	Else:
		Print "<TD><CENTER>\n<a href='$PHP_SELF?review_item_id=$item_id'>";
		Print "<img src='$PHP_SELF?image_id=$image_id' BORDER=0 WIDTH=225>";
		Print "<BR>";
		Print "<FONT FACE='Helvetica, Verdana, Arial' COLOR=";
		Print "'#$browse_font_color'>";
		Print "$item_name \$$item_price</FONT></a>";
		Print "</TD></TR>\n";
	Endif;
	}
	Print ("</TABLE></CENTER><BR>");
Endif;
If ($lower_limit==""):
	$lower_limit=1;
Endif;
$upper_limit=$lower_limit+4;
$result=mysql_query("SELECT * FROM items WHERE category_id=$category_id");
$num_results=mysql_num_rows($result);
$upper_limit=$num_results+$lower_limit-1;
Print "<CENTER><TABLE WIDTH=60% BORDER=0>";
Print "<TR><TD ALIGN=CENTER><B>";
Print "<FONT FACE='Helvetica, Verdana, Arial' COLOR='#$browse_font_color'>\n";
Print "Displaying $category_name from $lower_limit to $upper_limit:</TD></TR>";
Print "</FONT>\n";
Print "</B></TD></TR>";
WHILE ($row=mysql_fetch_array($result))
	{
	$item_id=$row["item_id"];
	$item_name=$row["item_name"];
	$item_description=$row["item_description"];
	$item_price=$row["item_price"];
	Print "<TR><TD>";
	Print "<a href='$PHP_SELF?review_item_id=$item_id'>\n";
	Print "<FONT FACE='Helvetica, Verdana, Arial' COLOR=";
	Print "'#$browse_font_color'>";
	Print "$item_name \$$item_price";
	Print "</FONT>\n";
	Print "</a>\n";
	Print "</TD></TR>\n";
	}
Print "</TABLE>";
Print "&nbsp</TD></TR>\n";
}

// Display bottom of Shopping Cart column
function end_shop_column()
{
global $session_id;
global $shopping_cart_color;
global $shopping_cart_font_color;
global $shopping_cart_width;
global $PHP_SELF;
global $session_status;
global $uc_user_first_name;
global $user_perm;
global $items_in_cart;
Print "<TR><TD BGCOLOR='#$shopping_cart_color' VALIGN=BOTTOM><p>";
If ($session_status == 1):
 	Print "<CENTER><A HREF='$PHP_SELF?logout=1'><FONT FACE=";
	Print "'Helvetica,Verdana,Arial' COLOR='$shopping_cart_font_color'";
	Print " SIZE=-1>Logout</FONT></CENTER><BR>";
Endif;
If ($session_status > 0 and $items_in_cart > 0):
 	Print "<CENTER><A HREF='$PHP_SELF?checkout=1'><FONT FACE=";
	Print "'Helvetica, Verdana, Arial' COLOR='$shopping_cart_font_color' ";
	Print "SIZE=-1>Checkout</FONT></CENTER><BR>";
Endif;
If ($user_perm > 0):
 	Print "<CENTER><A HREF='$PHP_SELF?admin=1'><FONT FACE=";
	Print "'Helvetica, Verdana, Arial' COLOR='$shopping_cart_font_color'";
	Print " SIZE=-1>Add an Item</FONT></CENTER><BR>";
Endif;
Print "<a href='$PHP_SELF?create_account=1'>\n";
Print "<FONT FACE='Helvetica, Verdana, Arial' SIZE=-1 COLOR=";
Print "'#$shopping_cart_font_color'>";
Print "<CENTER>Create an account</CENTER>";
Print "</FONT></a>";
Print "<BR>";
Print "<FORM ACTION='$PHP_SELF' METHOD=POST>\n";
Print "<FONT FACE='Helvetica, Verdana, Arial' SIZE=-2 COLOR=";
Print "'$shopping_cart_font_color'>Your User ID:<br>&nbsp";
Print "<INPUT TYPE=text NAME='user_id'>&nbsp<br>\n";
Print "Your Password:<br>&nbsp<INPUT TYPE=password NAME='user_password'>";
Print "&nbsp<br>\n";
Print "<INPUT TYPE=hidden NAME='login' VALUE='1'><br>\n";
Print "<CENTER><INPUT TYPE=SUBMIT VALUE='Login'></CENTER></FONT></FORM>\n";
Print "</p></TD>";
}

// Display bottom of Browse column
function end_browse_column()
{
global $browse_color;
global $browse_font_color;
global $company_name;
Print "<TD VALIGN=BOTTOM BGCOLOR='#$browse_color'><FONT FACE='Helvetica,";
Print "Verdana, Arial' COLOR='#$browse_font_color' SIZE=-2><CENTER>Copyright ";
Print "&copy 2000 $company_name</CENTER></FONT></TD>";
Print "</TR>";
}

// End Shopping Cart & Browse Table
function end_shop_browse_table()
{
Print "</TABLE>";
}

// Start of Program
// Note -- NO PROGRAM STATEMENTS SHOULD EXIST OUTSIDE OF A FUNCTION
// BEFORE THIS SECTION!
init_db_variables();
set_color_theme();
connect_db();
If ($image_id != ""):
   display_image();
   exit();
Endif;
init_cookies();
logout_user();
register_user();
login_user();
read_user_info();
layout_page();
init_category();
header_table();
start_shop_browse_table();
start_shop_column();
delete_item();
buy_item();
print_shopping_cart();
divide_colv();
start_browse_column();
divide_lineh();
category_table();
divide_lineh();
inform_auth();
// Change browse window based on action:
If ($checkout!=""):
	checkout();
Endif;
If ($review_item_id!=""):
	review_item();
ElseIf ($admin!=""):
	admin();
ElseIf ($admin_add!=""):
	admin_add_item();
ElseIf($register_form!=""):
    inform_user();
ElseIf ($reviewbuy_item_id!=""):
	review_purchase();
ElseIf ($create_account!=""):
	create_account();
ElseIf ($search!=""):
	search_column();
Else:
	browse_column();
Endif;
// Display page footer
end_shop_column();
divide_colv();
end_browse_column();
end_shop_browse_table();

?>
