<?php
date_default_timezone_set('America/Sao_Paulo');

//English: Starting and configuring BoxCache, the only parameter you need is the cache folder.
//Português: Inicializando e configurando o BoxCache, o único parâmetro que você precisa é a pasta para guardar o cache
include 'boxcache.class.php';
$cache = new boxcache('/var/www/boxcache/cache');

//English: Caching a simple string.
//Português: Guardando uma string simples.
$cache->write('example', 'This is the example data that will be cached. Isto é uma string de exemplo que será quardada');
$cache->write('example1', 'This is a string that will expire in 10 seconds. Isto é uma string que vai expirar em 10 segundos', '+10 minutes');
$cache->write('example2', array( 'I can cache array too!', 'Eu também posso guardar arrays!' ), '+10 minutes');

//English: Support for all languages and characteres.
//Português: Suporte para todas as linguagens e caracteres.
$cache->write('이것은 테스트입니다', '이것은 필기 시험 기능 다국어을 증명할 수 있습니다', '+5 days');

//English: Returning our example that was cached.
//Português: Pegando o exemplo que foi guardado no cache.
echo $cache->get('example'); echo '<br />';
echo $cache->get('example1'); echo '<br />';
echo '<pre>'; print_r($cache->get('example2')); echo '</pre>';
echo $cache->get('이것은 테스트입니다'); echo '<br />';

//English: Cleaning a specific cache.
//Português: Limpando um arquivo de cache específico.
$cache->delete('example');

//English: Cleaning all expired cache.
//Português: Limpando todos os caches que já espiraram.
$cache->clean();

//English: Cleaning all cache dir.
//Português: Limpando todo o diretório de cache.
$cache->purge();
?>
