<?php

/* 
*Please make sure that you're using the last version by checking http://code.google.com/p/boxcache
 */

class boxcache {

    protected $path;
    protected $cache;
    protected $debug = false;
    protected $messages = array();
    protected $autoclean = false;

    public function __construct($path = null) {
        if (is_dir($path) && is_writable($path)) {
            $path = str_replace('\\', '/', $path);
            $path = (substr($path, -1, 1) == '/') ? $path : $path . '/';
            $this->path = $path;
            $this->trowDebug('The script was sucefully configured, your working path is: ' . $path, 2);
        } else {
            $this->trowDebug('You need to enter a valid and writable path to cache files. The path ' . $path . ' is invalid or not writable.', 1);
        }
    }

    public function write($name, $data, $expire = null) {
        if ($this->autoclean == true) {
            $this->clean();
        }

        if (empty($name) || empty($data)) {
            $this->trowDebug('You are required to enter a valid name for the cache and a valid data to be cached.', 1);
            return false;
        } else {
            $cache['filename'] = md5($name);
            $cache['data'] = base64_encode(serialize($data));
            $cache['expire'] = empty($expire) ? date('Y-m-d H:i:s', strtotime('+15 minutes')) : date('Y-m-d H:i:s', strtotime($expire));
            $this->cache = $cache;
            $caching = $this->putContents();
            if ($caching == true) {
                $this->trowDebug($name . ' have been sucefully cached.', 2);
                return true;
            } else {
                $this->trowDebug('Something went wrong wen the script tryed to cache ' . $name, 1);
                return false;
            }
        }
    }

    public function get($name) {
        if (!empty($name)) {
            $data = $this->getContents(md5($name));
            if ($data != false) {
                $data = explode('::', $data);
                if ($data[0] >= date('Y-m-d H:i:s')) {
                    $this->trowDebug($name . ' was succefully returned from the cache.', 2, $data[1]);
                    return unserialize(base64_decode($data[1]));
                } else {
                    if (file_exists($this->path . $name . '.cache')) {
                        $this->trowDebug($name . ' has expired, the file ' . $this->path . md5($name) . '.cache' . ' will be deleted now.', 4);
                        unlink($this->path . md5($name) . '.cache');
                    }
                    $this->trowDebug($name . ' has expired.', 4);
                    return false;
                }
            } else {
                $this->trowDebug('Something went wrong wen the script tryed to get the cache ' . $name, 1);
                return false;
            }
        } else {
            $this->trowDebug('The name parameter can\'t be empty.', 1);
            return false;
        }
    }

    protected function putContents() {
        if (!file_exists($this->path . $this->cache['filename'] . '.cache')) {
            file_put_contents($this->path . $this->cache['filename'] . '.cache', $this->cache['expire'] . '::' . $this->cache['data']);
            $this->trowDebug($this->cache['filename'] . ' was succefully cached', 2, $this->cache['data']);
            return true;
        } else {
            $this->trowDebug('The file ' . $this->path . $this->cache['filename'] . '.cache' . 'already exists, skiping cache.', 4, $this->cache['data']);
            return false;
        }
    }

    protected function getContents($name) {
        if (file_exists($this->path . $name . '.cache')) {
            $this->trowDebug('The file ' . $this->path . $name . '.cache' . ' have been readed succefully.', 2);
            return file_get_contents($this->path . $name . '.cache');
        } else {
            $this->trowDebug('The file ' . $this->path . $name . '.cache' . ' doesn\'t exists, skiping.', 4);
            return false;
        }
    }

    public function delete($name) {
        if (file_exists($this->path . md5($name) . '.cache')) {
            $this->trowDebug('The file ' . $this->path . md5($name) . '.cache' . ' have been deleted succefully.', 2);
            unlink($this->path . md5($name) . '.cache');
            return true;
        } else {
            $this->trowDebug('The file ' . $this->path . md5($name) . '.cache' . ' doesn\'t exists, skiping.', 4);
            return false;
        }
    }

    public function purge() {
        $files = array_slice(scandir($this->path), 2);
        if (!empty($files)) {
            foreach ($files as $file) {
                if (file_exists($this->path . $file) && stripos('.cache', $file) != false) {
                    $this->trowDebug('The file ' . $this->path . $file . ' have been deleted succefully.', 2);
                    unlink($this->path . $file);
                }
            }
        } else {
            $this->trowDebug('There is no files to be erased in the work path.', 4);
        }
    }

    public function clean() {
        $files = array_slice(scandir($this->path), 2);
        if (!empty($files)) {
            foreach ($files as $file) {
                if (file_exists($this->path . $file) && stripos('.cache', $file) != false) {
                    $data = file_get_contents($this->path . $file);
                    $data = explode('::', $data);
                    if ($data[0] <= date('Y-m-d H:i:s')) {
                        $this->trowDebug('The file ' . $this->path . $file . ' have been cleaned succefully.', 2);
                        unlink($this->path . $file);
                    }
                }
            }
        } else {
            $this->trowDebug('There is no files to be cleaned in the work path.', 4);
        }
    }

    public function enableDebug() {
        $this->debug = true;
        $this->trowDebug('Debug enabled.', 4);
    }

    public function disableDebug() {
        $this->debug = false;
        $this->trowDebug('Debug disabled.', 4);
    }

    public function debug() {
        return $this->messages;
    }

    protected function trowDebug($msg, $level = 4, $serialize = null) {

        $levels = array(
            0 => 'unknown',
            1 => 'error',
            2 => 'success',
            3 => 'warning',
            4 => 'info'
        );

        if (!empty($msg) && $this->debug == true) {

            $microseconds = microtime();
            $microseconds = explode(' ', $microseconds);
            $microseconds = $microseconds[0];

            $this->messages[] = array(
                'level' => array_key_exists($level, $levels) ? $levels[$level] : $levels[0],
                'message' => $msg,
                'timestamp' => date('Y-m-d H:i:s') . ' (' . $microseconds . ')',
                'data' => !empty($serialize) ? serialize($serialize) : null,
            );
        }
    }

}

?>
