<?php

/*
* PHP to JavaScript form Validation Generator.
* 
* Current supports 3 types of Validation:
*  - Required Field
*  - Numerical Field only
*  - Alphanumerical Field only
* the above validation types can be
* combined on any form field.
* 
* FUTURE:
* Will be adding many other types of validation
* 
* NOTICE:
* I you change or add to this class please send me a copy.
* stuartc1@users.sourceforge.net or stuartc1@hotmail.com
*/

/**
* js_validation Class
*
* This class is used to generate JavaScript
* for Form Validation.
* DATE: 2002-10-24
*
* @package      js_validation
* @copyright    as GPL
* @version      1.0
* @author       Stuart Cochrane - stuartc1@users.sourceforge.net
* @link			http://sourceforge.net/projects/php-cmc/
*   
*/

class js_validation {
	var $js_form ="";
	var $js_var ="";
	var $js_type ="";
	var $js_count ="";
	var $js_code ="";

// constructor
function js_validation() {
	$this->js_form = $js_form;
	$this->js_var = $js_var;
	$this->js_type = $js_var_type;
	$this->js_count = $js_count;
	$this->js_code = $js_code;
}


/**
* js_validation::set_js_form
* 
* @param    string    $name
* @access   public
* @return   form name
*/
function set_js_form($name) {
	$this->js_form = $name;
}


/**
* js_validation::set_js_array
* 
* Builds the 2 arrays, one with
* types and the other for variables
* 
* @param    array    $array
* @access   public
* @return   array
* 
*/
function set_js_array($array) {
	$this->js_count = 0;
	foreach($array as $var => $type) {
		$this->js_var[$this->js_count] = $var;
		$this->js_type[$this->js_count] = $type;
		$this->js_count ++;
	}
	$this->set_js_code();
}


/**
* js_validation::get_js_count
* 
* @access   private
* @return   integer
* 
*/
function get_js_count() {
	return $this->js_count;
}


/**
* js_validation::get_js_code
* 
* Returns the final JavaScript back
* to the form.
* 
* @access   public
* @return   string
* 
*/
function get_js_code() {
$front = "<script langauge=\"javascript\">\nfunction val_".$this->js_form." () {\n";
$back = "}\n</script>";
$this->js_code = $front.$this->js_code.$back;
return $this->js_code;
}


/**
* js_validation::set_js_code
* 
* Looks at the arrays and passes
* the form field name to the correct
* javascript validation type function.
* 
* 
* @access   private
*/
// private
function set_js_code() {
	$array_count = $this->get_js_count();

	for($i=0; $i < $array_count; $i++) {
		$var = $this->js_var[$i];

		if($this->js_type[$i] == "nu") {
			$this->set_type_nu($var);
		}
		if($this->js_type[$i] == "anu") {
			$this->set_type_anu($var);
		}
		if($this->js_type[$i] == "ne") {
			$this->set_type_ne($var);
		}
	}
}


/**
* js_validation::set_type_ne
* 
* Builds the javascript for
* fields that require a value.
* 
* @param    string    $var
* @access   private
*/
function set_type_ne($var) {
	$form = $this->js_form;
 $this->js_code .= "\nif ( document.$form.$var.value == \"\" ) {
 alert(\"Please complete $var before continuing\");
 return false;\n}// end of validation for $form.$var\n";
}


/**
* js_validation::set_type_nu
* 
* Builds the javascript for
* fields that require numeric data only.
* 
* @param    string    $var
* @access   private
*/
function set_type_nu($var) {
$form = $this->js_form;
$this->js_code .="\nvar valid_$var = \"1234567890\"
  var ok = \"yes\";
  var temp;
  for (var i=0; i<document.$form.$var.value.length; i++) {
    temp = \"\" + document.$form.$var.value.substring(i, i+1);
    if (valid_$var.indexOf(temp) == \"-1\") ok = \"no\";
      }
    if (ok == \"no\") {
     alert(\"Please ensure that $var is\\nnumerical before continuing\");
	return false;\n}// end of validation for $form.$var\n";
}


/**
* js_validation::set_type_anu
* 
* Builds the javascript for
* fields that require alphanumeric data only.
* 
* @param    string    $var
* @access   private
*/
function set_type_anu($var) {
$form = $this->js_form;
$this->js_code .= "\nvar valid_$var = \"1234567890[a-z][A-Z]\"
    var ok = \"yes\";
    var temp;
    for (var i=0; i<document.$form.$var.value.length; i++) {
    temp = \"\" + document.$form.$var.value.substring(i, i+1);
     if (valid_$var.indexOf(temp) == \"-1\") ok = \"no\";
      }
    if (ok == \"no\") {
      alert(\"Please ensure that $var is\\nalphanumerical before continuing\");\n
	  return false;\n}// end of validation for $form.$var\n";
}


}

?>