<?php
/*
***************************************************************************
*   Copyright (C) 2007 by Cesar D. Rodas                                  *
*   cesar@sixdegrees.com.br                                               *
*                                                                         *
*   Permission is hereby granted, free of charge, to any person obtaining *
*   a copy of this software and associated documentation files (the       *
*   "Software"), to deal in the Software without restriction, including   *
*   without limitation the rights to use, copy, modify, merge, publish,   *
*   distribute, sublicense, and/or sell copies of the Software, and to    *
*   permit persons to whom the Software is furnished to do so, subject to *
*   the following conditions:                                             *
*                                                                         *
*   The above copyright notice and this permission notice shall be        *
*   included in all copies or substantial portions of the Software.       *
*                                                                         *
*   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,       *
*   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF    *
*   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*
*   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR     *
*   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, *
*   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR *
*   OTHER DEALINGS IN THE SOFTWARE.                                       *
***************************************************************************
*/
require(dirname(__FILE__)."/http.php");

define('CLASS_VERSION','1.0');

class akismet_base {
    var $url = array(
        'check' => 'http://${api}.rest.akismet.com/1.1/comment-check',
        'spam'  => 'http://${api}.rest.akismet.com/1.1/submit-spam',
        'ham'   => 'http://${api}.rest.akismet.com/1.1/submit-ham',
        'verify'=> 'http://rest.akismet.com/1.1/verify-key'
    );
    
    function get_url($type) {
        $api = & $this->key;
        return eval('return "'.$this->url[$type].'";');
    }
        
    function open_url($type,$params=array()) {
        $http = new http_class;
        $http->request_method='POST';
        $http->user_agent = "cesar-rodas/1.0 | Akismet-Class/".CLASS_VERSION;
        $http->follow_redirect=1;
        $http->redirection_limit=5;
        $http->exclude_address="";
        $http->protocol_version="1.1";
        $http->GetRequestArguments( $this->get_url($type) ,$arguments);
        
        $arguments['PostValues'] = $params;
        
        
        $this->err = $http->Open($arguments);
        if ($this->err != "") return false; 
        
        $this->err = $http->SendRequest($arguments); 
        if ($this->err != "") return false; 
        
        $this->err = $http->ReadReplyHeaders($gHeaders);
        if ($this->err != "") return false; 
        
        if ($http->response_status != 200) {
            $this->err = "Pages status: ".$http->response_status;
            $http->Close();
            return false;
        } 
        $response = '';
        for(;;)
        {
            $this->error=$http->ReadReplyBody($body,1000);
            if($this->error!=""
            || strlen($body)==0)
                break;
            $response .= $body;
        }
        $http->close();
        return $response;
    }
    
}

class akismet extends akismet_base {
    var $key;
    var $blog;

    
    /**
     *
     */
    function akismet($key='',$blog='') {
        $this->key  = $key;
        $this->blog = $blog;
    }

    /**
     *
     *
     */
    function isspam($ip='',$author='',$email='',$url='',$content='') {
        $params = array(
            'blog' => $this->blog,
            'user_ip' => $ip,
            'comment_author' => $author,
            'comment_author_email' => $email,
            'comment_author_url' => $url,
            'comment_content' => $content
        );
        
        return $this->open_url('check',$params) == 'true';
    }
    
    function addham($ip='',$author='',$email='',$url='',$content='') {
        $params = array(
            'blog' => $this->blog,
            'user_ip' => $ip,
            'comment_author' => $author,
            'comment_author_email' => $email,
            'comment_author_url' => $url,
            'comment_content' => $content
        );
        
        return $this->open_url('ham',$params) == 'true';
    }
    
    function addspam($ip='',$author='',$email='',$url='',$content='') {
        $params = array(
            'blog' => $this->blog,
            'user_ip' => $ip,
            'comment_author' => $author,
            'comment_author_email' => $email,
            'comment_author_url' => $url,
            'comment_content' => $content
        );
        
        return $this->open_url('spam',$params) == 'true';
    }
    
    function verify() {
        $params = array(
            'key' => $this->key,
            'blog' => $this->blog
        );
        return $this->open_url('verify', $params) == 'valid';
        
    }

} 
?>