<?php 
include 'firewall.class.php';
/****************************************************************************************
*   Class   :   firewall
*   Ver.    :   1.0
*   Author  :   Temperini Mirko  <dottwatson@hotmail.it>
*   Date    :   03-29-2010
*   License :   GPL License
*
*   IMPORTANT!!!
*
*    The firewall must be EVER started at the top of  the script ( think to session_start() as condition rules)  
*
*   ONLY ONE ISTANCE IS ALLOWED IN A PAGE!!! 
*   
* 
*   calling costructor, you can pass directly the rules table to parse
*   eg: 
*   
*   $myFirewall = new firewall(fielname.ext);
*   and the table is directly loaded
*
*
*
*   you can set 2 different types of output on deny ip:
*   default:     send an header with 403 Status (Forbidden)
*   redirect:    it redirect by a single javascript line to a link specified.
*               why javascript? because when a server is not propelry setted or the page have already sended the header, it not fail.  
*               $myFirewall->setAction('redirect','http://www.google.com');
*
*   show:       simply output the code you pass in 
*               $myFirewall->setAction( 'show',file_get_contents('forbidden.tpl') );
*
*
*   if no action is specified, the default is a blank page whit 403 Status Header (Forbidden)
*
*
*   ok, we turn On our firewall
*   $myFirewall->start();
*   
*   ----------------------------------------
*   |CAUTION!                               |
*   ----------------------------------------------------------------------------------------------------
*   the forceHostname() method try to resolve an IP from ah hipotetic hostname, when it isn't a valid   |
*   this feature can make your firewall slow! Depends from the necessary time to resolve the IP!        |
*   ----------------------------------------------------------------------------------------------------   
*   
*this class is successfull tested on PHP 5.3 
*
*   please report bugs at : <dottwatson@hotmail.it>
*   
*
*
*
*THANKS TO:
*
* Asbjorn Grandt,   <http://www.phpclasses.org/browse/author/193800.html> 
*                   for his contribute for better organize the rules evalution 
*              
****************************************************************************************/




/***************************************************************/
//EXEMPLE
//call firewall
$myFirewall = new firewall; 

/*
uncomment this line if must try to resolve ip from hostname. This feature is not available for an ip range rule.
CAUTION! this feature can make your firewall slow! Depends from the necessary time to resolve the IP!
*/
//$myFirewall -> forceHostname(true);

//set the callback function for allowed ip 
$myFirewall->onAllow('my_callback');

//set the callback function for allowed ip 
$myFirewall->onDeny('my_callback');


//set action for denied ip 
$myFirewall->setAction('show',file_get_contents('forbidden.tpl'));
   

//load the rules table
$myFirewall->loadTable('rules.table');


//dinamically add extra rules
//uncomment this line for see the difference
//$myFirewall->importRule('deny 127.0.0.1');

//error tracking
//uncomment this line for see the difference
//$myFirewall->importRule('asdasdasd');



//a simple callback function that dump out its arguments
function my_callback($ip,$rule,$errors){
    $finded_errors=(!empty($errors))?implode(',',$errors):'no errors found';
    $finded_rule=($rule !="")?$rule:'undefined';
    echo "
    <div style=\"position:fixed;top:0;left:0;color:#fff;background:#000\">
    <br />HI, I'm a callback, and I've this informations:<br />
    your ip is {$ip}<br />
    the rule that allowed you is [<code><i>{$finded_rule}</i></code>]<br />
    errors found are:<br />&nbsp;&nbsp;{$finded_errors}<br />
    </div>";
    }


//start up the firewall
$myFirewall->start();
/***************************************************************/



// if samething is wrong you can see this message
echo "<br /><br /><br />i'm showed!!!<br />";
?>