<?php
/*
- Autor Mathias Possinke
- Copyright 2006-2007 Matpo.de / Mapos-Scripts.de
*/

// include Config	
define('IN_MATPO', "true");
require_once('./config.inc.php');

// Lade Desingdatei Header
$Matpo_Design->Laden("index_body", "header");
$Matpo_Design->Values(array("{wobinich}" => "Online"));

$Matpo_Design->Laden("online_body", "online_uebersicht");

$onlinetime = time() - (60*5);
$abfrage_eintraege = "SELECT * FROM ".TABELLE_ONLINE." WHERE time > $onlinetime ORDER BY time DESC";
$ergebnis_eintraege = $matpo_sql->sql_query($abfrage_eintraege);
while($online = $matpo_sql->sql_fetch_object($ergebnis_eintraege))
{
	$Matpo_Design->Laden_Block("online_uebersicht_box");

	$online_user = $online->user;
	$online_wo = $online->wo;
	$online_time = $online->time;
	$online_onlinezeit = $online->onlinezeit;
	$min = floor($online_onlinezeit / 60);
	$online_onlinezeit = $online_onlinezeit - floor($min * 60);
	$sek  = floor($online_onlinezeit);
	$online_onlinezeit = "$min min, $sek sek";
	$online_wo_url = htmlentities($online->wo);
	$online_wo_name = htmlentities(basename($online->wo));
	if (empty($online_wo_name))
	{
		$online_wo_name = "Startseite";
		$wo_link = '<a href="./'.INDEX_PHP.'">'.$online_wo_name.'</a>';
	}
	elseif ($online_wo_name == htmlentities(INDEX_PHP))
	{
		$online_wo_name = "Startseite";
		$wo_link = '<a href="./'.INDEX_PHP.'">'.$online_wo_name.'</a>';
	}
	elseif ($online_wo_name == htmlentities(NEWS_PHP))
	{
		$online_wo_name = "News";
		$wo_link = '<a href="./'.NEWS_PHP.'">'.$online_wo_name.'</a>';
	}
	elseif ($online_wo_name == htmlentities(GRUPPEN_PHP))
	{
		$online_wo_name = "Gruppen";
		$wo_link = '<a href="./'.GRUPPEN_PHP.'">'.$online_wo_name.'</a>';
	}
	elseif ($online_wo_name == htmlentities(FAQ_PHP))
	{
		$online_wo_name = "FAQ";
		$wo_link = '<a href="./'.FAQ_PHP.'">'.$online_wo_name.'</a>';
	}
	elseif ($online_wo_name == htmlentities(MITGLIEDER_PHP))
	{
		$online_wo_name = "Mitglieder";
		$wo_link = '<a href="./'.MITGLIEDER_PHP.'">'.$online_wo_name.'</a>';
	}
	elseif ($online_wo_name == htmlentities(ARCHIV_PHP))
	{
		$online_wo_name = "Bilder Anschauen";
		$wo_link = $online_wo_name;
	}
	elseif ($online_wo_name == htmlentities(PROFIL_PHP))
	{
		$online_wo_name = "Profil bearbeiten";
		$wo_link = $online_wo_name;
	}
	elseif ($online_wo_name == htmlentities(IMPRESSUM_PHP))
	{
		$online_wo_name = "Impressum";
		$wo_link = '<a href="./'.IMPRESSUM_PHP.'">'.$online_wo_name.'</a>';
	}
	elseif ($online_wo_name == htmlentities(AGB_PHP))
	{
		$online_wo_name = "Regeln";
		$wo_link = '<a href="./'.AGB_PHP.'">'.$online_wo_name.'</a>';
	}
	elseif ($online_wo_name == htmlentities(ONLINE_PHP))
	{
		$online_wo_name = "Online bersicht";
		$wo_link = '<a href="./'.ONLINE_PHP.'">'.$online_wo_name.'</a>';
	}
	elseif ($online_wo_name == htmlentities(KONTAKT_PHP))
	{
		$online_wo_name = "Kontakt";
		$wo_link = '<a href="./'.KONTAKT_PHP.'">'.$online_wo_name.'</a>';
	}
	elseif ($online_wo_name == htmlentities(GALERIE_PHP))
	{
		$online_wo_name = "Galerie";
		$wo_link = '<a href="./'.GALERIE_PHP.'">'.$online_wo_name.'</a>';
	}
	else
	{
		$online_wo_name = "n/a";
		$wo_link = $online_wo_name;
	}
	
	
	if ($online_user >= 1)
	{
		$abfrage_user = "SELECT * FROM ".TABELLE_USER." WHERE id = '$online_user'";
		$ergebnis_user = $matpo_sql->sql_query($abfrage_user);
		if ($user = $matpo_sql->sql_fetch_object($ergebnis_user))
		{	
			$mitglied_id = (int) $user->id;
			$mitglied_name = trim(htmlentities($user->name));
			$mitglied_email = trim(htmlentities($user->email));
			$mitglied_icq = (int) $user->icq;
			$mitglied_msn = trim(htmlentities($user->msn));
			$mitglied_yahoo = trim(htmlentities($user->yahoo));
			$mitglied_webseite = trim(htmlentities($user->webseite));
			$mitglied_reg_time = (int) $user->reg_time;
			$mitglied_letzt_login_time = (int) $user->letzt_login_time;
			$mitglied_letzt_login_ip = trim($user->letzt_login_ip);
			$mitglied_email_anzeigen = (int) $user->email_anzeigen;
			$ergebnis = $matpo_sql->sql_query("SELECT * FROM ".TABELLE_USER."_gruppen WHERE user_id = '$mitglied_id'") or die ($matpo_sql->sql_error());
			if($user_gruppen = $matpo_sql->sql_fetch_object($ergebnis))
			{
				$mitglied_gruppen_id = $user_gruppen->gruppen_id;
				$abfrage = "SELECT * FROM ".TABELLE_GRUPPEN." WHERE id = '$mitglied_gruppen_id'";
				$ergebnis = $matpo_sql->sql_query($abfrage) or die ($matpo_sql->sql_error());
				if($gruppen = $matpo_sql->sql_fetch_object($ergebnis))
				{
					
					if ($gruppen->online_markierung)
					{
						$mitglied_name_a = ereg_replace("\[user\]", $mitglied_name." [".htmlentities($gruppen->name)."]", $gruppen->online_markierung);
						
						$mitglied_name_a = $mitglied_name_a ? $mitglied_name_a : $mitglied_name." [".htmlentities($gruppen->name)."]";
					}
					else
					{
						$mitglied_name_a = $mitglied_name." [".htmlentities($gruppen->name)."]";
					}
				}
			}
			else
			{
				$mitglied_name_a = $mitglied_name;
			}
			$online_user = '<a href="./'.MITGLIEDER_PHP.'?profil='.$mitglied_name.'">'.$mitglied_name_a.'</a>';		
			
		}
		else
		{
			$online_user = "Gast";
		}
	}
	else
	{
		$hostname = gethostbyaddr($online->ip);
		$hostname = explode(".", $hostname);		
		$bote = count($hostname)-2;

		foreach($boten as $bote_suche => $bote_name)
		{
			if ($hostname[$bote] == $bote_suche)
			{
				$online_user = $bote_name;
			}
		}
		if (!$online_user)
		{
			$online_user = "Gast";
		}
	}
	$Matpo_Design->Values(array(
	"{online_user}" => $online_user,
	"{online_wo}" => $wo_link,
	"{online_onlinezeit}" => $online_onlinezeit,
	"{online_time}" => date("d.m.Y H:i", $online_time),
	),"online_uebersicht_box");
}

$Matpo_Design->Ersetze_Block("online_uebersicht_box", $Matpo_Design->online_uebersicht_box);

$couter_abfrage = "SELECT COUNT(*) FROM ".TABELLE_BILDER."";
$couter_ergebnis = $matpo_sql->sql_query($couter_abfrage);
$myrow = $matpo_sql->sql_fetch_row($couter_ergebnis);
$gesamt_bilder = (string) floor($myrow[0]);

$couter_abfrage = "SELECT COUNT(*) FROM ".TABELLE_BILDER." WHERE user_id > '0'";
$couter_ergebnis = $matpo_sql->sql_query($couter_abfrage);
$myrow = $matpo_sql->sql_fetch_row($couter_ergebnis);

$gesamt_mitglieder_bilder = (string) floor($myrow[0]);
$gesamt_gaeste_bilder = (string) floor($gesamt_bilder - $gesamt_mitglieder_bilder);

$couter_abfrage = "SELECT COUNT(*) FROM ".TABELLE_BILDER." WHERE time > '".strtotime("00:00:01")."'";
$couter_ergebnis = $matpo_sql->sql_query($couter_abfrage);
$myrow = $matpo_sql->sql_fetch_row($couter_ergebnis);
$gesamt_bilder_heute = (string) floor($myrow[0]);


$ergebnis = $matpo_sql->sql_query("SELECT COUNT(*) FROM ".TABELLE_USER."");
$myrow = $matpo_sql->sql_fetch_row($ergebnis);
$count_user = (string) floor($myrow[0]);


	
$verbrauchter_webspace = verbrauchter_webspace();
if (floor($verbrauchter_webspace->gb) >= 1)
{
	$verbrauchter_webspace = $verbrauchter_webspace->gb." GB";
}
elseif (floor($verbrauchter_webspace->mb) >= 1)
{
	$verbrauchter_webspace = $verbrauchter_webspace->mb." MB";
}
elseif (floor($verbrauchter_webspace->kb) >= 1)
{
	$verbrauchter_webspace = $verbrauchter_webspace->kb." KB";
}
else
{
	$verbrauchter_webspace = $verbrauchter_webspace->bb." BB";
}

$abfrage_user = "SELECT * FROM ".TABELLE_USER." ORDER BY id DESC";
$ergebnis_user = $matpo_sql->sql_query($abfrage_user);
if ($user = $matpo_sql->sql_fetch_object($ergebnis_user))
{
	$user_name = trim(htmlentities($user->name));
	$user_name_link = trim(urlencode($user->name));
}
else
{
	$user_name = trim(htmlentities("Keiner"));
	$user_name_link = trim(urlencode("Keiner"));
}

$Matpo_Design->Values(array(
"{gesamt_bilder_heute}" => $gesamt_bilder_heute,
"{count_user}" => $count_user,
"{gesamt_bilder}" => $gesamt_bilder,
"{gesamt_gaeste_bilder}" => $gesamt_gaeste_bilder,
"{gesamt_mitglieder_bilder}" => $gesamt_mitglieder_bilder,
"{verbracht_webspace}" =>  $verbrauchter_webspace,
"{mitglied_name}" => $user_name,
"{mitglied_name_link}" => $user_name_link,
));
	
// Lade Desingdatei Footer
$Matpo_Design->Laden("index_body", "footer");
// Desingdatei Ausgeben
$Matpo_Design->Ausgeben();
$matpo_sql->sql_close();
?>