<?php
/*
- Autor Mathias Possinke
- Copyright 2006-2008 Matpo.de / Mapos-Scripts.de
*/
if (!defined('IN_MATPO'))
{
	die("Hacking attempt");
}
function bbcode($text)
{
	$text = str_replace("\r\n", "\r", $text);
	$text = preg_replace("/\[b\](.*?)\[\/b\]/si", "<b>$1</b>", $text); //Fett
	$text = preg_replace("/\[i\](.*?)\[\/i\]/si", "<i>$1</i>", $text); //kussif
	$text = preg_replace("/\[u\](.*?)\[\/u\]/si", "<u>$1</u>", $text); //unterstrichen
	$text = preg_replace("/\[s\](.*?)\[\/s\]/si", "<strike>$1</strike>", $text); //Durchstrichen
	$text = preg_replace("/\[img\](.*?)\[\/img\]/e", 'bild_anpassen("$1")', $text);
	$text = preg_replace("/\[imgl\](.*?)\[\/imgl\]/e", 'bild_anpassen("$1", "left")', $text);
	$text = preg_replace("/\[imgr\](.*?)\[\/imgr\]/e", 'bild_anpassen("$1", "right")', $text);
	$text = preg_replace("/\[url=(.*?)\](.*?)\[\/url\]/e", 'link_anpassen("$1", "$2")', $text);
	$text = preg_replace("/\[url\](.*?)\[\/url\]/e", 'link_anpassen("$1")', $text);		
	$text = preg_replace("/\[email=(.*?)\](.*?)\[\/email\]/si", '<a href="mailto:$1">$2</a>', $text);	
	$text = preg_replace("/\[color=(.*?)\](.*?)\[\/color\]/si", '<font color="$1">$2</font>', $text);
	$text = preg_replace("/\[zitat\](.*?)\[\/zitat\]/se", 'zitat_anpassen("$1")', $text); 
	$text = preg_replace("/\[code\](.*?)\[\/code\]/se", 'code_anpassen("$1")', $text);	
	$text = preg_replace("/\[line\]/si", '<hr style="color: black;" size="2" noshade="noshade"/>', $text);
	$text = preg_replace("/\[line=(.[0-9]?)\]/si", '<hr style="color: black;" size="$1" noshade/>', $text);
	$text = preg_replace("/\[line=(.[0-9]?)=(.*?)\]/si", '<hr style="color: $2;" size="$1" noshade/>', $text);	
	$text = preg_replace("/\[rahmen\](.*?)\[\/rahmen\]/si", '<div class="zitat">$1</div>', $text); 
	$text = preg_replace("/\[font=(.*?)\](.*?)\[\/font\]/si", '<font face="$1">$2</font>', $text);
	$text = preg_replace("/\[size=(.*?)\](.*?)\[\/size\]/si", '<font size="$1">$2</font>', $text);	
	$text = preg_replace("/\[left\](.*?)\[\/left\]/si", '<div align="left">$1</div>', $text);
	$text = preg_replace("/\[center\](.*?)\[\/center\]/si", '<div align="center">$1</div>', $text);
	$text = preg_replace("/\[right\](.*?)\[\/right\]/si", '<div align="right">$1</div>', $text);
	$text = preg_replace("/\[liste\](.*?)\[\/liste\]/se", 'liste_anpassen("$1")', $text);
	$text = preg_replace("/\[html\](.*?)\[\/html\]/se", 'html("$1")', $text);	
	return $text;
}
// Test Html Code
function html($text)
{
	$text = html_entity_decode($text);
	return $text;
}
// BBcode Zitat
function zitat_anpassen($text)
{
$text = ereg_replace("\r\n", "<br>", $text);

$zitat = '<b>Zitat:</b><br /><div class="BBCode_Zitat">'.$text.'&nbsp;</div>';
$zitat = ereg_replace("\r\n", "", $zitat);
return $zitat;
}

// BBcode Code
function code_anpassen($code)
{
	$code = ereg_replace("\r\n", "<br>", $code);
	$code = stripslashes($code);
	$neu_code = '<b>Code:</b><br /><div class="BBCode_Code">'.$code.'&nbsp;</div>';
	$neu_code = ereg_replace("\r\n", "", $neu_code);
	return $neu_code;
}


function bild_anpassen($link,$align = '')
{
	global $config;
	global $dbsql;
	
	if ($align == "left"){$align = ' align="left"';}
	elseif ($align == "right"){$align = ' align="right"';}
	else{$align = '';}
	if (!ini_get('allow_url_fopen'))
	{
		$neu_bild = '<img src="'.$link.'" border="0" alt="'.$link.'"'.$align.'/>'."\n";
	}
	elseif ($size = @getimagesize($link))
	{
		$neu_breite = $config->bild_max_breite; 
 		$breite = $size[0]; 
		$hoehe = $size[1];
		if ($breite >= $neu_breite)
		{
  		$neueBreite = $neu_breite;
  		$neueHoehe = @intval($hoehe*$neueBreite/$breite);
  	}
  	else
  	{
  		$neueBreite = $breite;
  		$neueHoehe = $hoehe;
  	}
		$neu_bild = '<img src="'.$link.'" border="0" width="'.$neueBreite.'" height="'.$neueHoehe.'" alt="'.$link.'"'.$align.'/>'."\n";
	}
	else
	{
		$neu_bild = '[url]'.$link.'[/url]';
	}
	return $neu_bild;
}
// BBcode Link / URL
function link_anpassen($link, $linkname = 0)
{
	if (!$linkname)
	{
	 	$linkname = trim($link);
		if (substr($linkname, 0, 7) == "http://")
		{
			$linkname = substr($linkname, 7);
		}
	}
	if (substr($link, 0, 7) !== "http://")
	{
			$link = "http://".$link;
	}
	$neu_link = '<a href="'.$link.'" target="_blank" class="eintrag_link">'.$linkname.'</a>'."\n";
	return $neu_link;
}

function liste_anpassen($text)
{
	$neu_text = explode("<br />", $text);
	$liste = '';
	foreach($neu_text as $value)
	{
		$value = explode("[*.]", $value);
		$value = trim($value[0]);
		
		if (substr($value, 0, 3) == "[*]")
		{
			$liste .= "<li>".substr($value, 3)."</li>\n";
		}
	}
	$liste = "<ul>\n".$liste."</ul>";
	return $liste;
}
?>