<?php
/*
- Autor Mathias Possinke
- Copyright 2006-2007 Matpo.de / Mapos-Scripts.de
*/

// include Config		
define('IN_MATPO', "true");
require_once('../config.inc.php');
$Matpo_Design->Laden("admin_body", "header");

if ($user_daten['login'] and $user_daten['type'] == 1)
{
	$Matpo_Design->Laden("admin_body", "admin_header");
	
	$Matpo_Design->Laden("admin_bilder_archiv", "bilder_archiv");		

	
	# seiten
	
	$seitenlinks = 20;
	$pro_seite = 25;
	
	$seite = isset($_GET['seite']) ? filter_int($_GET['seite']) : 1;
	
	$ergebnis_bild = $matpo_sql->sql_query("SELECT COUNT(*) FROM ".$dbsql."bilder_daten") or die ($matpo_sql->sql_error());
	$count_bild = $matpo_sql->sql_fetch_row($ergebnis_bild);
	$count_bild = ( int ) $count_bild[0];
	
	$seiten_insgesammt = ceil($count_bild / $pro_seite);
	if ($seiten_insgesammt == 0){$seiten_insgesammt = 1;}
	if ($seite >= $seiten_insgesammt){$seite = $seiten_insgesammt;}
	
	$seitenlinks -= 1;
	$for_seiten = round($seitenlinks/2, 2);
	
	$for_seiten_a = floor($for_seiten * 2) + 1;
	
	$for_seiten_b = round($for_seiten_a - 1);
	
	$for_seiten_von = ceil($seite - $for_seiten);
	$for_seiten_bis = $seite + round($for_seiten);
	
	if ($for_seiten_von < 1){$for_seiten_bis = $for_seiten_a;}
	if ($for_seiten_bis > $seiten_insgesammt){$for_seiten_von = $seiten_insgesammt-$for_seiten_b;}
	
	$Matpo_Design->Laden_Block("seiten_links");
	$seiten_links = $Matpo_Design->seiten_links;
	$seiten_url = array();
	for ($i=1;$i <= $seiten_insgesammt;$i++)
	{	
		if ($i >= $for_seiten_von and $i <= $for_seiten_bis)
		{
			
			if ($i == $seite) 
			{
				$seiten_url[] = ereg_replace("{atuelle_seite}", "$i", "<b>$seiten_links</b>");
			}
			else
			{
				$seiten_url[] = ereg_replace("{atuelle_seite}", "$i", $seiten_links);
			}
			
		}
	}
	$seiten_url = implode(' ', $seiten_url);
	$seite_vor = floor($seite + 1);
	if ($seite_vor >= $seiten_insgesammt){$seite_vor = $seiten_insgesammt;}
	$seite_zurueck = floor($seite - 1);
	if ($seite_zurueck < 1){$seite_zurueck = 1;}	
	
	$tabellebeitrage_bis = $pro_seite;
	$tabellebeitrage_von = ($pro_seite * $seite) - $pro_seite;
	$Matpo_Design->Ersetze_Block("seiten_links", $seiten_url);
	
	
	$seite_vor = floor($seite + 1);
	if ($seite_vor >= $seiten_insgesammt){$seite_vor = $seiten_insgesammt;}
	$seite_zurueck = floor($seite - 1);
	if ($seite_zurueck < 1){$seite_zurueck = 1;}	
	
	$tabellebeitrage_bis = $pro_seite;
	$tabellebeitrage_von = ($pro_seite * $seite) - $pro_seite;

	$Matpo_Design->Values(array(
	"{seite_zurueck}" => (string) $seite_zurueck,
	"{seite_vor}" => (string) $seite_vor,
	"{seite_ganz_vor}" => (string) $seiten_insgesammt,
	"{seite}" => (string) $seite,
	));
	# Ende Seiten
	
	$abfrage = "SELECT * FROM ".$dbsql."bilder_daten ORDER BY time DESC LIMIT $tabellebeitrage_von, $tabellebeitrage_bis";
	$ergebnis = $matpo_sql->sql_query($abfrage) or die ($matpo_sql->sql_error());
	while($bild = $matpo_sql->sql_fetch_object($ergebnis))
	{
		$bild_id = $bild->id;
		$bild_name = htmlspecialchars($bild->url);
		$bilder_url = urlencode($bild->url);
		$bild_root_link = UPLOADER_DIR.$config->bilder_ordner."/".$bild->url;
		$bild_info = new Matpo_Bild($bild_root_link);
		if (!$bild_info->error)
		{
			$Matpo_Design->Laden_Block("bild_archiv_box");
			$bild_text = filter_string($bild->text);
			$bild_email = filter_string($bild->email);
			$bild_bewertungen = filter_int($bild->bewertungen);
			$bild_bewertungen_stimmen = filter_int($bild->bewertungen_stimmen);
			$bild_bewertung =  @round($bild_bewertungen / $bild_bewertungen_stimmen, 2);
			$bild_user_id = filter_int($bild->user_id);
			$bild_time = filter_int($bild->time);
			$bild_tage = filter_int($bild->bis_time);
			$bild_loeche_time = (60*60*24*$bild_tage)+$bild->time;
			$bild_ip = filter_string($bild->ip);
			$bild_aufrufe = filter_int($bild->aufrufe);
			
	 		$bild_breite = (string) $bild_info->breite; 
			$bild_hoehe = (string) $bild_info->hoehe;
			
	  	$bild_groesse_bb = @filesize($bild_root_link);
	  	$bild_groesse_kb = round($bild_groesse_bb/1024, 2);
	  	$bild_groesse_mb = round($bild_groesse_bb/1024/1024, 2);
				
			$berechnen = $bild_info->groesse_berechnen($config->tumbnail_breite, $config->tumbnail_hoehe);
  		$bild_breite = $berechnen["breite"];
  		$bild_hoehe = $berechnen["hoehe"];
	
			if ($bild_user_id >= 1)
			{
				$abfrage_eintraege = "SELECT * FROM ".$dbsql."user WHERE id = '".$bild_user_id."'";
				$ergebnis_eintraege = $matpo_sql->sql_query($abfrage_eintraege);
				$user = $matpo_sql->sql_fetch_object($ergebnis_eintraege);
				if ($user)
				{
					$mitglied_name = trim(htmlentities($user->name));
					$mitglied_name_link = trim(urlencode($user->name));
					$bild_user = '<a href="'.$config->script_ordner.'/mitglieder.php?profil='.$mitglied_name_link.'" title="'.$mitglied_name.'">User</a>';
				}
				else
				{
					$bild_user = 'User';
				}
			}
			else
			{
				$bild_user = "Gast";
			}
	  	$Matpo_Design->Values(array(
	  	"{bild_breite}" => $bild_breite,
	  	"{bild_hoehe}" => $bild_hoehe,
	  	"{bild_id}" => (string)$bild_id,
	  	"{bild_name}" => $bild_name,
	  	"{bild_name_gekrzt}" => text_kurzen($bild_name, 15),
	  	"{link_bild_name}" => $bilder_url, 
	  	"{bild_email}" => $bild_email, 
	  	"{bild_text}" => $bild_text,
	  	"{bild_user}" => $bild_user,
	  	"{bild_groesse_kb}" => (string) $bild_groesse_kb,
	  	"{bild_datum}" => date($config->datum_format, $bild_time),
	  	"{bild_loeche_datum}" => date($config->datum_format, $bild_loeche_time),
	  	"{bild_tage}" => $bild_tage,
	  	"{bild_bewertung}" => (string) $bild_bewertung,
	  	"{bild_aufrufe}" => (string) $bild_aufrufe,
	  	"{bild_ip}" => $bild_ip,
	  	),"bild_archiv_box");
  	}
  	else
  	{
  		$matpo_sql->sql_query("DELETE FROM ".$dbsql."bilder_daten WHERE id = '$bild_id'");
  	}
	}
	
	if (isset($Matpo_Design->bild_archiv_box))
	{
		$Matpo_Design->Ersetze_Block("bild_archiv_box", $Matpo_Design->bild_archiv_box);
	}
	else
	{
		$Matpo_Design->Ersetze_Block("bild_archiv_box");
	}
	
		
	$Matpo_Design->Laden("admin_body", "admin_footer");
	$matpo_sql->sql_query("INSERT INTO ".$dbsql."admin_logs  (log) VALUES ('".$user_daten['id']."|".$user_daten['name']."|".time()."|".$config->user_ip."|".$_SERVER['REQUEST_URI']."')");
}
else
{
		Header("Location: ./admin.php");
}
$Matpo_Design->Laden("admin_body", "footer");

// Desingdatei Ausgeben
$Matpo_Design->Ausgeben();
$matpo_sql->sql_close();
?>