<?php
/*
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2005 Michael Mifsud
 */

/**
 * This script is to setup the TinyMCE javascript WYSIWYG Editor
 * 
 * @package Ui
 */
class Jdk_Ui_TinyMce extends Dom_Renderer 
{
    
    const MODE_SIMPLE = 0;
    const MODE_BASIC= 1;
    const MODE_NORMAL = 2;
    const MODE_ADVANCED = 3;
    
    /**
     * @var integer
     */
    private $mode = self::MODE_SIMPLE;
    
    
    
    
    /**
     * @var string
     */
    private $initStr = '';
    
    /**
     * @var string
     */
    private $selectorClass = 'mceEditor';
    
    /**
     * @var string
     */
    private $deselectorClass = 'mceNoEditor';
    
    /**
     * @var array
     */
    private $initParams = array();
    
    /**
     * @var array
     */
    private $plugins = array();
    
    
    
    /**
     * @var Dk_Util_Url
     */
    private $editorCss = null;
    
    /**
     * @var array
     */
    private $settings = array();
    
    /**
     * A relative path form the site data path
     * @var string
     */
    private $libPath = '/tiny_mce3';
    
    /**
     * A relative path from the site data path
     * @var string
     */
    private $publicFilePath = '';
    
    
     
    /**
     * __construct
     * 
     */
    function __construct()
    {
        $this->publicFilePath = Dk_Config::getInstance()->getDataDir() . '/.tinyMce';
        $this->libPath = Dk_Config::getInstance()->getDataDir() . '/tiny_mce3';
    }
    
    /**
     * The current default init.
     * 
     * @todo this will change in the future, and subclassing will be the preferred usage
     */
    function init()
    {
        $config = Dk_Config::getInstance();
        $this->settings['FileRoot'] = $config->getFileRoot();
        $this->settings['HtdocRoot'] = $config->getHtdocRoot();
        $this->settings['FileManagerPath'] = $this->publicFilePath;
        Dk_Session::getInstance()->setParameter('mce-params', $this->settings);
        
        
        // Unzip tiny mce package if required.
        if (!is_dir($this->libPath) && is_writable(dirname($this->libPath))) {
            $shell = new Dk_Util_Shell();
            $cmd = sprintf("cd %s && tar zxf %s/lib/Jdk/other/tiny_mce3.tgz", dirname($this->libPath), $config->getFileRoot());
            $shell->system($cmd);
        }
        
        // add default jdkmanager plugin
        if ($this->mode >= 1) {
            $this->plugins = array_merge(array('jdkmanager' => 'jdkmanager'), $this->plugins);
            if (!is_dir($this->publicFilePath)) {
                mkdir($this->publicFilePath, 0777, true);
            }
        }
        $this->addInitParam('remove_linebreaks', 'false');
        $this->addInitParam('convert_urls', 'false');
        $this->addInitParam('relative_urls', 'false');
        $this->addInitParam('remove_script_host', 'true');
        $sName = Dk_Session::getInstance()->getName();
        $this->addInitParam('dk_sessionName', enquote($sName));
        if ($this->editorCss != null) {
            $this->addInitParam('content_css', enquote($this->editorCss->toString()));
        }
        $paramStr = '';
        $i = 0;
        foreach ($this->initParams as $k => $v) {
            $paramStr .= "$k : $v";
            if ($i < count($this->initParams)-1) {
                $paramStr .= ",\n";                
            }
            $i++;
        }
        
        // build plugin strings
        $plugins = '';
        $extPlugins = '';
        if (count($this->plugins) > 0) {
            $plugins = implode(',', $this->plugins) . ',';
            $extPlugins = implode(',', $this->plugins) . ',|,';
        }
        
        // Replace all template strings 
        $this->initStr = $this->getInit();
        $this->initStr = str_replace('@CSS_SELECTOR_CLASS@', $this->selectorClass, $this->initStr);
        $this->initStr = str_replace('@CSS_DESELECTOR_CLASS@', $this->deselectorClass, $this->initStr);
        $this->initStr = str_replace('@PLUGINS@', $plugins, $this->initStr);
        $this->initStr = str_replace('@EXT_PLUGINS@', $extPlugins, $this->initStr);
        $this->initStr = str_replace('@MCE_PARAMS@', $paramStr, $this->initStr);
        
    }
    
    /**
     * show
     * 
     * @param Dom_Template $template
     */
    function show($template = null)
    {
        $this->init();
        
        $path = str_replace(Dk_Config::getInstance()->getFileRoot(), '', $this->libPath);
        
        $jsUrl = new Dk_Util_Url($path . '/tiny_mce.js');
        $template->appendHeadElement('script', 
            array('type' => 'text/javascript', 'src' => $jsUrl->toString()));
            
        $url = new Dk_Util_Url($path . '/utils/validate.js');
        $template->appendHeadElement('script', 
            array('type' => 'text/javascript', 'src' => $url->toString()));
        
        $template->appendHeadElement('script', 
            array('type' => 'text/javascript'), $this->initStr);
    }
    
    /**
     * Set the deselector class for tinymce params
     * (default: mceEditor)
     * 
     * @param string $str
     */
    function setSelectorClass($str)
    {
        $this->selectorClass = $str;
    }
    
    /**
     * set the deselector class for tinymce
     * (default: mceNoEditor)
     *
     * @param string $str
     */
    function setDeselectorClass($str)
    {
        $this->deselectorClass = $str;
    }
    
    /**
     * Enable a plugin
     *
     * @param unknown_type $name
     */
    function enablePlugin($name)
    {
        $this->plugins[$name] = $name;
    }
    
    /**
     * Enable a plugin
     *
     * @param string $name
     */
    function disablePlugin($name)
    {
        $tmp = $this->plugins[$name];
        if (isset($this->plugins[$name])) {
            unset($this->plugins[$name]);
        }
        return $tmp;
    }
    
    
    /**
     * Add a MCE parameter to replace the @MCE_PARAMS@ string in the init templates 
     * 
     * For string `$value` parameters use enquote() to wrap the string in single quotes.
     * 
     * @param string $name
     * @param string $value
     */
    function addInitParam($name, $value)
    {
        $this->initParams[$name] = $value;
    }
    
    /**
     * Get teh init params array
     *
     * @return array
     */
    function getInitParams()
    {
        return $this->initParams;
    }
    
    /**
     * Set the base css path for the editor window
     * 
     *  content_css: <url>
     * 
     * @param Dk_Util_Url $url
     */
    function setEditorCss($url)
    {
        $this->editorCss = $url;
    }
    
    /**
     * Get the editor css files url
     *
     * @return Dk_Util_Url
     */
    function getEditorCss()
    {
        return $this->editorCss;
    }
    
    /**
     * Set the init string for the TinyMCE editor
     * Set the init string template, the replaceable variables are: 
     * 
     *  o @CSS_SELECTOR_CLASS@ The css selector class (default: mceEditor)
     *  o @CSS_DESELECTOR_CLASS@ The css deselector class (default: mceNoEditor)
     *  o @PLUGINS@ Any plugins that are to be added, using Jdk_Ui_TinyMce::enablePlugin()
     *  o @Ext_PLUGINS@ Any plugins that are to be added, using Jdk_Ui_TinyMce::enablePlugin()
     *  o @MCE_PARAMS@ Any mce setup parameters, from Jdk_Ui_TinyMce::getInitParams()
     * 
     * @param string $str
     * @see http://tinymce.moxiecode.com/
     * @see Jdk_Ui_TinyMce::getDefinedInit() For default examples
     */
    function setInit($str)
    {
        $this->initStr = $str;
    }
    
    /**
     * Return the mce javascript init template string
     *
     * @return string
     */
    final function getInit()
    {
        if ($this->initStr) {
            return $this->initStr;
        }
        return $this->getDefinedInit();
    }
    
    /**
     * Set the display Mode of the editor 
     * (Default: self::MODE_SIMPLE)
     *
     * @param integer $const
     */
    function setDefaultMode($const)
    {
        $this->mode = $const;
    }
    
    /**
     * Get the current mode of MCE
     *
     * @return integer
     */
    function getDefaultMode()
    {
        return $this->mode;
    }
    
    /**
     * Set the mce editors public path for adding user files.
     * Usually used by the jdkmanager plugin
     * 
     * This should be the full file path to a writable directory 
     *
     * @param string $str
     */
    function setPublicFilePath($str)
    {
        $this->publicFilePath = $str;    
    }
    
    
    /**
     * Get the init string of a predefined mode.
     *
     * @param integer $mode
     */
    private function getDefinedInit()
    {
        switch($this->mode)
        {
            case self::MODE_ADVANCED:
                $str = "tinyMCE.init({
  mode : 'textareas',
  theme : 'advanced',
  skin : 'o2k7',
  editor_selector : '@CSS_SELECTOR_CLASS@',
  editor_deselector : '@CSS_DESELECTOR_CLASS@',
  plugins : '@PLUGINS@safari,pagebreak,style,layer,table,save,advhr,advimage,advlink,emotions,iespell,insertdatetime,preview,media,searchreplace,print,paste,directionality,fullscreen,noneditable,visualchars,nonbreaking,xhtmlxtras,template',
  theme_advanced_buttons1 : '@EXT_PLUGINS@bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,|,formatselect,fontselect,fontsizeselect,|,forecolor,backcolor',
  theme_advanced_buttons2 : 'pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,link,unlink,anchor,image,media,cleanup,removeformat,code,|,insertdate,inserttime,preview,|,hr,charmap,|,fullscreen',
  theme_advanced_buttons3 : 'tablecontrols,|,removeformat,visualaid,|,sub,sup,|,emotions,iespell,advhr,|,print,|,ltr,rtl',
  theme_advanced_buttons4 : 'insertlayer,moveforward,movebackward,absolute,|,styleprops,|,cite,abbr,acronym,del,ins,attribs,|,visualchars,nonbreaking',
  theme_advanced_toolbar_location : 'top',
  theme_advanced_toolbar_align : 'left',
  theme_advanced_statusbar_location : 'bottom',
  theme_advanced_resizing : true,
  @MCE_PARAMS@
});";
                break;
            case self::MODE_NORMAL:
                $str = "tinyMCE.init({
  mode : 'textareas',
  theme : 'advanced',
  skin : 'o2k7',
  editor_selector : '@CSS_SELECTOR_CLASS@',
  editor_deselector : '@CSS_DESELECTOR_CLASS@',
  plugins : '@PLUGINS@safari,pagebreak,style,layer,table,save,advhr,advimage,advlink,emotions,iespell,insertdatetime,preview,media,searchreplace,print,paste,directionality,fullscreen,noneditable,visualchars,nonbreaking,xhtmlxtras,template',
  theme_advanced_buttons1 : '@EXT_PLUGINS@bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,|,formatselect,fontselect,fontsizeselect,|,forecolor,backcolor',
  theme_advanced_buttons2 : 'pastetext,pasteword,|,bullist,numlist,|,outdent,indent,blockquote,|,link,unlink,anchor,image,media,cleanup,removeformat,code,|,insertdate,inserttime,preview,|,hr,charmap,|,fullscreen',
  theme_advanced_buttons3 : '',
  theme_advanced_buttons4 : '',
  theme_advanced_toolbar_location : 'top',
  theme_advanced_toolbar_align : 'left',
  theme_advanced_statusbar_location : 'bottom',
  theme_advanced_resizing : true,
  @MCE_PARAMS@
});";
                break;
            case self::MODE_BASIC:
                $str = "tinyMCE.init({
  mode : 'textareas',
  theme : 'advanced',
  skin : 'o2k7',
  editor_selector : '@CSS_SELECTOR_CLASS@',
  editor_deselector : '@CSS_DESELECTOR_CLASS@',
  plugins : '@PLUGINS@safari,paste',
  theme_advanced_buttons1 : '@EXT_PLUGINS@bold,italic,underline,strikethrough,|,pastetext,pasteword,selectall',
  theme_advanced_buttons2 : '',
  theme_advanced_buttons3 : '',
  theme_advanced_buttons4 : '',
  theme_advanced_toolbar_location : 'top',
  theme_advanced_toolbar_align : 'left',
  theme_advanced_resizing : true,
  @MCE_PARAMS@
});";
                break;
            case self::MODE_SIMPLE:
                $str = "tinyMCE.init({
  mode : 'textareas',
  theme : 'advanced',
  skin : 'o2k7',
  editor_selector : '@CSS_SELECTOR_CLASS@',
  editor_deselector : '@CSS_DESELECTOR_CLASS@',
  plugins : '@PLUGINS@safari,paste',
  theme_advanced_buttons1 : '@EXT_PLUGINS@bold,italic,underline,|,pastetext,pasteword,|,strikethrough,justifyleft,justifycenter,justifyright,justifyfull,|,bullist,numlist,|,forecolor,backcolors,|,link,unlink,image,code',
  theme_advanced_buttons2 : '',
  theme_advanced_buttons3 : '',
  theme_advanced_toolbar_location : 'top',
  theme_advanced_toolbar_align : 'left',
  theme_advanced_statusbar_location : 'bottom',
  theme_advanced_resizing : true,
  @MCE_PARAMS@
});";
                break;
            default:
                $str = "tinyMCE.init({
  @MCE_PARAMS@
});";
        }
        return $str;
    }
    
}
?>