-- -----------------------------------
-- DkWiki install.sql
-- This is the db scheema for the DkWiki
-- 
-- 
-- 
-- 

-- --------------------------------------------------------
--
-- Table structure for table `page`
--
CREATE TABLE `page` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `currentTextId` int(11) unsigned NOT NULL default '0' COMMENT 'The current content record to associate this page with',
  `userId` INT UNSIGNED NOT NULL DEFAULT '1' COMMENT 'The original author of the page.',
  
  `title` varchar(255) NOT NULL default '' COMMENT 'This is the published text',
  `name` VARCHAR( 255 ) NOT NULL COMMENT 'This is the name used by urls',
  `keywords` varchar(255) NOT NULL default '' COMMENT 'User defined meta keywrds for the internal search engine',
  `css` text NOT NULL default '' COMMENT 'Any user defined css inline styles',
  `javascript` text NOT NULL default '' COMMENT 'Any user defined inline javascript',
  `hits` int(11) unsigned NOT NULL default '0' COMMENT 'The page views per session',
  `size` int(11) unsigned NOT NULL default '0' COMMENT 'The page content size in bytes',
  `score` FLOAT NOT NULL DEFAULT '0' COMMENT '',
  
  `modified` datetime NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE (`name`),
  fulltext(`title`, `keywords`),
  KEY (`currentTextId`)
) ENGINE=MYISAM;

-- --------------------------------------------------------
--
-- Table structure for tsp_pageable `text`
-- This is the text for the pages it will contain past revisions etc
--
CREATE TABLE `text` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `pageId` int(11) unsigned NOT NULL default '0' COMMENT 'The current content record to associate this page with',
  `userId` INT UNSIGNED NOT NULL DEFAULT '1' COMMENT 'The user who made the modifications (contributer)',
  `text` longtext NOT NULL default '',
  `created` DATETIME NOT NULL,
  PRIMARY KEY  (`id`),
  fulltext(`text`),
  KEY (`pageId`)
) ENGINE=MYISAM;

-- --------------------------------------------------------
--
-- Table structure for table `pageLink`
-- This table is a way to check for Orphaned pages
--
CREATE TABLE `pageLink` (
  `pageFrom` int(11) unsigned NOT NULL default '0',
  `pageToName` varchar(255) NOT NULL default '',
  UNIQUE KEY `pageFrom` (`pageFrom`,`pageToName`),
  KEY `pageToName` (`pageToName`,`pageFrom`)
) ENGINE=MYISAM;

-- --------------------------------------------------------
--
-- Table structure for table `pageLock`
-- This table is a way to check for Orphaned pages
--
CREATE TABLE `pageLock` (
  `hash` varchar(64) NOT NULL default '',
  `pageId` int(11) unsigned NOT NULL default '0',
  `userId` int(11) unsigned NOT NULL default '0',
  `userIp` varchar(32) NOT NULL default '',
  `expire` DATETIME NOT NULL,
  UNIQUE KEY `hash` (`hash`),
  KEY (`pageId`),
  KEY (`userId`)
) ENGINE=MYISAM;

-- --------------------------------------------------------
-- 
-- Table structure for table `user`
-- 
CREATE TABLE `user` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  
  `name` VARCHAR(128) NOT NULL DEFAULT '' COMMENT 'Required: ',
  `email` VARCHAR(128) NOT NULL DEFAULT '' COMMENT 'Required: ',
  `image` VARCHAR(255) NOT NULL DEFAULT '' COMMENT 'Optional: The user avtar image 120x120',
  `active` TINYINT(1) NOT NULL DEFAULT '1' COMMENT 'If the user is inactive they cannot login',
  
  `username` VARCHAR(64) NOT NULL DEFAULT '' COMMENT 'Required: ',
  `password` VARCHAR(64) NOT NULL DEFAULT '' COMMENT 'Required: ',
  `group` INT NOT NULL DEFAULT '0' COMMENT 'Required: ADMIN = 128, USER = 1',
  `hash` VARCHAR(64) NOT NULL DEFAULT '' COMMENT 'Used by the user activation system',
  
  `modified` DATETIME NOT NULL,
  `created` DATETIME NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE (`email`),
  KEY (`group`),
  KEY (`hash`)
) ENGINE=MyISAM COMMENT = '';

-- --------------------------------------------------------
-- 
-- Table structure for table `version`
-- 
CREATE TABLE `version` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  
  `version` VARCHAR(5) NOT NULL DEFAULT '1.0.0',
  `changelog` TEXT NOT NULL DEFAULT '',
  
  `modified` DATETIME NOT NULL, /* upgrade date */
  `created` DATETIME NOT NULL,  /* installed date */
  PRIMARY KEY  (`id`),
  UNIQUE (`version`)
) ENGINE=MyISAM COMMENT = '';