<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * Maps a URI request path to the actual path of the resource or resource producer.
 * 
 * @package Web
 */
class Ext_Web_ResourceMapper extends  Dk_Web_ResourceMapper 
{
    
    
    /**
     * 
     * @param Dk_Util_Path $baseDir The resource system base template directory.
     */
    function __construct(Dk_Util_Path $baseDir)
    {
        parent::__construct($baseDir);
    }
    
    
    
    
    /**
     * Gets the system resource path.
     * Paths ending in .html are mapped to .php if not found. 
     *
     * @param Sdk_Util_Url $requestUrl The requested url.
     * @return Dk_Util_Path The resource path/template or null if it cannot be found.
     * @TODO Add extension to have language directories as /sp/ instead of /language/sp/, also alias /en/
     */
    function getResourcePath(Dk_Util_Url $requestUrl)
    {
        $templatePath = null;
        if (ereg('page/', $requestUrl->getPath())) {
            $pos = strpos($requestUrl->getPath(), 'page/');
            $pageName = substr($requestUrl->getPath(), $pos+5);
            $templatePath = new Dk_Util_Path(Dk_Config::getInstance()->getHtmlTemplates() . '/index.html');
            $request = Dk_Request::getInstance();
            $request->setParameter('pageName', $pageName);
            return $templatePath;
        }
        return parent::getResourcePath($requestUrl);
    }
}
?>
