<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * A front controller for 
 * 
 * 
 * @package Web
 */
class Ext_Web_FrontController extends Dk_Web_SiteFrontController
{
    
    /**
     * Check the install status of the site
     *
     */
    function checkInstall()
    {
        if (is_dir(Ext_Config::getInstance()->getFileRoot() . '/install')) {
            try {
                $fileVer = trim(file_get_contents(Ext_Config::getInstance()->getFileRoot() . '/VERSION'));
                if (getDkWikiVersion() < $fileVer) {
                    throw new Exception();
                }
            } catch (Exception $e) {
                $url = new Dk_Util_Url('/install/index.php');
                $url->redirect();
            }
        }
    }
    
    /**
     * Post init the front controller
     * 
     */
    function init() 
    {
        $config = Ext_Config::getInstance();
        parent::init();
        
        $this->checkInstall();
        
        $crumbs = Ext_Util_CrumbList::getInstance(10);
        $name = Dk_Request::getInstance()->getRequestUri()->getBasename();
        $pos = strrpos($name, '.');
        if ($pos !== false) {
            $name = substr($name, 0, $pos);
        }
        if (strtolower($name) == 'index') {
            $name = 'Home';
        }
        $name = ucwords(str_replace('_', ' ', $name));
        if (Dk_Request::getInstance()->getRequestUri()->getBasename() != 'edit.html') {
            $crumbs->addUrl($name, Dk_Request::getInstance()->getRequestUri());
        }
        
        $this->pageComponent->addChild($crumbs);
        
        $ver = getDkWikiVersion();
        $this->pageComponent->getTemplate()->replaceText('version', 'DkWiki Ver: ' . $ver);
    
        if ($config->getRegistrationEnabled()) {
            $this->pageComponent->getTemplate()->setChoice('register');
        }
        
        $this->pageComponent->getTemplate()->replaceText('header', $config->getSiteTitle());
        $title = $this->pageComponent->getTemplate()->getTitleText();
        $this->pageComponent->getTemplate()->setTitleText($config->getSiteTitle() . ' - ' .$title);
        
        // allow config disable of the advert.
        if (!$config->isDebugMode() && $config->getShowAdvert()) {
            $this->pageComponent->getTemplate()->replaceAttr('advertBox', 'src', 'http://www.tropotek.com/home/DkWiki/advertBox.js');
            $this->pageComponent->getTemplate()->setChoice('showAdvert');
        }
    
        // Check if the install directory exists
        if (!$config->isDebugMode() && is_dir($config->getFileRoot() . '/install')) {
            $body = $this->pageComponent->getTemplate()->getBodyElement();
            $div = $body->ownerDocument->createElement('div', "DkWiki: The '/install' directory exists and is a security risk. Please delete the directory.");
            $div->setAttribute('class', '__Dk_Warning');
            $div->setAttribute('style', 'font-size: 10px;border: 1px outset #ccc; background-color: #F99;padding: 2px 4px;font-family: arial,sans-serif;');
            $body->insertBefore($div, $body->firstChild);
        }
    }
}



/**
 * Get the DkWiki version from the database
 *
 * @return string
 */
function getDkWikiVersion() 
{
    $sql = "SELECT * FROM `version` ORDER BY `id` DESC LIMIT 0, 1";
    $db = Dk_Db_ObjectFactory::getDb();
    $result = $db->query($sql);
    $row = $result->current();
    if (!$row || count($row) == 0) {
        throw new Dk_ExceptionRuntime('Cannot get version info.');
    }
    return $row['version'];
}
?>