<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * A base component object. 
 * 
 * 
 * @package Web
 */
class Ext_Web_Component extends Dk_Web_Component
{
    /**
     * @var integer
     */
    private $accessGroup = 0;

    
    
    /**
     * The Component Event Engine Lies HERE!
     * Execute this component and its children
     * Only call this on the parent/page component, usualy in
     * a front controller
     *
     * @return boolean
     */
    function execute()
    {
        $user = Dk_User_Auth::getInstance()->getUser();
        $gid = 0;
        if ($user) {
            $gid = $user->getGroupId();
        }
        if ($gid < $this->getAccessGroup()) {
            $this->setEnabled(false);
            return false;
        }
        return parent::execute();
    }
    
    /**
     * Does the logged in user have Admin permissions?
     * 
     * @return boolean
     */
    function isAdmin()
    {
        $user = Dk_User_Auth::getInstance()->getUser();
        if ($user && $user->getGroupId() >= Ext_Db_User::GROUP_ADMIN) {
            return true;
        }
        return false;
    }
    
    /**
     * Does the logged in user have User permissions?
     * 
     * @return boolean
     */
    function isUser()
    {
        $user = Dk_User_Auth::getInstance()->getUser();
        if ($user && $user->getGroupId() >= Ext_Db_User::GROUP_USER) {
            return true;
        }
        return false;
    }
    
    /**
     * Set the allowed access group for the module.
     * If the users groupId is => the access group they can execute it.
     *
     * Use the user class constants:
     *  o Ext_Db_User::GROUP_PUBLIC
     *  o Ext_Db_User::GROUP_USER
     *  o Ext_Db_User::GROUP_ADMIN
     * 
     * @param integer $i
     */
    function setAccessGroup($i)
    {
        $this->accessGroup = $i;
    }
    
    /**
     * get the allowed access group for the module.
     *
     * @return integer
     */
    function getAccessGroup()
    {
        return $this->accessGroup;
    }
}
?>
