<?php
/* 
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2005 Tropotek Development
 */

/**
 * 
 *
 * @package Util
 */
class Ext_Util_CrumbList extends Ext_Web_Component
{
    const SID = '__CrumbList';
    
    /**
     * @var Ext_Util_CrumbList
     */
    static protected $instance = null;
    
    /**
     * @var array
     */
    private $list = array();
    
    /**
     * @var integer
     */
    private $maxCrumbs = 5;
    
    
    /**
     * __construct
     * 
     * @param integer $max
     */
    function __construct($max = 5)
    {
        parent::__construct();
        $this->max = intval($max);
    }
    
    /**
     * Get an instance of this object
     * 
     * @return Ext_Util_CrumbList
     */
    static function getInstance($max = 5) 
    {
        if (self::$instance == null) {
            if (Dk_Session::getInstance()->exists(self::SID)) {
                self::$instance = Dk_Session::getInstance()->getParameter(self::SID);
            } else {
                self::$instance = new Ext_Util_CrumbList($max);
                Dk_Session::getInstance()->setParameter(self::SID, self::$instance);
            }
        }
        // Reset the template
        self::$instance->setTemplate(self::$instance->__makeTemplate());
        return self::$instance;
    }
    
    
    /**
     * makeTemplate
     *
     * @return string
     */
    protected function __makeTemplate()
    {
        $xmlStr = '<?xml version="1.0"?>
<ul class="Ext_Util_CrumbList" choice="Ext_Util_CrumbList">
  <li repeat="row" var="row"><a href="javascript:;" var="url"></a> <span choice="sep">&raquo;</span> </li>
</ul>';
        $template = Dk_Web_Template::loadXml($xmlStr);
        return $template;
    }
    
    /**
     * Get the render html for the crumbs list
     * 
     * @return string
     */
    function show($template = null)
    {
        if (count($this->list) <= 0) {
            return;
        }
        $template->setChoice('Ext_Util_CrumbList');
        $i = 0;
        /* @var $url Dk_Util_Url */
        foreach ($this->list as $name => $url)
        {
            $repeat = $template->getRepeat('row');
            $repeat->replaceAttr('url', 'href', $url->toString());
            $repeat->replaceText('url', $name);
            if($i < (count($this->list) - 1)) {
                $repeat->setChoice('sep');
            }
            $repeat->append();
            $i++;
        }
    }
    
    /**
     * Add a url to the crumb list.
     * This will drop urls when the size of the array is greater than $max
     *
     * @param string $name
     * @param Dk_Util_Url $url
     */
    function addUrl($name, Dk_Util_Url $url) 
    {
        if ($name == null) {
            return;
        }
        if (array_key_exists($name, $this->list)) {
            unset($this->list[$name]);
        }
        if (count($this->list) >= $this->max) {
            array_shift($this->list);
        }
        $this->list[$name] = $url;
    }
    
    /**
     * Clear the crumb list
     * 
     */
    function reset()
    {
        $this->list = array();
    }
    
}
?>