<?php
/*
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2005 Michael Mifsud
 */

/**
 * Edit:
 * To call this module use the following component markup in the template:
 *   <div var="Ext_Modules_User_Edit" com-class="Ext_Modules_User_Edit"></div>
 * 
 * @package Modules
 */
class Ext_Modules_User_Signup extends Dk_Web_Component
{
    
    /**
     * @var Ext_Db_User
     */
    private $object = null;
    
    
    /**
     * __construct
     * 
     */
    function __construct()
    {
        parent::__construct();
        $this->addEvent('add', 'doAdd');
        $this->addEvent('h', 'doActivate');
        $this->addEvent('cancel', 'doCancel');
        
        $this->object = new Ext_Db_User();
    }
    
    /**
     * The default init method
     * 
     */
    function init()
    {
        if (!Ext_Config::getInstance()->getRegistrationEnabled()) {
            $url = new Dk_Util_Url('/index.html');
            $url->redirect();
        }
        
        $form = new Dk_Form_Object("User");
        $form->addField('name');
        $form->addField('email');
        $form->addField('password');
        $form->addField('confPassword');
        $form->addField('image', 'file', $this->object->getDataPath()->getFullPath());
        $this->setForm($form);
        
        
    }

    /**
     * doDefault
     * 
     */
    function doDefault()
    {
        $this->getForm()->loadFromObject($this->object);
        Ext_Db_UserMapper::cleanNonConfirmed();
    }
    
    /**
     * doAdd
     * 
     */
    function doAdd()
    {
        $this->getForm()->loadFromRequest($this->getRequest());
        $this->getForm()->loadObject($this->object);
        
        $this->object->setUsername($this->object->getEmail());
        $this->object->setGroup(Ext_Db_User::GROUP_USER);
        
        if ($this->getForm()->getFieldValue('password') != $this->getForm()->getFieldValue('confPassword')) {
            //$this->object->setPassword('');
            $this->getForm()->addFieldError('password', 'Passwords do not match please re-enter.');
        }
        
        $valid = $this->object->validate();
        $this->getForm()->addFieldErrors($valid->getErrors());
        if ($this->getForm()->hasErrors()) {
            return;
        }
        
        
        $this->object->setHash($this->object->createHash());
        $this->object->setActive(false);
        
        $this->processImage();
        $this->object->insert();
        
        // Send validation email
        $address = new Dk_Mail_Address($this->object->getEmail());
        //$address->setFrom(Dk_Config::getInstance()->getSiteEmail()); 
        
        $message = new Dk_Mail_HtmlMessage($address);
        $message->setSubject('Welcome To ' . Dk_Config::getInstance()->getSiteTitle() . ' - Account Confirmation');
        
        $url = new Dk_Util_Url('/signUp.html');
        $url->setQueryField('h', $this->object->getHash());
        $html = sprintf('
<p>
  To %s,
</p>
<p>
Welcome to %s. This email is to confirm your new account.
</p>

<p>
  Please follow the link to activate your new account.<br/>
  <a href="%s">%s</a>
</p>

<p>
 Thanks,<br/>
 The %s Team
</p>
        ', $this->object->getName(), Dk_Config::getInstance()->getSiteTitle(), 
            $url->toString(), $url->toString(), Dk_Config::getInstance()->getSiteTitle());
        $message->setContent($html);
        $message->send();
        
        $url = new Dk_Util_Url('/signUpThanks.html');
        $url->redirect();
    }
    
    
    function doActivate()
    {
        
        $this->object = Ext_Db_UserMapper::findByHash($this->getRequest()->getParameter('h'));
        if ($this->object) {
            $this->object->setHash('');
            $this->object->setActive(true);
            $this->object->update();
        }
        
    }
    
    function doCancel()
    {
        $url = new Dk_Util_Url('/index.html');
        $url->redirect();
    }
    
    /**
     * resize the image
     * 
     * @return boolean
     */
    function processImage()
    {
        $fileField =  $this->getForm()->getField('image');
        if (!$fileField->hasFile()) {
            return;
        }
        $file = $this->getConfig()->getFileRoot() . $this->object->getImage();
        return Dk_Util_Image::conditionalResize($file, $file, 120, 120);
    }
    
    
    /**
     * Render the component
     * 
     * @param Dom_Template $template
     */
    function show($template = null) 
    {
        $title = $this->getPage()->getTemplate()->getTitleText();
        $this->getPage()->getTemplate()->setTitleText($title . ' - Sign Up');
        
        if ($this->getRequest()->exists('h')) {
            if ($this->object && $this->object->getActive()) {
                $template->setChoice('activated');
            } else {
                $template->setChoice('activateError');
            }
            return;
        }
        
        $template->setChoice('add');
        $template->setChoice('form');
    }
    
}
?>