<?php
/*
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2005 Michael Mifsud
 */

/**
 * Manager:
 * To call this widget use the following widget markup in the template:
 *   <div var="Ext_Modules_User_Manager" com-class="Ext_Modules_User_Manager"></div>
 *
 *
 * @package Modules
 */
class Ext_Modules_User_Manager extends Ext_Web_Component
{
    
    
    /**
     * __construct
     * 
     * Add any events here: $this->addEvent($this->getEventKey('delete'), 'doDelete');
     */
    function __construct()
    {
        parent::__construct();
        $this->addEvent($this->getEventKey('delete'), 'doDelete');
        
        $this->setAccessGroup(Ext_Db_User::GROUP_ADMIN);
    }
    
    /**
     * initalisation
     *
     */
    function init()
    {
        // Get orderby, limit, offset
        $loo = Dk_Util_Loo::createFromRequest($this->getId());
        
        // Get DB results list
        $list = Ext_Db_UserMapper::findAll($loo);
        
        // create table manager
        $cManager = new Dk_Ui_Table_Base($list);
        $this->addChild($cManager);
        
        $cells = array();
        $cells['C'] = 'Dk_Ui_Table_CheckboxCell';
        $cells['id'] = Dk_Ui_Table_CellFactory::TYPE_INTEGER;
        $cells['username'] = Dk_Ui_Table_CellFactory::TYPE_STRING;
        $cells['name'] = Dk_Ui_Table_CellFactory::TYPE_STRING;
        $cells['email'] = 'Dk_Ui_Table_EmailCell';
        $cells['active'] = Dk_Ui_Table_CellFactory::TYPE_BOOLEAN;
        $cells['group'] = 'Ext_Modules_GroupCell';
        $cells['created'] = 'Dk_Util_DateCell';
        
        $cellArray = Dk_Ui_Table_CellFactory::createCellsFromArray($cells, 'username', new Dk_Util_Url('/admin/userEdit.html'));
        $cManager->setCells($cellArray);
        
        
        $cManager->addAction(new Dk_Ui_Table_Action($this->getEventKey('delete'), 'Delete Selected', 'delete', 'Do you want to delete these records?'));
        $url = new Dk_Util_Url('/admin/userEdit.html');
        $cManager->addAction(new Dk_Ui_Table_ActionUrl($url, 'Add User', 'user'));
        
    }
    
    /**
     * Delete Selected Records
     *
     */
    function doDelete()
    {
        $selected = $this->getRequest()->getParameterValues($this->getEventKey('cb'));
        foreach ($selected as $id) {
            $obj = Ext_Db_UserMapper::find($id);
            if ($obj) {
                $obj->delete();
            }
        }
        $url = $this->getRequest()->getRequestUri();
        $url->redirect();
    }
    
    /**
     * Render the module
     *
     * @param Dom_Template $template
     */
    function show($template = null) 
    {
        
    }
    
}

/**
 * Render an array of Dk objects to a table
 *  
 * 
 * @package Ui
 */
class Ext_Modules_GroupCell extends Dk_Ui_Table_Cell 
{
    
    
    /**
     * Get the table data from an object if available
     * 
     * @param Ext_Db_User $obj
     * @return string
     */
    function getPropertyData($obj)
    {
        if ($obj->getGroupId() == Ext_Db_User::GROUP_USER) {
            return 'User';
        } else if ($obj->getGroupId() == Ext_Db_User::GROUP_ADMIN) {
            return 'Admin';
        }
        return 'Err';
    }
}
?>