<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * Ext_Widgets_Login_Widget
 * 
 * 
 * @package Widgets
 */
class Ext_Modules_User_Login extends Dk_User_Login  
{
    
    
    /**
     * __makeTemplate
     *
     * @return Dk_Web_Template
     */
    function __makeTemplate()
    {
        $html = '<?xml version="1.0" encoding="UTF-8"?>
<div class="Login">
  <form id="_Login" method="post">
    
    <div choice="logout" class="logout">
      <a href="#" var="logoutUrl"><input type="button" name="logout" value="Logout" var="logoutBtn" /></a>
    </div>
    
    <div choice="login">
      <p class="error" choice="form-error" var="form-error" />
      <p class="error" choice="username-error" var="username-error" />
      <p class="error" choice="password-error" var="password-error" />
      <p>
        <label for="fid-username">Username:</label>
        <input type="text" name="username" id="fid-username" size="10" />
      </p>
      <p>
        <label for="fid-password">Password:</label>
        <input type="password" name="password" id="fid-password" size="10" />
      </p>
      <p choice="remember">
        <label for="fid-remember">Remember Me:</label>
        <input type="checkbox" name="remember" value="remember" id="fid-remember" />
      </p>
      <p class="submit">
        <input type="submit" name="login" value="Login" />
      </p>
    </div>
    <div class="clear"></div>
    
  </form>
</div>';
        return Dk_Web_Template::loadXml($html);
    }

    /**
     * Called after a successful login.
     *
     * @param Dk_User_Interface $user
     */
    function loginCallback(Dk_User_Interface $user) 
    {
        $url = $this->getRequest()->getRequestUri();
        $url->removeQueryField('login');
        $url->redirect();
    }
    
    /**
     * Called before a logout.
     *
     * @param Dk_User_Interface $user
     */
    function logoutCallback()
    {
        Ext_Util_CrumbList::getInstance()->reset();
        
        $url = $this->getRequest()->getRequestUri();
        $url->removeQueryField('logout');
        if ($this->getRequest()->exists('pageName')) {
            $url = new Dk_Util_Url('/page/' . $this->getRequest()->getParameter('pageName'));
        }
        $url->redirect();
    }
}
?>