<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */


/**
 * A front controller for user authentication
 * 
 * 
 * @package Web
 */
class Ext_Modules_User_FrontController implements Dk_Util_ControllerInterface
{

    private $authorised = true;
    
    /**
     * Do all pre-initalisation operations
     * This method should be called before the execution method is called
     *
     */
    function init() 
    {
        $this->checkAuth();
    }
    
    /**
     * Process the request and response of page requested
     * 
     */
    function execute() { }
    
    /**
     * Do all post initalisation operations here
     * This function should be called after the execute method has been called
     * 
     */
    function postInit() 
    { 
        if (!$this->authorised) {
            $loginUrl = $this->getRequest()->getRequestUri();
            $loginUrl->removeQueryField('logout');
            if ($this->getRequest()->exists('pageName')) {
                $loginUrl = new Dk_Util_Url('/page/' . $this->getRequest()->getParameter('pageName'));
            }
            $loginUrl->redirect();
        }
    }
    
    
    
    
    /**
     * Check user permission and restore request data/url.
     * 
     * @todo: Fix the reffer login so it goes to the page requested before login.
     */
    function checkAuth()
    {
        // Check permissions
        if (!$this->getAuth()->hasPermission()) {
            $this->authorised = false;
        }
        $this->authorised = true;
    }
    
    
    /**
     * Get the main auth object
     *
     * @return Dk_User_Auth
     */
    function getAuth()
    {
        return Dk_User_Auth::getInstance();
    }
}
?>