<?php
/*
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2005 Michael Mifsud
 */

/**
 * Edit:
 * To call this module use the following component markup in the template:
 *   <div var="Ext_Modules_User_Edit" com-class="Ext_Modules_User_Edit"></div>
 * 
 * @package Modules
 */
class Ext_Modules_User_EmailPassword extends Dk_Web_Component
{
    
    /**
     * @var Ext_Db_User
     */
    private $object = null;
    
    
    /**
     * __construct
     * 
     */
    function __construct()
    {
        parent::__construct();
        $this->addEvent('send', 'doSend');
    }
    
    /**
     * The default init method
     * 
     */
    function init()
    {
        
        $form = new Dk_Form_Object("User");
        $form->addField('email');
        $this->setForm($form);
        
    }
    
    
    /**
     * doAdd
     * 
     */
    function doSend()
    {
        $this->getForm()->loadFromRequest($this->getRequest());
        
        $this->object = Ext_Db_UserMapper::findByEmail($this->getForm()->getFieldValue('email'));
        if ($this->object == null) {
            $this->getForm()->addFieldError('email', 'No valid account exists.');
        }
        
        if ($this->getForm()->hasErrors()) {
            return;
        }
        
        $newPass = $this->createPassword();
        $this->object->setPassword($newPass);
        $this->object->update();
        
        
        // Send validation email
        $address = new Dk_Mail_Address($this->object->getEmail());
        //$address->setFrom(Dk_Config::getInstance()->getSiteEmail()); 
        
        $message = new Dk_Mail_HtmlMessage($address);
        $message->setSubject('Account login Details for ' . Dk_Config::getInstance()->getSiteTitle());
        
        $url = new Dk_Util_Url('/index.html');
        
        $html = sprintf('
<p>
  To %s,
</p>
<p>
This email contains your new password.
</p>

<p>
  Your New Password is: %s<br/>
  
  Please follow the link to login to your account.<br/>
  
  <a href="%s">%s</a>
</p>

<p>
 Thanks,<br/>
 The %s Team
</p>
        ', $this->object->getName(), $newPass,
            $url->toString(), $url->toString(), Dk_Config::getInstance()->getSiteTitle());
        $message->setContent($html);
        $message->send();
        
        
        
        
    }
    
    function createPassword($length = 8) {
      	//$chars = "234567890abcdefghijkmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
      	$chars = "234567890abcdefghjkmnpqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ";
      	$i = 0;
      	$password = "";
      	while ($i <= $length) {
        		$password .= $chars{mt_rand(0,strlen($chars))};
        		$i++;
      	}
      	return $password;
    }
    
    
    /**
     * Render the component
     * 
     * @param Dom_Template $template
     */
    function show($template = null) 
    {
        if ($this->getRequest()->exists('send') && !$this->getForm()->hasErrors()) {
            $template->setChoice('emailed');
            return;
        }
        
        $template->setChoice('add');
        $template->setChoice('form');
    }
    
}
?>