<?php
/*
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2005 Michael Mifsud
 */

/**
 * Edit:
 * To call this module use the following component markup in the template:
 *   <div var="Ext_Modules_User_Edit" com-class="Ext_Modules_User_Edit"></div>
 * 
 * @package Modules
 */
class Ext_Modules_User_Edit extends Ext_Web_Component
{
    
    /**
     * @var Ext_Db_User
     */
    private $object = null;
    
    
    /**
     * __construct
     * 
     */
    function __construct()
    {
        parent::__construct();
        $this->addEvent('add', 'doAdd');
        $this->addEvent('update', 'doUpdate');
        $this->addEvent('cancel', 'doCancel');
        $this->addEvent('deleteImage', 'doDeleteImage');
        
        
        $this->object = new Ext_Db_User();
        if ($this->getRequest()->getParameter('userId') != null) {
            $this->object = Ext_Db_UserMapper::find($this->getRequest()->getParameter('userId'));
        }
        
        $this->setAccessGroup(Ext_Db_User::GROUP_ADMIN);
    }
    
    /**
     * The default init method
     * 
     */
    function init()
    {
        
        $form = new Dk_Form_Object("User");
        $form->addField('name');
        $form->addField('email');
        $form->addField('active', 'boolean');
        
        $form->addField('username');
        $form->addField('password');
        $form->addField('group', 'integer');
        
        $form->addField('image', 'file', $this->object->getDataPath()->getFullPath());
        $this->setForm($form);
        
    }

    /**
     * doDefault
     * 
     */
    function doDefault()
    {
        $this->getForm()->loadFromObject($this->object);
    }
    
    /**
     * doAdd
     * 
     */
    function doAdd()
    {
        $this->getForm()->loadFromRequest($this->getRequest());
        $this->getForm()->loadObject($this->object);
        
        $valid = $this->object->validate();
        $this->getForm()->addFieldErrors($valid->getErrors());
        if ($this->getForm()->hasErrors()) {
            return;
        }
        
        $this->processImage();
        $this->object->insert();
        
        $url = new Dk_Util_Url('/admin/userManager.html');
        $url->redirect();
    }
    
    /**
     * doUpdate
     * 
     */
    function doUpdate()
    {
        $this->getForm()->loadFromRequest($this->getRequest());
        
        // Check if email and username are the same
        if ($this->object->getEmail() != $this->getForm()->getFieldValue('email')) {
            $chk = Ext_Db_UserMapper::findByEmail($this->getForm()->getFieldValue('email'));
            if ($chk) {
                $this->getForm()->addFieldError('email', 'User already exists with selected email.');
            }
        }
        if ($this->object->getUsername() != $this->getForm()->getFieldValue('username')) {
            $chk = Ext_Db_UserMapper::findByUsername($this->getForm()->getFieldValue('username'));
            if ($chk) {
                $this->getForm()->addFieldError('username', 'User already exists with selected username.');
            }
        }
        $this->getForm()->loadObject($this->object);
        
        $valid = $this->object->validate();
        $this->getForm()->addFieldErrors($valid->getErrors());
        if ($this->getForm()->hasErrors()) {
            return;
        }
        $this->processImage();
        $this->object->update();
        
        $url = new Dk_Util_Url('/admin/userManager.html');
        $url->redirect();
    }
    
    /**
     * doCancel
     * 
     */
    function doCancel()
    {
        
        $url = new Dk_Util_Url('/admin/userManager.html');
        $url->redirect();
    }
    
    
    /**
     * doDeleteImage
     *
     */
    function doDeleteImage()
    {
        $request = $this->getRequest();
        
        if ($this->object->getImage() != null) {
            @unlink($this->getConfig()->getFileRoot() . $this->object->getImage());
            $this->object->setImage("");
            $this->object->update();
        }
        
        $url = $request->getRequestUri();
        $url->removeQueryField("deleteImage");
        $url->redirect();
    }
    

    
    /**
     * resize the image
     * 
     * @return boolean
     */
    function processImage()
    {
        $fileField =  $this->getForm()->getField('image');
        if (!$fileField->hasFile()) {
            return;
        }
        $file = $this->getConfig()->getFileRoot() . $this->object->getImage();
        return Dk_Util_Image::staticResize($file, $file, 120, 120);
    }
    
    
    /**
     * Render the component
     * 
     * @param Dom_Template $template
     */
    function show($template = null) 
    {
        if ($this->object->getId()) {
            $template->setChoice('update');
            
            if ($this->object->getImage() != null) {
                $template->setChoice("image");
                $template->replaceAttr("viewImage", "onclick", "popup('{$this->object->getImageUrl()->toString()}', 200, 200);return false;");
            }
        } else {
            $template->setChoice('add');
        }
    }
    
}
?>