<?php
/*
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2005 Michael Mifsud
 */

/**
 * Edit:
 * To call this module use the following component markup in the template:
 *   <div var="Ext_Modules_User_Edit" com-class="Ext_Modules_User_Edit"></div>
 * 
 * @package Modules
 */
class Ext_Modules_User_ChangePassword extends Ext_Web_Component
{
    
    /**
     * @var Ext_Db_User
     */
    private $object = null;
    
    
    /**
     * __construct
     * 
     */
    function __construct()
    {
        parent::__construct();
        $this->addEvent('add', 'doAdd');
        $this->addEvent('cancel', 'doCancel');
        
        $this->setAccessGroup(Ext_Db_User::GROUP_USER);
    }
    
    /**
     * The default init method
     * 
     */
    function init()
    {
        $this->object = $this->getUser();
        
        $form = new Dk_Form_Object("User");
        $form->addField('password');
        $form->addField('confPassword');
        $this->setForm($form);
        
    }
    
    
    /**
     * doAdd
     * 
     */
    function doAdd()
    {
        $this->getForm()->loadFromRequest($this->getRequest());
        
        if ($this->getForm()->getFieldValue('password') == '' || 
            $this->getForm()->getFieldValue('password') != $this->getForm()->getFieldValue('confPassword')) 
        {
            $this->getForm()->addFieldError('password', 'Passwords do not match please re-enter.');
        }
        
        if ($this->getForm()->hasErrors()) {
            return;
        }
        
        
        $this->object->setPassword($this->getForm()->getFieldValue('password'));
        $this->object->update();
        
//        $url = new Dk_Util_Url('/page/Home');
//        $url->redirect();
    }
    
    function doCancel()
    {
        $url = new Dk_Util_Url('/page/Home');
        $url->redirect();
    }
    
    
    /**
     * Render the component
     * 
     * @param Dom_Template $template
     */
    function show($template = null) 
    {
        if ($this->getRequest()->exists('add') && !$this->getForm()->hasErrors()) {
            $template->setChoice('changed');
            return;
        }
        
        $template->setChoice('add');
        $template->setChoice('form');
    }
    
}
?>